#!/bin/sh
#
#  this script builds libfwbuilder and libfwbuilder-devel RPMs
#
#

function die {
   echo $1
   exit 1
}

CONFIGURE_ARGS=$*

RPMROOT=/var/tmp/libfwbuilder
EXPORTDIR=`pwd`/export

mkdir -p ${EXPORTDIR}

#./autogen.sh --prefix=/usr ${CONFIGURE_ARGS} || exit 1
cd OS
./configure
cd ..

DISTRO=`cat /etc/issue|grep release|sed 's/Linux.*$//; s/ //g'`

SPECFILE=libfwbuilder.spec

source VERSION

# %define version 0.10.14
#
VERSION=${LIBFWBUILDER_VERSION}
TAR_FILE=libfwbuilder-${VERSION}.tar.gz
SNAPSHOT_DIR=libfwbuilder-${VERSION}

./maketar.sh "libfwbuilder" "$VERSION"


echo " === Building libfwbuilder RPM version $VERSION === "

mkdir -p ${RPMROOT}
mkdir -p ${RPMROOT}/SOURCES
mkdir -p ${RPMROOT}/BUILD
mkdir -p ${RPMROOT}/SPECS
mkdir -p ${RPMROOT}/SRCS
mkdir -p ${RPMROOT}/RPMS
mkdir -p ${RPMROOT}/SRPMS

if [ ! -d $EXPORTDIR ]; then
    echo "Can't find export directory"
    exit 1
else

    cp ${EXPORTDIR}/${TAR_FILE} ${RPMROOT}/SOURCES
    cp OS/Linux/RPM/${SPECFILE} ${RPMROOT}/SPECS 
    cd ${RPMROOT}/SPECS

    DISTRO=`cat /etc/issue|grep release|sed 's/Linux.*$//; s/ //g'`
    if test "x${DISTRO}" == "xMandrake"; then
    	ARCH=`uname -m`
    	if [ "X$ARCH" = "Xi686" ]; then
		RPMARCH="--target i586"
    	fi
    fi

    rm -f .rpmmacros
    echo "%_topdir ${RPMROOT}" > .rpmmacros

    export HOME=`pwd`
    F=`which rpmbuild 2>/dev/null`
    if test -x "$F"; then rpmbuild -ba $RPMARCH ${SPECFILE} 
    else rpm -ba $RPMARCH ${SPECFILE}
    fi
fi

