/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NAT.cc,v 1.8 2002/09/08 19:28:16 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <assert.h>

#include <fwbuilder/NAT.hh>
#include <fwbuilder/Rule.hh>
#include <fwbuilder/FWOptions.hh>
#include <fwbuilder/FWObjectDatabase.hh>

using namespace libfwbuilder;

const char *NAT::TYPENAME={"NAT"};
 
NAT::NAT() : RuleSet() 
{
    remStr("name");
    remStr("comment");
}

NAT::NAT(const FWObject *root) : RuleSet(root) 
{
    remStr("name");
    remStr("comment");
}

NAT::~NAT()  {}

Rule* NAT::createRule()
{
    FWObjectDatabase* db=dynamic_cast<FWObjectDatabase*>(getRoot());
    assert(db!=NULL);
    return Rule::cast( db->create(NATRule::TYPENAME, true) );
}


