/**
 * @file libgalago/galago-types.h Basic data types
 *
 * @Copyright (C) 2004-2005 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_TYPES_H_
#define _GALAGO_TYPES_H_

/*
 * Let me explain what we're doing here...
 * A lot of these types are just typedefs of D-BUS types. I don't want
 * to #define that macro and include dbus.h in a bunch of files, since
 * it's not quite obvious why we're including that file in non-D-BUS
 * code. So instead, we're putting them here and typedef'ing them. It
 * just feels better to me.
 */

#define DBUS_API_SUBJECT_TO_CHANGE

#include <dbus/dbus.h>

typedef dbus_bool_t galago_bool;

typedef void (*GalagoForEachFunc)(void *data, void *user_data);
typedef void (*GalagoHForEachFunc)(void *key, void *value, void *user_data);
typedef unsigned int (*GalagoHashFunc)(const void *key);
typedef galago_bool (*GalagoEqualFunc)(const void *a, const void *b);
typedef void (*GalagoFreeFunc)(void *data);

typedef void (*GalagoCallback)(void *obj, const char *prop, void *user_data);

#define GALAGO_CALLBACK(cb) ((GalagoCallback)(cb))

#endif /* _GALAGO_TYPES_H_ */
