/**
 * @file get-avatar.c Queries an account for its avatar.
 *
 * @Copyright (C) 2004-2005 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <libgalago/galago.h>
#include <stdio.h>
#include <string.h>

int
main(int argc, char **argv)
{
	char *username, *service_id, *filename;
	GalagoAvatar *avatar;
	GalagoAccount *account;
	GalagoService *service;

	if (argc != 4)
	{
		printf("Usage: get-presence service-id username out-filename\n");
		exit(1);
	}

	service_id = argv[1];
	username   = argv[2];
	filename   = argv[3];

	galago_init("get-avatar", FALSE);

	service = galago_core_get_service(service_id, FALSE, TRUE);

	if (service == NULL)
	{
		printf("Unknown service %s\n", service_id);
		exit(1);
	}

	account = galago_service_get_account(service, username, TRUE);

	if (account == NULL)
	{
		printf("Unknown account %s on service %s\n", username, service_id);
		exit(1);
	}

	avatar = galago_account_get_avatar(account, TRUE);

	if (avatar == NULL)
	{
		printf("No avatar was found.\n");
	}
	else
	{
		unsigned char *data;
		size_t len;
		FILE *fp;

		galago_avatar_get_image_data(avatar, &data, &len);

		if ((fp = fopen(filename, "wb")) == NULL)
		{
			fprintf(stderr, "Unable to write to %s\n", filename);
			exit(1);
		}

		fwrite(data, 1, len, fp);

		fclose(fp);

		printf("Avatar written to %s\n", filename);
	}

	return 0;
}
