/* readonlymap.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gee/readonlymap.h>
#include <gee/readonlyset.h>
#include <gee/readonlycollection.h>

struct _GeeReadOnlyMapPrivate {
	GeeMap* _map;
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
};
#define GEE_READ_ONLY_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapPrivate))
enum  {
	GEE_READ_ONLY_MAP_DUMMY_PROPERTY,
	GEE_READ_ONLY_MAP_SIZE,
	GEE_READ_ONLY_MAP_MAP,
	GEE_READ_ONLY_MAP_K_TYPE,
	GEE_READ_ONLY_MAP_K_DUP_FUNC,
	GEE_READ_ONLY_MAP_K_DESTROY_FUNC,
	GEE_READ_ONLY_MAP_V_TYPE,
	GEE_READ_ONLY_MAP_V_DUP_FUNC,
	GEE_READ_ONLY_MAP_V_DESTROY_FUNC
};
static GeeSet* gee_read_only_map_real_get_keys (GeeMap* base);
static GeeCollection* gee_read_only_map_real_get_values (GeeMap* base);
static gboolean gee_read_only_map_real_contains (GeeMap* base, gconstpointer key);
static gpointer gee_read_only_map_real_get (GeeMap* base, gconstpointer key);
static void gee_read_only_map_real_set (GeeMap* base, gconstpointer key, gconstpointer value);
static gboolean gee_read_only_map_real_remove (GeeMap* base, gconstpointer key);
static void gee_read_only_map_real_clear (GeeMap* base);
static gpointer gee_read_only_map_parent_class = NULL;
static GeeMapIface* gee_read_only_map_gee_map_parent_iface = NULL;
static void gee_read_only_map_dispose (GObject * obj);


GeeReadOnlyMap* gee_read_only_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map) {
	GeeReadOnlyMap * self;
	g_return_val_if_fail (map == NULL || GEE_IS_MAP (map), NULL);
	self = g_object_newv (GEE_TYPE_READ_ONLY_MAP, 0, NULL);
	gee_read_only_map_set_map (self, map);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	return self;
}


static GeeSet* gee_read_only_map_real_get_keys (GeeMap* base) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	if (self->priv->_map == NULL) {
		return GEE_SET (gee_read_only_set_new (self->priv->k_type, ((GBoxedCopyFunc) self->priv->k_dup_func), self->priv->k_destroy_func, NULL));
	}
	return gee_map_get_keys (self->priv->_map);
}


static GeeCollection* gee_read_only_map_real_get_values (GeeMap* base) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	if (self->priv->_map == NULL) {
		return GEE_COLLECTION (gee_read_only_collection_new (self->priv->v_type, ((GBoxedCopyFunc) self->priv->v_dup_func), self->priv->v_destroy_func, NULL));
	}
	return gee_map_get_values (self->priv->_map);
}


static gboolean gee_read_only_map_real_contains (GeeMap* base, gconstpointer key) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	if (self->priv->_map == NULL) {
		return FALSE;
	}
	return gee_map_contains (self->priv->_map, key);
}


static gpointer gee_read_only_map_real_get (GeeMap* base, gconstpointer key) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	if (self->priv->_map == NULL) {
		return NULL;
	}
	return gee_map_get (self->priv->_map, key);
}


static void gee_read_only_map_real_set (GeeMap* base, gconstpointer key, gconstpointer value) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	g_assert_not_reached ();
}


static gboolean gee_read_only_map_real_remove (GeeMap* base, gconstpointer key) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	g_assert_not_reached ();
	return FALSE;
}


static void gee_read_only_map_real_clear (GeeMap* base) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	g_assert_not_reached ();
}


static gint gee_read_only_map_real_get_size (GeeReadOnlyMap* self) {
	g_return_val_if_fail (GEE_IS_READ_ONLY_MAP (self), 0);
	return gee_map_get_size (self->priv->_map);
}


void gee_read_only_map_set_map (GeeReadOnlyMap* self, GeeMap* value) {
	GeeMap* _tmp1;
	GeeMap* _tmp0;
	g_return_if_fail (GEE_IS_READ_ONLY_MAP (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->_map = (_tmp1 = (_tmp0 = value, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->_map == NULL ? NULL : (self->priv->_map = (g_object_unref (self->priv->_map), NULL))), _tmp1);
}


static void gee_read_only_map_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (object);
	switch (property_id) {
		case GEE_READ_ONLY_MAP_SIZE:
		g_value_set_int (value, gee_read_only_map_real_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_read_only_map_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (object);
	switch (property_id) {
		case GEE_READ_ONLY_MAP_MAP:
		gee_read_only_map_set_map (self, g_value_get_object (value));
		break;
		case GEE_READ_ONLY_MAP_K_TYPE:
		self->priv->k_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_MAP_K_DUP_FUNC:
		self->priv->k_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_MAP_K_DESTROY_FUNC:
		self->priv->k_destroy_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_MAP_V_TYPE:
		self->priv->v_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_MAP_V_DUP_FUNC:
		self->priv->v_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_MAP_V_DESTROY_FUNC:
		self->priv->v_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_read_only_map_class_init (GeeReadOnlyMapClass * klass) {
	gee_read_only_map_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeReadOnlyMapPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_read_only_map_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_read_only_map_set_property;
	G_OBJECT_CLASS (klass)->dispose = gee_read_only_map_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_K_TYPE, g_param_spec_gtype ("k-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_K_DUP_FUNC, g_param_spec_pointer ("k-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_K_DESTROY_FUNC, g_param_spec_pointer ("k-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_V_TYPE, g_param_spec_gtype ("v-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_V_DUP_FUNC, g_param_spec_pointer ("v-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_V_DESTROY_FUNC, g_param_spec_pointer ("v-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_SIZE, "size");
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_MAP_MAP, g_param_spec_object ("map", "map", "map", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void gee_read_only_map_gee_map_interface_init (GeeMapIface * iface) {
	gee_read_only_map_gee_map_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_keys = gee_read_only_map_real_get_keys;
	iface->get_values = gee_read_only_map_real_get_values;
	iface->contains = gee_read_only_map_real_contains;
	iface->get = gee_read_only_map_real_get;
	iface->set = gee_read_only_map_real_set;
	iface->remove = gee_read_only_map_real_remove;
	iface->clear = gee_read_only_map_real_clear;
}


static void gee_read_only_map_init (GeeReadOnlyMap * self) {
	self->priv = GEE_READ_ONLY_MAP_GET_PRIVATE (self);
}


static void gee_read_only_map_dispose (GObject * obj) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (obj);
	(self->priv->_map == NULL ? NULL : (self->priv->_map = (g_object_unref (self->priv->_map), NULL)));
	G_OBJECT_CLASS (gee_read_only_map_parent_class)->dispose (obj);
}


GType gee_read_only_map_get_type (void) {
	static GType gee_read_only_map_type_id = 0;
	if (G_UNLIKELY (gee_read_only_map_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyMap), 0, (GInstanceInitFunc) gee_read_only_map_init };
		static const GInterfaceInfo gee_map_info = { (GInterfaceInitFunc) gee_read_only_map_gee_map_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_read_only_map_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyMap", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_map_type_id, GEE_TYPE_MAP, &gee_map_info);
	}
	return gee_read_only_map_type_id;
}




