/* abstractcollection.c generated by valac, the Vala compiler
 * generated from abstractcollection.vala, do not modify */

/* abstractcollection.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_READ_ONLY_COLLECTION (gee_read_only_collection_get_type ())
#define GEE_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollection))
#define GEE_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))
#define GEE_IS_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_IS_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_READ_ONLY_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))

typedef struct _GeeReadOnlyCollection GeeReadOnlyCollection;
typedef struct _GeeReadOnlyCollectionClass GeeReadOnlyCollectionClass;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeAbstractCollectionPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeCollection* _read_only_view;
};


static gpointer gee_abstract_collection_parent_class = NULL;
static GeeIterableIface* gee_abstract_collection_gee_iterable_parent_iface = NULL;
static GeeCollectionIface* gee_abstract_collection_gee_collection_parent_iface = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_abstract_collection_get_type (void);
#define GEE_ABSTRACT_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionPrivate))
enum  {
	GEE_ABSTRACT_COLLECTION_DUMMY_PROPERTY,
	GEE_ABSTRACT_COLLECTION_SIZE,
	GEE_ABSTRACT_COLLECTION_IS_EMPTY,
	GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE,
	GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW,
	GEE_ABSTRACT_COLLECTION_G_TYPE,
	GEE_ABSTRACT_COLLECTION_G_DUP_FUNC,
	GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC
};
gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_contains (GeeAbstractCollection* self, gconstpointer item);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_add (GeeAbstractCollection* self, gconstpointer item);
gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item);
static gboolean gee_abstract_collection_real_remove (GeeAbstractCollection* self, gconstpointer item);
void gee_abstract_collection_clear (GeeAbstractCollection* self);
static void gee_abstract_collection_real_clear (GeeAbstractCollection* self);
gint gee_collection_get_size (GeeCollection* self);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
gpointer* gee_abstract_collection_to_array (GeeAbstractCollection* self, int* result_length1);
static gpointer* gee_abstract_collection_real_to_array (GeeAbstractCollection* self, int* result_length1);
gboolean gee_collection_get_is_empty (GeeCollection* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_abstract_collection_add_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_add_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_abstract_collection_contains_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_contains_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_abstract_collection_remove_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_remove_all (GeeAbstractCollection* self, GeeCollection* collection);
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
gboolean gee_abstract_collection_retain_all (GeeAbstractCollection* self, GeeCollection* collection);
static gboolean gee_abstract_collection_real_retain_all (GeeAbstractCollection* self, GeeCollection* collection);
static GeeIterator* gee_abstract_collection_real_iterator (GeeAbstractCollection* self);
GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self);
GeeReadOnlyCollection* gee_read_only_collection_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
GeeReadOnlyCollection* gee_read_only_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
GType gee_read_only_collection_get_type (void);
GeeCollection* gee_abstract_collection_get_read_only_view (GeeAbstractCollection* self);
static void gee_abstract_collection_finalize (GObject* obj);
GType gee_iterable_get_element_type (GeeIterable* self);
static void gee_abstract_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_abstract_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



#line 50 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_contains (GeeAbstractCollection* self, gconstpointer item) {
#line 202 "abstractcollection.c"
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_contains'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


#line 50 "abstractcollection.vala"
gboolean gee_abstract_collection_contains (GeeAbstractCollection* self, gconstpointer item) {
#line 50 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->contains (self, item);
#line 213 "abstractcollection.c"
}


#line 55 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_add (GeeAbstractCollection* self, gconstpointer item) {
#line 219 "abstractcollection.c"
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_add'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


#line 55 "abstractcollection.vala"
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item) {
#line 55 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->add (self, item);
#line 230 "abstractcollection.c"
}


#line 60 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_remove (GeeAbstractCollection* self, gconstpointer item) {
#line 236 "abstractcollection.c"
	g_return_val_if_fail (self != NULL, FALSE);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_remove'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


#line 60 "abstractcollection.vala"
gboolean gee_abstract_collection_remove (GeeAbstractCollection* self, gconstpointer item) {
#line 60 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->remove (self, item);
#line 247 "abstractcollection.c"
}


#line 65 "abstractcollection.vala"
static void gee_abstract_collection_real_clear (GeeAbstractCollection* self) {
#line 253 "abstractcollection.c"
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_clear'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


#line 65 "abstractcollection.vala"
void gee_abstract_collection_clear (GeeAbstractCollection* self) {
#line 65 "abstractcollection.vala"
	GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->clear (self);
#line 264 "abstractcollection.c"
}


#line 70 "abstractcollection.vala"
static gpointer* gee_abstract_collection_real_to_array (GeeAbstractCollection* self, int* result_length1) {
#line 270 "abstractcollection.c"
	gpointer* result;
	gpointer* _tmp1_;
	gint array_size;
	gint array_length1;
	gint _tmp0_;
	gpointer* array;
	gint index;
	gpointer* _tmp5_;
#line 70 "abstractcollection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 281 "abstractcollection.c"
	array = (_tmp1_ = g_new0 (gpointer, _tmp0_ = gee_collection_get_size ((GeeCollection*) self)), array_length1 = _tmp0_, array_size = array_length1, _tmp1_);
#line 72 "abstractcollection.vala"
	index = 0;
#line 285 "abstractcollection.c"
	{
		GeeIterator* _element_it;
		_element_it = gee_abstract_collection_iterator (self);
#line 73 "abstractcollection.vala"
		while (TRUE) {
#line 291 "abstractcollection.c"
			gpointer element;
			gpointer _tmp4_;
			gpointer *_tmp3_;
			gconstpointer _tmp2_;
#line 73 "abstractcollection.vala"
			if (!gee_iterator_next (_element_it)) {
#line 73 "abstractcollection.vala"
				break;
#line 300 "abstractcollection.c"
			}
#line 73 "abstractcollection.vala"
			element = gee_iterator_get (_element_it);
#line 74 "abstractcollection.vala"
			_tmp3_ = &array[index++];
#line 74 "abstractcollection.vala"
			(*_tmp3_) = (_tmp4_ = (_tmp2_ = element, ((_tmp2_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->g_dup_func ((gpointer) _tmp2_)), (((*_tmp3_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp3_) = (self->priv->g_destroy_func ((*_tmp3_)), NULL)), _tmp4_);
#line 308 "abstractcollection.c"
			((element == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (element = (self->priv->g_destroy_func (element), NULL));
		}
		_g_object_unref0 (_element_it);
	}
	result = (_tmp5_ = array, *result_length1 = array_length1, _tmp5_);
#line 76 "abstractcollection.vala"
	return result;
#line 316 "abstractcollection.c"
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
}


#line 70 "abstractcollection.vala"
gpointer* gee_abstract_collection_to_array (GeeAbstractCollection* self, int* result_length1) {
#line 70 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->to_array (self, result_length1);
#line 325 "abstractcollection.c"
}


#line 82 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_add_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 331 "abstractcollection.c"
	gboolean result;
	gboolean changed;
#line 82 "abstractcollection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 82 "abstractcollection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 83 "abstractcollection.vala"
	if (gee_collection_get_is_empty (collection)) {
#line 340 "abstractcollection.c"
		result = FALSE;
#line 84 "abstractcollection.vala"
		return result;
#line 344 "abstractcollection.c"
	}
#line 87 "abstractcollection.vala"
	changed = FALSE;
#line 348 "abstractcollection.c"
	{
		GeeIterator* _item_it;
		_item_it = gee_iterable_iterator ((GeeIterable*) collection);
#line 88 "abstractcollection.vala"
		while (TRUE) {
#line 354 "abstractcollection.c"
			gpointer item;
#line 88 "abstractcollection.vala"
			if (!gee_iterator_next (_item_it)) {
#line 88 "abstractcollection.vala"
				break;
#line 360 "abstractcollection.c"
			}
#line 88 "abstractcollection.vala"
			item = gee_iterator_get (_item_it);
#line 89 "abstractcollection.vala"
			changed = changed | gee_abstract_collection_add (self, item);
#line 366 "abstractcollection.c"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = changed;
#line 91 "abstractcollection.vala"
	return result;
#line 374 "abstractcollection.c"
}


#line 82 "abstractcollection.vala"
gboolean gee_abstract_collection_add_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 82 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->add_all (self, collection);
#line 382 "abstractcollection.c"
}


#line 97 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_contains_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 388 "abstractcollection.c"
	gboolean result;
#line 97 "abstractcollection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 97 "abstractcollection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 98 "abstractcollection.vala"
	if (gee_collection_get_size (collection) > gee_collection_get_size ((GeeCollection*) self)) {
#line 396 "abstractcollection.c"
		result = FALSE;
#line 99 "abstractcollection.vala"
		return result;
#line 400 "abstractcollection.c"
	}
	{
		GeeIterator* _item_it;
		_item_it = gee_iterable_iterator ((GeeIterable*) collection);
#line 102 "abstractcollection.vala"
		while (TRUE) {
#line 407 "abstractcollection.c"
			gpointer item;
#line 102 "abstractcollection.vala"
			if (!gee_iterator_next (_item_it)) {
#line 102 "abstractcollection.vala"
				break;
#line 413 "abstractcollection.c"
			}
#line 102 "abstractcollection.vala"
			item = gee_iterator_get (_item_it);
#line 103 "abstractcollection.vala"
			if (!gee_abstract_collection_contains (self, item)) {
#line 419 "abstractcollection.c"
				result = FALSE;
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
				_g_object_unref0 (_item_it);
#line 104 "abstractcollection.vala"
				return result;
#line 425 "abstractcollection.c"
			}
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = TRUE;
#line 107 "abstractcollection.vala"
	return result;
#line 434 "abstractcollection.c"
}


#line 97 "abstractcollection.vala"
gboolean gee_abstract_collection_contains_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 97 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->contains_all (self, collection);
#line 442 "abstractcollection.c"
}


#line 113 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_remove_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 448 "abstractcollection.c"
	gboolean result;
	gboolean changed;
#line 113 "abstractcollection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 113 "abstractcollection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 114 "abstractcollection.vala"
	changed = FALSE;
#line 457 "abstractcollection.c"
	{
		GeeIterator* _item_it;
		_item_it = gee_iterable_iterator ((GeeIterable*) collection);
#line 115 "abstractcollection.vala"
		while (TRUE) {
#line 463 "abstractcollection.c"
			gpointer item;
#line 115 "abstractcollection.vala"
			if (!gee_iterator_next (_item_it)) {
#line 115 "abstractcollection.vala"
				break;
#line 469 "abstractcollection.c"
			}
#line 115 "abstractcollection.vala"
			item = gee_iterator_get (_item_it);
#line 116 "abstractcollection.vala"
			changed = changed | gee_abstract_collection_remove (self, item);
#line 475 "abstractcollection.c"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = changed;
#line 118 "abstractcollection.vala"
	return result;
#line 483 "abstractcollection.c"
}


#line 113 "abstractcollection.vala"
gboolean gee_abstract_collection_remove_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 113 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->remove_all (self, collection);
#line 491 "abstractcollection.c"
}


#line 124 "abstractcollection.vala"
static gboolean gee_abstract_collection_real_retain_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 497 "abstractcollection.c"
	gboolean result;
	gboolean changed;
	gpointer* _tmp1_;
	gint items_size;
	gint items_length1;
	gint _tmp0_;
	gpointer* items;
	gint size_of_items;
#line 124 "abstractcollection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 124 "abstractcollection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 125 "abstractcollection.vala"
	changed = FALSE;
#line 512 "abstractcollection.c"
	items = (_tmp1_ = gee_abstract_collection_to_array (self, &_tmp0_), items_length1 = _tmp0_, items_size = items_length1, _tmp1_);
#line 127 "abstractcollection.vala"
	size_of_items = gee_collection_get_size ((GeeCollection*) self);
#line 516 "abstractcollection.c"
	{
		gint index;
#line 128 "abstractcollection.vala"
		index = 0;
#line 521 "abstractcollection.c"
		{
			gboolean _tmp2_;
#line 128 "abstractcollection.vala"
			_tmp2_ = TRUE;
#line 128 "abstractcollection.vala"
			while (TRUE) {
#line 128 "abstractcollection.vala"
				if (!_tmp2_) {
#line 128 "abstractcollection.vala"
					index++;
#line 532 "abstractcollection.c"
				}
#line 128 "abstractcollection.vala"
				_tmp2_ = FALSE;
#line 128 "abstractcollection.vala"
				if (!(index < size_of_items)) {
#line 128 "abstractcollection.vala"
					break;
#line 540 "abstractcollection.c"
				}
#line 129 "abstractcollection.vala"
				if (!gee_collection_contains (collection, items[index])) {
#line 130 "abstractcollection.vala"
					changed = changed | gee_abstract_collection_remove (self, items[index]);
#line 546 "abstractcollection.c"
				}
			}
		}
	}
	result = changed;
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
#line 133 "abstractcollection.vala"
	return result;
#line 555 "abstractcollection.c"
}


#line 124 "abstractcollection.vala"
gboolean gee_abstract_collection_retain_all (GeeAbstractCollection* self, GeeCollection* collection) {
#line 124 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->retain_all (self, collection);
#line 563 "abstractcollection.c"
}


#line 146 "abstractcollection.vala"
static GeeIterator* gee_abstract_collection_real_iterator (GeeAbstractCollection* self) {
#line 569 "abstractcollection.c"
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `gee_abstract_collection_iterator'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


#line 146 "abstractcollection.vala"
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self) {
#line 146 "abstractcollection.vala"
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->iterator (self);
#line 580 "abstractcollection.c"
}


#line 33 "abstractcollection.vala"
GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
#line 586 "abstractcollection.c"
	GeeAbstractCollection * self;
#line 33 "abstractcollection.vala"
	self = (GeeAbstractCollection*) g_object_new (object_type, NULL);
#line 33 "abstractcollection.vala"
	self->priv->g_type = g_type;
#line 33 "abstractcollection.vala"
	self->priv->g_dup_func = g_dup_func;
#line 33 "abstractcollection.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 596 "abstractcollection.c"
	return self;
}


gint gee_abstract_collection_get_size (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_size (self);
}


gboolean gee_abstract_collection_get_is_empty (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_is_empty (self);
}


static gboolean gee_abstract_collection_real_get_is_empty (GeeAbstractCollection* base) {
	gboolean result;
	GeeAbstractCollection* self;
	self = base;
	result = gee_collection_get_size ((GeeCollection*) self) == 0;
#line 44 "abstractcollection.vala"
	return result;
#line 618 "abstractcollection.c"
}


static GType gee_abstract_collection_real_get_element_type (GeeIterable* base) {
	GType result;
	GeeAbstractCollection* self;
	self = (GeeAbstractCollection*) base;
	result = self->priv->g_type;
#line 140 "abstractcollection.vala"
	return result;
#line 629 "abstractcollection.c"
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeCollection* gee_abstract_collection_get_read_only_view (GeeAbstractCollection* self) {
	return GEE_ABSTRACT_COLLECTION_GET_CLASS (self)->get_read_only_view (self);
}


static GeeCollection* gee_abstract_collection_real_get_read_only_view (GeeAbstractCollection* base) {
	GeeCollection* result;
	GeeAbstractCollection* self;
	GeeCollection* instance;
	self = base;
#line 155 "abstractcollection.vala"
	instance = _g_object_ref0 (self->priv->_read_only_view);
#line 156 "abstractcollection.vala"
	if (self->priv->_read_only_view == NULL) {
#line 652 "abstractcollection.c"
		GeeCollection* _tmp0_;
#line 157 "abstractcollection.vala"
		instance = (_tmp0_ = (GeeCollection*) gee_read_only_collection_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, (GeeCollection*) self), _g_object_unref0 (instance), _tmp0_);
#line 158 "abstractcollection.vala"
		self->priv->_read_only_view = instance;
#line 159 "abstractcollection.vala"
		g_object_add_weak_pointer ((GObject*) instance, (void**) (&self->priv->_read_only_view));
#line 660 "abstractcollection.c"
	}
	result = instance;
#line 161 "abstractcollection.vala"
	return result;
#line 665 "abstractcollection.c"
}


static void gee_abstract_collection_class_init (GeeAbstractCollectionClass * klass) {
	gee_abstract_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeAbstractCollectionPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_abstract_collection_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_abstract_collection_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_abstract_collection_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_abstract_collection_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->to_array = gee_abstract_collection_real_to_array;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add_all = gee_abstract_collection_real_add_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains_all = gee_abstract_collection_real_contains_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove_all = gee_abstract_collection_real_remove_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->retain_all = gee_abstract_collection_real_retain_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_abstract_collection_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_is_empty = gee_abstract_collection_real_get_is_empty;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only_view = gee_abstract_collection_real_get_read_only_view;
	G_OBJECT_CLASS (klass)->get_property = gee_abstract_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_abstract_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_abstract_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_SIZE, "size");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_IS_EMPTY, "is-empty");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE, "element-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW, "read-only-view");
}


static void gee_abstract_collection_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_abstract_collection_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) gee_abstract_collection_iterator;
	iface->get_element_type = gee_abstract_collection_real_get_element_type;
}


static void gee_abstract_collection_gee_collection_interface_init (GeeCollectionIface * iface) {
	gee_abstract_collection_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_contains;
	iface->add = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_add;
	iface->remove = (gboolean (*)(GeeCollection* ,gconstpointer)) gee_abstract_collection_remove;
	iface->clear = (void (*)(GeeCollection*)) gee_abstract_collection_clear;
	iface->to_array = (gpointer* (*)(GeeCollection* ,int*)) gee_abstract_collection_to_array;
	iface->add_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_add_all;
	iface->contains_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_contains_all;
	iface->remove_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_remove_all;
	iface->retain_all = (gboolean (*)(GeeCollection* ,GeeCollection*)) gee_abstract_collection_retain_all;
	iface->get_size = (gint (*) (GeeCollection *)) gee_abstract_collection_get_size;
	iface->get_is_empty = (gboolean (*) (GeeCollection *)) gee_abstract_collection_get_is_empty;
	iface->get_read_only_view = (GeeCollection* (*) (GeeCollection *)) gee_abstract_collection_get_read_only_view;
}


static void gee_abstract_collection_instance_init (GeeAbstractCollection * self) {
	self->priv = GEE_ABSTRACT_COLLECTION_GET_PRIVATE (self);
}


static void gee_abstract_collection_finalize (GObject* obj) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (obj);
	G_OBJECT_CLASS (gee_abstract_collection_parent_class)->finalize (obj);
}


GType gee_abstract_collection_get_type (void) {
	static GType gee_abstract_collection_type_id = 0;
	if (gee_abstract_collection_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeAbstractCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_abstract_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeAbstractCollection), 0, (GInstanceInitFunc) gee_abstract_collection_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_abstract_collection_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) gee_abstract_collection_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_abstract_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeAbstractCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gee_abstract_collection_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_abstract_collection_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
	}
	return gee_abstract_collection_type_id;
}


static void gee_abstract_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (object);
	switch (property_id) {
		case GEE_ABSTRACT_COLLECTION_IS_EMPTY:
		g_value_set_boolean (value, gee_abstract_collection_get_is_empty (self));
		break;
		case GEE_ABSTRACT_COLLECTION_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		case GEE_ABSTRACT_COLLECTION_READ_ONLY_VIEW:
		g_value_set_object (value, gee_abstract_collection_get_read_only_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_abstract_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeAbstractCollection * self;
	self = GEE_ABSTRACT_COLLECTION (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ABSTRACT_COLLECTION_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ABSTRACT_COLLECTION_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ABSTRACT_COLLECTION_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




