# This file was automatically generated by SWIG (http://www.swig.org).
# Version 1.3.31
#
# Don't modify this file, modify the SWIG interface instead.
# This file is compatible with both classic and new-style classes.

"""
Python interface for libgeier.

libgeier is a library for exchanging data with the german ELSTER tax
system.
"""

import _geier
import new
new_instancemethod = new.instancemethod
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'PySwigObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types


class geier_context(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, geier_context, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, geier_context, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        this = _geier.new_geier_context(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _geier.delete_geier_context
    __del__ = lambda self : None;
geier_context_swigregister = _geier.geier_context_swigregister
geier_context_swigregister(geier_context)

ERROR_FORMAT = _geier.ERROR_FORMAT
ERROR_NEW_PARSER_CTXT = _geier.ERROR_NEW_PARSER_CTXT
ERROR_SCHEMA_PARSE = _geier.ERROR_SCHEMA_PARSE
ERROR_NEW_VALID_CTXT = _geier.ERROR_NEW_VALID_CTXT
ERROR_SCHEMA_VALIDATE_DOC = _geier.ERROR_SCHEMA_VALIDATE_DOC
ERROR_FIND_NODE_NO_UNIQUE_NODE = _geier.ERROR_FIND_NODE_NO_UNIQUE_NODE
_init = _geier._init
_exit = _geier._exit
_context_new = _geier._context_new
_context_free = _geier._context_free
_send_text = _geier._send_text
_send = _geier._send
_validate = _geier._validate
_validate_text = _geier._validate_text
_xsltify_text = _geier._xsltify_text
_xsltify = _geier._xsltify
_get_clearing_error = _geier._get_clearing_error
_get_clearing_error_text = _geier._get_clearing_error_text
_dsig_sign = _geier._dsig_sign
_dsig_sign_text = _geier._dsig_sign_text
#--- end of code generated by swig ---

import libxml2

FORMAT_ENCRYPTED   = 0
FORMAT_UNENCRYPTED = 1

class Context(geier_context):
    """
    Implements a higher-level layer for libgeier's geier_context.

    """
    def validate(self, data, format=FORMAT_ENCRYPTED):
         """
         Check whether the XML data is valid according to the
         schema.

         'data' may be either a string or a libxml2.xmlDoc()
         'format' specifies the inpute data format. Set one of
           - encrypted (default)
           - unencrypted

         Please note: 'encrypted' is default, but not yet supported by the
         underlying libgeier.
         """
         if format == FORMAT_ENCRYPTED:
             raise NotImplementedError('validate(..., format_encrypted). Sorry')
         if isinstance(data, basestring):
             res = _geier._validate_text(self, format, data)
         else:
             res = _geier._validate(self, format, data._o)
         return not res # inverse logic


    def sign(self, data, softpse_filename, pincode):
         """
         Sign the XML data.
         
         'data' may be either a string or a libxml2.xmlDoc()
         'softpse_filename' is ...., 'pincode' the matching pincode.
         """
         if isinstance(data, basestring):
             res = _geier._dsig_sign_text(self, data,
                                          softpse_filename, pincode)
         else:
             res = _geier._dsig_sign(self, data._o,
                                     softpse_filename, pincode)
         return res


    def send(self, data, crypt=False):
         """
         Send Elster data and return response.
         
         'data' may be either a string or a libxml2.xmlDoc() If 'crypt'
         is true, data will be send encrypted and result will be
         decrypted.
         """
         if isinstance(data, basestring):
             res = _geier._send_text(self, data)
             errMsg = _geier._get_clearing_error_text(self, res)
         else:
             res = _geier._send(self, data._o)
             print `res`
             if res:
                 res = libxml2.xmlDoc(res)
             print `res`
             errMsg = _geier._get_clearing_error(self, res)
         return res, errMsg


    def as_html(self, data):
         """
         Convert the XML dadta into a HTML text.

         This is done by processing the official style-sheet on the data.

         'data' may be either a string or a libxml2.xmlDoc()
         """
         if isinstance(data, basestring):
             res = _geier._xsltify_text(self, data)
         else:
             res = _geier._xsltify(self, data._o)
             if res:
                 res = libxml2.xmlDoc(res)
         return res


import atexit
_geier._init(0)
atexit.register(_geier._exit)




