/*******************************************************************************************************************************************
 cserialized.c
*******************************************************************************************************************************************/

#include "cserialized.h"

//-------------------------------------------------------------------------------------------------------------------------------------------
// constant definition
//-------------------------------------------------------------------------------------------------------------------------------------------
const static CString CSERIALIZED_XML_ELEMENT 		("cserialized");
const static CString CSERIALIZED_XML_NAME_ATTRIBUTE	("name");
const static CString CSERIALIZED_XML_TAG_ATTRIBUTE	("tag");

//-------------------------------------------------------------------------------------------------------------------------------------------
// class tag to string conversion
//-------------------------------------------------------------------------------------------------------------------------------------------
CString ClassTagToString (const UInt32 inTag)
{
	char outTag[5]; outTag[4]='\0';
	outTag[0] = ((inTag&0xFF000000)>>24);
	outTag[1] = ((inTag&0x00FF0000)>>16);
	outTag[2] = ((inTag&0x0000FF00)>> 8);
	outTag[3] = ( inTag&0x000000FF);
	return CString(outTag);
}

//-------------------------------------------------------------------------------------------------------------------------------------------
// string to class tag conversion
//-------------------------------------------------------------------------------------------------------------------------------------------
UInt32 StringToClassTag (const CString &inTag)
{
	return inTag.GetLength() < 4 ? 0L : ((*inTag[0])<<24) | ((*inTag[1])<<16) | ((*inTag[2])<<8) | (*inTag[3]);
}

//-------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CSerialized);

//-------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-------------------------------------------------------------------------------------------------------------------------------------------
CSerialized::CSerialized ()
	    :CClass	 ()
{ }

//-------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-------------------------------------------------------------------------------------------------------------------------------------------
CSerialized::~CSerialized ()
{ }

//-------------------------------------------------------------------------------------------------------------------------------------------
// serializable check
//-------------------------------------------------------------------------------------------------------------------------------------------
bool CSerialized::IsSerializable (const CMetaClass *inMetaClass)
{
	return inMetaClass != NULL && CMetaClass::MetaClassIs (__metaclass(CSerialized), inMetaClass) &&
	       inMetaClass -> MetaClassType == METACLASS_DYNAMIC && inMetaClass -> ClassInstanciate != NULL;
}

//-------------------------------------------------------------------------------------------------------------------------------------------
// generic serialization
//-------------------------------------------------------------------------------------------------------------------------------------------
void CSerialized::Serialize (CArchive &ioArchive)
{
	// archive process analye
	switch (ioArchive.GetProcess())
	{
		case ARCHIVEPROCESS_STORING :
		{
			ioArchive << classtag_cast (this);
		}
		break;
		case ARCHIVEPROCESS_LOADING :
		{
			if (ioArchive.NextDataIs() == UINT32) ioArchive++;
		}
		break;
	}
}

//-------------------------------------------------------------------------------------------------------------------------------------------
// generic serialization
//-------------------------------------------------------------------------------------------------------------------------------------------
void CSerialized::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// xml serialization mode analyse
	switch (inMode)
	{
		// loading from xml
		case XML_READ :
		{
			// check the current node...
			if (::xml_node_get_name (ioXMLElementNode) != CSERIALIZED_XML_ELEMENT)
			{
				// ... get one of its children if it is not corresponding to a serialization one and check again
				if ((ioXMLElementNode = ::xml_node_get_child (static_cast <CXMLElementNode *> (ioXMLElementNode), 
				     const_cast <CString &> (CSERIALIZED_XML_ELEMENT))) == NULL)
				{
					// throw an exception that should never happen, be paranoïd anyway...
					throw new CException (CString("CSerialized::Serialize, specified xml node is not a \"") + 
							      CSERIALIZED_XML_ELEMENT + CString("\" element one."), __exception(XMLPARSE));
				}
			}
		}
		break;

		// storing to xml
		case XML_WRITE :
		{
			// instanciate a new xml element
			CXMLElement *ioXMLElement = new CXMLElement (ioXMLElementNode, CSERIALIZED_XML_ELEMENT);

			// modify the input output node pointer to the current new allocated one
			ioXMLElementNode = *ioXMLElementNode -> GetChildren() [ioXMLElementNode -> GetChildren().GetLength() - 1];

			// write its attributes
			ioXMLElement -> AddAttribute (CSERIALIZED_XML_NAME_ATTRIBUTE, metaclass_cast(this) -> ClassName);
			ioXMLElement -> AddAttribute (CSERIALIZED_XML_TAG_ATTRIBUTE, ::ClassTagToString (classtag_cast(this)));
		}
		break;
	}
}

//-------------------------------------------------------------------------------------------------------------------------------------------
// metaclass search in
//-------------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CSerialized::GetMetaClass (CArchive &inArchive)
{
	UInt32 inClassTag = 0L;
	if (!inArchive.ReadUInt32 (inClassTag)) return NULL;
	inArchive--;
	return CMetaClass::GetMetaClass (inClassTag);
}

//-------------------------------------------------------------------------------------------------------------------------------------------
// metaclass search in
//-------------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CSerialized::GetMetaClass (CXMLElementNode *inXMLElementNode)
{
	if (::xml_node_get_name (inXMLElementNode) != CSERIALIZED_XML_ELEMENT)
		inXMLElementNode = ::xml_node_get_child (inXMLElementNode, const_cast <CString &> (CSERIALIZED_XML_ELEMENT));
	if (inXMLElementNode == NULL) return NULL;
	CXMLAttribute inXMLAttribute (::xml_node_get_attribute (inXMLElementNode, const_cast <CString &> (CSERIALIZED_XML_TAG_ATTRIBUTE)));
	return CMetaClass::GetMetaClass (::StringToClassTag (inXMLAttribute.GetValue()));
}

//-------------------------------------------------------------------------------------------------------------------------------------------
// class instanciation
//-------------------------------------------------------------------------------------------------------------------------------------------
CSerialized * CSerialized::Instanciate (CArchive &inArchive)
{
	const CMetaClass *inMetaClass = CSerialized::GetMetaClass (inArchive);
	if (inMetaClass == NULL || inMetaClass -> MetaClassType != METACLASS_DYNAMIC || inMetaClass -> ClassInstanciate == NULL ||
	    !CMetaClass::MetaClassIs (__metaclass(CSerialized), inMetaClass))
		return NULL;
	CSerialized *newInstance = static_cast <CSerialized *> (inMetaClass -> ClassInstanciate ());
	if (newInstance != NULL) inArchive >> *newInstance;
	return newInstance;
}

//-------------------------------------------------------------------------------------------------------------------------------------------
// class instanciation 	
//-------------------------------------------------------------------------------------------------------------------------------------------
CSerialized * CSerialized::Instanciate (CXMLElementNode *inXMLElementNode) THROWABLE
{
	const CMetaClass *inMetaClass = CSerialized::GetMetaClass (inXMLElementNode);
	if (inMetaClass == NULL || inMetaClass -> MetaClassType != METACLASS_DYNAMIC || inMetaClass -> ClassInstanciate == NULL ||
	    !CMetaClass::MetaClassIs (__metaclass(CSerialized), inMetaClass))
		return NULL;
	CSerialized *newInstance = static_cast <CSerialized *> (inMetaClass -> ClassInstanciate ());
	if (newInstance != NULL) newInstance -> Serialize (inXMLElementNode, XML_READ);
	return newInstance;
}

