=begin
  gettext/cgi.rb - GetText for CGI

  Copyright (C) 2005  Masao Mutoh

  You may redistribute it and/or modify it under the same
  license terms as Ruby.

  $Id: cgi.rb,v 1.4 2005/12/07 17:09:39 mutoh Exp $
=end

require 'cgi'
require 'gettext'

module Locale
  alias :orig_get :get
  alias :orig_set :set

  @@cgi = nil
  @@locale_cgi = nil

  module_function
  def cgi=(cgi)
    @@cgi = cgi
  end

  def cgi
    @@cgi = CGI.new unless @@cgi
    @@cgi
  end

  def normalize(lang)
    lang = lang.split(',').first.gsub(/_/, "-").split('-') rescue []
    language = lang[0]
    dialect  = lang[1]
    language = language ? language.downcase : 'en' # default is en
    dialect  = dialect ? "_#{dialect.upcase}" : ""
    ret = "#{language}#{dialect}" 
  end

  def get(lctype = Locale::CTYPE) #lctype doesn't used here.
    ret = @@locale_cgi
    unless ret
      @@cgi = CGI.new unless @@cgi
      if ret = @@cgi["lang"] and ret.size > 0
	$stderr.print "query_string: lang = #{ret}\n" if $DEBUG
      elsif ret = @@cgi.cookies["lang"][0]
	$stderr.print "cookie: lang = #{ret}\n" if $DEBUG
      elsif lang = @@cgi.accept_language
	$stderr.print "accept lanaugage: lang = #{lang}\n" if $DEBUG
	ret = normalize(lang)
      else
	ret = "en"
      end
    end
    $stderr.print "Locale.get = #{ret}\n" if $DEBUG
    ret
  end

  def set(lctype, loc)
    # Override this method. Because the value from WWW browser doesn't
    # match to the locale strings of POSIX setlocale.
    @@locale_cgi = loc
  end

  def codeset
    @@cgi = CGI.new unless @@cgi
    codesets = @@cgi.accept_charset
    if codesets
      ary = codesets.split(',')
      ary[0]
    else
      "UTF-8"
    end
  end

  alias :charset :codeset
  alias :setlocale :set
  alias :set_cgi :cgi=

  module_function :charset, :set_cgi, :set, :setlocale
end

module GetText
  def cgi=(cgi)
    @cgi = cgi
    Locale.cgi = cgi
  end

  def cgi
    @cgi = Locale.cgi unless @cgi
    @cgi
  end

  alias :set_cgi :cgi=

  module_function :cgi=, :set_cgi, :cgi
end
