/* $Id: builtins.c,v 1.2 2005/09/15 08:38:57 cegger Exp $
******************************************************************************

   LibGGIMisc builtin target bindings

   Copyright (c) 2005 Christoph Egger
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   The above copyright notice applies to all files in this package, unless 
   explicitly stated otherwise in the file itself or in a file named COPYING 
   in the same directory as the file.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


******************************************************************************
*/

#include "config.h"
#include <ggi/gg.h> /* We use LibGG to manage config files */
#include <ggi/internal/misc_debug.h>
#include <string.h>



typedef int (ggimiscfunc_dlinit)(int, void **);

#ifdef BUILTIN_DISPLAY
ggimiscfunc_dlinit GGIMISCdl_pseudo_stubs_ggimisc;
#endif
#ifdef BUILTIN_DISPLAY_FBDEV
ggimiscfunc_dlinit GGIMISCdl_fbdev_ggimisc;
#endif
#ifdef BUILTIN_DISPLAY_SVGALIB
ggimiscfunc_dlinit GGIMISCdl_svgalib_ggimisc;
#endif
#ifdef BUILTIN_DISPLAY_X
ggimiscfunc_dlinit GGIMISCdl_x_ggimisc;
#endif
#ifdef BUILTIN_DISPLAY_DIRECTX
ggimiscfunc_dlinit GGIMISCdl_directx_ggimisc;
#endif


struct target {
	const char *target;
	ggimiscfunc_dlinit *func;
};

static struct target _targets[] = {

#ifdef BUILTIN_DISPLAY
	{ "GGIMISCdl_pseudo_stubs_ggimisc", &GGIMISCdl_pseudo_stubs_ggimisc },
#endif
#ifdef BUILTIN_DISPLAY_FBDEV
	{ "GGIMISCdl_fbdev_ggimisc", &GGIMISCdl_fbdev_ggimisc },
#endif
#ifdef BUILTIN_DISPLAY_SVGALIB
	{ "GGIMISCdl_svgalib_ggimisc", &GGIMISCdl_svgalib_ggimisc },
#endif
#ifdef BUILTIN_DISPLAY_X
	{ "GGIMISCdl_x_ggimisc", &GGIMISCdl_x_ggimisc },
#endif
#ifdef BUILTIN_DISPLAY_DIRECTX
	{ "GGIMISCdl_directx_ggimisc", &GGIMISCdl_directx_ggimisc },
#endif
	{ NULL, NULL }
};



static void * _builtins_get(void * _, const char *symbol)
{
	struct target *t;

	for (t = _targets; t->target != NULL; t++) {
		if (!strcmp(t->target, symbol)) {
			DPRINT_LIBS("builtin symbol found: '%s'\n", symbol);
			return t->func;
		}
	}
	DPRINT_LIBS("builtin symbol '%s' not found\n", symbol);
	return NULL;
}

static gg_scope _builtins;

void _ggimiscInitBuiltins(void);
void _ggimiscExitBuiltins(void);

void _ggimiscInitBuiltins(void)
{
	_builtins = ggNewScope("@libggimisc", NULL, &_builtins_get, NULL);
}

void _ggimiscExitBuiltins(void)
{
	ggDelScope(_builtins);
}
