/* $Id: builtins.c,v 1.3 2005/09/14 08:47:39 cegger Exp $
******************************************************************************

   Libggiwmh builtin targets bindings.

   Copyright (C) 2005 Eric Faurot	[eric.faurot@gmail.com]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include <ggi/gg.h>
#include <ggi/internal/wmh_debug.h>
#include <string.h>

typedef int (ggiwmhfunc_dlinit)(int, void **);

#ifdef BUILTIN_DISPLAY
ggiwmhfunc_dlinit WMHdl_pseudo_stubs_wmh;
#endif
#ifdef BUILTIN_DISPLAY_X
ggiwmhfunc_dlinit WMHdl_X_wmh;
#endif
#ifdef BUILTIN_DISPLAY_QUARTZ
ggiwmhfunc_dlinit WMHdl_quartz_wmh;
#endif
#ifdef BUILTIN_DISPLAY_DIRECTX
ggiwmhfunc_dlinit WMHdl_directx_wmh;
#endif


struct target { 
	const char     *target;
	ggiwmhfunc_dlinit *func;
};

static struct target _targets[] = {

#ifdef BUILTIN_DISPLAY
	{ "WMHdl_pseudo_stubs_wmh", &WMHdl_pseudo_stubs_wmh },
#endif
#ifdef BUILTIN_DISPLAY_X
	{ "WMHdl_X_wmh", &WMHdl_X_wmh },
#endif
#ifdef BUILTIN_DISPLAY_QUARTZ
	{ "WMHdl_quartz_wmh", &WMHdl_quartz_wmh },
#endif
#ifdef BUILTIN_DISPLAY_DIRECTX
	{ "WMHdl_directx_wmh", &WMHdl_directx_wmh },
#endif
	{ NULL, NULL }
};




static void * _builtins_get(void * _, const char *symbol) {
	struct target * t;

	for(t = _targets; t->target != NULL; t++) {
		if(!strcmp(t->target, symbol)) {
			DPRINT_LIBS("builtin symbol found: '%s'\n", symbol);
			return t->func;
		}
	}
	DPRINT_LIBS("builtin symbol '%s' not found\n", symbol);
	return NULL;
}

static gg_scope _builtins;

void _ggiwmhInitBuiltins(void);
void _ggiwmhExitBuiltins(void);

void _ggiwmhInitBuiltins(void)
{
	_builtins = ggNewScope("@libggiwmh", NULL, &_builtins_get,  NULL);
}

void _ggiwmhExitBuiltins(void)
{
	ggDelScope(_builtins);
}
