/*
 * File: misc.h
 * Author: Brent Hendricks
 * Project: GGZ Common components library
 * Date: 2001-10-12
 *
 * Internal header file for ggz components lib
 *
 * Copyright (C) 2001-2002 Brent Hendricks.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


/* Libggz internal debugging function */
#ifdef DEBUG
void _ggz_debug(const char *type, const char *fmt, ...);
#else
#  define _ggz_debug(type, fmt, args...) (void)0
#endif

/* Libggz internal message output function */
void _ggz_msg(const char *fmt, ...);

struct _GGZFile {
	int fdes;	/* File descriptor */
	char *buf;	/* Data buffer */
	char *p;	/* Current position in buffer */
	char *e;	/* Points one char past end of valid data in buffer */
	int bufsize;	/* Current buffer size */
};
