// ENG2_QM_MM.H : the mixed QM/MM "engine" classes.

// Copyright (C) 2002 Tommi Hassinen.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#ifndef ENG2_QM_MM_H
#define ENG2_QM_MM_H

#include "libghemical-features.h"

class setup2_qm_mm;

#include "eng1_qm.h"
#include "eng1_mm_default.h"

#ifdef ENABLE_MOPAC7
class eng2_qm_mm_mopac;
#include "eng1_qm_mopac.h"
#endif	// ENABLE_MOPAC7

#ifdef ENABLE_MPQC
class eng2_qm_mm_mpqc;
#include "eng1_qm_mpqc.h"
#endif	// ENABLE_MPQC

/*################################################################################################*/

class setup2_qm_mm : public setup1_qm, public setup1_mm
{
	protected:

	static const i32u eng_id_tab[];
	static const char * eng_name_tab[];
	
	public:
	
	setup2_qm_mm(model *);
	~setup2_qm_mm(void);

	void UpdateAtomFlags(void);		// virtual
	
	static i32u static_GetEngineCount(void);
	static i32u static_GetEngineIDNumber(i32u);
	static const char * static_GetEngineName(i32u);
	static const char * static_GetClassName(void);
	
	i32u GetEngineCount(void);		// virtual
	i32u GetEngineIDNumber(i32u);		// virtual
	const char * GetEngineName(i32u);	// virtual
	const char * GetClassName_lg(void);	// virtual
	
	engine * CreateEngineByIndex(i32u);	// virtual
};

/*################################################################################################*/

#ifdef ENABLE_MOPAC7

class eng2_qm_mm_mopac : public eng1_qm_mopac, public eng1_mm_default_bp
{
	protected:
	
	public:
	
	eng2_qm_mm_mopac(setup *, i32u, i32u);
	~eng2_qm_mm_mopac(void);
	
	i32s GetOrbitalCount(void);	// virtual
	f64 GetOrbitalEnergy(i32s);	// virtual
	
	i32s GetElectronCount(void);	// virtual
	
	void Compute(i32u, bool = false);	// virtual
	
	virtual bool SetTorsionConstraint(atom *, atom *, atom *, atom *, f64, f64, bool) { cout << "callEXIT : SetTorsionConstraint() is not yet implemented at eng2_qm_mm_mopac!" << endl; exit(EXIT_FAILURE); }
	virtual bool RemoveTorsionConstraint(atom *, atom *, atom *, atom *) { cout << "callEXIT : RemoveTorsionConstraint() is not yet implemented at eng2_qm_mm_mopac!" << endl; exit(EXIT_FAILURE); }
	
	void SetupPlotting(void);	// virtual
	
	fGL GetVDWSurf(fGL *, fGL *);	// virtual
	
	fGL GetESP(fGL *, fGL *);	// virtual
	
	fGL GetElDens(fGL *, fGL *);	// virtual
	
	fGL GetOrbital(fGL *, fGL *);	// virtual
	fGL GetOrbDens(fGL *, fGL *);	// virtual
};

#endif	// ENABLE_MOPAC7

/*################################################################################################*/

#ifdef ENABLE_MPQC

class eng2_qm_mm_mpqc : public eng1_qm_mpqc, public eng1_mm_default_bp
{
	protected:
	
	public:
	
	eng2_qm_mm_mpqc(setup *, i32u, i32u);
	~eng2_qm_mm_mpqc(void);
	
	i32s GetOrbitalCount(void);	// virtual
	f64 GetOrbitalEnergy(i32s);	// virtual
	
	i32s GetElectronCount(void);	// virtual
	
	void Compute(i32u, bool = false);	// virtual
	
	virtual bool SetTorsionConstraint(atom *, atom *, atom *, atom *, f64, f64, bool) { cout << "callEXIT : SetTorsionConstraint() is not yet implemented at eng2_qm_mm_mpqc!" << endl; exit(EXIT_FAILURE); }
	virtual bool RemoveTorsionConstraint(atom *, atom *, atom *, atom *) { cout << "callEXIT : RemoveTorsionConstraint() is not yet implemented at eng2_qm_mm_mpqc!" << endl; exit(EXIT_FAILURE); }
	
	void SetupPlotting(void);	// virtual

	fGL GetVDWSurf(fGL *, fGL *);	// virtual
	
	fGL GetESP(fGL *, fGL *);	// virtual
	
	fGL GetElDens(fGL *, fGL *);	// virtual
	
	fGL GetOrbital(fGL *, fGL *);	// virtual
	fGL GetOrbDens(fGL *, fGL *);	// virtual
};

#endif	// ENABLE_MPQC

/*################################################################################################*/

#endif	// ENG2_QM_MM_H

// eof
