// GEOMOPT.H : geometry optimization classes.

// Copyright (C) 1998 Tommi Hassinen.

// This package is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this package; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

/*################################################################################################*/

#ifndef GEOMOPT_H
#define GEOMOPT_H

class geomopt_param;

class geomopt;

/*################################################################################################*/

#include "engine.h"
#include "eng1_qm.h"

#include "conjgrad.h"

/*################################################################################################*/

class geomopt_param
{
	protected:
	
	bool confirm;		// for GUI only...
	
	public:
	
	bool enable_nsteps;
	i32s treshold_nsteps;
	
	bool enable_grad;
	f64 treshold_grad;
	
	bool enable_delta_e;
	f64 treshold_delta_e;
	
	public:
	
	geomopt_param(setup * su)
	{
		confirm = false;
		
	// set the defaults...
	// ^^^^^^^^^^^^^^^^^^^
		
		enable_nsteps = true;
		treshold_nsteps = 2500;
	setup1_qm * suqm = dynamic_cast<setup1_qm *>(su);
	if (suqm != NULL) treshold_nsteps = 500;		// override...
		
		enable_grad = true;
		treshold_grad = 1.0e-3;
		
		enable_delta_e = false;
		treshold_delta_e = 1.0e-7;
	}
	
	~geomopt_param(void) { }
	
	bool GetConfirm(void) { return confirm; }
	void Confirm(void) { confirm = true; }
};

/*################################################################################################*/

/// A geometry optimization class.

class geomopt : public conjugate_gradient
{
	protected:
	
	engine * eng;
	
	public:
	
	geomopt(engine *, i32s, f64, f64);
	~geomopt(void);
	
	f64 GetValue(void);		// virtual
	f64 GetGradient(void);		// virtual
};

/*################################################################################################*/

#endif	// GEOMOPT_H

// eof
