/* $Id: quad.h,v 1.6 2004/01/31 11:31:57 cegger Exp $
***************************************************************************
   
   LibGG - 64bit arithmetic

***************************************************************************
*/


/* This code has been imported to GGI from NetBSD-current 2003-12-29 */

/*-
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)quad.h	8.1 (Berkeley) 6/4/93
 */


/*
 * Quad arithmetic.
 *
 * This library makes the following assumptions:
 *
 *  - The type long long (aka uint64) exists.
 *
 *  - A quad variable is exactly twice as long as `int'.
 *
 *  - The machine's arithmetic is two's complement.
 *
 * This library can provide 128-bit arithmetic on a machine with 128-bit
 * quads and 64-bit ints, for instance, or 96-bit arithmetic on machines
 * with 48-bit ints.
 */

#include "config.h"
#include "plat.h"


/* Get LLONG_MIN and LLONG_MAX defined
 * in <limits.h>
 */
#if defined(__WIN32__) && defined(__CYGWIN__)
#define __STDC_VERSION__	199901L
#endif

#include <sys/types.h>
#include <limits.h>


#if defined(GG_HAVE_INT64)

#if !defined(_QUAD_HIGHWORD) && !defined(_QUAD_LOWWORD)
#if defined(GGI_LITTLE_ENDIAN)
#define _QUAD_HIGHWORD 1
#define _QUAD_LOWWORD 0
#endif
#if defined(GGI_BIG_ENDIAN)
#define _QUAD_HIGHWORD 0
#define _QUAD_LOWWORD 1
#endif
#endif

#ifndef QUAD_MIN
#define QUAD_MIN	LLONG_MIN
#endif
#ifndef QUAD_MAX
#define QUAD_MAX	LLONG_MAX
#endif
#ifndef UQUAD_MAX
#define UQUAD_MAX	ULLONG_MAX
#endif

/*
 * Depending on the desired operation, we view a `long long' (aka quad_t) in
 * one or more of the following formats.
 */
union uu {
	sint64	q;		/* as a (signed) quad */
	uint64 uq;		/* as an unsigned quad */
	int	sl[2];		/* as two signed ints */
	u_int	ul[2];		/* as two unsigned ints */
};

/*
 * Define high and low parts of a quad_t.
 */
#define	H		_QUAD_HIGHWORD
#define	L		_QUAD_LOWWORD

/*
 * Total number of bits in a quad_t and in the pieces that make it up.
 * These are used for shifting, and also below for halfword extraction
 * and assembly.
 */
#define	QUAD_BITS	(sizeof(quad_t) * CHAR_BIT)
#define	INT_BITS	(sizeof(int) * CHAR_BIT)
#define	HALF_BITS	(sizeof(int) * CHAR_BIT / 2)

/*
 * Extract high and low shortwords from longword, and move low shortword of
 * longword to upper half of long, i.e., produce the upper longword of
 * ((quad_t)(x) << (number_of_bits_in_int/2)).  (`x' must actually be u_int.)
 *
 * These are used in the multiply code, to split a longword into upper
 * and lower halves, and to reassemble a product as a quad_t, shifted left
 * (sizeof(int)*CHAR_BIT/2).
 */
#define	HHALF(x)	((u_int)(x) >> HALF_BITS)
#define	LHALF(x)	((u_int)(x) & (((int)1 << HALF_BITS) - 1))
#define	LHUP(x)		((u_int)(x) << HALF_BITS)

typedef unsigned int	qshift_t;

__BEGIN_DECLS
sint64 __adddi3 (sint64, sint64);
sint64 __anddi3 (sint64, sint64);
sint64 __ashldi3 (sint64, qshift_t);
sint64 __ashrdi3 (sint64, qshift_t);
int __cmpdi2 (sint64, sint64);
sint64 __divdi3 (sint64, sint64);
sint64 __fixdfdi (double);
sint64 __fixsfdi (float);
uint64 __fixunsdfdi (double);
uint64 __fixunssfdi (float);
double __floatdidf (sint64);
float __floatdisf (sint64);
double __floatunsdidf (uint64);
sint64 __iordi3 (sint64, sint64);
sint64 __lshldi3 (sint64, qshift_t);
sint64 __lshrdi3 (sint64, qshift_t);
sint64 __moddi3 (sint64, sint64);
sint64 __muldi3 (sint64, sint64);
sint64 __negdi2 (sint64);
sint64 __one_cmpldi2 (sint64);
uint64 __qdivrem (uint64, uint64, uint64 *);
sint64 __subdi3 (sint64, sint64);
int __ucmpdi2 (uint64, uint64);
uint64 __udivdi3 (uint64, uint64);
uint64 __umoddi3 (uint64, uint64);
sint64 __xordi3 (sint64, sint64);
__END_DECLS

#endif	/* GG_HAVE_INT64 */
