dnl Check for safe and secure string functions

AC_DEFUN([GGI_CHECK_STRING_FUNCS],
[

dnl strings.h exists on SYSV systems
dnl and contains strcasecmp() and strncasecmp()
AC_CHECK_HEADERS(string.h strings.h)

AC_CHECK_DECLS([strcasecmp, strncasecmp,
	strncat, strncpy, snprintf,
	strlcpy, strlcat, asprintf])

if test "x$ac_cv_have_decl_strcasecmp" = "xyes"; then
	AC_CHECK_FUNCS([strcasecmp])
fi
if test "x$ac_cv_have_decl_strncasecmp" = "xyes"; then
	AC_CHECK_FUNCS([strncasecmp])
fi
if test "x$ac_cv_have_decl_strncat" = "xyes"; then
	AC_CHECK_FUNCS([strncat])
fi
if test "x$ac_cv_have_decl_strncpy" = "xyes"; then
	AC_CHECK_FUNCS([strncpy])
fi
if test "x$ac_cv_have_decl_snprintf" = "xyes"; then
	AC_CHECK_FUNCS([snprintf])
fi
if test "x$ac_cv_have_decl_strlcpy" = "xyes"; then
	AC_CHECK_FUNCS([strlcpy])
fi
if test "x$ac_cv_have_decl_strlcat" = "xyes"; then
	AC_CHECK_FUNCS([strlcat])
fi
if test "x$ac_cv_have_decl_asprintf" = "xyes"; then
	AC_CHECK_FUNCS([asprintf])
fi

])
