import unittest
from support import GNATCOLL_TestCase, chdir, pathsep, requires_not_windows
import os
import sys


def requires_email_data(func):
    def wrapped(*args):
        if os.path.isdir("email/email_data"):
            return func(*args)
        if hasattr(unittest, "SkipTest"):
            raise unittest.SkipTest("No email_data available")
    return wrapped


class Test(GNATCOLL_TestCase):
    def setUp(self):
        # See man tzset(3) for more information on the format of this variable
        # Let's go to newzealand.
        # This fails on Windows, so disable for now

        os.environ["TZ"] = "NZS-12"

    @requires_not_windows
    @chdir("email3")
    def test_email3(self):
        self.gprbuild()
        self.runexec("obj/test_email3", "test_email3.expected")

    @requires_email_data
    @chdir("email4")
    def test_multiple_files_in_single_mbox(self):
        self.gprbuild()
        self.runexec("obj/test_email4", "")

    @requires_email_data
    @chdir("email5")
    def test_threading(self):
        self.gprbuild()
        self.runexec("obj/test_email5", "test_email5.expected")

    # Disabled on windows, since the env. variable TZ is not taken into account
    # and thus the results are different
    @requires_not_windows
    @requires_email_data
    @chdir("email1")
    def test_api(self):
        self.gprbuild()
        self.runexec("obj/test_email", "test_email.expected")

    @requires_email_data
    @chdir("email6")
    def test_splitted_headers(self):
        self.gprbuild()
        self.runexec("obj/test_email6", "test_email6.expected")

    @chdir("encode")
    def test_encode(self):
        self.gprbuild()
        self.runexec("obj/encode_test", "")

    # Do not run on Windows, we do not know how to setup the proper
    # timezones, and the TZ environment variable is not enough
    # (see MA16-015)
    @requires_not_windows
    @chdir("date")
    def test_date(self):
        self.gprbuild()
        self.runexec("obj/test_email_date", "test_email_date.expected")

    @chdir("L619-017")
    def test_L619_017(self):
        self.gprbuild()
        self.runexec("obj/parse", "test.out")

    @chdir("M409-021")
    def test_M409_021(self):
        self.gprbuild()
        self.runexec("obj/process_msg", "test.out")
