with GNATCOLL.Projects;          use GNATCOLL.Projects;
with GNATCOLL.VFS;               use GNATCOLL.VFS;
with GNATCOLL.Traces; use GNATCOLL.Traces;
with Ada.Text_IO;

procedure test_it is
   Source_Project_Tree : GNATCOLL.Projects.Project_Tree;
   Proj : Project_Type;
begin
   Parse_Config_File;

   declare
      Dummy : constant String := Register_New_Attribute
        (Name => "harness_dir",
         Pkg  => "gnattest");
   begin
      if Dummy /= "" then
         Ada.Text_IO.Put_Line (Dummy);
         return;
      end if;
   end;

   Source_Project_Tree.Load (GNATCOLL.VFS.Create (+"testlib.gpr"));

   Proj := Source_Project_Tree.Root_Project;

   declare
      Attr : constant Attribute_Pkg_String :=
        Build ("gnattest", "harness_dir");
   begin
      if not Has_Attribute (Proj, Attr) then
         Ada.Text_IO.Put_Line ("user defined attribute not found");
      end if;

      Ada.Text_IO.Put_Line ("Value is '"
         & Attribute_Value (Proj, Attr) & "'");
   end;

end test_it;
