#
# $Header: /cvsroot/gtk2-perl/gtk2-perl-xs/Gnome2/Makefile.PL,v 1.37 2004/04/27 18:48:29 kaffeetisch Exp $
#

use 5.008;
use strict;
use warnings;
use ExtUtils::MakeMaker;
use Cwd;
use File::Spec;

# minimum required version of dependencies we need to build
our %build_reqs = (
	'perl-ExtUtils-Depends'   => '0.20',
	'perl-ExtUtils-PkgConfig' => '1.03',
	'perl-Glib'               => '1.04',
	'perl-Gtk2'               => '1.00',
	'perl-Gnome2-Canvas'      => '1.00',
	'perl-Gnome2-VFS'         => '1.00',
	'Gnome'                   => '2.0.0',
	'Bonobo'                  => '2.0.0',
);

# Writing a fake Makefile ensures that CPAN will pick up the correct
# dependencies and install them.
unless (eval "use ExtUtils::Depends '$build_reqs{'perl-ExtUtils-Depends'}';"
           . "use ExtUtils::PkgConfig '$build_reqs{'perl-ExtUtils-PkgConfig'}';"
           . "use Glib '$build_reqs{'perl-Glib'}';"
           . "use Gtk2 '$build_reqs{'perl-Gtk2'}';"
           . "use Gnome2::Canvas '$build_reqs{'perl-Gnome2-Canvas'}';"
           . "use Gnome2::VFS '$build_reqs{'perl-Gnome2-VFS'}';"
	   . "use Gtk2::CodeGen;"
           . "use Glib::MakeHelper;"
           . "1") {
   warn "$@\n";
   WriteMakefile(
         PREREQ_FATAL => 1,
         PREREQ_PM    => {
            'Glib'                => $build_reqs{'perl-Glib'},
            'Gtk2'                => $build_reqs{'perl-Gtk2'},
            'Gnome2::Canvas'      => $build_reqs{'perl-Gnome2-Canvas'},
            'Gnome2::VFS'         => $build_reqs{'perl-Gnome2-VFS'},
            'ExtUtils::Depends'   => $build_reqs{'perl-ExtUtils-Depends'},
            'ExtUtils::PkgConfig' => $build_reqs{'perl-ExtUtils-PkgConfig'},
         },
   );
   exit 1; # not reached
}

# now let's get started on the real work...
# in theory, getting what we need to build libgnomeui should 
# also get everything we need for libgnome.
my %libgnomeui_pkgcfg = ExtUtils::PkgConfig->find ("libgnomeui-2.0 >= $build_reqs{Gnome}");
my %libbonoboui_pkgcfg = ExtUtils::PkgConfig->find("libbonoboui-2.0 >= $build_reqs{Bonobo}");

mkdir 'build', 0777;

our @xs_files = <xs/*.xs>;
our %pod_files = (
	'Gnome2.pm' => '$(INST_MAN3DIR)/Gnome2.$(MAN3EXT)',
	# we will be installing a whole slew of pod files, generated directly
	# from the xs source -- but to have them installed and manified
	# properly, we have to know their names at Makefile.PL time.
	#   This is a bit of a chicken and egg problem, and this solution
	# basically means that if you create a new package name in the xs
	# code, you'll need to re-run Makefile.PL.  you already need to
	# re-run to pick up new XS files, so that's not such a big deal. 
	Glib::MakeHelper->do_pod_files (@xs_files),
);

#
# autogeneration
#
Gtk2::CodeGen->parse_maps ('gnome2perl');
Gtk2::CodeGen->write_boot;

#
# create version guards for the libs that don't provide them.
#
ExtUtils::PkgConfig->write_version_macros(
	"build/gnome2perl-versions.h",
	'libgnome-2.0' => 'LIBGNOME',
	'libgnomeui-2.0' => 'LIBGNOMEUI',
	'libbonoboui-2.0' => 'LIBBONOBOUI',
);


# now we're ready to start creating the makefile.
# we need to use ExtUtils::Depends to get relevant information out of
# the Glib extension, and to save config information for other modules which
# will chain from this one.

our $gnome2 = ExtUtils::Depends->new ('Gnome2', 'Gnome2::Canvas', 'Gnome2::VFS');
$gnome2->set_inc ($libgnomeui_pkgcfg{cflags} . " " . $libbonoboui_pkgcfg{cflags});
$gnome2->set_libs ($libgnomeui_pkgcfg{libs} . " " . $libbonoboui_pkgcfg{libs});
$gnome2->add_xs (@xs_files);
$gnome2->add_pm ('Gnome2.pm' => '$(INST_LIBDIR)/Gnome2.pm');
$gnome2->add_typemaps (map {File::Spec->catfile(cwd(), $_)} 'build/gnome2perl.typemap', 'gnome.typemap');

$gnome2->install (qw(gnome2perl.h
                     build/gnome2perl-autogen.h
                     build/gnome2perl-versions.h
                     doctypes));
$gnome2->save_config ('build/IFiles.pm');

WriteMakefile(
    NAME            => 'Gnome2',
    VERSION_FROM    => 'Gnome2.pm', # finds $VERSION
    ABSTRACT_FROM   => 'Gnome2.pm', # retrieve abstract from module
    XSPROTOARG      => '-noprototypes',
    MAN3PODS        => \%pod_files,
    $gnome2->get_makefile_vars,
);

sub MY::postamble {
	return Glib::MakeHelper->postamble_clean ()
	     . Glib::MakeHelper->postamble_docs_full (
			DEPENDS => $main::gnome2,
			DOCTYPES => 'doctypes',
			COPYRIGHT_FROM => 'copyright.pod'
	       )
	     . Glib::MakeHelper->postamble_rpms (
			'GNOME' => $build_reqs{'Gnome'},
			'PERL_EXTUTILS_DEPENDS' => 
				$build_reqs{'perl-ExtUtils-Depends'},
			'PERL_EXTUTILS_PKGCONFIG' => 
				$build_reqs{'perl-ExtUtils-PkgConfig'},
			'PERL_GLIB' => $build_reqs{'perl-Glib'},
			'PERL_GTK' => $build_reqs{'perl-Gtk2'},
			'PERL_GNOME_CANVAS' => $build_reqs{'perl-Gnome2-Canvas'},
			'PERL_GNOME_VFS' => $build_reqs{'perl-Gnome2-VFS'},
		);
}
