#!/bin/sh

prefix=/usr
libdir=${prefix}/lib/DEB_HOST_MULTIARCH
alidir=${prefix}/lib/DEB_HOST_MULTIARCH/ada/adalib/gtkada
includedir=${prefix}/share/ada/adainclude/gtkada
gtk_libs="-L${libdir} GTKADA_LDFLAGS"

cflags_static="-aI${includedir} -aO${alidir}"
cflags_relocatable="-aI${includedir} -aO${alidir}"
libs_relocatable="-L${libdir} -lgtkada ${gtk_libs}"
libs_static="${libdir}/libgtkada.a ${gtk_libs}"

usage()
{
        cat <<EOF
Usage: gtkada-config [OPTIONS]
Options:
        [--prefix]
        [--version|-v]
        [--libs]
        [--cflags]
        [--static]
        [--help|-h]
EOF
        exit $1
}

show_cflags=1
show_libs=1
libtype=relocatable

while test $# -gt 0; do
  case "$1" in
  -*=*) optarg=`echo "$1" | sed 's/[-_a-zA-Z0-9]*=//'` ;;
  *) optarg= ;;
  esac

  case $1 in
    --help|-h)
      usage 1>&2
      exit 1
      ;;
    --static)
      libtype=static
      ;;
    --prefix)
      echo $prefix
      exit 0
      ;;
    --version|-v)
      echo GTKADA_VERSION
      exit 0
      ;;
    --libs)
      show_libs=1
      show_cflags=0
      ;;
    --cflags)
      show_libs=0
      show_cflags=1
      ;;
    *)
      usage 1>&2
      exit 1
      ;;
  esac
  shift
done

result=""

if [ $show_cflags = 1 ]; then
   if [ $libtype = static ]; then
      result="$cflags_static"
   else
      result="$cflags_relocatable"
   fi

   if [ $show_libs = 1 ]; then
     result="$result -largs "
   fi
fi

if [ $show_libs = 1 ]; then
   if [ $libtype = static ]; then
     result="${result}${libs_static}"
   else
     result="${result}${libs_relocatable}"
   fi
fi

echo $result
