/*******************************************************************************************************************************************
 centry.c
*******************************************************************************************************************************************/

#include "centry.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CEntryListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CEntryListener::CEntryListener ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CEntryListener::~CEntryListener ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// CEntry::OnInsertText
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::OnInsertText (GtkEditable *inGtkEditable, gchar *ioText, gint, gint *ioPosition, gpointer inData)
{
	// get the text as a string
	CString ioString (ioText);

	// default to accept...
        Bool doAccept = true;

	// retreive our instance
        CEntry *theEntry = reinterpret_cast <CEntry *> (inData);

	// listener function call if any
        if (theEntry != NULL && theEntry -> GetListener() != NULL)
		static_cast <CEntryListener *> (theEntry -> GetListener()) ->
                	OnQueryInsert (theEntry, ioString, (UInt16&)*ioPosition, doAccept);

	// check the query result
        if (doAccept)
        {
		// disconnect the signal
                ::g_signal_handlers_disconnect_by_func (G_OBJECT(inGtkEditable), (void*)G_CALLBACK(CEntry::OnInsertText), theEntry);

		// set the property
                ::gtk_editable_insert_text (inGtkEditable, ioString.Get(), ioString.GetLength(), ioPosition);

		// reconnect the signal
                ::g_signal_connect (G_OBJECT(inGtkEditable), "insert-text", G_CALLBACK(CEntry::OnInsertText), theEntry);
        }

	// stop
        ::g_signal_stop_emission_by_name (GTK_OBJECT(inGtkEditable), "insert_text");
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CEntry::OnDeleteText
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::OnDeleteText (GtkEditable *inGtkEditable, gint inStart, gint inEnd, gpointer inData)
{
	// retreive the instance
	CEntry *theEntry = reinterpret_cast <CEntry *> (inData);
	
	// default to accept...
        Bool doAccept = true;

	// send the request to the listener if any
        if (theEntry != NULL && theEntry -> GetListener() != NULL)
		static_cast <CEntryListener *> (theEntry -> GetListener()) ->
                	OnQueryDelete (theEntry, (UInt16&)inStart, (UInt16&)inEnd, doAccept);

	// check result
        if (doAccept)
        {
		// disconnect the function
                ::g_signal_handlers_disconnect_by_func (G_OBJECT(inGtkEditable), (void*)G_CALLBACK(CEntry::OnDeleteText), theEntry);

		// set the associated property
                ::gtk_editable_delete_text (inGtkEditable, inStart, inEnd);

		// reconnect the signal
                ::g_signal_connect (G_OBJECT(inGtkEditable), "delete-text", G_CALLBACK(CEntry::OnDeleteText), theEntry);
        }

	// stop the signal emission
        ::g_signal_stop_emission_by_name (GTK_OBJECT(inGtkEditable), "delete_text");
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CEntry::OnChange
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::OnChange (GtkEditable *, gpointer inData)
{
	// retreive our instance
	CEntry *theEntry = reinterpret_cast <CEntry *> (inData);

	// send the notification to the listener if any
	if (theEntry != NULL && theEntry -> GetListener() != NULL)
		static_cast <CEntryListener *> (theEntry -> GetListener()) -> OnChange (theEntry);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// CEntry::OnEditingDone
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::OnEditingDone (GtkCellEditable *, gpointer inData)
{
	// retreive our instance
	CEntry *theEntry = reinterpret_cast <CEntry *> (inData);

	// send the notification to the listener if any
	if (theEntry != NULL && theEntry -> GetListener() != NULL)
		static_cast <CEntryListener *> (theEntry -> GetListener()) -> OnEditingDone (theEntry);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CEntry);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CEntry::CEntry  (CContainer *inOwner, const CEntryListener *inListener)
       :CWidget (inOwner, inListener)
{
	// widget instanciation requested
	if (inOwner != NULL) CWidget::CreateWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CEntry::~CEntry ()
{
	// deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CEntry::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_entry_new();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget initialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::PerformWidgetInitialize ()
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// connect the signals
	::g_signal_connect (G_OBJECT(inGtkWidget), "insert-text",  G_CALLBACK(CEntry::OnInsertText),  this);
        ::g_signal_connect (G_OBJECT(inGtkWidget), "delete-text",  G_CALLBACK(CEntry::OnDeleteText),  this);
        ::g_signal_connect (G_OBJECT(inGtkWidget), "changed",      G_CALLBACK(CEntry::OnChange),      this);
	::g_signal_connect (G_OBJECT(inGtkWidget), "editing-done", G_CALLBACK(CEntry::OnEditingDone), this);

	// show the widget
	Show();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// listener affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
const CMetaClass * CEntry::ListenerMustBe () const
{
	return __metaclass(CEntryListener);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// expected owner
//-----------------------------------------------------------------------------------------------------------------------------------------
CMetaClasses CEntry::OwnerMustBe () const
{
	return __metaclasses(CContainer);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// set the entry text
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::SetText (const CString &inText)
{
	// our widget
        GtkWidget *inGtkWidget (GetGtkWidget());

        // check pointer
        if (inGtkWidget != NULL)
        {
		// disconnect the signal functions
                ::g_signal_handlers_disconnect_by_func (G_OBJECT(inGtkWidget), (void*)G_CALLBACK(CEntry::OnInsertText),  this);
                ::g_signal_handlers_disconnect_by_func (G_OBJECT(inGtkWidget), (void*)G_CALLBACK(CEntry::OnDeleteText),  this);
                ::g_signal_handlers_disconnect_by_func (G_OBJECT(inGtkWidget), (void*)G_CALLBACK(CEntry::OnChange),      this);
		::g_signal_handlers_disconnect_by_func (G_OBJECT(inGtkWidget), (void*)G_CALLBACK(CEntry::OnEditingDone), this);

		// property affectation
                ::gtk_entry_set_text (GTK_ENTRY(inGtkWidget), inText.Get());

		// signal reconnection
                ::g_signal_connect (G_OBJECT(inGtkWidget), "insert-text",  G_CALLBACK(CEntry::OnInsertText),  this);
                ::g_signal_connect (G_OBJECT(inGtkWidget), "delete-text",  G_CALLBACK(CEntry::OnDeleteText),  this);
                ::g_signal_connect (G_OBJECT(inGtkWidget), "changed",      G_CALLBACK(CEntry::OnChange),      this);
		::g_signal_connect (G_OBJECT(inGtkWidget), "editing-done", G_CALLBACK(CEntry::OnEditingDone), this);
        }
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// get the entry text
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CEntry::GetText () const
{
	// get our widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return inGtkWidget != NULL ? CString(::gtk_entry_get_text (GTK_ENTRY(inGtkWidget))) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// max length affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::SetMaxLength (const SInt16 inMaxLength)
{
	if (GetGtkWidget() != NULL) ::gtk_entry_set_max_length (GTK_ENTRY(GetGtkWidget()), inMaxLength);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// max length access
//-----------------------------------------------------------------------------------------------------------------------------------------
SInt16 CEntry::GetMaxLength () const
{	
	return GetGtkWidget() != NULL ? ::gtk_entry_get_max_length (GTK_ENTRY(GetGtkWidget())) : 0;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// visibility attribute writer
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::SetVisibility (const bool inVisibility)
{
	if (GetGtkWidget() != NULL) ::gtk_entry_set_visibility (GTK_ENTRY(GetGtkWidget()), inVisibility);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// visibility attribute reader
//-----------------------------------------------------------------------------------------------------------------------------------------
bool CEntry::GetVisibility () const
{
	return GetGtkWidget() != NULL ? ::gtk_entry_get_visibility (GTK_ENTRY(GetGtkWidget())) : false;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// invisible char
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::SetInvisibleChar (const SInt8 inChar)
{
	if (GetGtkWidget() != NULL) ::gtk_entry_set_invisible_char (GTK_ENTRY(GetGtkWidget()), inChar);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// invisible char
//-----------------------------------------------------------------------------------------------------------------------------------------
SInt8 CEntry::GetInvisibleChar () const
{
	return GetGtkWidget() != NULL ? ::gtk_entry_get_invisible_char (GTK_ENTRY(GetGtkWidget())) : '*';
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// set has frame
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::SetHasFrame (const bool inFrame)
{
	if (GetGtkWidget() != NULL) ::gtk_entry_set_has_frame (GTK_ENTRY(GetGtkWidget()), inFrame);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// has frame ?
//-----------------------------------------------------------------------------------------------------------------------------------------
bool CEntry::GetHasFrame () const
{
	return GetGtkWidget() != NULL ? ::gtk_entry_get_has_frame (GTK_ENTRY(GetGtkWidget())) : false;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// cut
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::Cut ()
{
	if (GetGtkWidget() != NULL) ::gtk_editable_cut_clipboard (GTK_EDITABLE(GetGtkWidget()));
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// copy
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::Copy ()
{
	if (GetGtkWidget() != NULL) ::gtk_editable_copy_clipboard (GTK_EDITABLE(GetGtkWidget()));
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// paste
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::Paste ()
{
	if (GetGtkWidget() != NULL) ::gtk_editable_paste_clipboard (GTK_EDITABLE(GetGtkWidget()));
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// editable state affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::SetEditable (const bool inEditable)
{
	if (GetGtkWidget() != NULL) ::gtk_editable_set_editable (GTK_EDITABLE(GetGtkWidget()), inEditable);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// editable state access
//-----------------------------------------------------------------------------------------------------------------------------------------
bool CEntry::GetEditable () const
{
	return GetGtkWidget() != NULL ? ::gtk_editable_get_editable (GTK_EDITABLE(GetGtkWidget())) : false;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// text selection
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::Select (const SInt16 inStart, const SInt16 inEnd)
{
	if (GetGtkWidget() != NULL) ::gtk_editable_select_region (GTK_EDITABLE(GetGtkWidget()), inStart, inEnd);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// text get selection
//----------------------------------------------------------------------------------------------------------------------------------------- 
CString CEntry::GetSelection (SInt16 *outStart, SInt16 *outEnd) const
{
	// potential indices
	SInt32 inStart = 0L;
        SInt32 inEnd   = 0L;

        // get those indices
        if (GetGtkWidget() != NULL)
                if (!::gtk_editable_get_selection_bounds (GTK_EDITABLE(GetGtkWidget()), (gint*)&inStart, (gint*)&inEnd))
                        return CString();

        // param output copy
        if (outStart != NULL) *outStart = inStart;
        if (outEnd   != NULL) *outEnd   = inEnd;

        // set the associated string
        CString outString (GetText());
        outString.Delete (inEnd, outString.GetLength()-inEnd);
        outString.Delete (0, inStart);

        // ok
        return outString;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// cursor position affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::SetPosition (const SInt16 inPosition)
{
	if (GetGtkWidget() != NULL) ::gtk_editable_set_position (GTK_EDITABLE(GetGtkWidget()), (gint)inPosition);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// cursor position access
//-----------------------------------------------------------------------------------------------------------------------------------------
SInt16 CEntry::GetPosition () const
{
	return GetGtkWidget() != NULL ? ::gtk_editable_get_position (GTK_EDITABLE(GetGtkWidget())) : 0L;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// serialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CEntry::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic call first
	CWidget::Serialize (ioXMLElementNode, inMode);

	// request analyse
	switch (inMode)
	{
		// dump
		case XML_WRITE :
		{
			// instanciate a new xml element 
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_ENTRY_ELEMENT);

			// get the selection indices, the invisible char
//			SInt32 inStart, inEnd; CString inSelection (GetSelection ((SInt16*)&inStart, (SInt16*)&inEnd));
			SInt8 inInvisibleChar[2] = { GetInvisibleChar(), '\0' };

			// add the xml element attributes
			newXMLElement -> AddAttribute (XML_ENTRY_ATTR_TEXT, 		GetText());
			newXMLElement -> AddAttribute (XML_ENTRY_ATTR_MAX_LENGTH, 	CString((SInt32)GetMaxLength()));
			newXMLElement -> AddAttribute (XML_ENTRY_ATTR_VISIBILITY, 	CString(GetVisibility()?"true":"false"));
			newXMLElement -> AddAttribute (XML_ENTRY_ATTR_INVISIBLE_CHAR, 	CString(inInvisibleChar));
			newXMLElement -> AddAttribute (XML_ENTRY_ATTR_HAS_FRAME, 	CString(GetHasFrame()?"true":"false"));
			newXMLElement -> AddAttribute (XML_ENTRY_ATTR_EDITABLE, 	CString(GetEditable()?"true":"false"));
			newXMLElement -> AddAttribute (XML_ENTRY_ATTR_POSITION, 	CString((SInt32)GetPosition()));
/*
			newXMLElement -> AddAttribute (XML_ENTRY_ATTR_SELECTION_BEG, 	CString(inSelection!=CString()?inStart:0L));
			newXMLElement -> AddAttribute (XML_ENTRY_ATTR_SELECTION_END, 	CString(inSelection!=CString()?inEnd  :0L));
*/
			// change the io xml element node so that derivation would continue under the current definition
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;

		// load
		case XML_READ :
		{
			// get the child node this serialization process is interested in
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_ENTRY_ELEMENT);

			// check we got the expected node
			if (inXMLNode == NULL)
				throw new CException (CString("CEntry::Serialize, specified xml node is not a \"") + 
							      XML_ENTRY_ELEMENT + CString("\" element one."), __exception(XMLPARSE));

			// modify the in/out element node pointer so that the serialization process will continue under the current node
			ioXMLElementNode = inXMLNode;

			// retreive the attributes and set them
			SetText 	 ( ::xml_node_get_attribute (inXMLNode, XML_ENTRY_ATTR_TEXT	     ).GetValue());
			SetMaxLength	 ( ::xml_node_get_attribute (inXMLNode, XML_ENTRY_ATTR_MAX_LENGTH    ).GetValue().ToLong());
			SetVisibility 	 ( ::xml_node_get_attribute (inXMLNode, XML_ENTRY_ATTR_VISIBILITY    ).GetValue().ToBool());
			SetInvisibleChar (*::xml_node_get_attribute (inXMLNode, XML_ENTRY_ATTR_INVISIBLE_CHAR).GetValue()[0]);
			SetHasFrame 	 ( ::xml_node_get_attribute (inXMLNode, XML_ENTRY_ATTR_HAS_FRAME     ).GetValue().ToBool());
			SetEditable	 ( ::xml_node_get_attribute (inXMLNode, XML_ENTRY_ATTR_EDITABLE      ).GetValue().ToBool());
			SetPosition	 ( ::xml_node_get_attribute (inXMLNode, XML_ENTRY_ATTR_POSITION      ).GetValue().ToLong());
/*
			Select		 ( ::xml_node_get_attribute (inXMLNode, XML_ENTRY_ATTR_SELECTION_BEG ).GetValue().ToLong(),
					   ::xml_node_get_attribute (inXMLNode, XML_ENTRY_ATTR_SELECTION_END ).GetValue().ToLong());
*/
		}
		break;
	}
}



