/*******************************************************************************************************************************************
 chseparator.c
*******************************************************************************************************************************************/

#include "chseparator.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CHSeparator);

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CHSeparator::CHSeparator (CContainer *inOwner, const CWidgetListener *inListener)
	    :CSeparator	 (inOwner, inListener)
{
	// widget instanciation requested
	if (inOwner != NULL) CWidget::CreateWidget (this);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CHSeparator::~CHSeparator ()
{
	// deletion coherence requested
	CWidget::DestroyWidget (this);
}

//------------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//------------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CHSeparator::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_hseparator_new ();
}
