/*******************************************************************************************************************************************
 cstatusbar.h
 
 CClass	
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
	     |--CControl
	        |--CWidget
		   |--CContainer
		      |--CLayout
		         |--CBoxLayout
			    |--CHBoxLayout
			       |--CStatusBar

 Standard statusbar definition.
*******************************************************************************************************************************************/

#ifndef __CSTATUSBAR_H__
#define __CSTATUSBAR_H__

#include "chboxlayout.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// cstatusbar xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cstatusbar has-resize-grip="bool">
//    ...
// </cstatusbar>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_STATUSBAR_ELEMENT			("cstatusbar");
static CString XML_STATUSBAR_ATTR_HAS_RESIZE_GRIP	("has-resize-grip");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CStatusBar class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CStatusBar : public CHBoxLayout
{
	// instanciation section
	public :
		
		CStatusBar			(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CStatusBar		();

	// protected requests handling
	protected :
		
		// gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// statusbar specifics
	public :

		// resize grip
		virtual void			SetHasResizeGrip		(const Bool);
		Bool				GetHasResizeGrip		() const;

		// caption access
		virtual void			SetCaption			(const CString &);
		CString				GetCaption			() const;

	// cserialized redefinition
	public :

		// cstatusbar serialization handling
		virtual void			Serialize			(CXMLElementNode *&, const int) THROWABLE;

	// protected section
	protected :

		UInt32				m_ContextId;
		CString				m_Caption;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('stbr', CStatusBar, CHBoxLayout);

#endif
