/*******************************************************************************************************************************************
 ccontainer.h
 
 CClass
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
   	     |--CControl
	        |--CWidget
	   	   |--CContainer

 Gtk container notion generic gtkol abstraction definition. The Gtk container definition derives many structures. As GtkOL does not map the
 GtkBin definition that restricts a container to only one child handling, the default behaviour of a CContainer class is to handle only one 
 child unless beeing derived to a GtkOL CLayout or a CMenu that overwrites this restriction.
*******************************************************************************************************************************************/

#ifndef __CCONTAINER_H__
#define __CCONTAINER_H__

#include "cwidget.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// ccontainer xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <ccontainer padding="UInt32">
//    ...
// </ccontainer>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_CONTAINER_ELEMENT 		("ccontainer");
static CString XML_CONTAINER_ATTR_PADDING	("padding");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CContainer class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CContainer : public CWidget
{
	// instanciation section
	public :

		CContainer			(CComponent *inOwner, const CWidgetListener *inListener=NULL);
		virtual ~CContainer		() =0;

	// container specific protected functions
	protected :

		// those two functions should be overwritten whenever the container is derived to a specific one; such overloaded 
		// definitions as layouts should use the container indexed widgets services to get the specified children placements and 
		// do the appropriate job accordinaly; when those requests are called, the associated gtk widget must be already allocated
		// and the instance must be set in the gtkol hierarchy so no need to check for mistakes about that in derivations !
		virtual void			PerformContainerAdd		(CWidget *inChild);
		virtual void			PerformContainerRemove		(CWidget *inChild);

	// CComponent functionalities add on
	public :

		// get the container maximum children number handling left, defaults to 1 at this level or 0 if there is already one
		// handled child (should be -1 for unlimited handling); has to be overloaded when deriving to layouts or any special 
		// widget that is not a GtkBin binding
		virtual SInt16			GetGtkChildrenNumberLeft	() const;

		// direct children of potential requested and rejected type specifications (i.e. the desired components must be
		// derived from "inRequested" type and must not be derived from "inRejected" type); the inRequested type must derive at
		// least the CWidget definition; returns all the gtkol widgets that are handled by the container i.e. those whose 
		// m_PerformContainerProcess is set to true
		CWidgets 			GetGtkChildren			(const CMetaClass *inRequested=__metaclass(CWidget), 
										 const CMetaClass *inRejected=NULL) const;

		// in owner direct child widget index; index incrementation only on specified "inRequested" type if any, -1 if not found
		static SInt16			GetGtkInOwnerIndex		(const CContainer *inOwner, const CWidget *inChild,
										 const CMetaClass *inRequested=__metaclass(CWidget), 
										 const CMetaClass *inRejected=NULL);

	// container specific public functions
	public :

		// container padding
		virtual void			SetPadding			(const UInt16 inPadding);
		UInt16				GetPadding			() const;

	// serialization redefinition
	public :

		// ccontainer xml serialization handling
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;

		// friend class CWidget that calls PerformContainerAdd and PerformContainerRemove when needed
		friend class			CWidget;
	
		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('ctnr', CContainer, CWidget);

#endif
