/*******************************************************************************************************************************************
 cframe.h
 
 CClass
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
   	     |--CControl
	        |--CWidget
	   	   |--CContainer
		      |--CFrame

 The frame widget surrounds its child with a decorative frame and an optional label.
*******************************************************************************************************************************************/

#ifndef __CFRAME_H__
#define __CFRAME_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// cframe xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cframe caption="string" caption-align-x="[0f-1f]" caption-align-y="[0f-1f]" shadow-type="none|in|out|etched-in|etched-out">
//    ...
// </cframe>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_FRAME_ELEMENT 		("cframe");
static CString XML_FRAME_ATTR_CAPTION		("caption");
static CString XML_FRAME_ATTR_CAPTION_ALIGN_X	("caption-align-x");
static CString XML_FRAME_ATTR_CAPTION_ALIGN_Y	("caption-align-y");
static CString XML_FRAME_ATTR_SHADOW_TYPE	("shadow-type");

//-----------------------------------------------------------------------------------------------------------------------------------------
// cframe class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CFrame : public CContainer
{
	// instanciation section
	public :

		CFrame				(CContainer *inOwner=NULL, const CString &inCaption=CString(), 
						 const CWidgetListener *inListener=NULL);
		virtual ~CFrame			();

	// protected gtk request handling
	protected :

		// gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// CComponent redefinition
	public :

		// expected owner type __metaclasses(CContainer)
		virtual CMetaClasses		OwnerMustBe			() const;

	// frame specifics
	public :

		// caption
		virtual void			SetCaption			(const CString &inCaption);
		virtual CString			GetCaption			() const;

		// caption alignment
		virtual void			SetCaptionAlignment		(const float inX, const float inY);
		virtual float			GetCaptionAlignmentX		() const;
		virtual float			GetCaptionAlignmentY		() const;

		// shadow type
		virtual void			SetShadowType			(const GtkShadowType);
		virtual GtkShadowType		GetShadowType			() const;
	
	// serialization
	public :

		// frame serialization definition
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)	
										 THROWABLE;

	// protected attributes
	protected :

		// caption 
		CString				m_Caption;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('frme', CFrame, CContainer);

#endif
