/*******************************************************************************************************************************************
 crange.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CRange			    |--CRangeListener

 CRange abstract class definition for widgets that visualize adjustments.
*******************************************************************************************************************************************/

#ifndef __CRANGE_H__
#define __CRANGE_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// crange xml serialization constant definition
//-----------------------------------------------------------------------------------------------------------------------------------------
// <crange value="Float64" update-policy="continuous|discontinuous|delayed" inverted="true|false" min="Float64" max="Float64" 
//  step="Flat64" page="Float64">
//   ...
// </crange>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_RANGE_ELEMENT		("crange");
static CString XML_RANGE_ATTR_VALUE		("value");
static CString XML_RANGE_ATTR_UPDATE_POLICY	("update-policy");
static CString XML_RANGE_ATTR_INVERTED		("inverted");
static CString XML_RANGE_ATTR_MIN		("min");
static CString XML_RANGE_ATTR_MAX		("max");
static CString XML_RANGE_ATTR_STEP		("step");
static CString XML_RANGE_ATTR_PAGE		("page");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CRangeListener class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CRangeListener : public CWidgetListener
{
	// instanciation section
	public :

		CRangeListener			();
		virtual ~CRangeListener		() =0;

	// specific listening section
	public :

		// called when a scroll action is performed on the given inSender range, allows an application to determine the type of
		// scroll event that occurred and the resultant new value (delayed range policy won't throw this event)
		virtual void			OnValueQueryChange	(CObject *inSender, GtkScrollType &ioGtkScrollType, 
									 Float64 &ioValue)					{ }
		
		// called when the value of the given inSender range has changed
		virtual void			OnValueChanged		(CObject *inSender)					{ }

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('_rng', CRangeListener, CWidgetListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// CRange class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CRange : public CWidget
{
	// instanciation section
	public :

		CRange				(CContainer *inOwner=NULL, const CRangeListener *inListener=NULL);
		virtual ~CRange			() =0;

	// protected cobject redefinition
	protected :

		// expected listener type : CRangeListener
		virtual CMetaClass *		ListenerMustBe		() const;

	// protected gtk section
	protected :

		// crange associated gtk widget initialization
		virtual void			PerformWidgetInitialize		();

	// CComponent redefinition
	public :

		// default owner type : __metaclasses(CContainer)
		virtual CMetaClasses		OwnerMustBe			() const;

	// specific api section
	public :

		// range value
		virtual void			SetValue			(const double inValue);
		double				GetValue			() const;

		// update policy of the range
		virtual void			SetUpdatePolicy			(const GtkUpdateType inGtkUpdateType);
		GtkUpdateType			GetUpdatePolicy			() const;

		// minimum and maximum allowable values for the range
		virtual void			SetRange			(const double inMin, const double inMax);
		double				GetMin				() const;
		double				GetMax				() const;

		// step and page increment for the range
		virtual void			SetIncrements			(const double inStep, const double inPage);
		double				GetStep				() const;
		double				GetPage				() const;

		// inverted range
		virtual void			SetInverted			(const bool inInverted);
		bool				GetInverted			() const;

	// serialization
	public :

		// range layer gtkol serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;
	// protected section
	protected :

		double				m_Min;
		double				m_Max;
		double				m_Step;
		double 				m_Page;

		static gboolean    		OnValueQueryChange		(GtkRange *, GtkScrollType *, gdouble, gpointer);
		static void        		OnValueChanged			(GtkRange *, gpointer);

		// metaclass association
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('rnge', CRange, CWidget);

#endif
