/*******************************************************************************************************************************************
 capplication.c
*******************************************************************************************************************************************/

#include "capplication.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//------------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CApplication);

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CApplication::CApplication (int argc, char **argv) THROWABLE
	     :CComponent   (NULL, NULL),
	      m_Argv	   ()
{
	// local copy of command line, gtk librarie initialization if command line is specified
	for (size_t i=0; i<argc; i++) m_Argv += argv[i]; if (argc > 0 && argv != NULL) InitializeGtk ();

	// lock gtkol spine
	CComponent::Lock();

	// CApplication should be the first and only one CApplication instance !
	if (CComponent::m_AbsoluteNode.GetValue() != NULL)

		// throw an exception
		throw new CException (CString("there must be only one instance of CApplication defined and it must be the first one."));

	// component hierarchy absolute node value affectation
	CComponent::m_AbsoluteNode.SetValue (this);

	// component instance node affectation
	CComponent::m_ComponentNode = &CComponent::m_AbsoluteNode;

	// unlock gtkol spine
	CComponent::Unlock();
}

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CApplication::~CApplication ()
{ }

//------------------------------------------------------------------------------------------------------------------------------------------
// main loop event dispatcher
//------------------------------------------------------------------------------------------------------------------------------------------
void CApplication::Run ()
{
	// be simple, delegate the event queue job to gtk...
	::gtk_main ();
}

//------------------------------------------------------------------------------------------------------------------------------------------
// events flush
//------------------------------------------------------------------------------------------------------------------------------------------
void CApplication::Flush ()
{
	// queue flush
	::gdk_flush ();
}

//------------------------------------------------------------------------------------------------------------------------------------------
// gtk initialization
//------------------------------------------------------------------------------------------------------------------------------------------
void CApplication::InitializeGtk ()
{
	// argv construction
	int argc = m_Argv.GetLength(); char **argv = new char * [argc];
	for (size_t i=0; i<argc; i++) { argv[i] = new char [m_Argv[i]->GetLength()+1]; ::strcpy (argv[i], m_Argv[i]->Get()); }

	// gtk initialization from argc / argv values
	::gtk_init (&argc, (argv != NULL) ? &argv : NULL);

	// pointers deletion
	for (size_t i=0; i<argc; i++) delete [] argv[i]; delete [] argv;
}

//------------------------------------------------------------------------------------------------------------------------------------------
// get home directory
//------------------------------------------------------------------------------------------------------------------------------------------
CString CApplication::GetHomeDir ()
{
	// ok
	return CString(::g_get_home_dir());
}

//------------------------------------------------------------------------------------------------------------------------------------------
// screen size
//------------------------------------------------------------------------------------------------------------------------------------------
TSize CApplication::GetScreenSize ()
{
        return TSize (::gdk_screen_width(), ::gdk_screen_height());
}

//------------------------------------------------------------------------------------------------------------------------------------------
// gtkol application xml serialization
//------------------------------------------------------------------------------------------------------------------------------------------
void CApplication::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// serialization request analyse
	switch (inMode)
	{
		// xml dump
		case XML_WRITE :
		{
			// generic call first...
			CComponent::Serialize (ioXMLElementNode, inMode);

			// instanciate a new xml element
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_APPLICATION_ELEMENT);

			// the component created a xml node referencing the potential children of this instance; to give the user a more
			// friendly presentation, keep the current control serialization before the children specifications that may grow
			// considerably; so reparent the concerned xml node at the end of the io one
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_COMPONENT_CHILDREN_ELEMENT);

			// check we got the node to reparent (it may not have been created by the generic call if there is no child at all)
			if (inXMLNode != NULL)
	
				// "reparent" it (it is already its parent), i.e. move it at the end of the io xml node
				::xml_node_set_parent (ioXMLElementNode, inXMLNode);

			// modify the input/output xml node pointer so that overwritten definitions will continue the serialization process
			// under the current xml node pointer
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();

			// foreach command line argument
			for (size_t i=0; i<m_Argv.GetLength(); i++)
				new CXMLElement (ioXMLElementNode, XML_APPLICATION_ARGV_ELEMENT, *m_Argv[i]);
		}
		break;

		// xml load
		case XML_READ :
		{
			// search for our interested xml entry as we have to initialize the gtk librarie before any else gtk operation
			CXMLElementNode *inXMLNode = ::xml_node_search (ioXMLElementNode, XML_APPLICATION_ELEMENT);

			// check we got the expected node
			if (inXMLNode == NULL)
				throw new CException (CString("CApplication::Serialize, specified xml node is not a \"") + 
							      XML_APPLICATION_ELEMENT + CString("\" element one."), __exception(XMLPARSE));

			// get the children of the current xml node
			CXMLElementNodes inXMLNodes (::xml_node_get_children (inXMLNode));

			// foreach child, add the argv to the local copy of the command line
			m_Argv = CStrings(); for (size_t i=inXMLNodes.GetLength(), j=0; i>0; i--, j++)
				if (::xml_node_get_name (*inXMLNodes[j]) == XML_APPLICATION_ARGV_ELEMENT)
					m_Argv += ::xml_node_get_value (*inXMLNodes[j]);

			// we got the original command line, so initialize the gtk library from given arguments
			InitializeGtk ();

			// the gtk librarie has been initialized so we can safely call the generic definition that will instanciate all of
			// the gtkol components hierarchy and associated funny gtk widgets
			CComponent::Serialize (ioXMLElementNode, inMode);

			// modify the input/output xml node pointer so that overwritten definitions will continue the serialization under
			// the current xml node
			ioXMLElementNode = inXMLNode;
		}
		break;
	}
}





