/*******************************************************************************************************************************************
 cprogressbar.c
*******************************************************************************************************************************************/

#include "cprogressbar.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CProgressBar);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CProgressBar::CProgressBar (CContainer *inOwner, const CWidgetListener *inListener)
	     :CWidget	   (inOwner, inListener)
{
	// widget instanciation requested
	if (inOwner != NULL) CWidget::CreateWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destrutcor
//-----------------------------------------------------------------------------------------------------------------------------------------
CProgressBar::~CProgressBar ()
{
	// widget deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CProgressBar::PerformWidgetInstanciate ()
{
	// ok
	return ::gtk_progress_bar_new ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk initialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CProgressBar::PerformWidgetInitialize ()
{
	// show the job
	Show();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// expected owner type
//-----------------------------------------------------------------------------------------------------------------------------------------
CMetaClasses CProgressBar::OwnerMustBe () const
{
	return __metaclasses(CContainer);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// caption writer
//-----------------------------------------------------------------------------------------------------------------------------------------
void CProgressBar::SetCaption (const CString &inCaption)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// property affectation
	::gtk_progress_bar_set_text (GTK_PROGRESS_BAR(inGtkWidget), inCaption.Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// caption reader
//-----------------------------------------------------------------------------------------------------------------------------------------
CString CProgressBar::GetCaption () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok
	return (inGtkWidget != NULL) ? ::gtk_progress_bar_get_text (GTK_PROGRESS_BAR(inGtkWidget)) : CString();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// fraction affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CProgressBar::SetFraction (const double inFraction)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// property affectation
	::gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR(inGtkWidget), inFraction);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// fraction access
//-----------------------------------------------------------------------------------------------------------------------------------------
double CProgressBar::GetFraction () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok, pointer check
	return (inGtkWidget != NULL) ? ::gtk_progress_bar_get_fraction (GTK_PROGRESS_BAR(inGtkWidget)) : 0;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// pulse step affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CProgressBar::SetPulseStep (const double inPulseStep)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// property affectation
	::gtk_progress_bar_set_pulse_step (GTK_PROGRESS_BAR(inGtkWidget), inPulseStep);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// pulse step access
//-----------------------------------------------------------------------------------------------------------------------------------------
double CProgressBar::GetPulseStep () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// ok, pointer check
	return (inGtkWidget != NULL) ? ::gtk_progress_bar_get_pulse_step (GTK_PROGRESS_BAR(inGtkWidget)) : 0;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// pulse
//-----------------------------------------------------------------------------------------------------------------------------------------
void CProgressBar::Pulse ()
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// ok
	::gtk_progress_bar_pulse (GTK_PROGRESS_BAR(inGtkWidget));
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// orientation affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CProgressBar::SetOrientation (const GtkProgressBarOrientation inGtkProgressBarOrientation)
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	if (inGtkWidget == NULL) return;

	// property affectation
	::gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR(inGtkWidget), inGtkProgressBarOrientation);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// orientation access
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkProgressBarOrientation CProgressBar::GetOrientation () const
{
	// get our gtk widget
	GtkWidget *inGtkWidget (GetGtkWidget());

	// pointer check
	return (inGtkWidget != NULL) ? ::gtk_progress_bar_get_orientation (GTK_PROGRESS_BAR(inGtkWidget)) : GTK_PROGRESS_LEFT_TO_RIGHT;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// serialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CProgressBar::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic call first
	CWidget::Serialize (ioXMLElementNode, inMode);

	// request analyse
	switch (inMode)
	{
		// dump
		case XML_WRITE :
		{
			// instanciate a new xml element
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_PROGRESSBAR_ELEMENT);

			// add the attributes
			newXMLElement -> AddAttribute (XML_PROGRESSBAR_ATTR_CAPTION, GetCaption());
			newXMLElement -> AddAttribute (XML_PROGRESSBAR_ATTR_FRACTION, CString(GetFraction()));
			newXMLElement -> AddAttribute (XML_PROGRESSBAR_ATTR_PULSE_STEP, CString(GetPulseStep()));
			switch (GetOrientation())
			{
				case GTK_PROGRESS_LEFT_TO_RIGHT : 
					newXMLElement -> AddAttribute (XML_PROGRESSBAR_ATTR_ORIENTATION, CString("left-to-right"));
					break;
				case GTK_PROGRESS_RIGHT_TO_LEFT :
					newXMLElement -> AddAttribute (XML_PROGRESSBAR_ATTR_ORIENTATION, CString("right-to-left"));
					break;
				case GTK_PROGRESS_BOTTOM_TO_TOP :
					newXMLElement -> AddAttribute (XML_PROGRESSBAR_ATTR_ORIENTATION, CString("bottom-to-top"));
					break;
				case GTK_PROGRESS_TOP_TO_BOTTOM :
					newXMLElement -> AddAttribute (XML_PROGRESSBAR_ATTR_ORIENTATION, CString("top-to-bottom"));
					break;
			}

			// change the io xml element node so that overloaded definition will continue under this xml node
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();
		}
		break;

		// load
		case XML_READ :
		{
			// get the child node this serialization process is interested in
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_PROGRESSBAR_ELEMENT);

			// check we got an expected cprogressbar node
			if (inXMLNode == NULL)
				throw new CException (CString("CProgressBar::Serialize, specified xml node is not a \"") + 
							      XML_PROGRESSBAR_ELEMENT + CString("\" element one."), __exception(XMLPARSE));

			// modify the in/out element node pointer so that the serialization process will continue under the current node
			ioXMLElementNode = inXMLNode;

			// retreive and set the progress bar attributes
			SetCaption   (::xml_node_get_attribute (inXMLNode, XML_PROGRESSBAR_ATTR_CAPTION   ).GetValue());
			SetFraction  (::xml_node_get_attribute (inXMLNode, XML_PROGRESSBAR_ATTR_FRACTION  ).GetValue().ToDouble());
			SetPulseStep (::xml_node_get_attribute (inXMLNode, XML_PROGRESSBAR_ATTR_PULSE_STEP).GetValue().ToDouble());
			CString inOrientation (::xml_node_get_attribute (inXMLNode, XML_PROGRESSBAR_ATTR_ORIENTATION).GetValue());
			if (inOrientation == CString("left-to-right"))
				SetOrientation (GTK_PROGRESS_LEFT_TO_RIGHT);
			else if (inOrientation == CString("right-to-left"))
				SetOrientation (GTK_PROGRESS_RIGHT_TO_LEFT);
			else if (inOrientation == CString("bottom-to-top"))
				SetOrientation (GTK_PROGRESS_BOTTOM_TO_TOP);
			else if (inOrientation == CString("top-to-bottom"))
				SetOrientation (GTK_PROGRESS_TOP_TO_BOTTOM);
		}
		break;
	}
}

