#!/bin/sh -
# Copyright (C) 2012 Red Hat Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

set -e
#set -x

if [ ! -d "$QEMUDIR" ]; then
    echo "$0: \$QEMUDIR not a directory, tests against upstream qemu skipped"
    exit 77
fi

upstream_qemu="$QEMUDIR/x86_64-softmmu/qemu-system-x86_64"
if ! "$upstream_qemu" --help >/dev/null 2>&1; then
    echo "$0: $upstream_qemu not executable, tests against upstream qemu skipped"
    exit 77
fi

"$upstream_qemu" --version

# Write a custom wrapper script for this invocation.  (Since multiple
# parallel 'make extra-tests' should not be running in the same
# libguestfs directory, this should be safe).
LIBGUESTFS_QEMU="$abs_srcdir/qemu-wrapper.sh"
rm -f "$LIBGUESTFS_QEMU" "$LIBGUESTFS_QEMU"-t
cat > "$LIBGUESTFS_QEMU"-t <<EOF
#!/bin/sh -
# Wrapper generated by '$0'.
# Do not edit this file directly.
exec "$upstream_qemu" -L "$QEMUDIR/pc-bios" "\$@"
EOF
chmod +x "$LIBGUESTFS_QEMU"-t
mv "$LIBGUESTFS_QEMU"-t "$LIBGUESTFS_QEMU"

export LIBGUESTFS_QEMU

exec $MAKE extra-tests-non-recursive
