/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: FaceDemoPanel.java,v 1.22 2006/02/26 00:59:08 pietschy Exp $
 */

package org.pietschy.command.demo.face;

import au.com.skypie.ui.HTMLPane;
import org.pietschy.command.*;
import org.pietschy.command.demo.AbstractDemoPanel;
import org.pietschy.command.demo.BeepCommand;
import org.pietschy.command.demo.toggle.SimpleToggle;
import org.pietschy.explicit.TableBuilder;

import javax.swing.*;
import java.awt.*;
import java.io.IOException;

public class
FaceDemoPanel
extends AbstractDemoPanel
{
   static final String _ID_ = "$Id: FaceDemoPanel.java,v 1.22 2006/02/26 00:59:08 pietschy Exp $";

   private CommandGroup[] menus;

   public FaceDemoPanel()
   {
      super("Face Examples", "face-page.selector", "face-commands.xml");
   }


   public void
   loadBlurb(HTMLPane html)
   {
      try
      {
         html.setPage(getClass().getResource("face.html"));
      }
      catch (IOException e)
      {
         throw new RuntimeException("Couldn't load toggle file", e);
      }
   }

   public JComponent
   createExamplePanel()
   {
      menus = new CommandGroup[]
      {
         CommandManager.defaultInstance().getGroup("face-page.menu"),
         CommandManager.defaultInstance().getGroup("face-page.help-menu")
      };

      TableBuilder tb = new TableBuilder();

      DefaultToolbarFactory factory = new DefaultToolbarFactory(new Insets(2, 5, 2, 5),
                                                                false,
                                                                false);


      int row = 0;
//      tb.installFace(createTextArea("A basic command."), row, 0)
//         .fill()
//         .minimumWidth(0);
//      JToolBar toolBar = menu.createToolBar(ButtonFactories.TOOLBAR);
//      toolBar.setRollover(true);
//      tb.installFace(toolBar, row, 1);
//
//      row++;
      ActionCommand ac = new BeepCommand("face-page.basic-command");
      tb.add(createTextArea("A basic command."), row, 0)
         .fill()
         .minimumWidth(0);
      tb.add(ac.createButton(factory), row, 1);

      row++;
      ac = new BeepCommand("face-page.text-leading");
      tb.add(createTextArea("A command with leading text."), row, 0)
         .fill()
         .minimumWidth(0);
      tb.add(ac.createButton(factory), row, 1);

      row++;
      ac = new BeepCommand("face-page.text-bottom");
      tb.add(createTextArea("A command with the vertical text position set to bottom."), row, 0)
         .fill()                  
         .minimumWidth(0);
      tb.add(ac.createButton(factory), row, 1);

      row++;
      ac = new BeepCommand("face-page.icon-bean");
      tb.add(createTextArea("One command that uses a JavaBean for the icon, and two that use a " +
      "static factory method and one that uses an IconFactory."), row, 0, 4, 1)
         .fill()
         .minimumWidth(0);
      tb.add(ac.createButton(factory), row, 1);
      row++;
      ac = new BeepCommand("face-page.static-icon-factory");
      tb.add(ac.createButton(factory), row, 1);
      row++;
      ac = new BeepCommand("face-page.static-icon-factory-params");
      tb.add(ac.createButton(factory), row, 1);
      row++;
      ac = new BeepCommand("face-page.icon-factory");
      tb.add(ac.createButton(factory), row, 1);

      row++;
      ac = new BeepCommand("face-page.rollover-example");
      tb.add(createTextArea("A command with a rollover and pressed icons specified."), row, 0)
         .fill()
         .minimumWidth(0);
      tb.add(ac.createButton(factory), row, 1);

      row++;
      SimpleToggle tc = new SimpleToggle("face-page.selected-icon-example");
      tb.add(createTextArea("This is a toggle command with a different icon for selection."), row, 0)
         .fill()
         .minimumWidth(0);
      tb.add(tc.createButton(factory), row, 1);

      row++;
      final BeepCommand disabledCommand = new BeepCommand("face-page.disabled-icon-example");
      tb.add(createTextArea("A command with the disabled icon specified."), row, 0)
         .fill()
         .minimumWidth(0);
      tb.add(disabledCommand.createButton(factory), row, 1);
      disabledCommand.setEnabled(false);
//
//      Timer t = new Timer(1000, new ActionListener()
//      {
//         public void actionPerformed(ActionEvent event)
//         {
//            disabledCommand.setEnabled(!disabledCommand.isEnabled());
//         }
//      });
//      t.start();

      row++;
      ac = new BeepCommand("face-page.text-mnemonic");
      tb.add(createTextArea("Commands with a mnemonic specified, one with the mnemonic key, one with the mnemonic index and the other embedded in the text"), row, 0, 3, 1)
         .fill()
         .minimumWidth(0);
      tb.add(ac.createButton(factory), row, 1);
      row++;
      ac = new BeepCommand("face-page.text-mnemonic-index");
      tb.add(ac.createButton(factory), row, 1);
      row++;
      ac = new BeepCommand("face-page.text-mnemonic-embedded");
      tb.add(ac.createButton(factory), row, 1);

      row++;
      ac = new BeepCommand("face-page.text-html");
      tb.add(createTextArea("A command with html for the text and tooltip."), row, 0)
         .fill()
         .minimumWidth(0);
      tb.add(ac.createButton(factory), row, 1);

      row++;
      ac = new BeepCommand("face-page.extends-example");
      tb.add(createTextArea("A face the extends the basic face, but adds a tooltip and removes the icon and accelerator."), row, 0)
         .fill()
         .minimumWidth(0);
      tb.add(ac.createButton(factory), row, 1);

      row++;
      ac = new BeepCommand("face-page.i18n-example");
      tb.add(createTextArea("A face that gets its properties from a resource bundle"), row, 0)
         .fill()
         .minimumWidth(0);
      tb.add(ac.createButton(factory), row, 1);

      row++;
      BeepCommand shortCut = new BeepCommand("face-page.shortcut-example");
      tb.add(createTextArea(shortCut.getDefaultFace().getDescription()), row, 0)
         .fill()
         .minimumWidth(0);
      tb.add(shortCut.createButton(factory), row, 1);

      row++;
      ac = new BeepCommand("face-page.client-property-example");
      tb.add(createTextArea("A face that has the client-propery Quaqua.Button.style=square."), row, 0)
         .fill()
         .minimumWidth(0);
      tb.add(ac.createButton(factory), row, 1);


      new BeepCommand("face-page.help");

      tb.firstColumn().grow(1);
      tb.firstColumn().paddingLeft(0);
      tb.firstRow().paddingTop(0);
      tb.margin(tb.layoutStyle().tabbedDialogMargin());
      tb.buildLayout();
      JPanel panel = tb.getPanel();
      panel.setBackground(Color.WHITE);

      shortCut.installShortCut(panel, Face.DEFAULT, JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

      return new JScrollPane(panel);
   }

   public CommandGroup[]
   getMenuGroups()
   {
      return menus;
   }

}
