/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: UndoCommand.java,v 1.5 2006/02/26 00:59:10 pietschy Exp $
 */
package org.pietschy.command.undo;

import org.pietschy.command.ActionCommand;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 *
 * @version $Revision: 1.5 $
 * @author andrewp
 */
class
UndoCommand
extends ActionCommand
implements ChangeListener
{
   private UndoController undoController;

   public UndoCommand(String id, UndoController undoController)
   {
      super(undoController.getCommandManager(), id);
      setUndoController(undoController);
   }

   protected void
   handleExecute()
   {
      undoController.undo();
   }

   public void
   setUndoController(UndoController undoController)
   {
      if (this.undoController != null)
         this.undoController.addChangeListener(this);

      this.undoController = undoController;
      this.undoController.addChangeListener(this);

      updateState();
   }

   public void
   stateChanged(ChangeEvent e)
   {
      updateState();
   }

   public void
   updateState()
   {
      setEnabled(undoController.canUndo());
   }
}
