/***************************************************************************
 $RCSfile: types.h.in,v $
                             -------------------
    cvs         : $Id: types.h.in,v 1.8 2004/11/19 16:17:17 aquamaniac Exp $
    begin       : Sun Jan 04 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GWENHYWFAR_TYPES_H
#define GWENHYWFAR_TYPES_H

#include <gwenhywfar/gwenhywfarapi.h>

/** define type templates */
#define GWEN_TYPE_TMPL_UINT32 "%u"
#define GWEN_TYPE_TMPL_UINT64 "%llu"


/** Define an unsigned integer type with 32 bit storage length. */
typedef unsigned int GWEN_TYPE_UINT32;

/* Here we provide G_GNUC_EXTENSION as an alias for __extension__,
 * where this is valid. This allows for warningless compilation of
 * "long long" types even in the presence of '-ansi -pedantic'. Copied
 * from glib-2.0's gmacros.h.
 */
#if     __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 8)
#  define GWEN_GNUC_EXTENSION __extension__
#else
#  define GWEN_GNUC_EXTENSION
#endif

/** Define an unsigned integer type with 64 bit storage length.
 *
 *  This depends heavily on the actual compiler. Currently gcc and
 *  MSVC are supported. For any further compilers, additional
 *  conditional clauses have to be added. */
#ifdef __GNUC__
  GWEN_GNUC_EXTENSION
  typedef unsigned long long GWEN_TYPE_UINT64;
#else /* __GNUC__ */
# include <windows.h>
  /* Workaround for Microsoft Visual Studio Compiler (MSVC) which does
   * not have "long long" but ULONG64 instead. */
  typedef ULONG64 GWEN_TYPE_UINT64;
#endif /* __GNUC__ */

#endif

