/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: lhc.c 1393 2007-11-22 18:26:05Z martin $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif



#include "args.h"
#include "typemaker_p.h"
#include <gwenhywfar/debug.h>
#include <gwenhywfar/logger.h>
#include <gwenhywfar/xml.h>
#include <gwenhywfar/bufferedio.h>

#include <stdlib.h>
#include <assert.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>




int write_hl_file_c(ARGUMENTS *args, GWEN_XMLNODE *node) {
  int rv;
  const char *f;
  GWEN_BUFFER *fname;
  GWEN_BUFFER *hbuf;
  const char *s;
  int fd;
  const char *nacc;
  const char *constAcc;
  const char *constName;
  const char *fromDbAcc;
  const char *fromDbName;
  const char *dupAcc;
  const char *dupName;
  GWEN_BUFFEREDIO *bio;
  int err;
  GWEN_XMLNODE *n;
  const char *id;
  const char *prefix;

  id=get_struct_property(node, "id", 0);
  if (!id) {
    DBG_ERROR(0, "No id for struct");
    return -1;
  }

  prefix=get_struct_property(node, "prefix", 0);
  if (!prefix) {
    DBG_ERROR(0, "No prefix for struct");
    return -1;
  }

  f=get_struct_property(node, "filename", 0);
  if (!f) {
    DBG_ERROR(0, "No filename given");
    return -1;
  }

  nacc=get_struct_property(node, "access", "public");
  constAcc=get_struct_property(node, "constructor-access", nacc);
  constName=get_struct_property(node, "constructor-name", 0);
  fromDbAcc=get_struct_property(node, "fromdb-access", nacc);
  fromDbName=get_struct_property(node, "fromdb-name", 0);
  dupAcc=get_struct_property(node, "dup-access", nacc);
  dupName=get_struct_property(node, "fromdb-name", 0);

  fname=GWEN_Buffer_new(0, 256, 0, 1);
  GWEN_Buffer_AppendString(fname, f);
  GWEN_Buffer_AppendString(fname, "_l.h");
  fd=open(GWEN_Buffer_GetStart(fname),
	  O_RDWR|O_CREAT|O_TRUNC,
	  S_IRUSR|S_IWUSR);
  if (fd==-1) {
    DBG_ERROR(0, "open(%s): %s",
	      GWEN_Buffer_GetStart(fname),
	      strerror(errno));
    GWEN_Buffer_free(fname);
    return -1;
  }
  GWEN_Buffer_free(fname);

  bio=GWEN_BufferedIO_File_new(fd);
  GWEN_BufferedIO_SetWriteBuffer(bio, 0, 1024);

  /* Insert the auto-generation warning */
  GWEN_BufferedIO_Write(bio, "/* This file is auto-generated from \"");
  GWEN_BufferedIO_Write(bio, f);
  GWEN_BufferedIO_WriteLine(bio, ".xml\" by the typemaker");
  GWEN_BufferedIO_WriteLine(bio, "   tool of Gwenhywfar. ");
  GWEN_BufferedIO_WriteLine(bio, "   Do not edit this file -- all changes will be lost! */");

  hbuf=GWEN_Buffer_new(0, 256, 0, 1);
  s=f;
  while(*s) {
    GWEN_Buffer_AppendByte(hbuf, toupper(*s));
    s++;
  }
  GWEN_Buffer_AppendString(hbuf, "_L_H");

  GWEN_BufferedIO_Write(bio, "#ifndef ");
  GWEN_BufferedIO_WriteLine(bio, GWEN_Buffer_GetStart(hbuf));
  GWEN_BufferedIO_Write(bio, "#define ");
  GWEN_BufferedIO_WriteLine(bio, GWEN_Buffer_GetStart(hbuf));
  GWEN_BufferedIO_WriteLine(bio, "");


  rv=write_apidoc_c(args, node, bio, "lib");
  if (rv)
    return rv;

  if (strcasecmp(nacc, "lib")==0) {
    GWEN_BufferedIO_WriteLine(bio, "#ifdef __cplusplus");
    GWEN_BufferedIO_WriteLine(bio, "extern \"C\" {");
    GWEN_BufferedIO_WriteLine(bio, "#endif");
    GWEN_BufferedIO_WriteLine(bio, "");
    GWEN_BufferedIO_Write(bio, "typedef struct ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, " ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, ";");
    GWEN_BufferedIO_WriteLine(bio, "");
    GWEN_BufferedIO_WriteLine(bio, "#ifdef __cplusplus");
    GWEN_BufferedIO_WriteLine(bio, "} /* __cplusplus */");
    GWEN_BufferedIO_WriteLine(bio, "#endif");
    GWEN_BufferedIO_WriteLine(bio, "");

  }


  if (strcasecmp(get_struct_property(node, "inherit", ""),
                 "lib")==0) {
    GWEN_BufferedIO_WriteLine(bio, "#include <gwenhywfar/inherit.h>");
  }

  if (strcasecmp(get_struct_property(node, "list", ""),
                 "lib")==0) {
    GWEN_BufferedIO_WriteLine(bio, "#include <gwenhywfar/misc.h>");
  }

  if (strcasecmp(get_struct_property(node, "list2", ""),
                 "lib")==0) {
    GWEN_BufferedIO_WriteLine(bio, "#include <gwenhywfar/list2.h>");
  }

  if (strcasecmp(nacc, "public")==0) {
    fname=GWEN_Buffer_new(0, 256, 0, 1);
    GWEN_Buffer_AppendString(fname, f);
    GWEN_Buffer_AppendString(fname, ".h");
    GWEN_BufferedIO_Write(bio, "#include \"");
    GWEN_BufferedIO_Write(bio, GWEN_Buffer_GetStart(fname));
    GWEN_BufferedIO_WriteLine(bio, "\"");
    GWEN_Buffer_free(fname);
  }

  if (strcasecmp(get_struct_property(node, "list", ""),
                 "lib")==0) {
    GWEN_BufferedIO_WriteLine(bio, "#include <gwenhywfar/misc.h>");
  }


  if (strcasecmp(nacc, "lib")==0) {
    GWEN_BufferedIO_WriteLine(bio, "#include <gwenhywfar/db.h>");

    n=GWEN_XMLNode_FindFirstTag(node, "pre-headers", 0, 0);
    if (n) {
      GWEN_XMLNODE *nn;
  
      nn=GWEN_XMLNode_GetFirstTag(n);
      while(nn) {
        rv=write_hp_group_c(args, nn, bio);
        if (rv) {
          GWEN_Buffer_free(hbuf);
          return -1;
        }
        nn=GWEN_XMLNode_GetNextTag(nn);
      } /* while */
    }

    n=GWEN_XMLNode_FindFirstTag(node, "headers", 0, 0);
    if (n) {
      GWEN_XMLNODE *nn;
  
      nn=GWEN_XMLNode_GetFirstTag(n);
      while(nn) {
        rv=write_hp_group_c(args, nn, bio);
        if (rv) {
          GWEN_Buffer_free(hbuf);
          return -1;
        }
        nn=GWEN_XMLNode_GetNextTag(nn);
      } /* while */
    }

    n=GWEN_XMLNode_FindFirstTag(node, "post-headers", 0, 0);
    if (n) {
      GWEN_XMLNODE *nn;
  
      nn=GWEN_XMLNode_GetFirstTag(n);
      while(nn) {
        rv=write_hp_group_c(args, nn, bio);
        if (rv) {
          GWEN_Buffer_free(hbuf);
          return -1;
        }
        nn=GWEN_XMLNode_GetNextTag(nn);
      } /* while */
    }

  }
  GWEN_BufferedIO_WriteLine(bio, "");
  GWEN_BufferedIO_WriteLine(bio, "#ifdef __cplusplus");
  GWEN_BufferedIO_WriteLine(bio, "extern \"C\" {");
  GWEN_BufferedIO_WriteLine(bio, "#endif");
  GWEN_BufferedIO_WriteLine(bio, "");

  if (write_h_enums(args, node, bio, "lib")) {
    DBG_ERROR(0, "Error writing enum types");
    return -1;
  }

  if (write_h_funcs(args, node, bio, "lib")) {
    DBG_ERROR(0, "Error writing function types");
    return -1;
  }

  if (strcasecmp(get_struct_property(node, "inherit", ""),
                 "lib")==0) {
    GWEN_BufferedIO_Write(bio, "GWEN_INHERIT_FUNCTION_DEFS(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, ")");
  }

  if (strcasecmp(get_struct_property(node, "list", ""),
                 "lib")==0) {
    GWEN_BufferedIO_Write(bio, "GWEN_LIST_FUNCTION_DEFS(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, ", ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_WriteLine(bio, ")");

    if (dupAcc && strcasecmp(dupAcc, "none")!=0) {
      GWEN_BufferedIO_Write(bio, id);
      GWEN_BufferedIO_Write(bio, "_LIST *");
      GWEN_BufferedIO_Write(bio, prefix);
      GWEN_BufferedIO_Write(bio, "_List_dup(const ");
      GWEN_BufferedIO_Write(bio, id);
      GWEN_BufferedIO_WriteLine(bio, "_LIST *stl);");
      GWEN_BufferedIO_WriteLine(bio, "");
    }
  }

  if (strcasecmp(get_struct_property(node, "list2", ""),
                 "lib")==0) {
    GWEN_BufferedIO_Write(bio, "GWEN_LIST2_FUNCTION_DEFS(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, ", ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_WriteLine(bio, ")");

    GWEN_BufferedIO_WriteLine(bio, "");
    GWEN_BufferedIO_Write(bio, "void ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_List2_freeAll(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, "_LIST2 *stl);");

    GWEN_BufferedIO_WriteLine(bio, "");
  }

  if (strcasecmp(constAcc, "lib")==0) {
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, " *");
    GWEN_BufferedIO_Write(bio, prefix);
    if (constName)
      GWEN_BufferedIO_Write(bio, constName);
    else
      GWEN_BufferedIO_Write(bio, "_new");
    GWEN_BufferedIO_WriteLine(bio, "();");
  }

  /* FromDb */
  if (strcasecmp(fromDbAcc, "lib")==0) {
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, " *");
    GWEN_BufferedIO_Write(bio, prefix);
    if (fromDbName)
      GWEN_BufferedIO_Write(bio, fromDbName);
    else
      GWEN_BufferedIO_Write(bio, "_fromDb");
    GWEN_BufferedIO_WriteLine(bio, "(GWEN_DB_NODE *db);");
  }

  /* dup */
  if (strcasecmp(dupAcc, "lib")==0) {
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_Write(bio, " *");
    GWEN_BufferedIO_Write(bio, prefix);
    if (dupName)
      GWEN_BufferedIO_Write(bio, dupName);
    else
      GWEN_BufferedIO_Write(bio, "_dup");
    GWEN_BufferedIO_Write(bio, "(const ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, "*st);");
  }

  if (strcasecmp(nacc, "lib")==0) {
    GWEN_BufferedIO_Write(bio, "void ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_free(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, " *st);");

    GWEN_BufferedIO_Write(bio, "void ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_Attach(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, " *st);");

    /* ReadDb */
    GWEN_BufferedIO_Write(bio, "int ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_ReadDb(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, " *st, GWEN_DB_NODE *db);");

    /* ToDb */
    GWEN_BufferedIO_Write(bio, "int ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_toDb(const ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, "*st, GWEN_DB_NODE *db);");

    GWEN_BufferedIO_Write(bio, "int ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_IsModified(const ");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, " *st);");

    GWEN_BufferedIO_Write(bio, "void ");
    GWEN_BufferedIO_Write(bio, prefix);
    GWEN_BufferedIO_Write(bio, "_SetModified(");
    GWEN_BufferedIO_Write(bio, id);
    GWEN_BufferedIO_WriteLine(bio, " *st, int i);");
  }

  rv=write_h_setget_c(args, node, bio, "lib");
  if (rv) {
    GWEN_Buffer_free(hbuf);
    GWEN_BufferedIO_Abandon(bio);
    GWEN_BufferedIO_free(bio);
    return rv;
  }

  GWEN_BufferedIO_WriteLine(bio, "");
  GWEN_BufferedIO_WriteLine(bio, "#ifdef __cplusplus");
  GWEN_BufferedIO_WriteLine(bio, "} /* __cplusplus */");
  GWEN_BufferedIO_WriteLine(bio, "#endif");
  GWEN_BufferedIO_WriteLine(bio, "");

  /* write trailing endif */
  GWEN_BufferedIO_WriteLine(bio, "");

  GWEN_BufferedIO_Write(bio, "#endif /* ");
  GWEN_BufferedIO_Write(bio, GWEN_Buffer_GetStart(hbuf));
  GWEN_BufferedIO_WriteLine(bio, " */");

  err=GWEN_BufferedIO_Close(bio);
  if (err) {
    DBG_ERROR_ERR(0, err);
    GWEN_BufferedIO_free(bio);
    GWEN_Buffer_free(hbuf);
    return -1;
  }

  GWEN_Buffer_free(hbuf);
  return 0;
}



int write_hl_files_c(ARGUMENTS *args, GWEN_XMLNODE *node) {
  GWEN_XMLNODE *n;
  int rv;

  n=GWEN_XMLNode_FindFirstTag(node, "type", 0, 0);
  while (n) {
    rv=write_hl_file_c(args, n);
    if (rv)
      return rv;
    n=GWEN_XMLNode_FindNextTag(n, "type", 0, 0);
  }
  return 0;
}








