/* hp.c
 *
 * (c) 2003, 2004, 2005, 2006 Markus Heinz
 *
 * This software is licensed under the terms of the GPL.
 * For details see file COPYING.
 */

#include "inklevel.h"

extern int my_axtoi(char *);
extern int my_atoi(char *);

int parse_device_id_new_hp(char tags[NR_TAGS][BUFLEN], int n, 
                           struct ink_level *level);
int parse_device_id_old_hp(char [NR_TAGS][BUFLEN], int n, 
                           struct ink_level *level);


/* This function parses the device id of a new HP printer
 * for example HP Deskjet 5550 
 */

int parse_device_id_new_hp(char tags[NR_TAGS][BUFLEN], int n, 
				  struct ink_level *level) {
  char *s = tags[n];
  int length = 0;
  char black[3]; /* level of black ink as hexadecimal string */
  char color[3]; /* level of color ink as hexadecimal string */
  char photo[3]; /* level of photo ink as hexadecimal string */
  char cyan[3]; /* level of cyan ink as hexadecimal string */
  char magenta[3]; /* level of magenta ink as hexadecimal string */
  char yellow[3]; /* level of yellow ink as hexadecimal string */

  /* Determine the length of the string */

  while (*s != '\0') {
    length++;
    s++;
  }

  s = tags[n];

  /* I do not know for sure if "2c" or "2C" is a viable means of distinction */

  if ((s[length - 17] == '2') && ((s[length - 16] == 'c') || 
                                  (s[length - 16] == 'C'))) {

    /* We deal with a printer with two possible cartridges */
  
    /* I do not know if "1" always denotes a black cartridge and if "3" always
     * denotes a photo cartridge
     */

    if (s[length - 15] == '0') {
      /* We have only the color cartridge */

      color[0] = s[length - 2];
      color[1] = s[length - 1];
      color[2] = '\0';

      level->status = RESPONSE_VALID;
      level->levels[0][INDEX_TYPE] = CARTRIDGE_COLOR;
      level->levels[0][INDEX_LEVEL] = my_axtoi(color);

#ifdef DEBUG
      printf("Color: %d%%\n", my_axtoi(color));
#endif

      return OK;
    } else if (s[length - 15] == '1') {

      /* We have black and color cartridge */

      black[0] = s[length - 10];
      black[1] = s[length - 9];
      black[2] = '\0';
      
      color[0] = s[length - 2];
      color[1] = s[length - 1];
      color[2] = '\0';

      level->status = RESPONSE_VALID;
      level->levels[0][INDEX_TYPE] = CARTRIDGE_BLACK;
      level->levels[0][INDEX_LEVEL] = my_axtoi(black);
      level->levels[1][INDEX_TYPE] = CARTRIDGE_COLOR;
      level->levels[1][INDEX_LEVEL] = my_axtoi(color);

#ifdef DEBUG
      printf("Black: %d%%, Color: %d%%\n", my_axtoi(black), my_axtoi(color));
#endif

      return OK;
    } else if (s[length - 15] == '3') {

      /* We have photo and color cartridge */

      photo[0] = s[length - 10];
      photo[1] = s[length - 9];
      photo[2] = '\0';
      
      color[0] = s[length - 2];
      color[1] = s[length - 1];
      color[2] = '\0';

      level->status = RESPONSE_VALID;
      level->levels[0][INDEX_TYPE] = CARTRIDGE_COLOR;
      level->levels[0][INDEX_LEVEL] = my_axtoi(color);
      level->levels[1][INDEX_TYPE] = CARTRIDGE_PHOTO;
      level->levels[1][INDEX_LEVEL] = my_axtoi(photo);

#ifdef DEBUG
      printf("Color: %d%%, Photo: %d%%\n", my_axtoi(color), my_axtoi(photo));
#endif

      return OK;
    }
  } else if ((s[length - 4] == '8') && (s[length - 8] == '7') && 
             (s[length - 12] == '6') && (s[length - 16] == '5')) {

    /* We deal with a printer with separate colors */
    /* We have black, cyan, magenta and yellow */

    yellow[0] = s[length - 2];
    yellow[1] = s[length - 1];
    yellow[2] = '\0';

    magenta[0] = s[length - 6];
    magenta[1] = s[length - 5];
    magenta[2] = '\0';

    cyan[0] = s[length - 10];
    cyan[1] = s[length - 9];
    cyan[2] = '\0';

    black[0] = s[length - 14];
    black[1] = s[length - 13];
    black[2] = '\0';

    level->status = RESPONSE_VALID;
    level->levels[0][INDEX_TYPE] = CARTRIDGE_BLACK;
    level->levels[0][INDEX_LEVEL] = my_axtoi(black);
    level->levels[1][INDEX_TYPE] = CARTRIDGE_CYAN;
    level->levels[1][INDEX_LEVEL] = my_axtoi(cyan);
    level->levels[2][INDEX_TYPE] = CARTRIDGE_MAGENTA;
    level->levels[2][INDEX_LEVEL] = my_axtoi(magenta);
    level->levels[3][INDEX_TYPE] = CARTRIDGE_YELLOW;
    level->levels[3][INDEX_LEVEL] = my_axtoi(yellow);

#ifdef DEBUG
    printf("Yellow: %d%%, Magenta: %d%%, Cyan: %d%%, Black: %d%%\n",
           my_axtoi(yellow), my_axtoi(magenta), my_axtoi(cyan), 
           my_axtoi(black));
#endif

    return OK;
  } 

  /* This type of printer is not yet supported */

#ifdef DEBUG
  printf("Printer not supported\n");
#endif

  return PRINTER_NOT_SUPPORTED;
}

/* This function parses the device id of an old HP printer
 * for example HP Photosmart 1000 
 */

int parse_device_id_old_hp(char tags[NR_TAGS][BUFLEN], int n, 
                           struct ink_level *level) {
  char *s = tags[n];
  int length = 0;
  char b[4]; /* level of black ink as decimal string */
  char c[4]; /* level of color ink as decimal string */

  /* Determine the length of the string */

  while (*s != '\0') {
    length++;
    s++;
  }

  s = tags[n];
  
  /* Check if "KP" and "CP" tags are there */

  if ((s[length - 11] == 'K') && (s[length - 10] == 'P') &&
      (s[length - 5]  == 'C') && (s[length - 4] == 'P')) {
    b[0] = s[length - 9];
    b[1] = s[length - 8];
    b[2] = s[length - 7];
    b[3] = '\0';
    
    c[0] = s[length - 3];
    c[1] = s[length - 2];
    c[2] = s[length - 1];
    c[3] = '\0';

    level->status = RESPONSE_VALID;
    level->levels[0][INDEX_TYPE] = CARTRIDGE_BLACK;
    level->levels[0][INDEX_LEVEL] = my_atoi(b);
    level->levels[1][INDEX_TYPE] = CARTRIDGE_COLOR;
    level->levels[1][INDEX_LEVEL] = my_atoi(c);

#ifdef DEBUG
    printf("Black %d%%, Color %d%%\n", my_atoi(b), my_atoi(c));
#endif

    return OK;
  } else {

#ifdef DEBUG
    printf("No ink level found\n");
#endif
    return NO_INK_LEVEL_FOUND;
  }
}
