/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef ISDOBJECT_H
#define ISDOBJECT_H

using namespace std;

/**
 * Abstract superclass for all objects in the instrudeo library. 
 *
 * @author Bram Biesbrouck <b@beligum.org>
 */

#define RETURN_ERROR(s) \
     lastError = s; \
     return lastError;

#define RETURN_SUCCESS \
     return ISD_SUCCESS

class ISDObject
{

 public:
    enum ISDErrorCode {
	/**
	 * everything OK
	 */
	ISD_SUCCESS,
	/**
	 * general error
	 */
	ISD_FAILURE,
	/**
	 * error during accessing a file
	 */
	ISD_FILE_ERROR,
	/**
	 * error while unpacking a recording file
	 */
	ISD_UNPACK_ERROR,
	/**
	 * error while packing a recording file
	 */
	ISD_PACK_ERROR,
	/**
	 * error during execution of importing routines
	 */
	ISD_IMPORT_ERROR,
	/**
	 * error during execution of exporting routines
	 */
	ISD_EXPORT_ERROR,
	/**
	 * file format isn't correct (corrupted file)
	 */
	ISD_FORMAT_ERROR,
	/**
	 * error because of version mismatch
	 */
	ISD_VERSION_ERROR,
	/**
	 * error while initialising data
	 */
	ISD_INIT_ERROR,
	/*
	 * error because of provided arguments
	 */
	ISD_ARGS_ERROR,
	/**
	 * error because EOF was reached
	 */
	ISD_EOF_ERROR,
	/**
	 * error during encoding routines
	 */
	ISD_ENCODING_ERROR,
	/**
	 * error while writing/reading an XML-element
	 */
	ISD_XML_ELEMENT_ERROR,
	/**
	 * error if two forbidden duplicate XML elements occurred
	 */
	ISD_XML_DUPLICATES_ERROR,
	/**
	 * missing XML element
	 */
	ISD_XML_MISSING_ERROR,
	/**
	 * error while contacting the webservice
	 */
	ISD_WS_CONTACT_ERROR,
	/**
	 * the webservice returned a valid error
	 */
	ISD_WS_RETURNED_ERROR,
	/**
	 * Error while connecting to the Instrudeo ftp server.
	 */
	ISD_FTP_CONNECT_ERROR,
	/**
	 * Error in the local or remote filesystem of the Instrudeo ftp server.
	 */
	ISD_FTP_FILE_ERROR,
	/**
	 * Error while logging in to the Instrudeo ftp server.
	 */
	ISD_FTP_LOGIN_ERROR,
	/**
	 * Error indicating the upload to the Instrudeo ftp server was cancelled.
	 */
	ISD_FTP_CANCELLED_ERROR,
	/**
	 * Error while connecting to the Instrudeo database (for Instrudeo Process Deamon)
	 */
	ISD_DB_CONNECT_ERROR,
	/**
	 * Error while querying the Instrudeo database (for Instrudeo Process Deamon)
	 */
	ISD_DB_QUERY_ERROR,
	/**
	 * Error while inserting into the Instrudeo database (for Instrudeo Process Deamon)
	 */
	ISD_DB_INSERT_ERROR,
	/**
	 * Error while updateing the Instrudeo database (for Instrudeo Process Deamon)
	 */
	ISD_DB_UPDATE_ERROR,
	/**
	 * Error while deleting in the Instrudeo database (for Instrudeo Process Deamon)
	 */
	ISD_DB_DELETE_ERROR,
	/**
	 * error while initialising an exporter
	 */
	ISD_EXPORT_INIT_ERROR,
	/**
	 * the specified format isn't supported by the export routine
	 */
	ISD_EXPORT_FORMAT_ERROR,
	/**
	 * file error while exporting video
	 */
	ISD_EXPORT_FILE_ERROR,
	/**
	 * error while cleaning up
	 */
	ISD_CLEANUP_ERROR
    };

    //-----CONSTRUCTORS-----
    ISDObject();

    virtual ~ISDObject();

    //-----METHODS-----
    /**
     * Indicates if an error occurred since the contruction of the object.
     *
     * @return Returns a code that indicates success or failure.
     */
    ISDErrorCode error();

    /**
     * Clears all error flags
     */
    void clearErrors();

 protected:
    //-----VARIABLES-----
    ISDErrorCode lastError;
};

#endif
