/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef ISDVIDEOPROPERTIES_H
#define ISDVIDEOPROPERTIES_H

/**
 * Holds various properties involving the video and settings.
 *
 * @author Bram Biesbrouck <b@beligum.org>
*/

#include <libinstrudeo/isddatafile.h>
#include <libinstrudeo/isdobject.h>

#undef LOG_HEADER
#define LOG_HEADER "Error while accessing video properties: \n"
#include <libinstrudeo/isdloggermacros.h>

using namespace std;

class ISDVideoProperties : public ISDObject
{
 public:
    /**
     * Init the object by extracting and calculating values from the file header
     * and other supplied properties.
     *
     * @param fileHeader The fileheader as in the instrudeo file format.
     * @param length The length of the video (maximal position) in milliseconds.
     * @param minUpdate The smallest period of time (milliseconds) between two rectangle-updates
     */
    ISDVideoProperties(ISDDataFile::ISDFileHeader fileHeader, int length, int minUpdate);

    ~ISDVideoProperties();

    /**
     * Returns the length of the video (maximal position) in milliseconds.
     *
     * @return The length in milliseconds.
     */
    int getLength();

    /**
     * Returns the smallest period of time (in milliseconds) between two rectangle-updates
     */
    int getMinUpdate();

    /**
     * Returns the width of the framebuffer.
     *
     * @return The width in pixels.
     */
    int getWidth();

     /**
     * Returns the height of the framebuffer.
     *
     * @return The height in pixels.
     */
    int getHeight();

    /**
     * Returns the image-depth of the framebuffer.
     *
     * @return The depth.
     */
    int getDepth();

    /**
     * Returns the number of bytes per pixel;
     *
     * @return The number of bytes per pixel.
     */
    int getBytesPerPixel();

    /**
     * Returns the mask of the red component of the image.
     *
     * @return The mask.
     */
    int getRedMask();

    /**
     * Returns the mask of the green component of the image.
     *
     * @return The mask.
     */
    int getGreenMask();

    /**
     * Returns the mask of the blue component of the image.
     *
     * @return The mask.
     */
    int getBlueMask();

    /**
     * This just return the whole header struct.
     *
     * @return The header.
     */
    ISDDataFile::ISDFileHeader getFileHeader();

 protected:
    ISDDataFile::ISDFileHeader fileHeader;
    int length;
    int minUpdate;
};

#endif
