/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.SafeTagList;

public class XMLWriterSupport {
    public static final int OPEN_TAG_INCREASE = 1;
    public static final int CLOSE_TAG_DECREASE = 2;
    public static final int INDENT_ONLY = 3;
    public static final boolean CLOSE = true;
    public static final boolean OPEN = false;
    private static String lineSeparator;
    private SafeTagList safeTags;
    private int indentLevel;
    private String indentString;
    private boolean newLineOk;

    public XMLWriterSupport() {
        this(new SafeTagList(), 0);
    }

    public XMLWriterSupport(SafeTagList safeTags, int indentLevel) {
        this(safeTags, indentLevel, "    ");
    }

    public XMLWriterSupport(SafeTagList safeTags, int indentLevel, String indentString) {
        if (indentString == null) {
            throw new NullPointerException("IndentString must not be null");
        }
        this.safeTags = safeTags;
        this.indentLevel = indentLevel;
        this.indentString = indentString;
    }

    public void allowLineBreak() throws IOException {
        this.newLineOk = true;
    }

    protected void decreaseIndent() {
        --this.indentLevel;
    }

    public void endBlock() throws IOException {
        --this.indentLevel;
        this.allowLineBreak();
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public static String getLineSeparator() {
        block2: {
            if (lineSeparator != null) break block2;
            try {
                lineSeparator = System.getProperty("line.separator", "\n");
            }
            catch (SecurityException securityException) {
                lineSeparator = "\n";
            }
        }
        return lineSeparator;
    }

    public SafeTagList getSafeTags() {
        return this.safeTags;
    }

    protected void increaseIndent() {
        ++this.indentLevel;
    }

    public void indent(Writer writer, int increase) throws IOException {
        if (increase == 2) {
            this.decreaseIndent();
        }
        int i = 0;
        while (i < this.indentLevel) {
            writer.write(this.indentString);
            ++i;
        }
        if (increase == 1) {
            this.increaseIndent();
        }
    }

    public static String normalize(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\n': {
                    if (i > 0) {
                        char lastChar = str.charAt(str.length() - 1);
                        if (lastChar != '\r') {
                            str.append(XMLWriterSupport.getLineSeparator());
                            break;
                        }
                        str.append('\n');
                        break;
                    }
                    str.append(XMLWriterSupport.getLineSeparator());
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    public void startBlock() throws IOException {
        ++this.indentLevel;
        this.allowLineBreak();
    }

    public void writeCloseTag(Writer w, String tag) throws IOException {
        if (this.newLineOk || this.getSafeTags().isSafeForOpen(tag)) {
            if (this.newLineOk) {
                w.write(XMLWriterSupport.getLineSeparator());
            }
            this.indent(w, 2);
        } else {
            this.decreaseIndent();
        }
        w.write("</");
        w.write(tag);
        w.write(">");
        if (this.getSafeTags().isSafeForClose(tag)) {
            w.write(XMLWriterSupport.getLineSeparator());
        }
        this.newLineOk = false;
    }

    public void writeTag(Writer w, String name) throws IOException {
        if (this.newLineOk) {
            w.write(XMLWriterSupport.getLineSeparator());
        }
        this.indent(w, 1);
        w.write("<");
        w.write(name);
        w.write(">");
        if (this.getSafeTags().isSafeForOpen(name)) {
            w.write(XMLWriterSupport.getLineSeparator());
        }
    }

    public void writeTag(Writer w, String name, String attributeName, String attributeValue, boolean close) throws IOException {
        AttributeList attr = new AttributeList();
        if (attributeName != null) {
            attr.setAttribute(attributeName, attributeValue);
        }
        this.writeTag(w, name, attr, close);
    }

    public void writeTag(Writer w, String name, Properties attributes, boolean close) throws IOException {
        AttributeList attList = new AttributeList();
        Enumeration keys = ((Hashtable)attributes).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            attList.setAttribute(key, attributes.getProperty(key));
        }
        this.writeTag(w, name, attList, close);
    }

    public void writeTag(Writer w, String name, AttributeList attributes, boolean close) throws IOException {
        if (this.newLineOk) {
            w.write(XMLWriterSupport.getLineSeparator());
            this.newLineOk = false;
        }
        this.indent(w, 1);
        w.write("<");
        w.write(name);
        Iterator keys = attributes.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = attributes.getAttribute(key);
            w.write(" ");
            w.write(key);
            w.write("=\"");
            w.write(XMLWriterSupport.normalize(value));
            w.write("\"");
        }
        if (close) {
            w.write("/>");
            if (this.getSafeTags().isSafeForClose(name)) {
                w.write(XMLWriterSupport.getLineSeparator());
            }
            this.decreaseIndent();
        } else {
            w.write(">");
            if (this.getSafeTags().isSafeForOpen(name)) {
                w.write(XMLWriterSupport.getLineSeparator());
            }
        }
    }
}

