//start of PostLh3Encoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PostLh3Encoder.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.OutputStream;
import java.lang.Math;
import jp.gr.java_conf.dangan.io.BitOutputStream;
import jp.gr.java_conf.dangan.util.lha.StaticHuffman;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

//import exceptions
import java.io.IOException;
import java.lang.NullPointerException;
import java.lang.IllegalArgumentException;


/**
 * -lh3- kp PostLzssEncoderB<br>
 * 
 * <pre>
 * $Log: PostLh3Encoder.java,v $
 * Revision 1.2  2002/12/06 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.1  2002/12/01 00:00:00  dangan
 * [change]
 *     flush() Ȃ 
 *     ڑꂽ OutputStream flush() Ȃ悤ɕύXB
 * [maintenance]
 *     \[XB
 *
 * Revision 1.0  2002/07/31 00:00:00  dangan
 * add to version control
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.2 $
 */
public class PostLh3Encoder implements PostLzssEncoder{

    //------------------------------------------------------------------
    //  class fields
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private static final int DictionarySize
    //  private static final int MaxMatch
    //  private static final int Threshold
    //------------------------------------------------------------------
    /** TCY */
    private static final int DictionarySize  = 8192;

    /** őv */
    private static final int MaxMatch        = 256;

    /** ŏv */
    private static final int Threshold       = 3;


    //------------------------------------------------------------------
    //  class fields
    //------------------------------------------------------------------
    //  private static final int[] ConstOffHiLen
    //  private static final int CodeSize
    //------------------------------------------------------------------
    /**
     * OffHǐŒnt}
     */
    private static final int[] ConstOffHiLen = PostLh3Encoder.createConstOffHiLen();

    /**
     * codẽnt}؂̃TCY 
     * codeȏ̒lꍇ͗]vȃrbgo͂ĕ₤B
     */
    private static final int CodeSize = 286;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  sink
    //------------------------------------------------------------------
    //  private BitOutputStream out
    //------------------------------------------------------------------
    /**
     * -lh3- `̈kf[^̏o͐ rbgo̓Xg[
     */
    private BitOutputStream out;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  buffer of LZSS codes
    //------------------------------------------------------------------
    //  private byte[] buffer
    //  private int blockSize
    //  private int position
    //  private int flagBit
    //  private int flagPos
    //------------------------------------------------------------------
    /**
     * ÓInt}k邽߂Ƀf[^ꎞIɒobt@
     */
    private byte[] buffer;

    /**
     * obt@ɂ code f[^̐B
     */
    private int blockSize;

    /**
     * buffeřݏʒu
     */
    private int position;

    /**
     * flag oCǧݏbit
     */
    private int flagBit;

    /**
     * buffeř݂flagoCg̈ʒu
     */
    private int flagPos;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  frequancy counter for huffman
    //------------------------------------------------------------------
    //  private int[] codeFreq
    //  private int[] offHiFreq
    //------------------------------------------------------------------
    /**
     * code̕px\
     */
    private int[] codeFreq;

    /**
     * offHi̕px\
     */
    private int[] offHiFreq;


    //------------------------------------------------------------------
    //  constructers
    //------------------------------------------------------------------
    //  private PostLh3Encoder()
    //  public PostLh3Encoder( OutputStream out )
    //  public PostLh3Encoder( OutputStream out, int BufferSize )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private PostLh3Encoder(){   }

    /**
     * -lh3- kp PostLzssEncoder\zB<br>
     * obt@TCYɂ̓ftHglgpB
     * 
     * @param out kf[^󂯎o̓Xg[
     */
    public PostLh3Encoder( OutputStream out ){
        this( out, 16384 );
    }

    /**
     * -lh3- kp PostLzssEncoder\zB<br>
     * 
     * @param out        kf[^󂯎o̓Xg[
     * @param BufferSize ÓInt}kp̃obt@TCY
     * 
     * @exception IllegalArgumentException 
     *                   BufferSize ꍇ
     */
    public PostLh3Encoder( OutputStream out, int BufferSize ){
        final int DictionarySizeByteLen = 2;
        final int MinCapacity = ( DictionarySizeByteLen + 1 ) * 8 + 1;

        if( out != null
         && MinCapacity <= BufferSize ){

            if( out instanceof BitOutputStream ){
                this.out   = (BitOutputStream)out;
            }else{
                this.out   = new BitOutputStream( out );
            }
            this.codeFreq  = new int[ PostLh3Encoder.CodeSize ];
            this.offHiFreq = new int[ PostLh3Encoder.DictionarySize >> 6 ];
            this.buffer    = new byte[ BufferSize ];
            this.blockSize = 0;
            this.position  = 0;
            this.flagBit   = 0;
            this.flagPos   = 0;
        }else if( out == null ){
            throw new NullPointerException( "out" );
        }else{
            throw new IllegalArgumentException( "BufferSize too small. BufferSize must be larger than " + MinCapacity );
        }
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  write methods
    //------------------------------------------------------------------
    //  public void writeCode( int code )
    //  public void writeOffset( int offset )
    //------------------------------------------------------------------
    /**
     * 1byte  LZSSk̃f[^́A
     * LZSS ňkꂽkR[ĥvށB<br>
     * 
     * @param code 1byte  LZSSk̃f[^́A
     *             LZSS ňkꂽkR[ĥv
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void writeCode( int code ) throws IOException {
        final int CodeMax  = PostLh3Encoder.CodeSize - 1;
        final int DictionarySizeByteLen = 2;
        final int Capacity = ( DictionarySizeByteLen + 1 ) * 8 + 1;

        if( this.flagBit == 0 ){
            if( this.buffer.length - this.position < Capacity 
             || ( 65536 - 8 ) <= this.blockSize ){
                this.writeOut();                                                //throws IOException
            }
            this.flagBit = 0x80;
            this.flagPos = this.position++;
            this.buffer[ this.flagPos ] = 0;
        }

        //f[^i[
        this.buffer[this.position++] = (byte)code;

        //1rbgtOƂĊi[
        if( 0x100 <= code ) this.buffer[ this.flagPos ] |= this.flagBit;
        this.flagBit >>= 1;

        //px\XV
        this.codeFreq[ Math.min( code, CodeMax ) ]++;

        //ubNTCYXV
        this.blockSize++;
    }

    /**
     * LZSS ňkꂽkR[ĥvʒuށB<br>
     * 
     * @param offset LZSS ňkꂽkR[ĥvʒu
     */
    public void writeOffset( int offset ){
        //f[^i[
        this.buffer[ this.position++ ] = (byte)( offset >> 8 );
        this.buffer[ this.position++ ] = (byte)offset;

        //px\XV
        this.offHiFreq[ ( offset >> 6 ) ]++;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.lha.PostLzssEncoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public void flush()
    //  public void close()
    //------------------------------------------------------------------
    /**
     *  PostLzssEncoder Ƀobt@OĂSĂ
     * 8rbgPʂ̃f[^o͐ OutputStream ɏo͂A
     * o͐ OutputStream  flush() B<br>
     * ̃\bh͈kωB
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PostLzssEncoder#flush()
     * @see BitOutputStream#flush()
     */
    public void flush() throws IOException {
        this.writeOut();
        this.out.flush();
    }

    /**
     * ̏o̓Xg[ƁAڑꂽo̓Xg[A
     * gpĂ\[XJB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.writeOut();
        this.out.close();                                                       //throws IOException

        this.out       = null;
        this.buffer    = null;
        this.codeFreq  = null;
        this.offHiFreq = null;
    }


    //------------------------------------------------------------------
    //  jp.gr.java_conf.dangan.util.lha.PostLzssEncoder methods
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     * -lh3-` LZSS̃TCY𓾂B
     * 
     * @return -lh3-` LZSS̃TCY
     */
    public int getDictionarySize(){
        return PostLh3Encoder.DictionarySize;
    }

    /**
     * -lh3-` LZSS̍őv𓾂B
     * 
     * @return -lh3-` LZSS̍őv
     */
    public int getMaxMatch(){
        return PostLh3Encoder.MaxMatch;
    }

    /**
     * -lh3-` LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return -lh3-` LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return PostLh3Encoder.Threshold;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  write huffman code
    //------------------------------------------------------------------
    //  private void writeOut()
    //------------------------------------------------------------------
    /**
     * obt@OꂽSẴf[^ this.out ɏo͂B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void writeOut() throws IOException {
        final int CodeMax = PostLh3Encoder.CodeSize - 1;

        if( 0 < this.blockSize ){
            //------------------------------------------------------------------
            //  ubNTCYo
            this.out.writeBits( 16, this.blockSize );                           //throws IOException

            //------------------------------------------------------------------
            //  nt}\
            int[] codeLen   = StaticHuffman.FreqListToLenList( this.codeFreq );
            int[] codeCode  = StaticHuffman.LenListToCodeList( codeLen );
            int[] offHiLen  = PostLh3Encoder.getBetterOffHiLen( this.offHiFreq,
                               StaticHuffman.FreqListToLenList( this.offHiFreq ) );
            int[] offHiCode = StaticHuffman.LenListToCodeList( offHiLen );

            //------------------------------------------------------------------
            //  codẽnt}\o
            if( 2 <= PostLh3Encoder.countNoZeroElement( this.codeFreq ) ){
                this.writeCodeLenList( codeLen );                               //throws IOException
            }else{
                this.out.writeBits( 15, 0x4210 );                               //throws IOException
                this.out.writeBits( 9,  
                       PostLh3Encoder.getNoZeroElementIndex( this.codeFreq ) ); //throws IOException
            }

            //------------------------------------------------------------------
            //  offHĩnt}\o
            if( offHiLen != PostLh3Encoder.ConstOffHiLen ){
                this.out.writeBit( 1 );                                         //throws IOException

                if( 2 <= PostLh3Encoder.countNoZeroElement( this.offHiFreq ) ){
                    this.writeOffHiLenList( offHiLen );                         //throws IOException
                }else{
                    this.out.writeBits( 12, 0x0111 );                           //throws IOException
                    this.out.writeBits( 7,  
                       PostLh3Encoder.getNoZeroElementIndex( this.offHiFreq ) );//throws IOException
                }
            }else{
                this.out.writeBit( 0 );                                         //throws IOException
            }

            //------------------------------------------------------------------
            //  nt}o
            this.position = 0;
            this.flagBit  = 0;
            for( int i = 0 ; i < blockSize ; i++ ){
                if( this.flagBit == 0 ){
                    this.flagBit = 0x80;
                    this.flagPos = this.position++;
                }

                if( 0 == ( this.buffer[ this.flagPos ] & this.flagBit ) ){
                    int code = this.buffer[ this.position++ ] & 0xFF;
                    this.out.writeBits( codeLen[ code ], codeCode[ code ] );    //throws IOException
                }else{
                    int code = ( this.buffer[ this.position++ ] & 0xFF ) | 0x100;
                    int offset = ( ( this.buffer[ this.position++ ] & 0xFF ) << 8 )
                               | ( this.buffer[ this.position++ ] & 0xFF );
                    int offHi  = offset >> 6;
                    if( code < CodeMax ){
                        this.out.writeBits( codeLen[ code ], codeCode[ code ] );//throws IOException
                    }else{
                        this.out.writeBits( codeLen[ CodeMax ], codeCode[ CodeMax ] );//throws IOException
                        this.out.writeBits( 8, code - CodeMax );                //throws IOException
                    }
                    this.out.writeBits( offHiLen[ offHi ], offHiCode[ offHi ] );//throws IOException
                    this.out.writeBits( 6, offset );                            //throws IOException
                }
                this.flagBit >>= 1;
            }

            //------------------------------------------------------------------
            //  ̃ubN̂߂̏
            for( int i = 0 ; i < this.codeFreq.length ; i++ ){
                this.codeFreq[i] = 0;
            }

            for( int i = 0 ; i < this.offHiFreq.length ; i++ ){
                this.offHiFreq[i] = 0;
            }

            this.blockSize = 0;
            this.position  = 0;
            this.flagBit   = 0;

        }// if( 0 < this.blockSize )
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  write huffman list
    //------------------------------------------------------------------
    //  private void writeCodeLenList( int[] codeLen )
    //  private void writeOffHiLenList( int[] offHiLen )
    //------------------------------------------------------------------
    /**
     * codẽnt}̃Xg𕄍Ȃ珑oB
     * 
     * @param codeLen codẽnt}̃Xg
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void writeCodeLenList( int[] codeLen ) throws IOException {
        for( int i = 0 ; i < codeLen.length ; i++ ){
            if( 0 < codeLen[i] ){
                this.out.writeBits( 5, 0x10 | ( codeLen[i] - 1 ) );             //throws IOException
            }else{
                this.out.writeBit( 0 );                                         //throws IOException
            }
        }
    }

    /**
     * OffHĩnt}̃Xg𕄍Ȃ珑oB
     * 
     * @param OffHiLenList CodeFreq ̃nt}̃Xg
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void writeOffHiLenList( int[] offHiLen ) throws IOException {
        for( int i = 0 ; i < offHiLen.length ; i++ ){
            this.out.writeBits( 4, offHiLen[i] );                               //throws IOException
        }
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  staff of huffman encoder
    //------------------------------------------------------------------
    //  private static int countNoZeroElement( int[] array )
    //  private static int getNoZeroElementIndex( int[] array )
    //------------------------------------------------------------------
    /**
     * z 0łȂvf𓾂B
     * 
     * @param array z
     * 
     * @return z 0łȂvf
     */
    private static int countNoZeroElement( int[] array ){
        int count = 0;
        for( int i = 0 ; i < array.length ; i++ ){
            if( 0 != array[i] ){
                count++;
            }
        }
        return count;
    }

    /**
     * z 0łȂŏ̗vf𓾂B
     * 
     * @param array z
     * 
     * @return z 0łȂŏ̗vf
     *         SĂ̗vf0̏ꍇ 0ԂB
     */
    private static int getNoZeroElementIndex( int[] array ){
        for( int i = 0 ; i < array.length ; i++ ){
            if( 0 != array[i] ){
                return i;
            }
        }
        return 0;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  calc the length of encoded data
    //------------------------------------------------------------------
    //  private static int[] createLenList()
    //  private static int[] getBetterOffHiLenList( int[] OffHiFreq, 
    //                                              int[] OffHiLen )
    //------------------------------------------------------------------
    /**
     * -lh3-  offHifR[hp nt}Xg𐶐B
     * 
     * @return -lh3-  offHifR[hp nt}Xg
     */
    private static int[] createConstOffHiLen(){
        final int length = PostLh3Encoder.DictionarySize >> 6;
        final int[] list = { 2, 0x01, 0x01, 0x03, 0x06, 0x0D, 0x1F, 0x4E, 0 };

        int[] offHiLen = new int[ length ];
        int index = 0;
        int len = list[ index++ ];

        for( int i = 0 ; i < length ; i++ ){
            while( list[index] == i ){
                len++;
                index++;
            }
            offHiLen[i] = len;
        }
        return offHiLen;
    }

    /**
     * OffHiFreq琶ꂽ nt}̃Xg
     * Œnt}̃XgrāAo̓rbg
     * ̏Ȃ̂𓾂B
     * 
     * @param OffHiFreq offset̏6bit̏opx̕\
     * @param OffHiLen  OffHiFreq琶ꂽnt}
     *                  ̃Xg
     * 
     * @return o̓rbg̏Ȃ̃nt}̃Xg
     */
    private static int[] getBetterOffHiLen( int[] OffHiFreq, 
                                            int[] OffHiLen ){
        boolean detect = false;
        for( int i = 0 ; i < OffHiLen.length ; i++ ){
            if( 15 < OffHiLen[i] ){ //15 writeOffHiLenListŏ߂ő̃nt}ӖB
                detect = true;
            }
        }

        if( !detect ){
            int origTotal = 1;
            int consTotal = 1;

            if( 2 <= PostLh3Encoder.countNoZeroElement( OffHiFreq ) ){
                origTotal += 4 * ( PostLh3Encoder.DictionarySize >> 6 );
            }else{
                origTotal += 4 * 3 + 7;
            }
            for( int i = 0 ; i < OffHiFreq.length ; i++ ){
                origTotal += OffHiFreq[i] * OffHiLen[i];
                consTotal += OffHiFreq[i] * PostLh3Encoder.ConstOffHiLen[i];
            }

            if( origTotal < consTotal ) return OffHiLen;
            else                        return PostLh3Encoder.ConstOffHiLen;
        }else{
            return PostLh3Encoder.ConstOffHiLen;
        }
    }

}
//end of PostLh3Encoder.java
