//start of PreLz5Decoder.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * PreLz5Decoder.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.InputStream;
import java.lang.Math;
import jp.gr.java_conf.dangan.io.CachedInputStream;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.lang.NullPointerException;

/**
 * -lz5- 𓀗p PreLzssDecoderB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: PreLz5Decoder.java,v $
 * Revision 1.1  2002/12/01 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.1 $
 */
public class PreLz5Decoder implements PreLzssDecoder{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private static final int DictionarySize
    //  private static final int MaxMatch
    //  private static final int Threshold
    //------------------------------------------------------------------
    /** TCY */
    private static final int DictionarySize = 4096;

    /** őv */
    private static final int MaxMatch       = 18;

    /** ŏv */
    private static final int Threshold      = 3;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private InputStream in
    //------------------------------------------------------------------
    /**
     * -lz5- `̈kf[^Xg[
     */
    private InputStream in;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  current position
    //------------------------------------------------------------------
    //  private int position
    //  private int matchPos
    //  private int matchLen
    //------------------------------------------------------------------
    /** 
     * ݏʒuB
     * larc ̈vʒu lha ̈vʒuւ̕ϊɕKv
     */
    private int position;

    /** Lzssk̂ vʒu(larc̈vʒu) */
    private int matchPos;

    /** Lzssk̂ v */
    private int matchLen;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  flag
    //------------------------------------------------------------------
    //  private int flagByte
    //  private int flagBit
    //------------------------------------------------------------------
    /** 8LzsskA񈳏ktO܂Ƃ߂ */
    private int flagByte;

    /** LzsskA񈳏ktO */
    private int flagBit;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  backup for mark/reset
    //------------------------------------------------------------------
    //  private int markPosition
    //  private int markMatchPos
    //  private int markMatchLen
    //  private int markFlagByte
    //  private int markFlagBit
    //------------------------------------------------------------------
    /** positioñobNAbvp */
    private int markPosition;

    /** matchOffset̃obNAbvp */
    private int markMatchPos;

    /** matchLength̃obNAbvp */
    private int markMatchLen;

    /** flagBytẽobNAbvpB*/
    private int markFlagByte;

    /** flagCount̃obNAbvpB */
    private int markFlagBit;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private PreLz5Decoder()
    //  public PreLz5Decoder( InputStream in )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gps
     */
    private PreLz5Decoder(){ }

    /**
     * -lz5- 𓀗p PreLzssDecoder \zB
     * 
     * @param in kf[^̓Xg[
     */
    public PreLz5Decoder( InputStream in ){
        if( in != null ){
            if( in instanceof CachedInputStream ){
                this.in = (CachedInputStream)in;
            }else{
                this.in = new CachedInputStream( in );
            }

            this.position     = 0;
            this.matchPos     = 0;
            this.matchLen     = 0;
            this.flagByte     = 0;
            this.flagBit      = 0x100;

            this.markPosition = 0;
            this.markMatchPos = 0;
            this.markMatchLen = 0;
            this.markFlagByte = 0;
            this.markFlagBit  = 0;
        }else{
            throw new NullPointerException( "in" );
        }
    }

    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.PreLzssDecoder
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int readCode()
    //  public int readOffset()
    //------------------------------------------------------------------
    /**
     * -lz5- ňkꂽ 
     * 1byte  LZSSk̃f[^A
     * ͈kR[ĥvǂݍށB<br>
     * 
     * @return 1byte  k̃f[^́A
     *         kꂽkR[ĥv
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStreamɒBꍇ
     */
    public int readCode() throws IOException {
        if( this.flagBit == 0x100 ){
            this.flagByte  = this.in.read();                                    //throws IOException

            if( 0 <= this.flagByte ){
                this.flagBit = 0x01;
            }else{
                throw new EOFException();
            }
        }

        if( 0 != ( this.flagByte & this.flagBit ) ){
            this.flagBit <<= 1;
            this.position++;
            int ret = this.in.read();                                           //throws IOException
            if( 0 <= ret ) return ret;
            else           throw new EOFException();
        }else{
            this.flagBit <<= 1;
            int c1   = this.in.read();                                          //throws IOException
            int c2   = this.in.read();                                          //throws IOException

            if( 0 <= c1 ){
                this.matchPos = ( ( c2 & 0xF0 ) << 4 ) | c1;
                this.matchLen = c2 & 0x0F;
                return this.matchLen | 0x100;
            }else{
                throw new EOFException();
            }
        }
    }

    /**
     * -lz5- ňkꂽ
     * kR[ĥvʒuǂݍށB<br>
     * 
     * @return -lz5- ňkꂽkR[ĥvʒu
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int readOffset() throws IOException {
        int offset  = ( this.position - this.matchPos - 1
                      - PreLz5Decoder.MaxMatch )
                    & ( PreLz5Decoder.DictionarySize - 1 );

        this.position += this.matchLen + PreLz5Decoder.Threshold;

        return offset;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.PreLzssDecoder
    //------------------------------------------------------------------
    //  mark/reset
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupported()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     *
     * @see PreLzssDecoder#mark(int)
     */
    public void mark( int readLimit ){
        this.in.mark( ( readLimit * 9 + 7 ) / 8 + 2 );
        this.markPosition = this.position;
        this.markMatchLen = this.matchLen;
        this.markMatchPos = this.matchPos;
        this.markFlagByte = this.flagByte;
        this.markFlagBit  = this.flagBit;
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException <br>
     * &emsp;&emsp; (1) mark()  reset() 悤ƂꍇB<br>
     * &emsp;&emsp; (2) ڑꂽ̓Xg[ markSupported()
     *                  false ԂꍇB<br>
     * &emsp;&emsp; (3) ڑꂽ̓Xg[
     *                  o̓G[ꍇB<br>
     * &emsp;&emsp; ̉ꂩB
     */
    public void reset() throws IOException {
        //mark() ĂȂ̂ reset() 悤ƂꍇA
        //ڑꂽXg[mark/resetT|[gȂꍇ
        //CachedInputStream  IOException 𓊂B
        this.in.reset();                                                        //throws IOException

        this.position = this.markPosition;
        this.matchLen = this.markMatchLen;
        this.matchPos = this.markMatchPos;
        this.flagByte = this.markFlagByte;
        this.flagBit  = this.markFlagBit;
    }

    /**
     * ڑꂽXg[ mark()  reset()
     * T|[g邩ԂB
     * 
     * @return ڑꂽXg[ mark,reset T|[gȂtrue,
     *         T|[gȂȂ false
     */
    public boolean markSupported(){
        return this.in.markSupported();
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.PreLzssDecoder
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ubNɓǂݏoƂ̏oŒoCg𓾂B<br>
     * ̒l͕ۏ؂B
     * 
     * @return ubNȂœǂݏoŒoCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     * 
     * @see PreLzssDecoder#available()
     */
    public int available() throws IOException {
        return Math.max( in.available() * 8 / 9 - 2, 0 );                       //throws IOException
    }

    /**
     * ̃Xg[AgpĂSĂ̎B
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void close() throws IOException {
        this.in.close();                                                        //throws IOException

        this.in = null;
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.util.PreLzssDecoder
    //------------------------------------------------------------------
    //  get LZSS parameter
    //------------------------------------------------------------------
    //  public int getDictionarySize()
    //  public int getMaxMatch()
    //  public int getThreshold()
    //------------------------------------------------------------------
    /**
     * -lz5-` LZSS̃TCY𓾂B
     * 
     * @return -lz5-` LZSS̃TCY
     */
    public int getDictionarySize(){
        return PreLz5Decoder.DictionarySize;
    }

    /**
     * -lz5-` LZSS̍őv𓾂B
     * 
     * @return -lz5-` LZSS̍őv
     */
    public int getMaxMatch(){
        return PreLz5Decoder.MaxMatch;
    }

    /**
     * -lz5-` LZSS̈kA񈳏k臒l𓾂B
     * 
     * @return -lz5-` LZSS̈kA񈳏k臒l
     */
    public int getThreshold(){
        return PreLz5Decoder.Threshold;
    }

}
//end of PreLz5Decoder.java
