
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         katedesc_parse
#define yylex           katedesc_lex
#define yyerror         katedesc_error
#define yylval          katedesc_lval
#define yychar          katedesc_char
#define yydebug         katedesc_debug
#define yynerrs         katedesc_nerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 10 "kate_parser.y"


#define KATE_INTERNAL
#include "kate_internal.h"

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <ctype.h>
#include "kate/oggkate.h"
#ifdef HAVE_PNG
#include "kpng.h"
#endif
#include "katedesc.h"
#include "kate_parser.h"

#define CHECK_KATE_API_ERROR(statement) \
  do {                                  \
    int ret=(statement);                \
    if (ret<0) {                        \
      yyerror("error in #statement");   \
      exit(-1);                         \
    }                                   \
  } while(0)

int nerrors=0;
int nwarnings=0;

static char *temp_macro_name=NULL;
static kate_float timebase = (kate_float)0;

typedef kate_style kd_style;
typedef kate_region kd_region;

typedef struct kd_curve {
  size_t idx;
  kate_curve *curve;
} kd_curve;

typedef struct kd_motion {
  size_t idx;
  kate_motion *motion;
} kd_motion;

typedef struct kd_palette {
  kate_palette *palette;
} kd_palette;

typedef struct kd_bitmap {
  kate_bitmap *bitmap;
} kd_bitmap;

static kate_style kstyle;
static kate_region kregion;
static kd_palette kpalette;
static kd_bitmap kbitmap;
static kd_curve kcurve;
static kate_font_range *krange=NULL;
static kate_font_mapping *kmapping=NULL;

static size_t nkmotions=0;
static kd_motion *kmotions=NULL;
static kate_motion *kmotion=NULL;

static char **style_names=NULL;
static char **region_names=NULL;
static char **palette_names=NULL;
static char **bitmap_names=NULL;
static char **curve_names=NULL;
static char **motion_names=NULL;
static char **font_range_names=NULL;
static char **font_mapping_names=NULL;

static size_t n_local_bitmaps=0;
static char **local_bitmap_names=NULL;
static kate_bitmap **local_bitmaps=NULL;

static int open_ended_curve=0;
static int n_curve_pts=-1;
static int n_palette_colors=-1;
static int n_bitmap_pixels=-1;

static kate_float karaoke_base_height=(kate_float)0;
static kate_float karaoke_top_height=(kate_float)0;

typedef struct kd_event {
  kate_float t0;
  kate_float t1;
  kate_float duration;
  char *text;
  kate_markup_type text_markup_type;
  int region_index;
  const kate_region *region;
  int style_index;
  const kate_style *style;
  int secondary_style_index;
  const kate_style *secondary_style;
  int palette_index;
  const kate_palette *palette;
  int bitmap_index;
  const kate_bitmap *bitmap;
} kd_event;
static kd_event kevent;

static void katedesc_trace(const char *msg,...)
{
  va_list ap;
  va_start(ap,msg);
  vfprintf(stderr,msg,ap);
  va_end(ap);
}
/* #define KDTRACE(msg,args...) katedesc_trace(msg, ##args) */
#define KDTRACE katedesc_trace

int yyerror(const char *s)
{
  (void)s;
  KDTRACE("Error line %d: %s (token %s)\n",nlines,s,katedesc_text);
  nerrors++;
  return 1;
}

int yyerrorf(const char *msg,...)
{
  static char buffer[4096];
  va_list ap;
  va_start(ap,msg);
  vsnprintf(buffer,sizeof(buffer),msg,ap);
  buffer[sizeof(buffer)-1]=0;
  va_end(ap);
  return yyerror(buffer);
}

int yywarning(const char *s)
{
  (void)s;
  KDTRACE("Warning line %d: %s (token %s)\n",nlines,s,katedesc_text);
  nwarnings++;
  return 1;
}

static char *catstrings(char *s1,const char *s2)
{
  size_t len;
  char *s;

  if (!s2) { yyerror("internal error: no string to append"); exit(-1); }
  len=(s1?strlen(s1):0)+strlen(s2)+1;
  s=(char*)kate_realloc(s1,len);
  if (!s) { yyerror("out of memory"); exit(-1); }
  if (s1) strcat(s,s2); else strcpy(s,s2);

  return s;
}

static char *dupstring(const char *s)
{
  size_t len;
  char *news;

  if (!s) { yyerror("internal error: no string"); exit(-1); }

  len=strlen(s);
  news=(char*)kate_malloc(len+1);
  if (!news) { yyerror("out of memory"); exit(-1); }
  memcpy(news,s,len+1);
  return news;
}

static int find_item(const char *name,size_t nnames,char **names)
{
  size_t n;
  for (n=0;n<nnames;++n) {
    if (names[n] && !strcmp(names[n],name)) return n;
  }
  yyerrorf("Named item not found: %s",name);
  return 0;
}

static void init_palette(void)
{
  kpalette.palette=(kate_palette*)kate_malloc(sizeof(kate_palette));
  if (!kpalette.palette) { yyerror("out of memory"); exit(-1); }
  if (kate_palette_init(kpalette.palette)<0) {
    yyerror("palette init failed");
    exit(-1);
  }
}

static void generate_full_filename(char *full_filename,size_t size,const char *filename)
{
  if (filename[0]=='/' || filename[0]=='\\') {
    strcpy(full_filename,filename);
  }
  else {
    snprintf(full_filename,size,"%s%s",base_path,filename);
    full_filename[size-1]=0;
  }
}

static void load_palette(const char *filename)
{
#ifdef HAVE_PNG
  int ncolors;
  kate_color *palette=NULL;
  static char full_filename[4096];

  generate_full_filename(full_filename,sizeof(full_filename),filename);
  if (kd_read_png8(full_filename,NULL,NULL,NULL,&palette,&ncolors,NULL)) {
    yyerrorf("failed to load %s",filename);
    return;
  }

  kpalette.palette->ncolors=ncolors;
  kpalette.palette->colors=palette;
#else
  yyerrorf("PNG support not compiled in: cannot load %s",filename);
  exit(-1);
#endif
}

static void check_palette(const kate_palette *kp)
{
  if (!kp) { yyerror("internal error: no palette"); exit(-1); }
}

static void add_palette(kate_info *ki,const char *name,kate_palette *kp)
{
  int ret;

  check_palette(kp);

  ret=kate_info_add_palette(ki,kp);
  if (ret<0) {
    yyerrorf("Failed to register palette: %d",ret);
  }
  else {
    palette_names=(char**)kate_realloc(palette_names,ki->npalettes*sizeof(char*));
    if (!palette_names) {
      yyerror("Out of memory");
      exit(-1);
    }
    palette_names[ki->npalettes-1]=name?dupstring(name):NULL;
  }
}

static int find_palette(const kate_info *ki,const char *name)
{
  return find_item(name,ki->npalettes,palette_names);
}

static void init_bitmap(void)
{
  kbitmap.bitmap=(kate_bitmap*)kate_malloc(sizeof(kate_bitmap));
  if (!kbitmap.bitmap) { yyerror("out of memory"); exit(-1); }
  if (kate_bitmap_init(kbitmap.bitmap)<0) {
    yyerror("bitmap init failed");
    exit(-1);
  }
}

static int compute_bitmap_x_offset(kate_float percent)
{
  if (kbitmap.bitmap->width) {
    return (int)(kbitmap.bitmap->width*percent/100+0.5);
  }
  else {
    yyerror("Bitmap width must be known before specifying offset as a percentage");
    return 0;
  }
}

static int compute_bitmap_y_offset(kate_float percent)
{
  if (kbitmap.bitmap->height) {
    return (int)(kbitmap.bitmap->height*percent/100+0.5);
  }
  else {
    yyerror("Bitmap height must be known before specifying offset as a percentage");
    return 0;
  }
}

static void load_bitmap(const char *filename,int paletted)
{
#ifdef HAVE_PNG
  int w,h;
  unsigned char *pixels=NULL;

  if (paletted) {
    int bpp;
    static char full_filename[4096];

    generate_full_filename(full_filename,sizeof(full_filename),filename);
    if (kd_read_png8(full_filename,&w,&h,&bpp,NULL,NULL,&pixels)) {
      yyerrorf("failed to load %s",filename);
      return;
    }

    kbitmap.bitmap->type=kate_bitmap_type_paletted;
    kbitmap.bitmap->width=w;
    kbitmap.bitmap->height=h;
    kbitmap.bitmap->bpp=bpp;
    kbitmap.bitmap->pixels=pixels;
    kbitmap.bitmap->size=0;
  }
  else {
    size_t size;
    static char full_filename[4096];

    generate_full_filename(full_filename,sizeof(full_filename),filename);
    if (kd_read_png(full_filename,&w,&h,&pixels,&size)) {
      yyerrorf("failed to load %s",filename);
      return;
    }

    kbitmap.bitmap->type=kate_bitmap_type_png;
    kbitmap.bitmap->width=w;
    kbitmap.bitmap->height=h;
    kbitmap.bitmap->bpp=0;
    kbitmap.bitmap->pixels=pixels;
    kbitmap.bitmap->size=size;
  }

  kbitmap.bitmap->palette=-1;
#else
  (void)paletted;
  yyerrorf("PNG support not compiled in: cannot load %s",filename);
  exit(-1);
#endif
}

static void check_bitmap(const kate_bitmap *kb)
{
  if (!kb) { yyerror("internal error: no bitmap"); exit(-1); }
}

static void add_bitmap(kate_info *ki,const char *name,kate_bitmap *kb)
{
  int ret;

  check_bitmap(kb);

  ret=kate_info_add_bitmap(ki,kb);
  if (ret<0) {
    yyerrorf("Failed to register bitmap: %d",ret);
  }
  else {
    bitmap_names=(char**)kate_realloc(bitmap_names,ki->nbitmaps*sizeof(char*));
    if (!bitmap_names) {
      yyerror("Out of memory");
      exit(-1);
    }
    bitmap_names[ki->nbitmaps-1]=name?dupstring(name):NULL;
  }
}

static void add_local_bitmap(kate_state *k,const char *name,kate_bitmap *kb)
{
  int ret;

  check_bitmap(kb);

  ret=kate_encode_add_bitmap(k,kb);
  if (ret<0) {
    yyerrorf("Failed to register bitmap: %d",ret);
  }
  else {
    ++n_local_bitmaps;
    local_bitmap_names=(char**)kate_realloc(local_bitmap_names,n_local_bitmaps*sizeof(char*));
    if (!local_bitmap_names) {
      yyerror("Out of memory");
      exit(-1);
    }
    local_bitmap_names[n_local_bitmaps-1]=name?dupstring(name):NULL;
    local_bitmaps=(kate_bitmap**)kate_realloc(local_bitmaps,n_local_bitmaps*sizeof(kate_bitmap*));
    if (!local_bitmaps) {
      yyerror("Out of memory");
      exit(-1);
    }
    local_bitmaps[n_local_bitmaps-1]=kb;
  }
}

static void add_local_bitmap_index(kate_state *k,const char *name,size_t idx)
{
  int ret;

  ret=kate_encode_add_bitmap_index(k,idx);
  if (ret<0) {
    yyerrorf("Failed to register bitmap: %d",ret);
  }
  else {
    ++n_local_bitmaps;
    local_bitmap_names=(char**)kate_realloc(local_bitmap_names,n_local_bitmaps*sizeof(char*));
    if (!local_bitmap_names) {
      yyerror("Out of memory");
      exit(-1);
    }
    local_bitmap_names[n_local_bitmaps-1]=name?dupstring(name):NULL;
    local_bitmaps=(kate_bitmap**)kate_realloc(local_bitmaps,n_local_bitmaps*sizeof(kate_bitmap*));
    if (!local_bitmaps) {
      yyerror("Out of memory");
      exit(-1);
    }
    local_bitmaps[n_local_bitmaps-1]=NULL;
  }
}

static int find_bitmap(const kate_info *ki,const char *name)
{
  int ret=find_item(name,ki->nbitmaps,bitmap_names);
  if (ret>=0) return ret;
  ret=find_item(name,n_local_bitmaps,local_bitmap_names);
  if (ret>=0) return ret+ki->nbitmaps;
  return ret;
}

static void check_style(const kate_style *ks)
{
  if (!ks) { yyerror("internal error: no style"); exit(-1); }
}

static void add_style(kate_info *ki,const char *name,const kate_style *ks)
{
  int ret;
  kate_style *ks2;

  check_style(ks);

  ks2=(kate_style*)kate_malloc(sizeof(*ks2));
  if (!ks2) {
    yyerrorf("Out of memory");
    exit(-1);
  }
  memcpy(ks2,ks,sizeof(*ks2));

  ret=kate_info_add_style(ki,ks2);
  if (ret<0) {
    yyerrorf("Failed to register style: %d",ret);
  }
  else {
    style_names=(char**)kate_realloc(style_names,ki->nstyles*sizeof(char*));
    if (!style_names) {
      yyerror("Out of memory");
      exit(-1);
    }
    style_names[ki->nstyles-1]=name?dupstring(name):NULL;
  }
}

static int find_style(const kate_info *ki,const char *name)
{
  return find_item(name,ki->nstyles,style_names);
}

static void check_region(const kate_region *kr)
{
  if (!kr) { yyerror("internal error: no region"); exit(-1); }
  if (kr->w<0) yyerrorf("Region width (%d) must be non negative",kr->w);
  if (kr->h<0) yyerrorf("Region height (%d) must be non negative",kr->h);
}

static void add_region(kate_info *ki,const char *name,const kate_region *kr)
{
  int ret;
  kate_region *kr2;

  check_region(kr);

  kr2=(kate_region*)kate_malloc(sizeof(*kr2));
  if (!kr2) {
    yyerrorf("Out of memory");
    exit(-1);
  }
  memcpy(kr2,kr,sizeof(*kr2));

  ret=kate_info_add_region(ki,kr2);
  if (ret<0) {
    yyerrorf("Failed to register region: %d",ret);
  }
  else {
    region_names=(char**)kate_realloc(region_names,ki->nregions*sizeof(char*));
    if (!region_names) {
      yyerror("Out of memory");
      exit(-1);
    }
    region_names[ki->nregions-1]=name?dupstring(name):NULL;
  }
}

static int find_region(const kate_info *ki,const char *name)
{
  return find_item(name,ki->nregions,region_names);
}

static void check_curve(const kate_curve *kc)
{
  size_t minpts=0,maxpts=INT_MAX;
  if (!kc) { yyerror("internal error: no curve"); exit(-1); }
  switch (kc->type) {
    case kate_curve_none: minpts=0; maxpts=0; break;
    case kate_curve_static: minpts=1; maxpts=1; break;
    case kate_curve_linear: minpts=2; maxpts=INT_MAX; break;
    case kate_curve_catmull_rom_spline: minpts=2; maxpts=INT_MAX; break;
    case kate_curve_bezier_cubic_spline: minpts=3; maxpts=INT_MAX; break;
    case kate_curve_bspline: minpts=2; maxpts=INT_MAX; break;
  }
  if (kc->npts<minpts) yyerrorf("Curve does not have enough points for this type (has %d, min pts %d)",kc->npts,minpts);
  if (kc->npts>maxpts) yyerrorf("Curve has too many points for this type (has %d, max pts %d)",kc->npts,maxpts);
  if (kc->type==kate_curve_bezier_cubic_spline) {
    if ((kc->npts-1)%3) yyerrorf("Cubic Bezier splines should have 1+3n points");
  }
}

static void add_curve(kate_info *ki,const char *name,kate_curve *kc)
{
  int ret;

  check_curve(kc);

  ret=kate_info_add_curve(ki,kc);
  if (ret<0) {
    yyerrorf("Failed to register curve: %d",ret);
  }
  else {
    curve_names=(char**)kate_realloc(curve_names,ki->ncurves*sizeof(char*));
    if (!curve_names) {
      yyerror("Out of memory");
      exit(-1);
    }
    curve_names[ki->ncurves-1]=name?dupstring(name):NULL;
  }
}

static int find_curve(const kate_info *ki,const char *name)
{
  return find_item(name,ki->ncurves,curve_names);
}

static void clear_motions(void)
{
  kate_free(kmotions);
  kmotions=NULL;
  kmotion=NULL;
  nkmotions=0;
}

static void check_motion(kate_motion *kmotion)
{
  if (!kmotion) { yyerror("internal error: no motion"); exit(-1); }

  if (kmotion->ncurves==0) { yyerror("motion must have at least one curve"); return; }
  if (kmotion->semantics==(kate_motion_semantics)-1) { yyerror("motion semantics is not defined"); return; }
}

static void add_motion(kate_info *ki,const char *name,kate_motion *km)
{
  int ret;

  check_motion(km);

  ret=kate_info_add_motion(ki,km);
  if (ret<0) {
    yyerrorf("Failed to register motion: %d",ret);
  }
  else {
    motion_names=(char**)kate_realloc(motion_names,ki->nmotions*sizeof(char*));
    if (!motion_names) {
      yyerror("Out of memory");
      exit(-1);
    }
    motion_names[ki->nmotions-1]=name?dupstring(name):NULL;
  }

  clear_motions();
}

static int find_motion(const kate_info *ki,const char *name)
{
  return find_item(name,ki->nmotions,motion_names);
}

static void init_style(kd_style *style)
{
  int ret=kate_style_init(style);
  if (ret<0) {
    yyerrorf("Error initializing style: %d\n",ret);
    exit(1);
  }
}

static void set_font_width(kd_style *style,kate_float s,kate_space_metric metric)
{
  if (style->font_width>=0) {
    yyerror("Font width already set");
  }
  if (style->font_height>=0 && style->font_metric!=metric) {
    yyerror("All font size metrics must be the same");
  }
  style->font_width=s;
  style->font_metric=metric;
}

static void set_font_height(kd_style *style,kate_float s,kate_space_metric metric)
{
  if (style->font_height>=0) {
    yyerror("Font height already set");
  }
  if (style->font_width>=0 && style->font_metric!=metric) {
    yyerror("All font size metrics must be the same");
  }
  style->font_height=s;
  style->font_metric=metric;
}

static void set_font(kd_style *style,const char *font)
{
  size_t len;
  if (!font) {
    yyerror("Internal error: no font");
    exit(-1);
  }
  len=strlen(font);
  if (style->font) {
    yyerror("Font already set");
  }
  style->font=(char*)kate_malloc(len+1);
  if (!style->font) {
    yyerror("out of memory");
    exit(-1);
  }
  strcpy(style->font,font);
}

static void set_font_size(kd_style *style,kate_float s,kate_space_metric metric)
{
  if (style->font_height>=0 || style->font_width>=0) {
    yyerror("Font width and/or height already set");
  }
  style->font_width=s;
  style->font_height=s;
  style->font_metric=metric;
}

static void set_margin(kd_style *style,kate_float *margin,kate_float m,kate_space_metric metric)
{
  int metric_already_set=0;
  if (&style->left_margin!=margin && style->left_margin!=0) metric_already_set=1;
  if (&style->top_margin!=margin && style->top_margin!=0) metric_already_set=1;
  if (&style->right_margin!=margin && style->right_margin!=0) metric_already_set=1;
  if (&style->bottom_margin!=margin && style->bottom_margin!=0) metric_already_set=1;
  if (metric_already_set && metric!=style->margin_metric) {
    yyerror("Metric must be the same for all margins");
    return;
  }
  *margin=m;
  style->margin_metric=metric;
}

static void set_margins(kd_style *style,
                        kate_float left,kate_space_metric left_metric,
                        kate_float top,kate_space_metric top_metric,
                        kate_float right,kate_space_metric right_metric,
                        kate_float bottom,kate_space_metric bottom_metric)
{
  if (left_metric!=right_metric || left_metric!=top_metric || left_metric!=bottom_metric) {
    yyerror("Metric must be the same for all margins");
    return;
  }
  style->left_margin=left;
  style->top_margin=top;
  style->right_margin=right;
  style->bottom_margin=bottom;
  style->margin_metric=left_metric;
}

static void init_style_from(int idx)
{
  const kate_style *from=ki.styles[idx];
  init_style(&kstyle);
  memcpy(&kstyle,from,sizeof(kate_style));
}

static void init_region(kd_region *region)
{
  int ret=kate_region_init(region);
  if (ret<0) {
    yyerrorf("Error initializing region: %d\n",ret);
    exit(1);
  }
}

static void init_region_from(int idx)
{
  const kate_region *from=ki.regions[idx];
  init_region(&kregion);
  memcpy(&kregion,from,sizeof(kate_region));
}

static void reference_curve_from(int idx)
{
  kcurve.idx=idx;
  kcurve.curve=NULL;
}

static void init_curve(void)
{
  kcurve.idx=0;
  kcurve.curve=(kate_curve*)kate_malloc(sizeof(kate_curve));
  if (!kcurve.curve) { yyerror("out of memory"); exit(-1); }
  if (kate_curve_init(kcurve.curve)<0) {
    yyerror("error initializing curve");
    exit(-1);
  }
}

static void init_curve_from(int idx)
{
  const kate_curve *from=ki.curves[idx];
  if (!from || !from->pts) {
    yyerror("invalid curve to init from");
    exit(-1);
  }
  init_curve();
  memcpy(kcurve.curve,from,sizeof(kate_curve));
  kcurve.curve->pts=(kate_float*)kate_malloc(kcurve.curve->npts*2*sizeof(kate_float));
  if (!kcurve.curve->pts) {
    yyerror("out of memory");
    exit(-1);
  }
  memcpy(kcurve.curve->pts,from->pts,kcurve.curve->npts*2*sizeof(kate_float));
}

static void init_curve_points(int npts)
{
  if (!kcurve.curve) { yyerror("internal error: curve not initialized"); exit(-1); }
  if (n_curve_pts<0) { katedesc_error("Curve type must be specified before the points"); exit(-1); }
  if (npts<=0) { katedesc_error("Number of points cannot be negative or zero"); exit(-1); }
  kcurve.curve->npts=npts;
  kcurve.curve->pts=(kate_float*)kate_malloc(npts*2*sizeof(kate_float));
  if (!kcurve.curve->pts) {
    yyerror("Out of memory");
    exit(-1);
  }
  open_ended_curve=0;
}

static void init_open_ended_curve_points(void)
{
  if (!kcurve.curve) { yyerror("internal error: curve not initialized"); exit(-1); }
  if (n_curve_pts<0) katedesc_error("Curve type must be specified before the points");
  kcurve.curve->npts=0;
  kcurve.curve->pts=NULL;
  open_ended_curve=1;
}

static void add_open_ended_curve_point(kate_float pt)
{
  if (!kcurve.curve) { yyerror("internal error: curve not initialized"); exit(-1); }
  ++n_curve_pts;
  kcurve.curve->npts=(n_curve_pts+1)/2;
  kcurve.curve->pts=(kate_float*)kate_realloc(kcurve.curve->pts,kcurve.curve->npts*2*sizeof(kate_float));
  if (!kcurve.curve->pts) {
    yyerror("Out of memory");
    exit(-1);
  }
  kcurve.curve->pts[n_curve_pts-1]=pt;
}

static void init_palette_colors(int ncolors)
{
  if (!kpalette.palette) { yyerror("internal error: palette not initialized"); exit(-1); }
  kpalette.palette->ncolors=ncolors;
  kpalette.palette->colors=(kate_color*)kate_malloc(ncolors*sizeof(kate_color));
  if (!kpalette.palette->colors) {
    yyerror("Out of memory");
    exit(-1);
  }
  n_palette_colors=0;
}

static void init_bitmap_pixels(int width,int height,int bpp)
{
  if (!kbitmap.bitmap) { yyerror("internal error: bitmap not initialized"); exit(-1); }
  if (width<=0 || height<=0) yyerror("Bitmap dimensions must be positive");
  if (bpp<=0) yyerror("Bitmap bit depth must be positive");
  if (bpp>8) yyerrorf("Bitmap bit depth must not be more than 8 (is %d)",bpp);
  kbitmap.bitmap->type=kate_bitmap_type_paletted;
  kbitmap.bitmap->width=width;
  kbitmap.bitmap->height=height;
  kbitmap.bitmap->bpp=bpp;
  kbitmap.bitmap->pixels=(unsigned char*)kate_malloc(width*height*sizeof(unsigned char));
  if (!kbitmap.bitmap->pixels) {
    yyerror("Out of memory");
    exit(-1);
  }
  kbitmap.bitmap->size=0;
  n_bitmap_pixels=0;
}

static void init_png_bitmap_pixels(int width,int height,int size)
{
  if (!kbitmap.bitmap) { yyerror("internal error: bitmap not initialized"); exit(-1); }
  if (width<=0 || height<=0) yyerror("Bitmap dimensions must be positive");
  kbitmap.bitmap->type=kate_bitmap_type_png;
  kbitmap.bitmap->width=width;
  kbitmap.bitmap->height=height;
  kbitmap.bitmap->bpp=0;
  kbitmap.bitmap->pixels=(unsigned char*)kate_malloc(size);
  if (!kbitmap.bitmap->pixels) {
    yyerror("Out of memory");
    exit(-1);
  }
  kbitmap.bitmap->size=size;
  n_bitmap_pixels=0;
}

static void set_color(kate_color *kc,uint32_t c)
{
  int r=(c>>24)&0xff;
  int g=(c>>16)&0xff;
  int b=(c>>8)&0xff;
  int a=(c>>0)&0xff;
  if (!kc) {
    yyerror("Internal error: null color");
    exit(-1);
  }
  if (r<0 || r>255) yyerrorf("red component (%d) must be between 0 and 255",r);
  if (g<0 || g>255) yyerrorf("green component (%d) must be between 0 and 255",g);
  if (b<0 || b>255) yyerrorf("blue component (%d) must be between 0 and 255",b);
  if (a<0 || a>255) yyerrorf("alpha component (%d) must be between 0 and 255",a);
  kc->r=r;
  kc->g=g;
  kc->b=b;
  kc->a=a;
}

static void init_event(kd_event *ev)
{
  if (!ev) {
    yyerror("Internal error: null event");
    exit(-1);
  }
  ev->t0=ev->t1=ev->duration=(kate_float)-1.0;
  ev->text=NULL;
  ev->text_markup_type=kate_markup_none;
  ev->region_index=ev->style_index=ev->secondary_style_index=-1;
  ev->region=NULL;
  ev->style=NULL;
  ev->secondary_style=NULL;
  ev->palette_index=ev->bitmap_index=-1;
  ev->palette=NULL;
  ev->bitmap=NULL;
}

static void kd_encode_set_id(kate_state *kstate,unsigned int id)
{
  if (id&0x80000000) yyerrorf("ID %d (hex %x) out of range, must fit on 31 bits",id,id);

  /* unused at the moment - will need to map an autogenerated id to this user id */
  (void)kstate;
  (void)id;
}

static int add_entity(const char *entity,char **text,size_t *wlen0)
{
  int count=0;

  if (!entity || !text || !wlen0) {
    yyerror("internal error: add_entity passed null parameter");
    exit(-1);
  }

  /* write out the entity */
  while (*entity) {
    int ret=kate_text_set_character(kate_utf8,*entity,text,wlen0);
    if (ret<0) return ret;
    count+=ret;
    ++entity;
  }
  return count;
}

static char *expand_numeric_entities(const char *text)
{
  enum {
    s_text,
    s_amp,
    s_code,
    s_named
  } state=s_text;
  int c,code=0,code_from_numeric,base=-1;
  size_t len=strlen(text),len0=len+1,rlen0=len0,wlen0=len0,allocated=len0;
  /* we might need to replace "&#00;" with "&amp;" - we can't use more characters, so we needn't allocate more */
  /* this might change if we even can replace a numeric entity with a named one that is longer as a string */
  char *newtext=(char*)kate_malloc(allocated),*newtextptr=newtext;

  if (!newtext) { yyerror("out of memory"); exit(-1); }

  while (1) {
    int ret=kate_text_get_character(kate_utf8,&text,&rlen0);
    if (ret<0) {
      yyerrorf("failed to read character: %d",ret);
      kate_free(newtext);
      return NULL;
    }
    c=ret;

    code_from_numeric=0;
    switch (state) {
      case s_text:
        if (c=='&') {
          state=s_amp;
          code=0;
        }
        break;
      case s_amp:
        if (c=='#') {
          state=s_code;
          base=-1; /* unknown yet */
        }
        else {
          state=s_named;

          /* we've encountered a named entity, and we've discarded the & already,
             so we need to add it now before the newly read character */
          ret=kate_text_set_character(kate_utf8,'&',&newtextptr,&wlen0);
          if (ret<0) {
            yyerrorf("failed to write character: %d",ret);
            kate_free(newtext);
            return NULL;
          }
        }
        break;
      case s_code:
        if (c==';') {
          if (base<0) {
            /* no code given */
            yyerrorf("no code given in numeric entity");
            c=0;
            code_from_numeric=1;
            state=s_text;
          }
          else {
            c=code; /* this will be written below */
            code_from_numeric=1;
            state=s_text;
          }
        }
        else {
          /* if first character, determine if this is decimal or hexadecimal */
          if (base<0) {
            if (c=='x' || c=='X') {
              base=16;
              break; /* the code starts next character */
            }
            else {
              base=10;
              /* fall through */
            }
          }

          code*=base;
          if (isdigit(c)) code+=(c-'0');
          else if (base==16 && isxdigit(c)) code+=(tolower(c)-'a'+10);
          else yyerrorf("invalid character in numeric entity (only numeric entities are supported), got %d",c);
        }
        break;
      case s_named:
        if (c==';') {
          state=s_text;
        }
        break;
    }

    if (state==s_text || state==s_named) {
      /* we don't want to expand characters in "<&>" as they would then be wrongly interpreted,
         so we insert here as entities - note that we don't want to expand them and do another
         pass to reencode them, as we then might pick up others that *were* in the text verbatim */
      if (code_from_numeric && strchr("<&>",c)) {
        switch (c) {
          case '<': ret=add_entity("&lt;",&newtextptr,&wlen0); break;
          case '&': ret=add_entity("&amp;",&newtextptr,&wlen0); break;
          case '>': ret=add_entity("&gt;",&newtextptr,&wlen0); break;
        }
      }
      else {
        ret=kate_text_set_character(kate_utf8,c,&newtextptr,&wlen0);
      }
      if (ret<0) {
        yyerrorf("failed to write character: %d",ret);
        kate_free(newtext);
        return NULL;
      }
    }
    if (c==0) break;
  }
  return newtext;
}

static char *getrawline(const char **text)
{
  size_t rlen0;
  int newline,in_newline=0;
  const char *start_of_line;
  int c;

  if (!text || !*text) {
    yyerror("error: getrawline passed invalid text pointer");
    exit(-1);
  }

  rlen0=strlen(*text)+1;
  start_of_line=*text;

  while (1) {
    const char *ptr=*text;
    int ret=kate_text_get_character(kate_utf8,text,&rlen0);
    if (ret<0) {
      yyerrorf("failed to read character: %d",ret);
      return NULL;
    }
    c=ret;
    if (c==0) {
      /* end of the string, return everything */
      size_t len=strlen(start_of_line);
      char *line=(char*)kate_malloc(len+1);
      memcpy(line,start_of_line,len+1);
      *text=ptr; /* do not push past the start of the new line */
      return line;
    }
    newline=(strchr("\n\r",c)!=NULL);
    if (!newline && in_newline) {
      /* we are at the start of a new line */
      char *line=(char*)kate_malloc(ptr-start_of_line+1);
      memcpy(line,start_of_line,ptr-start_of_line);
      line[ptr-start_of_line]=0;
      *text=ptr; /* do not push past the start of the new line */
      return line;
    }
    in_newline=newline;
  }
}

static void trimend(char *line,size_t rlen0,int *eol)
{
  int ret;
  int c;
  int ws;
  char *text=line;

  if (!line) return;
  
  ret=kate_text_get_character(kate_utf8,(const char**)&text,&rlen0);
  if (ret<0) {
    yyerrorf("failed to read character: %d",ret);
    return;
  }
  c=ret;
  if (c==0) {
    *eol=1;
    return;
  }

  trimend(text,rlen0,eol);

  ws=(strchr(" \t\n\r",c)!=NULL);
  if (*eol && ws) *line=0;
  if (!ws) *eol=0;
}

static char *trimline(const char *line)
{
  char *trimmed;
  size_t rlen0;
  int c;
  int eol=0;

  if (!line) {
    yyerror("error: trimline passed null line");
    exit(-1);
  }

  rlen0=strlen(line)+1;

  /* first seek to the first non whitespace character in the line */
  while (1) {
    const char *ptr=line;
    int ret=kate_text_get_character(kate_utf8,&ptr,&rlen0);
    if (ret<0) {
      yyerrorf("failed to read character: %d",ret);
      return NULL;
    }
    c=ret;
    if (!c || !strchr(" \t",c)) {
      /* we found a non whitespace, or an end of line, stop */
      break;
    }
    /* we can advance the start of the line */
    line=ptr;
  }

  rlen0=strlen(line)+1;
  trimmed=(char*)kate_malloc(rlen0);
  memcpy(trimmed,line,rlen0);
  trimend(trimmed,strlen(trimmed)+1,&eol);
  return trimmed;
}

static char *trimtext(const char *text)
{
  char *newtext=(char*)kate_malloc(1);
  *newtext=0;
  while (text && *text) {
    char *line=getrawline(&text);
    char *trimmed=trimline(line);
    kate_free(line);
    if (*trimmed && strcmp(trimmed,"\n")) {
      /* ignore empty lines */
      if (newtext && *newtext) {
        /* add a newline between lines (eg, not before the first line) */
        newtext=catstrings(newtext,"\n");
      }
      newtext=catstrings(newtext,trimmed);
    }
    kate_free(trimmed);
  }
  return newtext;
}

static char *trimtext_pre(const char *text)
{
  /* in pre, we just kill a new line at start and one at the end, if any */
  size_t len;
  char *newtext;

  if (!text) {
    yyerror("error: trimtext_pre passed null text");
    exit(-1);
  }

  len=strlen(text);
  newtext=(char*)kate_malloc(len+1);

  /* start */
  if (*text=='\n') {
    memcpy(newtext,text+1,len);
    --len;
  }
  else {
    memcpy(newtext,text,len+1);
  }

  /* end */
  if (len>0 && newtext[len-1]=='\n') {
    newtext[len-1]=0;
  }

  return newtext;
}

static void backslash_n_to_newline(char *text)
{
  char *ptr=text;
  while (ptr && (ptr=strstr(ptr,"\\n"))) {
    *ptr='\n';
    memmove(ptr+1,ptr+2,strlen(ptr+2)+1);
  }
}

static void set_event_text(kd_event *ev,const char *text,int pre,int markup)
{
  char *newtext,*expanded;
  size_t len;

  if (ev->text) {
    yyerrorf("text already set (to %s, trying to set to %s)",ev->text,text);
    return;
  }
  if (!text) {
    yyerror("null text");
    return;
  }

  len=strlen(text);
  newtext=(char*)kate_malloc(len+1);
  memcpy(newtext,text,len+1);
  backslash_n_to_newline(newtext);

  expanded=expand_numeric_entities(newtext);
  kate_free(newtext);
  newtext=expanded;

  if (!pre) {
    char *trimmed_newtext=trimtext(newtext);
    kate_free(newtext);
    newtext=trimmed_newtext;
  }
  else {
    char *trimmed_newtext=trimtext_pre(newtext);
    kate_free(newtext);
    newtext=trimmed_newtext;
  }

  if (markup) {
    ev->text_markup_type=kate_markup_simple;
  }
  else {
    ev->text_markup_type=kate_markup_none;
  }

  ev->text=newtext;
}

static void set_event_text_from(kd_event *ev,const char *source,int pre,int markup)
{
  FILE *f;
  char *text=NULL;
  char s[4096],*sret;

  f=fopen(source,"rt");
  if (!f) {
    yyerrorf("Failed to open file %s\n",source);
    exit(-1);
  }
  sret=fgets(s,sizeof(s),f);
  if (!sret) {
    yyerrorf("Failed to read from file %s\n",source);
    exit(-1);
  }
  while (!feof(f)) {
    /* This implicitely forbids embedded zeros - could this be a problem ? */
    text=catstrings(text,s);
    sret=fgets(s,sizeof(s),f);
    if (!sret) {
      yyerrorf("Failed to read from file %s\n",source);
      exit(-1);
    }
  }
  fclose(f);

  if (text) {
    set_event_text(ev,text,pre,markup);
    kate_free(text);
  }
}

static void set_event_t0_t1(kd_event *ev,kate_float t0,kate_float t1)
{
  if (ev->t0>=0) { yyerror("start time already set"); return; }
  if (ev->t1>=0) { yyerror("end time already set"); return; }
  ev->t0=t0;
  ev->t1=t1;
}

static void set_event_t0(kd_event *ev,kate_float v)
{
  if (ev->t0>=0) { yyerror("start time already set"); return; }
  ev->t0=v;
}

static void set_event_t1(kd_event *ev,kate_float v)
{
  if (ev->t1>=0) { yyerror("end time already set"); return; }
  ev->t1=v;
}

static void set_event_duration(kd_event *ev,kate_float v)
{
  if (ev->duration>=0) { yyerror("duration already set"); return; }
  ev->duration=v;
}

static void set_event_region_index(kd_event *ev,int r)
{
  int ret;
  if (ev->region_index>=0 || ev->region) { yyerror("region already set"); return; }
  ev->region_index=r;
  ret=kate_encode_set_region_index(&k,r);
  if (ret<0) yyerrorf("failed to set region index: %d",ret);
}

static void set_event_region(kd_event *ev,kate_region *kr)
{
  int ret;
  check_region(kr);
  if (ev->region_index>=0 || ev->region) { yyerror("region already set"); return; }
  ev->region=kr;
  ret=kate_encode_set_region(&k,kr);
  if (ret<0) yyerrorf("failed to set region: %d",ret);
}

static void set_event_style_index(kd_event *ev,int s)
{
  int ret;
  if (ev->style_index>=0 || ev->style) { yyerror("style already set"); return; }
  ev->style_index=s;
  ret=kate_encode_set_style_index(&k,s);
  if (ret<0) yyerrorf("failed to set style index: %d",ret);
}

static void set_event_secondary_style_index(kd_event *ev,int s)
{
  int ret;
  if (ev->secondary_style_index>=0 || ev->secondary_style) { yyerror("secondary style already set"); return; }
  ev->secondary_style_index=s;
  ret=kate_encode_set_secondary_style_index(&k,s);
  if (ret<0) yyerrorf("failed to set secondary style index: %d",ret);
}

static void set_event_style(kd_event *ev,kate_style *ks)
{
  int ret;
  check_style(ks);
  if (ev->style_index>=0 || ev->style) { yyerror("style already set"); return; }
  ev->style=ks;
  ret=kate_encode_set_style(&k,ks);
  if (ret<0) yyerrorf("failed to set style: %d",ret);
}

static void set_event_secondary_style(kd_event *ev,kate_style *ks)
{
  int ret;
  check_style(ks);
  if (ev->secondary_style_index>=0 || ev->secondary_style) { yyerror("secondary style already set"); return; }
  ev->secondary_style=ks;
  ret=kate_encode_set_secondary_style(&k,ks);
  if (ret<0) yyerrorf("failed to set secondary style: %d",ret);
}

static void set_event_palette_index(kd_event *ev,int p)
{
  int ret;
  if (ev->palette_index>=0 || ev->palette) { yyerror("palette already set"); return; }
  ev->palette_index=p;
  ret=kate_encode_set_palette_index(&k,p);
  if (ret<0) yyerrorf("failed to set palette index: %d",ret);
}

static void set_event_palette(kd_event *ev,kate_palette *kp)
{
  int ret;
  check_palette(kp);
  if (ev->palette_index>=0 || ev->palette) { yyerror("palette already set"); return; }
  ev->palette=kp;
  ret=kate_encode_set_palette(&k,kp);
  if (ret<0) yyerrorf("failed to set palette: %d",ret);
}

static void set_event_bitmap_index(kd_event *ev,int b)
{
  int ret;
  if (ev->bitmap_index>=0 || ev->bitmap) { yyerror("bitmap already set"); return; }
  ev->bitmap_index=b;
  ret=kate_encode_set_bitmap_index(&k,b);
  if (ret<0) yyerrorf("failed to set bitmap index: %d",ret);
}

static void set_event_bitmap(kd_event *ev,kate_bitmap *kb)
{
  int ret;
  check_bitmap(kb);
  if (ev->bitmap_index>=0 || ev->bitmap) { yyerror("bitmap already set"); return; }
  ev->bitmap=kb;
  ret=kate_encode_set_bitmap(&k,kb);
  if (ret<0) yyerrorf("failed to set bitmap: %d",ret);
}

static kd_event *check_event(kd_event *ev)
{
  /* we can set:
     start and end
     start and duration
     duration and end
     */
  int sets=0;
  if (ev->t0>=(kate_float)0.0) ++sets;
  if (ev->t1>=(kate_float)0.0) ++sets;
  if (ev->duration>=(kate_float)0.0) ++sets;
  if (sets<2) { yyerror("start/end times underspecified"); return NULL; }
  if (sets>2) { yyerror("start/end times overspecified"); return NULL; }

  if (ev->t0<(kate_float)0.0) ev->t0=ev->t1-ev->duration;
  if (ev->t1<(kate_float)0.0) ev->t1=ev->t0+ev->duration;

  return ev;
}

static void init_motion(void)
{
  kmotions=(kd_motion*)kate_realloc(kmotions,(nkmotions+1)*sizeof(kd_motion));
  if (!kmotions) { yyerror("out of memory"); exit(-1); }
  ++nkmotions;
  kmotions[nkmotions-1].idx=0;
  kmotions[nkmotions-1].motion=kate_malloc(sizeof(kate_motion));
  kmotion=kmotions[nkmotions-1].motion;
  if (!kmotion) { yyerror("out of memory"); exit(-1); }

  if (kate_motion_init(kmotion)<0) {
    yyerror("failed to init motion");
    exit(-1);
  }
  kmotion->semantics=(kate_motion_semantics)-1;
}

static void add_curve_to_motion(kate_motion *kmotion,kate_float duration)
{
  kmotion->ncurves++;
  kmotion->curves=(kate_curve**)kate_realloc(kmotion->curves,kmotion->ncurves*sizeof(kate_curve*));
  if (!kmotion->curves) { yyerror("out of memory"); exit(-1); }
  kmotion->durations=(kate_float*)kate_realloc(kmotion->durations,kmotion->ncurves*sizeof(kate_float));
  if (!kmotion->durations) { yyerror("out of memory"); exit(-1); }

  if (kcurve.curve) {
    check_curve(kcurve.curve);
    kmotion->curves[kmotion->ncurves-1]=kcurve.curve;
    kcurve.curve=NULL;
  }
  else {
    if (kcurve.idx>=ki.ncurves) {
      yyerror("Internal error: curve index out of range");
      exit(-1);
    }
    kmotion->curves[kmotion->ncurves-1]=ki.curves[kcurve.idx];
  }

  kmotion->durations[kmotion->ncurves-1]=duration;
}

static size_t get_num_glyphs(const char *text)
{
  size_t len0;
  size_t nglyphs=0;
  int intag=0,c;

  if (!text) { yyerror("Internal error: get_num_glyphs got NULL text"); exit(-1); }

  len0=strlen(text)+1;
  while ((c=kate_text_get_character(kate_utf8,&text,&len0))>0) {
    if (c=='<') intag++;
    if (!intag) ++nglyphs;
    if (c=='>') intag--;
  }
  return nglyphs;
}

static void init_simple_glyph_pointer_motion(void)
{
  init_motion();
  kmotion->semantics=kate_motion_semantics_glyph_pointer_1;
  karaoke_base_height=(kate_float)0;
  karaoke_top_height=(kate_float)0;
}

static int get_glyph_pointer_offset(unsigned int pointer_id)
{
  if (pointer_id<1 || pointer_id>4) {
    yyerrorf("Only glyph pointers 1-4 are available (trying to set %d)",pointer_id);
    exit(-1);
  }
  return (kate_motion_semantics)(kate_motion_semantics_glyph_pointer_1+pointer_id-1);
}

static kate_float get_last_glyph_x(const kate_motion *km)
{
  const kate_curve *kc;
  if (!km) { yyerror("internal error: no motion"); exit(-1); }
  if (km->ncurves==0) return (kate_float)-0.5; /* by default, center of the glyph before the first one (eg, marks nothing yet) */
  kc=km->curves[km->ncurves-1];
  if (kc->npts<1) yyerror("internal error: no points in last curve");
  return kc->pts[kc->npts*2-2]; /* -1 would be y */
}

static kate_float compute_karaoke_height(float y)
{
  /* turn height (bottom to top) to screen coordinates (top to bottom): negate */
  return -(karaoke_base_height*(1-y)+karaoke_top_height*y);
}

static void add_glyph_pause(kate_float dt,kate_float y)
{
  init_curve();
  kcurve.curve->type=kate_curve_static;
  kcurve.curve->npts=1;
  kcurve.curve->pts=(kate_float*)kate_malloc(kcurve.curve->npts*2*sizeof(kate_float));
  if (!kcurve.curve->pts) { yyerror("out of memory"); exit(-1); }
  kcurve.curve->pts[0]=get_last_glyph_x(kmotion);
  kcurve.curve->pts[1]=compute_karaoke_height(y);
  add_curve_to_motion(kmotion,dt);
}

static void add_glyph_transition(unsigned int glyph,kate_float dt,kate_float ystart,kate_float ytop,int absolute,kate_float pause_fraction)
{
  /* get the last glyph position and the new one */
  kate_float x0=get_last_glyph_x(kmotion);
  kate_float x1=glyph+(kate_float)0.5;
  size_t n;

  /* convert absolute to relative */
  if (absolute) {
    for (n=0;n<kmotion->ncurves;++n) dt-=kmotion->durations[n];
  }

  if (dt<(kate_float)0.0) {
    yyerrorf("duration (%f) must not be negative\n",dt);
    exit(-1);
  }

  /* add a pause before the next jump */
  if (pause_fraction>(kate_float)0.0) {
    kate_float delay=dt*pause_fraction;
    add_glyph_pause(delay,ystart);
    dt-=delay;
    if (dt<(kate_float)0.0) dt=(kate_float)0.0;
    x0=get_last_glyph_x(kmotion);
  }

  init_curve();

  if (dt==(kate_float)0.0) {
    /* if zero duration, just add static point at the end point */
    kcurve.curve->type=kate_curve_static;
    kcurve.curve->npts=1;
    kcurve.curve->pts=(kate_float*)kate_malloc(kcurve.curve->npts*2*sizeof(kate_float));
    if (!kcurve.curve->pts) { yyerror("out of memory"); exit(-1); }
    /* directly at the end position */
    kcurve.curve->pts[0]=x1;
    kcurve.curve->pts[1]=compute_karaoke_height(ystart);
  }
  else {
    kcurve.curve->type=kate_curve_catmull_rom_spline;
    kcurve.curve->npts=3+2; /* the two end points are duplicated */
    kcurve.curve->pts=(kate_float*)kate_malloc(kcurve.curve->npts*2*sizeof(kate_float));
    if (!kcurve.curve->pts) { yyerror("out of memory"); exit(-1); }

    /* start position */
    kcurve.curve->pts[0]=kcurve.curve->pts[2]=x0;
    kcurve.curve->pts[1]=kcurve.curve->pts[3]=compute_karaoke_height(ystart);

    /* the interpolated points */
    for (n=2;n<kcurve.curve->npts-2;++n) {
      kate_float t=(n-1)/(kate_float)(kcurve.curve->npts-2-1);
      kcurve.curve->pts[n*2]=kcurve.curve->pts[n*2+2]=x1*t+x0*((kate_float)1.0-t);
      kcurve.curve->pts[n*2+1]=kcurve.curve->pts[n*2+3]=compute_karaoke_height(ytop);
    }

    /* end position */
    kcurve.curve->pts[kcurve.curve->npts*2-4]=kcurve.curve->pts[kcurve.curve->npts*2-2]=x1;
    kcurve.curve->pts[kcurve.curve->npts*2-3]=kcurve.curve->pts[kcurve.curve->npts*2-1]=compute_karaoke_height(ystart);
  }

  add_curve_to_motion(kmotion,dt);
}

static void add_glyph_transition_to_text(const char *text,kate_float dt,kate_float ystart,kate_float ytop,int absolute,kate_float pause_fraction)
{
  char *newtext;

  if (!text) {
    yyerror("null text");
    return;
  }

  if (kevent.text) {
    char *text2=(char*)kate_realloc(kevent.text,strlen(kevent.text)+strlen(text)+1);
    if (!text2) {
      yyerror("out of memory");
      return;
    }
    strcat(text2,text);
    kevent.text=text2;
  }
  else {
    char *text2=(char*)kate_malloc(strlen(text)+1);
    if (!text2) {
      yyerror("out of memory");
      return;
    }
    strcpy(text2,text);
    kevent.text=text2;
  }

  backslash_n_to_newline(kevent.text);
  newtext=expand_numeric_entities(kevent.text);
  if (!newtext) return;
  kate_free(kevent.text);
  kevent.text=newtext;

  add_glyph_transition(get_num_glyphs(kevent.text)-1,dt,ystart,ytop,absolute,pause_fraction);
}

static void set_style_morph(kd_event *ev,int from,int to)
{
  int ret;

  if (!ev) {
    yyerror("internal error: no event");
    exit(-1);
  }
  if (from<0 || to<0) {
    yyerror("error: style index cannot be negative");
    exit(-1);
  }

  if (ev->style_index>=0 || ev->style) { yyerror("style already set"); return; }
  ev->style_index=from;
  ret=kate_encode_set_style_index(&k,from);
  if (ret<0) yyerrorf("failed to set style index: %d",ret);

  if (ev->secondary_style_index>=0 || ev->secondary_style) { yyerror("secondary style already set"); return; }
  ev->secondary_style_index=to;
  ret=kate_encode_set_secondary_style_index(&k,to);
  if (ret<0) yyerrorf("failed to set secondary_style index: %d",ret);
}

static void clear_local_bitmaps(void)
{
  size_t n;

  if (local_bitmap_names) {
    for (n=0;n<n_local_bitmaps;++n) {
      if (local_bitmap_names[n]) kate_free(local_bitmap_names[n]);
      if (local_bitmaps[n]) {
        kate_free(local_bitmaps[n]->pixels);
        kate_free(local_bitmaps[n]);
      }
    }
    kate_free(local_bitmap_names);
    local_bitmap_names=NULL;
    kate_free(local_bitmaps);
    local_bitmaps=NULL;
  }
  n_local_bitmaps=0;
}

static void clear_event(kd_event *ev)
{
  if (!ev) {
    yyerror("internal error: no event");
    exit(-1);
  }
  if (ev->text) {
    kate_free(ev->text);
    ev->text=NULL;
  }
  clear_motions();
  clear_local_bitmaps();
}

static void kd_finalize_simple_timed_glyph_motion(kate_motion *kmotion)
{
  const kd_event *ev=&kevent;
  kate_float duration=ev->duration;
  kate_float t0=ev->t0,t1=ev->t1;
  kate_float duration_so_far;
  size_t n;
  int sets;

  if (!kmotion) {
    yyerror("internal error: kd_finalize_simple_timed_glyph_motion passed NULL motion");
    exit(-1);
  }

  /* for this helper motion, we require the timing of the event to be known in advance */
  sets=0;
  if (t0>=(kate_float)0.0) ++sets;
  if (t1>=(kate_float)0.0) ++sets;
  if (duration>=(kate_float)0.0) ++sets;
  if (sets<2) { yyerror("start/end times must be specified before timed glyph marker motion setup"); return; }
  if (sets>2) { yyerror("start/end times overspecified"); return; }

  if (t0<(kate_float)0.0) t0=t1-duration;
  if (t1<(kate_float)0.0) t1=t0+duration;
  duration=t1-t0;

  /* add a pause to take us to the end time */
  duration_so_far=(kate_float)0.0;
  for (n=0;n<kmotion->ncurves;++n) duration_so_far+=kmotion->durations[n];
  if (duration_so_far>duration) {
    yyerrorf("Simple timed glyph motion lasts longer than its event (motion %f, event %f)",duration_so_far,duration);
    exit(-1);
  }
  add_glyph_pause(duration-duration_so_far,(kate_float)1.0);
}

static void set_motion_mapping(kate_motion *kmotion,kate_motion_mapping x_mapping,kate_motion_mapping y_mapping)
{
  if (!kmotion) {
    yyerror("internal error: set_motion_mapping passed NULL motion");
    exit(-1);
  }

  kmotion->x_mapping=x_mapping;
  kmotion->y_mapping=y_mapping;
}

static void set_motion_semantics(kate_motion *kmotion,kate_motion_semantics semantics)
{
  if (!kmotion) {
    yyerror("internal error: set_motion_semantics passed NULL motion");
    exit(-1);
  }

  if (kmotion->semantics!=(kate_motion_semantics)-1) { yyerror("semantics is already defined"); return; }
  kmotion->semantics=semantics;
}

static kate_motion_semantics kd_get_marker_position_semantics(int n)
{
  switch (n) {
    case 1: return kate_motion_semantics_marker1_position;
    case 2: return kate_motion_semantics_marker2_position;
    case 3: return kate_motion_semantics_marker3_position;
    case 4: return kate_motion_semantics_marker4_position;
    default: yyerrorf("Invalid marker number: %d (only 1-4 are supported)",n); exit(-1);
  }
  return kate_motion_semantics_marker4_position;
}

static kate_motion_semantics kd_get_marker_bitmap_semantics(int n)
{
  switch (n) {
    case 1: return kate_motion_semantics_marker1_bitmap;
    case 2: return kate_motion_semantics_marker2_bitmap;
    case 3: return kate_motion_semantics_marker3_bitmap;
    case 4: return kate_motion_semantics_marker4_bitmap;
    default: yyerrorf("Invalid marker number: %d (only 1-4 are supported)",n); exit(-1);
  }
  return kate_motion_semantics_marker4_bitmap;
}

static kate_motion_semantics kd_get_glyph_pointer_semantics(int n)
{
  switch (n) {
    case 1: return kate_motion_semantics_glyph_pointer_1;
    case 2: return kate_motion_semantics_glyph_pointer_2;
    case 3: return kate_motion_semantics_glyph_pointer_3;
    case 4: return kate_motion_semantics_glyph_pointer_4;
    default: yyerrorf("Invalid glyph pointer number: %d (only 1-4 are supported)",n); exit(-1);
  }
  return kate_motion_semantics_glyph_pointer_4;
}

static kate_motion_semantics kd_get_glyph_pointer_bitmap_semantics(int n)
{
  switch (n) {
    case 1: return kate_motion_semantics_glyph_pointer_1_bitmap;
    case 2: return kate_motion_semantics_glyph_pointer_2_bitmap;
    case 3: return kate_motion_semantics_glyph_pointer_3_bitmap;
    case 4: return kate_motion_semantics_glyph_pointer_4_bitmap;
    default: yyerrorf("Invalid glyph pointer number: %d (only 1-4 are supported)",n); exit(-1);
  }
  return kate_motion_semantics_glyph_pointer_4_bitmap;
}

static void kd_add_event_motion(kate_motion *kmotion)
{
  int ret;

  if (!kmotion) {
    yyerror("internal error: kd_add_event_motion passed NULL motion");
    exit(-1);
  }

  check_motion(kmotion);
  ret=kate_encode_add_motion(&k,kmotion,1);
  if (ret<0) {
    yyerrorf("failed to add motion: %d",ret);
    exit(-1);
  }
  clear_motions();
}

static void kd_add_event_motion_index(size_t idx)
{
  int ret;

  if (idx>=ki.nmotions) { yyerrorf("Motion index %u out of range (%u motions available)",idx,ki.nmotions); exit(-1); }

  ret=kate_encode_add_motion_index(&k,idx);
  if (ret<0) {
    yyerrorf("failed to add motion: %d",ret);
    exit(-1);
  }
  clear_motions();
}

static void init_font_range(void)
{
  krange=(kate_font_range*)kate_malloc(sizeof(kate_font_range));
  if (!krange) { yyerror("out of memory"); exit(-1); }
  krange->first_code_point=-1;
  krange->last_code_point=-1;
  krange->first_bitmap=-1;
}

static void set_font_range_code_point_string(int *cp,const char *s)
{
  size_t len0;
  int ret,c;

  if (!cp) { yyerror("internal error: no code point pointer"); exit(-1); }
  if (!s) { yyerror("internal error: no string"); exit(-1); }
  len0=strlen(s)+1;
  ret=kate_text_get_character(kate_utf8,&s,&len0);
  if (ret<0) {
    yyerrorf("failed to get character from string: %d",ret);
    return;
  }
  c=ret;
  ret=kate_text_get_character(kate_utf8,&s,&len0);
  if (ret<0) {
    yyerrorf("failed to get character from string: %d",ret);
    return;
  }
  if (ret) {
    yyerror("code point string should contain only one character");
    return;
  }
  *cp=c;
}

static void set_font_range_first_code_point_string(const char *s)
{
  if (!s) { yyerror("internal error: no string"); exit(-1); }
  if (!krange) { yyerror("internal error: no font range"); exit(-1); }
  set_font_range_code_point_string(&krange->first_code_point,s);
}

static void set_font_range_last_code_point_string(const char *s)
{
  if (!s) { yyerror("internal error: no string"); exit(-1); }
  if (!krange) { yyerror("internal error: no font range"); exit(-1); }
  set_font_range_code_point_string(&krange->last_code_point,s);
}

static void set_font_range_first_code_point(int idx)
{
  if (!krange) { yyerror("internal error: no font range"); exit(-1); }
  krange->first_code_point=idx;
}

static void set_font_range_last_code_point(int idx)
{
  if (!krange) { yyerror("internal error: no font range"); exit(-1); }
  krange->last_code_point=idx;
}

static void set_font_range_first_bitmap(int idx)
{
  if (!krange) { yyerror("internal error: no font range"); exit(-1); }
  krange->first_bitmap=idx;
}

static void add_font_range(kate_info *ki,const char *name,kate_font_range *kfr)
{
  int ret;
  if (!ki || !kfr) { yyerror("internal error: no kate_info or kate_font_range"); exit(-1); }
  if (!krange) { yyerror("internal error: no font range"); exit(-1); }
  if (krange->first_code_point<0) yyerror("first code point not set");
  if (krange->last_code_point<0) yyerror("last code point not set");
  if (krange->last_code_point<krange->first_code_point) yyerror("last code point cannnot be less than first code point");
  if (krange->first_bitmap<0) yyerror("bitmap index not set");
  ret=kate_info_add_font_range(ki,kfr);
  if (ret<0) {
    yyerrorf("failed to add font range: %d",ret);
  }
  else {
    font_range_names=(char**)kate_realloc(font_range_names,ki->nfont_ranges*sizeof(char*));
    if (!font_range_names) {
      yyerror("Out of memory");
      exit(-1);
    }
    font_range_names[ki->nfont_ranges-1]=name?dupstring(name):NULL;
  }
}

static int find_font_range(const kate_info *ki,const char *name)
{
  return find_item(name,ki->nfont_ranges,font_range_names);
}

static void init_font_mapping(void)
{
  kmapping=(kate_font_mapping*)kate_malloc(sizeof(kate_font_mapping));
  if (!kmapping) { yyerror("out of memory"); exit(-1); }
  kmapping->nranges=0;
  kmapping->ranges=NULL;
}

static int check_font_overlap(const kate_font_range *kfr0,const kate_font_range *kfr1)
{
  if (!kfr0 || !kfr1) return KATE_E_INVALID_PARAMETER;

  if (kfr0->last_code_point<kfr1->first_code_point) return 0;
  if (kfr1->last_code_point<kfr0->first_code_point) return 0;

  return KATE_E_INIT;
}

static int check_font_ranges(const kate_font_mapping *kfm)
{
  size_t n,l;

  if (!kfm) return KATE_E_INVALID_PARAMETER;

  for (n=0;n<kfm->nranges;++n) {
    const kate_font_range *kfr=kfm->ranges[n];
    if (!kfr) return KATE_E_INIT;
    if (kfr->last_code_point<kfr->first_code_point) return KATE_E_INIT;
    for (l=n+1;l<kfm->nranges;++l) {
      int ret=check_font_overlap(kfr,kfm->ranges[l]);
      if (ret<0) return ret;
    }
  }

  return 0;
}

static void add_font_range_to_mapping(void)
{
  int ret;

  if (!krange) { yyerror("internal error: no font range"); exit(-1); }
  if (!kmapping) { yyerror("internal error: no font mapping"); exit(-1); }

  kmapping->ranges=(kate_font_range**)kate_realloc(kmapping->ranges,(kmapping->nranges+1)*sizeof(kate_font_range*));
  if (!kmapping->ranges) {
    yyerror("error: out of memory");
    exit(-1);
  }
  kmapping->ranges[kmapping->nranges]=krange;
  ++kmapping->nranges;

  ret=check_font_ranges(kmapping);
  if (ret<0) yyerror("font mapping ranges overlap");

  krange=NULL;
}

static void add_font_mapping(kate_info *ki,const char *name,kate_font_mapping *kfm)
{
  int ret;
  if (!ki) { yyerror("internal error: no kate_info"); exit(-1); }
  if (!kfm) { yyerror("internal error: no font mapping"); exit(-1); }
  if (kfm->nranges==0) yyerror("font mapping has no ranges");
  ret=kate_info_add_font_mapping(ki,kfm);
  if (ret<0) {
    yyerrorf("failed to add font mapping: %d",ret);
  }
  else {
    font_mapping_names=(char**)kate_realloc(font_mapping_names,ki->nfont_mappings*sizeof(char*));
    if (!font_mapping_names) {
      yyerror("Out of memory");
      exit(-1);
    }
    font_mapping_names[ki->nfont_mappings-1]=name?dupstring(name):NULL;
  }
}

static int find_font_mapping(const kate_info *ki,const char *name)
{
  return find_item(name,ki->nfont_mappings,font_mapping_names);
}

static void kd_write_headers(void)
{
  int ret=write_headers(katedesc_out);
  if (ret<0) {
    yyerrorf("Failed to write headers: %d\n",ret);
    exit(-1);
  }
}

static void kd_encode_text(kate_state *kstate,kd_event *ev)
{
  int ret;
  ogg_packet op;

  if (!ev) { yyerror("internal error: no event"); exit(-1); }
  ret=kate_encode_set_markup_type(kstate,ev->text_markup_type);
  if (ret<0) {
    yyerrorf("failed to set text markup type: %d",ret);
    return;
  }
  update_stream_time(kstate,katedesc_out,timebase+ev->t0);
  ret=kate_ogg_encode_text(kstate,timebase+ev->t0,timebase+ev->t1,ev->text?ev->text:"",ev->text?strlen(ev->text):0,&op);
  if (ret<0) {
    yyerrorf("failed to encode text %s: %d",ev->text?ev->text:"<none>",ret);
    return;
  }
  ret=send_packet(katedesc_out,&op,timebase+ev->t0);
  if (ret<0) {
    yyerrorf("failed to send text packet: %d",ret);
  }
}

static void kd_encode_set_language(kate_state *kstate,const char *s)
{
  int ret;
  if (!s) { yyerror("internal error: no language string"); exit(-1); }
  ret=kate_encode_set_language(kstate,s);
  if (ret<0) yyerrorf("failed to set event language override: %d",ret);
}

static uint32_t make_color(uint32_t r,uint32_t g,uint32_t b,uint32_t a)
{
  return (r<<24)|(g<<16)|(b<<8)|a;
}

static uint32_t make_color_alpha(uint32_t c,uint32_t a)
{
  return (c&0xffffff00)|a;
}

static void record_macro_name(const char *name)
{
  size_t len;
  if (!name) { yyerror("internal error: no macro name"); exit(-1); }
  len=strlen(name);
  if (temp_macro_name) kate_free(temp_macro_name);
  temp_macro_name=kate_malloc(len+1);
  if (!temp_macro_name) { yyerror("out of memory"); exit(-1); }
  strcpy(temp_macro_name,name);
}

static void add_temp_macro(const char *body)
{
  if (!body) { yyerror("internal error: no macro body"); exit(-1); }
  if (!temp_macro_name) { yyerror("internal error - unknown macro name"); return; }
  add_macro(temp_macro_name,body);
  kate_free(temp_macro_name);
  temp_macro_name=NULL;
}

static void set_granule_rate(unsigned int numerator,unsigned int denominator)
{
  ki.gps_numerator=numerator;
  ki.gps_denominator=denominator;
}

static void set_granule_shift(unsigned int granule_shift)
{
  if (granule_shift>=64) yyerror("granule shift out of range (0-64)\n");
  ki.granule_shift=granule_shift;
}

static void set_canvas_size(unsigned int width,unsigned int height)
{
  int ret=kate_info_set_original_canvas_size(&ki,width,height);
  if (ret<0) {
    yyerror("failed to set original canvas size");
    exit(-1);
  }
}

static void add_comment(kate_comment *kc,const char *s)
{
  /* check for "ENCODER=," as kateenc now sets it and we don't want cycles
     of decode/encode to duplicate them, and we want the new one to replace
     any existing one */
  int different=0;
  const char *encoder="ENCODER=",*sptr=s;
  while (*encoder) if ((*encoder++|32)!=(*sptr++|32)) {
    different=1;
    break;
  }
  if (different) {
    CHECK_KATE_API_ERROR(kate_comment_add(kc,s));
  }
}

static void cleanup_names(char **names,size_t count)
{
  size_t n;
  if (names) {
    for (n=0;n<count;++n) if (names[n]) kate_free(names[n]);
    kate_free(names);
  }
}

static void cleanup_memory(void)
{
  cleanup_names(style_names,ki.nstyles);
  cleanup_names(region_names,ki.nregions);
  cleanup_names(curve_names,ki.ncurves);
  cleanup_names(motion_names,ki.nmotions);
  cleanup_names(bitmap_names,ki.nbitmaps);
  cleanup_names(palette_names,ki.npalettes);
  cleanup_names(font_range_names,ki.nfont_ranges);
  cleanup_names(font_mapping_names,ki.nfont_mappings);
  cleanup_names(local_bitmap_names,n_local_bitmaps);

  free_macros();
}




/* Line 189 of yacc.c  */
#line 2186 "kate_parser.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     KATE = 258,
     DEFS = 259,
     LANGUAGE = 260,
     COMMENT = 261,
     CATEGORY = 262,
     DEFINE = 263,
     MACRO = 264,
     STYLE = 265,
     REGION = 266,
     CURVE = 267,
     TEXT = 268,
     BACKGROUND = 269,
     COLOR = 270,
     POSITION = 271,
     SIZE = 272,
     DEFAULT = 273,
     METRIC = 274,
     HALIGN = 275,
     VALIGN = 276,
     HLEFT = 277,
     HCENTER = 278,
     HRIGHT = 279,
     VTOP = 280,
     VCENTER = 281,
     VBOTTOM = 282,
     POINTS = 283,
     EVENT = 284,
     STARTS = 285,
     ENDS = 286,
     AT = 287,
     START = 288,
     END = 289,
     TIME = 290,
     DURATION = 291,
     ARROW = 292,
     FROM = 293,
     TO = 294,
     MAPPING = 295,
     NONE = 296,
     FRAME = 297,
     MOTION = 298,
     BEZIER_CUBIC = 299,
     LINEAR = 300,
     CATMULL_ROM = 301,
     BSPLINE = 302,
     STATIC = 303,
     SEMANTICS = 304,
     EXTERNAL = 305,
     INTERNAL = 306,
     ALIGNMENT = 307,
     RG = 308,
     BA = 309,
     FOR = 310,
     ALPHA = 311,
     TIMEBASE = 312,
     MARKER = 313,
     POINTER = 314,
     SIMPLE_TIMED_GLYPH_MARKER = 315,
     SIMPLE_TIMED_GLYPH_STYLE_MORPH = 316,
     GLYPH = 317,
     PAUSE = 318,
     IN = 319,
     MORPH = 320,
     SECONDARY = 321,
     PATH = 322,
     SECTION = 323,
     PERIODIC = 324,
     DIRECTIONALITY = 325,
     L2R_T2B = 326,
     R2L_T2B = 327,
     T2B_R2L = 328,
     T2B_L2R = 329,
     BITMAP = 330,
     PALETTE = 331,
     COLORS = 332,
     FONT = 333,
     RANGE = 334,
     FIRST = 335,
     LAST = 336,
     CODE = 337,
     POINT = 338,
     USER = 339,
     SOURCE = 340,
     PNG = 341,
     DRAW = 342,
     VISIBLE = 343,
     ID = 344,
     BOLD = 345,
     ITALICS = 346,
     UNDERLINE = 347,
     STRIKE = 348,
     JUSTIFY = 349,
     BASE = 350,
     OFFSET = 351,
     GRANULE = 352,
     RATE = 353,
     SHIFT = 354,
     WIDTH = 355,
     HEIGHT = 356,
     CANVAS = 357,
     LEFT = 358,
     TOP = 359,
     RIGHT = 360,
     BOTTOM = 361,
     MARGIN = 362,
     MARGINS = 363,
     HORIZONTAL = 364,
     VERTICAL = 365,
     CLIP = 366,
     PRE = 367,
     MARKUP = 368,
     LOCAL = 369,
     WRAP = 370,
     WORD = 371,
     NUMBER = 372,
     UNUMBER = 373,
     STRING = 374,
     FLOAT = 375,
     COLORSPEC = 376,
     IDENTIFIER = 377,
     MACRO_BODY = 378
   };
#endif
/* Tokens.  */
#define KATE 258
#define DEFS 259
#define LANGUAGE 260
#define COMMENT 261
#define CATEGORY 262
#define DEFINE 263
#define MACRO 264
#define STYLE 265
#define REGION 266
#define CURVE 267
#define TEXT 268
#define BACKGROUND 269
#define COLOR 270
#define POSITION 271
#define SIZE 272
#define DEFAULT 273
#define METRIC 274
#define HALIGN 275
#define VALIGN 276
#define HLEFT 277
#define HCENTER 278
#define HRIGHT 279
#define VTOP 280
#define VCENTER 281
#define VBOTTOM 282
#define POINTS 283
#define EVENT 284
#define STARTS 285
#define ENDS 286
#define AT 287
#define START 288
#define END 289
#define TIME 290
#define DURATION 291
#define ARROW 292
#define FROM 293
#define TO 294
#define MAPPING 295
#define NONE 296
#define FRAME 297
#define MOTION 298
#define BEZIER_CUBIC 299
#define LINEAR 300
#define CATMULL_ROM 301
#define BSPLINE 302
#define STATIC 303
#define SEMANTICS 304
#define EXTERNAL 305
#define INTERNAL 306
#define ALIGNMENT 307
#define RG 308
#define BA 309
#define FOR 310
#define ALPHA 311
#define TIMEBASE 312
#define MARKER 313
#define POINTER 314
#define SIMPLE_TIMED_GLYPH_MARKER 315
#define SIMPLE_TIMED_GLYPH_STYLE_MORPH 316
#define GLYPH 317
#define PAUSE 318
#define IN 319
#define MORPH 320
#define SECONDARY 321
#define PATH 322
#define SECTION 323
#define PERIODIC 324
#define DIRECTIONALITY 325
#define L2R_T2B 326
#define R2L_T2B 327
#define T2B_R2L 328
#define T2B_L2R 329
#define BITMAP 330
#define PALETTE 331
#define COLORS 332
#define FONT 333
#define RANGE 334
#define FIRST 335
#define LAST 336
#define CODE 337
#define POINT 338
#define USER 339
#define SOURCE 340
#define PNG 341
#define DRAW 342
#define VISIBLE 343
#define ID 344
#define BOLD 345
#define ITALICS 346
#define UNDERLINE 347
#define STRIKE 348
#define JUSTIFY 349
#define BASE 350
#define OFFSET 351
#define GRANULE 352
#define RATE 353
#define SHIFT 354
#define WIDTH 355
#define HEIGHT 356
#define CANVAS 357
#define LEFT 358
#define TOP 359
#define RIGHT 360
#define BOTTOM 361
#define MARGIN 362
#define MARGINS 363
#define HORIZONTAL 364
#define VERTICAL 365
#define CLIP 366
#define PRE 367
#define MARKUP 368
#define LOCAL 369
#define WRAP 370
#define WORD 371
#define NUMBER 372
#define UNUMBER 373
#define STRING 374
#define FLOAT 375
#define COLORSPEC 376
#define IDENTIFIER 377
#define MACRO_BODY 378




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 2116 "kate_parser.y"

  int number;
  unsigned int unumber;
  kate_float fp;
  const char *string;
  char *dynstring;
  kate_style *style;
  kate_region *region;
  kate_curve *curve;
  uint32_t color;



/* Line 214 of yacc.c  */
#line 2482 "kate_parser.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 2494 "kate_parser.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   595

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  136
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  94
/* YYNRULES -- Number of rules.  */
#define YYNRULES  294
/* YYNRULES -- Number of states.  */
#define YYNSTATES  549

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   378

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   127,     2,     2,
       2,     2,     2,   132,   135,     2,     2,   126,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   130,     2,
       2,   131,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,   134,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,   128,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     129,     2,   133,   124,     2,   125,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     4,     5,    13,    18,    19,    22,    23,
      26,    29,    32,    35,    36,    37,    44,    45,    53,    54,
      62,    63,    71,    72,    80,    81,    89,    90,    98,    99,
     108,   109,   118,   121,   127,   131,   136,   139,   140,   143,
     146,   148,   150,   152,   154,   156,   158,   162,   166,   170,
     172,   174,   176,   178,   180,   183,   186,   191,   196,   201,
     206,   211,   216,   221,   231,   233,   235,   236,   239,   240,
     242,   246,   250,   252,   256,   259,   260,   262,   263,   270,
     271,   277,   280,   281,   282,   289,   292,   295,   296,   297,
     307,   308,   318,   321,   325,   329,   333,   338,   340,   344,
     346,   348,   350,   352,   354,   356,   358,   360,   363,   364,
     370,   371,   375,   376,   380,   381,   383,   384,   386,   388,
     390,   392,   394,   396,   398,   400,   402,   404,   406,   408,
     410,   412,   414,   416,   418,   419,   424,   425,   431,   433,
     435,   437,   439,   441,   444,   446,   448,   451,   457,   461,
     463,   466,   467,   468,   474,   475,   479,   482,   483,   486,
     489,   492,   496,   500,   504,   508,   513,   516,   521,   525,
     528,   529,   536,   537,   543,   547,   548,   556,   557,   564,
     567,   571,   574,   578,   582,   587,   591,   596,   598,   599,
     605,   608,   609,   615,   616,   622,   626,   629,   630,   636,
     639,   640,   646,   647,   656,   663,   665,   666,   670,   672,
     675,   676,   679,   683,   686,   690,   692,   695,   699,   703,
     704,   706,   708,   710,   713,   716,   719,   721,   724,   727,
     730,   734,   738,   741,   744,   748,   752,   756,   760,   764,
     768,   772,   776,   779,   782,   786,   788,   791,   793,   796,
     799,   802,   805,   809,   814,   817,   820,   823,   824,   828,
     832,   838,   842,   847,   852,   855,   856,   860,   867,   871,
     876,   881,   885,   889,   890,   893,   894,   897,   899,   900,
     902,   904,   906,   908,   911,   912,   917,   922,   927,   932,
     936,   939,   940,   941,   947
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     137,     0,    -1,    -1,    -1,   138,     3,   124,   140,   139,
     192,   125,    -1,     4,   124,   141,   125,    -1,    -1,   141,
     142,    -1,    -1,     5,   119,    -1,     7,   119,    -1,    70,
     224,    -1,     6,   119,    -1,    -1,    -1,     8,     9,   143,
     122,   144,   123,    -1,    -1,     8,    10,   176,   145,   124,
     153,   125,    -1,    -1,     8,    11,   176,   146,   124,   156,
     125,    -1,    -1,     8,    12,   176,   147,   124,   158,   125,
      -1,    -1,     8,    43,   176,   148,   124,   210,   125,    -1,
      -1,     8,    76,   176,   149,   124,   162,   125,    -1,    -1,
       8,    75,   176,   150,   124,   165,   125,    -1,    -1,     8,
      78,    79,   176,   151,   124,   225,   125,    -1,    -1,     8,
      78,    40,   176,   152,   124,   227,   125,    -1,    57,   191,
      -1,    97,    98,   118,   126,   118,    -1,    97,    99,   118,
      -1,   102,    17,   118,   118,    -1,   153,   154,    -1,    -1,
      20,   188,    -1,    21,   188,    -1,    22,    -1,    23,    -1,
      24,    -1,    25,    -1,    26,    -1,    27,    -1,    13,    15,
     169,    -1,    14,    15,   169,    -1,    87,    15,   169,    -1,
      90,    -1,    91,    -1,    92,    -1,    93,    -1,    94,    -1,
     115,   170,    -1,    78,   119,    -1,    78,    17,   188,   155,
      -1,    78,   100,   188,   155,    -1,    78,   101,   188,   155,
      -1,   103,   107,   188,   155,    -1,   104,   107,   188,   155,
      -1,   105,   107,   188,   155,    -1,   106,   107,   188,   155,
      -1,   108,   188,   155,   188,   155,   188,   155,   188,   155,
      -1,   127,    -1,   128,    -1,    -1,   156,   157,    -1,    -1,
      19,    -1,    16,   188,   188,    -1,    17,   188,   188,    -1,
     111,    -1,    18,    10,   177,    -1,   158,   159,    -1,    -1,
     171,    -1,    -1,   118,    28,   160,   124,   172,   125,    -1,
      -1,    28,   161,   124,   172,   125,    -1,   162,   163,    -1,
      -1,    -1,   118,    77,   164,   124,   173,   125,    -1,    85,
     119,    -1,   165,   166,    -1,    -1,    -1,   118,   129,   118,
     129,   118,   167,   124,   174,   125,    -1,    -1,   118,   129,
     118,    86,   118,   168,   124,   175,   125,    -1,    85,   119,
      -1,    18,    76,   181,    -1,    96,   189,   190,    -1,   118,
     118,   118,    -1,   118,   118,   118,   118,    -1,   121,    -1,
     121,    56,   118,    -1,    41,    -1,   116,    -1,    41,    -1,
      48,    -1,    45,    -1,    46,    -1,    44,    -1,    47,    -1,
     172,   188,    -1,    -1,   173,   124,   169,   125,   223,    -1,
      -1,   174,   118,   223,    -1,    -1,   175,   118,   223,    -1,
      -1,   119,    -1,    -1,   119,    -1,   118,    -1,   119,    -1,
     118,    -1,   119,    -1,   118,    -1,   119,    -1,   118,    -1,
     119,    -1,   118,    -1,   119,    -1,   118,    -1,   119,    -1,
     118,    -1,   119,    -1,   118,    -1,   179,    -1,    -1,   186,
     124,   158,   125,    -1,    -1,   179,   187,   124,   158,   125,
      -1,   120,    -1,   118,    -1,   117,    -1,   118,    -1,   117,
      -1,   188,   127,    -1,   118,    -1,   117,    -1,   188,   127,
      -1,   118,   130,   219,   130,   221,    -1,   118,   130,   221,
      -1,   221,    -1,   192,   193,    -1,    -1,    -1,    29,   194,
     124,   196,   125,    -1,    -1,    29,   195,   196,    -1,   196,
     197,    -1,    -1,    89,   118,    -1,     5,   119,    -1,    70,
     224,    -1,    30,    32,   191,    -1,    31,    32,   191,    -1,
      33,    35,   191,    -1,    34,    35,   191,    -1,    38,   191,
      39,   191,    -1,    36,   191,    -1,    38,   191,    55,   191,
      -1,   191,    37,   191,    -1,    11,   178,    -1,    -1,    11,
     178,   198,   124,   156,   125,    -1,    -1,    11,   199,   124,
     156,   125,    -1,   208,    10,   177,    -1,    -1,   208,    10,
     177,   200,   124,   153,   125,    -1,    -1,   208,    10,   201,
     124,   153,   125,    -1,    13,   209,    -1,   112,    13,   209,
      -1,   113,   209,    -1,   112,   113,   209,    -1,    13,    85,
     119,    -1,   112,    13,    85,   119,    -1,   113,    85,   119,
      -1,   112,   113,    85,   119,    -1,   209,    -1,    -1,    43,
     202,   124,   210,   125,    -1,    43,   180,    -1,    -1,    60,
     203,   124,   215,   125,    -1,    -1,    61,   204,   124,   217,
     125,    -1,    78,    40,   184,    -1,    76,   181,    -1,    -1,
      76,   205,   124,   162,   125,    -1,    75,   182,    -1,    -1,
      75,   206,   124,   165,   125,    -1,    -1,     8,   114,    75,
     176,   207,   124,   165,   125,    -1,     8,   114,    75,   176,
     131,   182,    -1,    66,    -1,    -1,   209,   132,   119,    -1,
     119,    -1,   210,   211,    -1,    -1,    40,   213,    -1,    40,
     213,   213,    -1,    49,   214,    -1,    12,   185,   212,    -1,
      69,    -1,    55,   188,    -1,    55,   188,   127,    -1,    55,
     188,   128,    -1,    -1,    41,    -1,    42,    -1,    11,    -1,
      29,    36,    -1,    75,    17,    -1,    84,   118,    -1,    35,
      -1,    11,    16,    -1,    11,    17,    -1,    13,    52,    -1,
      51,    13,    52,    -1,    50,    13,    52,    -1,    13,    16,
      -1,    13,    17,    -1,    58,   118,    16,    -1,    62,    59,
     118,    -1,    13,    15,    53,    -1,    13,    15,    54,    -1,
      14,    15,    53,    -1,    14,    15,    54,    -1,    87,    15,
      53,    -1,    87,    15,    54,    -1,    10,    65,    -1,    13,
      67,    -1,    13,    67,    68,    -1,    87,    -1,    88,    68,
      -1,   133,    -1,   109,   108,    -1,   110,   108,    -1,    75,
      16,    -1,    75,    17,    -1,    58,   118,    75,    -1,    62,
      59,   118,    75,    -1,    87,   100,    -1,    84,   118,    -1,
     215,   216,    -1,    -1,    62,    59,   118,    -1,   134,    40,
     213,    -1,   101,    38,   188,    39,   188,    -1,    63,    55,
     191,    -1,    62,   118,    64,   191,    -1,    62,   118,    32,
     191,    -1,   217,   218,    -1,    -1,    62,    59,   118,    -1,
      38,    10,   177,    39,    10,   177,    -1,    63,    55,   191,
      -1,    62,   118,    64,   191,    -1,    62,   118,    32,   191,
      -1,   119,    64,   191,    -1,   119,    32,   191,    -1,    -1,
     118,   220,    -1,    -1,   188,   222,    -1,   135,    -1,    -1,
      71,    -1,    72,    -1,    73,    -1,    74,    -1,   225,   226,
      -1,    -1,    80,    82,    83,   119,    -1,    80,    82,    83,
     118,    -1,    81,    82,    83,   119,    -1,    81,    82,    83,
     118,    -1,    80,    75,   182,    -1,   227,   228,    -1,    -1,
      -1,    79,   229,   124,   225,   125,    -1,    79,   183,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  2201,  2201,  2201,  2201,  2204,  2205,  2208,  2209,  2212,
    2213,  2214,  2215,  2216,  2216,  2216,  2218,  2218,  2219,  2219,
    2220,  2220,  2221,  2221,  2222,  2222,  2223,  2223,  2224,  2224,
    2225,  2225,  2226,  2227,  2228,  2229,  2232,  2233,  2236,  2237,
    2238,  2239,  2240,  2241,  2242,  2243,  2244,  2245,  2246,  2247,
    2248,  2249,  2250,  2251,  2252,  2253,  2254,  2255,  2256,  2257,
    2258,  2259,  2260,  2261,  2265,  2266,  2267,  2270,  2271,  2274,
    2275,  2276,  2277,  2278,  2281,  2282,  2285,  2286,  2286,  2289,
    2289,  2292,  2293,  2296,  2296,  2301,  2304,  2305,  2308,  2308,
    2313,  2313,  2318,  2319,  2320,  2323,  2324,  2325,  2326,  2329,
    2330,  2333,  2334,  2335,  2336,  2337,  2338,  2341,  2350,  2353,
    2357,  2360,  2373,  2376,  2384,  2387,  2388,  2391,  2392,  2395,
    2396,  2399,  2400,  2403,  2404,  2407,  2408,  2411,  2412,  2415,
    2416,  2419,  2420,  2423,  2424,  2424,  2425,  2425,  2429,  2430,
    2431,  2434,  2435,  2436,  2439,  2440,  2441,  2444,  2445,  2446,
    2449,  2450,  2453,  2453,  2456,  2456,  2461,  2462,  2465,  2466,
    2467,  2468,  2469,  2470,  2471,  2472,  2473,  2474,  2475,  2476,
    2477,  2477,  2479,  2479,  2480,  2482,  2482,  2484,  2484,  2486,
    2487,  2488,  2489,  2490,  2491,  2492,  2493,  2494,  2495,  2495,
    2496,  2497,  2497,  2499,  2499,  2501,  2502,  2503,  2503,  2504,
    2505,  2505,  2506,  2506,  2507,  2510,  2511,  2514,  2515,  2518,
    2519,  2522,  2523,  2524,  2525,  2526,  2529,  2530,  2531,  2532,
    2535,  2536,  2537,  2538,  2539,  2540,  2546,  2547,  2548,  2549,
    2550,  2551,  2552,  2553,  2554,  2555,  2556,  2557,  2558,  2559,
    2560,  2561,  2562,  2563,  2564,  2565,  2566,  2567,  2568,  2569,
    2570,  2571,  2572,  2573,  2574,  2575,  2581,  2582,  2585,  2586,
    2587,  2588,  2589,  2590,  2593,  2594,  2597,  2598,  2600,  2601,
    2602,  2603,  2604,  2607,  2607,  2610,  2610,  2613,  2614,  2617,
    2618,  2619,  2620,  2623,  2624,  2627,  2628,  2629,  2630,  2631,
    2634,  2635,  2638,  2638,  2639
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "KATE", "DEFS", "LANGUAGE", "COMMENT",
  "CATEGORY", "DEFINE", "MACRO", "STYLE", "REGION", "CURVE", "TEXT",
  "BACKGROUND", "COLOR", "POSITION", "SIZE", "DEFAULT", "METRIC", "HALIGN",
  "VALIGN", "HLEFT", "HCENTER", "HRIGHT", "VTOP", "VCENTER", "VBOTTOM",
  "POINTS", "EVENT", "STARTS", "ENDS", "AT", "START", "END", "TIME",
  "DURATION", "ARROW", "FROM", "TO", "MAPPING", "NONE", "FRAME", "MOTION",
  "BEZIER_CUBIC", "LINEAR", "CATMULL_ROM", "BSPLINE", "STATIC",
  "SEMANTICS", "EXTERNAL", "INTERNAL", "ALIGNMENT", "RG", "BA", "FOR",
  "ALPHA", "TIMEBASE", "MARKER", "POINTER", "SIMPLE_TIMED_GLYPH_MARKER",
  "SIMPLE_TIMED_GLYPH_STYLE_MORPH", "GLYPH", "PAUSE", "IN", "MORPH",
  "SECONDARY", "PATH", "SECTION", "PERIODIC", "DIRECTIONALITY", "L2R_T2B",
  "R2L_T2B", "T2B_R2L", "T2B_L2R", "BITMAP", "PALETTE", "COLORS", "FONT",
  "RANGE", "FIRST", "LAST", "CODE", "POINT", "USER", "SOURCE", "PNG",
  "DRAW", "VISIBLE", "ID", "BOLD", "ITALICS", "UNDERLINE", "STRIKE",
  "JUSTIFY", "BASE", "OFFSET", "GRANULE", "RATE", "SHIFT", "WIDTH",
  "HEIGHT", "CANVAS", "LEFT", "TOP", "RIGHT", "BOTTOM", "MARGIN",
  "MARGINS", "HORIZONTAL", "VERTICAL", "CLIP", "PRE", "MARKUP", "LOCAL",
  "WRAP", "WORD", "NUMBER", "UNUMBER", "STRING", "FLOAT", "COLORSPEC",
  "IDENTIFIER", "MACRO_BODY", "'{'", "'}'", "'/'", "'%'", "'m'", "'x'",
  "':'", "'='", "'+'", "'z'", "'Y'", "','", "$accept", "kd_kate", "$@1",
  "$@2", "kd_opt_defs", "kd_defs", "kd_def", "$@3", "$@4", "$@5", "$@6",
  "$@7", "$@8", "$@9", "$@10", "$@11", "$@12", "kd_style_defs",
  "kd_style_def", "kd_opt_space_metric", "kd_region_defs", "kd_region_def",
  "kd_curve_defs", "kd_curve_def", "$@13", "$@14", "kd_palette_defs",
  "kd_palette_def", "$@15", "kd_bitmap_defs", "kd_bitmap_def", "$@16",
  "$@17", "kd_color", "kd_wrap_mode", "kd_curvetype", "kd_curve_points",
  "kd_palette_colors", "kd_bitmap_pixels", "kd_png_bitmap_pixels",
  "kd_opt_name", "kd_style_name_or_index", "kd_region_name_or_index",
  "kd_curve_name_or_index", "kd_motion_name_or_index",
  "kd_palette_name_or_index", "kd_bitmap_name_or_index",
  "kd_font_range_name_or_index", "kd_font_mapping_name_or_index",
  "kd_curve_def_name_or_index", "$@18", "$@19", "float", "bitmap_x_offset",
  "bitmap_y_offset", "timespec", "kd_events", "kd_event", "$@20", "$@21",
  "kd_event_defs", "kd_event_def", "$@22", "$@23", "$@24", "$@25", "$@26",
  "$@27", "$@28", "$@29", "$@30", "$@31", "kd_optional_secondary",
  "strings", "kd_motion_defs", "kd_motion_def",
  "kd_optional_curve_duration", "kd_motion_mapping", "kd_motion_semantics",
  "kd_simple_timed_glyph_marker_defs", "kd_simple_timed_glyph_marker_def",
  "kd_simple_timed_glyph_style_morph_defs",
  "kd_simple_timed_glyph_style_morph_def", "unumber60", "$@32", "float60",
  "$@33", "kd_opt_comma", "directionality", "kd_font_range_defs",
  "kd_font_range_def", "kd_font_mapping_defs", "kd_font_mapping_def",
  "$@34", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   123,   125,    47,    37,   109,   120,
      58,    61,    43,   122,    89,    44
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,   136,   138,   139,   137,   140,   140,   141,   141,   142,
     142,   142,   142,   143,   144,   142,   145,   142,   146,   142,
     147,   142,   148,   142,   149,   142,   150,   142,   151,   142,
     152,   142,   142,   142,   142,   142,   153,   153,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   155,   155,   155,   156,   156,   157,
     157,   157,   157,   157,   158,   158,   159,   160,   159,   161,
     159,   162,   162,   164,   163,   163,   165,   165,   167,   166,
     168,   166,   166,   166,   166,   169,   169,   169,   169,   170,
     170,   171,   171,   171,   171,   171,   171,   172,   172,   173,
     173,   174,   174,   175,   175,   176,   176,   177,   177,   178,
     178,   179,   179,   180,   180,   181,   181,   182,   182,   183,
     183,   184,   184,   185,   186,   185,   187,   185,   188,   188,
     188,   189,   189,   189,   190,   190,   190,   191,   191,   191,
     192,   192,   194,   193,   195,   193,   196,   196,   197,   197,
     197,   197,   197,   197,   197,   197,   197,   197,   197,   197,
     198,   197,   199,   197,   197,   200,   197,   201,   197,   197,
     197,   197,   197,   197,   197,   197,   197,   197,   202,   197,
     197,   203,   197,   204,   197,   197,   197,   205,   197,   197,
     206,   197,   207,   197,   197,   208,   208,   209,   209,   210,
     210,   211,   211,   211,   211,   211,   212,   212,   212,   212,
     213,   213,   213,   213,   213,   213,   214,   214,   214,   214,
     214,   214,   214,   214,   214,   214,   214,   214,   214,   214,
     214,   214,   214,   214,   214,   214,   214,   214,   214,   214,
     214,   214,   214,   214,   214,   214,   215,   215,   216,   216,
     216,   216,   216,   216,   217,   217,   218,   218,   218,   218,
     218,   218,   218,   220,   219,   222,   221,   223,   223,   224,
     224,   224,   224,   225,   225,   226,   226,   226,   226,   226,
     227,   227,   229,   228,   228
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     0,     7,     4,     0,     2,     0,     2,
       2,     2,     2,     0,     0,     6,     0,     7,     0,     7,
       0,     7,     0,     7,     0,     7,     0,     7,     0,     8,
       0,     8,     2,     5,     3,     4,     2,     0,     2,     2,
       1,     1,     1,     1,     1,     1,     3,     3,     3,     1,
       1,     1,     1,     1,     2,     2,     4,     4,     4,     4,
       4,     4,     4,     9,     1,     1,     0,     2,     0,     1,
       3,     3,     1,     3,     2,     0,     1,     0,     6,     0,
       5,     2,     0,     0,     6,     2,     2,     0,     0,     9,
       0,     9,     2,     3,     3,     3,     4,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     5,
       0,     3,     0,     3,     0,     1,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     4,     0,     5,     1,     1,
       1,     1,     1,     2,     1,     1,     2,     5,     3,     1,
       2,     0,     0,     5,     0,     3,     2,     0,     2,     2,
       2,     3,     3,     3,     3,     4,     2,     4,     3,     2,
       0,     6,     0,     5,     3,     0,     7,     0,     6,     2,
       3,     2,     3,     3,     4,     3,     4,     1,     0,     5,
       2,     0,     5,     0,     5,     3,     2,     0,     5,     2,
       0,     5,     0,     8,     6,     1,     0,     3,     1,     2,
       0,     2,     3,     2,     3,     1,     2,     3,     3,     0,
       1,     1,     1,     2,     2,     2,     1,     2,     2,     2,
       3,     3,     2,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     2,     2,     3,     1,     2,     1,     2,     2,
       2,     2,     3,     4,     2,     2,     2,     0,     3,     3,
       5,     3,     4,     4,     2,     0,     3,     6,     3,     4,
       4,     3,     3,     0,     2,     0,     2,     1,     0,     1,
       1,     1,     1,     2,     0,     4,     4,     4,     4,     3,
       2,     0,     0,     5,     2
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       2,     0,     0,     1,     0,     6,     0,     3,     8,   151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     7,   154,     4,   150,     9,    12,    10,    13,   116,
     116,   116,   116,   116,   116,     0,   140,   139,   138,   275,
      32,   149,   279,   280,   281,   282,    11,     0,     0,     0,
       0,   157,     0,   115,    16,    18,    20,    22,    26,    24,
     116,   116,     0,   276,     0,    34,     0,   157,   155,    14,
       0,     0,     0,     0,     0,     0,    30,    28,   139,     0,
     148,     0,    35,   206,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,   188,   191,   193,   205,     0,   200,
     197,     0,     0,     0,     0,   208,     0,   156,     0,   187,
       0,    37,    68,    75,   210,    87,    82,     0,     0,   274,
       0,    33,   153,   159,     0,   120,   119,   169,     0,     0,
     179,     0,     0,     0,     0,   166,     0,   124,   123,   190,
       0,     0,     0,   160,   128,   127,   199,     0,   126,   125,
     196,     0,     0,   158,     0,     0,     0,   181,     0,   177,
       0,    15,     0,     0,     0,     0,     0,     0,   291,   284,
     139,   147,   116,     0,    68,   183,   161,   162,   163,   164,
       0,     0,   210,   257,   265,    87,    82,   132,   131,   195,
       0,   180,     0,   182,   185,   168,   118,   117,   174,     0,
     207,     0,     0,     0,     0,    40,    41,    42,    43,    44,
      45,     0,     0,    49,    50,    51,    52,    53,     0,     0,
       0,     0,     0,     0,    17,    36,     0,     0,     0,    69,
      72,    19,    67,    79,   101,   105,   103,   104,   106,   102,
       0,    21,    74,    76,   134,     0,     0,   215,    23,   209,
       0,     0,     0,     0,    27,    86,     0,     0,    25,    81,
       0,     0,   202,    68,     0,   165,   167,     0,     0,     0,
       0,     0,   184,   186,     0,    37,     0,     0,    38,    39,
       0,     0,     0,    55,     0,     0,     0,     0,     0,    66,
      99,   100,    54,     0,     0,     0,     0,    77,   122,   121,
     133,   219,     0,   222,     0,   220,   221,     0,     0,   211,
       0,     0,     0,     0,   226,     0,     0,     0,     0,     0,
       0,   245,     0,     0,     0,   247,   213,     0,    92,   142,
     141,     0,     0,     0,    85,    83,   292,    31,   290,     0,
       0,    29,   283,     0,     0,     0,   173,   189,     0,     0,
       0,   192,     0,   256,     0,     0,     0,     0,   194,   264,
     201,   198,    37,     0,     0,    97,    46,    47,    66,    66,
      66,    48,    66,    66,    66,    66,    64,    65,     0,    70,
      71,    73,   108,     0,     0,     0,   214,    75,   223,   224,
     225,   212,   242,   227,   228,     0,   232,   233,   229,   243,
       0,     0,     0,     0,     0,   250,   251,   255,     0,   254,
     246,   248,   249,    93,   143,   145,   144,     0,    94,     0,
       0,   130,   129,   294,     0,     0,     0,     0,   204,    87,
     171,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   178,     0,     0,    56,    57,    58,    59,
      60,    61,    62,    66,     0,   108,    75,   216,     0,   236,
     237,   244,   238,   239,   231,   230,   234,   252,   235,   240,
     241,   146,     0,     0,   110,   284,   289,     0,     0,     0,
     258,     0,     0,   261,     0,   259,     0,   266,     0,     0,
     268,   272,   271,   176,    95,    98,     0,    80,   107,     0,
       0,   217,   218,   135,   253,    90,    88,     0,     0,   286,
     285,   288,   287,   203,   263,   262,     0,     0,   270,   269,
      96,    66,    78,   137,     0,     0,     0,    84,   293,   260,
       0,     0,   114,   112,     0,   267,    66,     0,     0,   278,
      63,   278,    91,   278,    89,   277,   109,   113,   111
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,     2,     9,     7,    10,    21,    52,   110,    70,
      71,    72,    73,    75,    74,   118,   117,   162,   225,   378,
     163,   232,   164,   242,   383,   296,   167,   259,   420,   166,
     255,   525,   524,   366,   292,   243,   454,   507,   538,   537,
      54,   198,   127,   300,   139,   150,   146,   423,   189,   301,
     302,   384,    39,   332,   418,   106,    11,    24,    50,    51,
      68,   107,   173,   128,   274,   199,   140,   141,   142,   151,
     147,   344,   108,   109,   165,   249,   386,   309,   326,   268,
     353,   269,   359,    79,   119,    41,    63,   546,    46,   261,
     342,   260,   338,   424
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -343
static const yytype_int16 yypact[] =
{
    -343,    69,    60,  -343,  -102,    84,   -51,  -343,  -343,  -343,
      11,    19,    51,    65,    94,   227,   203,   265,   151,   103,
    -343,  -343,    95,  -343,  -343,  -343,  -343,  -343,  -343,   122,
     122,   122,   122,   122,   122,   111,  -343,   136,  -343,  -343,
    -343,  -343,  -343,  -343,  -343,  -343,  -343,   143,   158,   163,
     145,  -343,   171,  -343,  -343,  -343,  -343,  -343,  -343,  -343,
     122,   122,   225,  -343,   161,  -343,   178,  -343,   252,  -343,
     210,   222,   233,   237,   239,   244,  -343,  -343,   168,   176,
    -343,   197,  -343,   155,   170,   268,   -18,   -15,   355,   388,
     350,   387,   203,   203,     5,  -343,  -343,  -343,   265,   182,
     207,   398,   321,    42,   129,  -343,   423,  -343,   452,   331,
     341,  -343,  -343,  -343,  -343,  -343,  -343,   345,   346,  -343,
     238,  -343,  -343,  -343,   396,  -343,  -343,   351,   360,   358,
     331,   203,   203,   203,   203,  -343,    20,  -343,  -343,  -343,
     361,   362,   363,  -343,  -343,  -343,  -343,   364,  -343,  -343,
    -343,   366,   272,  -343,   135,   160,   370,   331,   203,   274,
     372,  -343,   353,    22,   159,     2,    36,   110,  -343,  -343,
    -343,  -343,   122,   374,  -343,  -343,  -343,  -343,  -343,  -343,
     203,   203,  -343,  -343,  -343,  -343,  -343,  -343,  -343,  -343,
     377,   331,   380,   331,  -343,  -343,  -343,  -343,   376,   378,
    -343,   459,   486,   238,   238,  -343,  -343,  -343,  -343,  -343,
    -343,     6,   488,  -343,  -343,  -343,  -343,  -343,   400,   401,
     402,   403,   238,    -6,  -343,  -343,   238,   238,   495,  -343,
    -343,  -343,  -343,  -343,  -343,  -343,  -343,  -343,  -343,  -343,
     483,  -343,  -343,  -343,   276,   167,    47,  -343,  -343,  -343,
     436,   394,   242,   395,  -343,  -343,   397,   440,  -343,  -343,
     -30,   131,   392,  -343,    28,  -343,  -343,     3,   109,   139,
      44,   174,  -343,  -343,   404,  -343,   -22,   -22,  -343,  -343,
     238,   238,   238,  -343,   -22,   238,   238,   238,   238,   269,
    -343,  -343,  -343,   238,   238,   274,   405,  -343,  -343,  -343,
     406,   470,   411,  -343,   490,  -343,  -343,   510,   419,   167,
     473,   382,   337,   524,  -343,   527,   528,   424,   485,   384,
     427,    14,   478,   439,   441,  -343,  -343,   207,  -343,   421,
     425,   429,   266,   432,  -343,  -343,   287,  -343,  -343,   100,
     469,  -343,  -343,   182,   430,    48,  -343,  -343,   -25,   500,
     519,  -343,   518,  -343,   549,    31,   505,   165,  -343,  -343,
    -343,  -343,  -343,   389,   443,   506,  -343,  -343,   269,   269,
     269,  -343,   269,   269,   269,   269,  -343,  -343,   238,  -343,
    -343,  -343,  -343,   442,   444,   238,  -343,  -343,  -343,  -343,
    -343,  -343,  -343,  -343,  -343,   354,  -343,  -343,  -343,   496,
     365,   511,   513,    37,   449,  -343,  -343,  -343,   373,  -343,
    -343,  -343,  -343,  -343,  -343,   421,   425,   445,  -343,     8,
     446,  -343,  -343,  -343,   447,   182,   491,   492,  -343,  -343,
    -343,   451,   191,   203,   238,   167,   274,   455,   214,   203,
     203,   203,   428,  -343,   458,   460,  -343,  -343,  -343,  -343,
    -343,  -343,  -343,   269,   199,  -343,  -343,   302,   263,  -343,
    -343,  -343,  -343,  -343,  -343,  -343,  -343,  -343,   502,  -343,
    -343,  -343,   461,   462,  -343,  -343,  -343,   314,   316,    56,
    -343,   203,   203,  -343,   542,  -343,   543,  -343,   203,   203,
    -343,  -343,  -343,  -343,   465,  -343,   238,  -343,  -343,   215,
     303,  -343,  -343,  -343,  -343,  -343,  -343,   312,   146,  -343,
    -343,  -343,  -343,  -343,  -343,  -343,   238,   574,  -343,  -343,
    -343,   269,  -343,  -343,   463,   464,   -22,  -343,  -343,  -343,
     274,   238,  -343,  -343,   466,  -343,   269,     1,    74,   450,
    -343,   450,  -343,   450,  -343,  -343,  -343,  -343,  -343
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -343,  -343,  -343,  -343,  -343,  -343,  -343,  -343,  -343,  -343,
    -343,  -343,  -343,  -343,  -343,  -343,  -343,  -219,  -343,  -342,
    -161,  -343,  -298,  -343,  -343,  -343,   407,  -343,  -343,  -182,
    -343,  -343,  -343,  -273,  -343,  -343,   134,  -343,  -343,  -343,
     -24,  -290,  -343,  -343,  -343,   259,  -322,  -343,  -343,  -343,
    -343,  -343,  -202,  -343,  -343,   -16,  -343,  -343,  -343,  -343,
     523,  -343,  -343,  -343,  -343,  -343,  -343,  -343,  -343,  -343,
    -343,  -343,  -343,    63,   410,  -343,  -343,  -297,  -343,  -343,
    -343,  -343,  -343,  -343,  -343,    25,  -343,  -319,   497,   119,
    -343,  -343,  -343,  -343
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -274
static const yytype_int16 yytable[] =
{
      40,   278,   279,   270,   367,   381,    55,    56,    57,    58,
      59,   371,   391,   264,   244,   244,    12,    13,    14,    15,
     289,   428,     5,   280,   293,   294,   446,   447,   448,   408,
     449,   450,   451,   452,   431,   290,    76,    77,   226,   227,
     228,   229,   245,   245,   226,   227,   228,   229,    22,   336,
     331,   246,   246,   466,   250,   154,   363,   310,   311,   180,
     312,   313,   250,     4,   226,   227,   228,   229,    16,     3,
     129,   247,   247,     8,   250,   181,   135,   136,   368,   369,
     370,    17,   314,   372,   373,   374,   375,    80,     6,   458,
     437,   379,   380,   432,   472,   337,   364,   315,   316,   365,
     125,   126,   345,   476,   105,   317,   281,   282,    18,   318,
     291,   496,   467,    19,   409,   176,   177,   178,   179,   541,
      49,   251,   319,   137,   138,   283,   542,   248,   347,   251,
     417,   320,   252,   230,   321,   322,    20,   473,   485,   230,
     252,   251,   195,   442,    23,   171,   486,   231,   262,   438,
     130,    60,   252,   346,   253,   155,   323,   324,   500,   230,
      84,   254,   253,    85,   265,   266,    86,   157,    87,   360,
      25,   348,   349,   430,   253,   425,   453,   354,   303,   531,
     325,   513,   426,   457,    26,    88,    89,   233,    90,    91,
      61,    92,   543,    93,   540,   256,   304,   440,    94,   544,
     234,   355,   356,   235,   236,   237,   238,   239,   305,   306,
     350,   339,   340,    27,   156,    95,    96,   191,   193,  -152,
     190,    97,   547,   481,   548,    98,   339,   340,   257,   441,
      99,   100,   484,   101,   351,   258,    28,    29,    30,    31,
     535,    53,   307,   352,   102,   192,   488,   479,   105,    47,
      48,   308,   498,   534,   105,   482,   341,    84,   357,   256,
      85,    64,  -206,    86,   358,    87,    62,   103,   104,    67,
      32,   528,    36,    37,   105,    38,    65,   240,   489,   105,
     122,    66,    88,    89,   241,    90,    91,    81,    92,   123,
      93,   233,   257,    69,   521,    94,    82,   498,  -273,   361,
     144,   145,    33,    34,   234,    35,   120,   235,   236,   237,
     238,   239,    95,    96,   529,   121,    36,   170,    97,    38,
      36,    37,    98,    38,   497,   148,   149,    99,   100,   536,
     101,   233,    36,   170,   111,    38,    42,    43,    44,    45,
     522,   102,    36,    78,   234,    38,   112,   235,   236,   237,
     238,   239,   395,   396,   397,    36,   170,   113,    38,   329,
     330,   114,    38,   115,   103,   104,   201,   202,   116,    36,
      37,   105,    38,   203,   204,   205,   206,   207,   208,   209,
     210,   240,   124,   415,   416,   133,    38,   131,   503,   398,
     187,   188,   196,   197,   298,   299,   376,   377,   393,   394,
     405,   406,   201,   202,   399,   421,   422,   459,   460,   203,
     204,   205,   206,   207,   208,   209,   210,   483,   462,   463,
     132,   240,   134,   490,   491,   492,   469,   470,   523,   501,
     502,   211,   509,   510,   511,   512,   526,   527,   152,   153,
     212,   201,   202,   213,   214,   215,   216,   217,   203,   204,
     205,   206,   207,   208,   209,   210,   218,   219,   220,   221,
     158,   222,   159,   160,   161,   514,   515,   211,   223,   168,
     169,   172,   518,   519,   276,  -170,   212,   175,   224,   213,
     214,   215,   216,   217,   174,   182,   183,   184,   185,   194,
     186,   200,   218,   219,   220,   221,   272,   222,   263,   273,
    -175,   277,   275,   284,   223,   295,   211,   285,   286,   287,
     288,   297,   327,   328,   443,   212,   334,   335,   213,   214,
     215,   216,   217,   343,   333,   385,   388,   389,   362,   382,
    -136,   218,   219,   220,   221,   387,   222,   390,   392,   400,
     401,   402,   403,   223,   404,   407,   410,   411,  -140,   412,
     419,   427,  -139,   493,   429,   433,   414,   434,   435,   436,
     439,   444,   445,   464,   461,   465,   455,   468,   456,   480,
     474,   475,   471,   487,   477,   478,   494,   504,   495,   505,
     506,   516,   517,   520,   530,   545,   413,   532,   533,   499,
      83,   539,   267,   271,   508,   143
};

static const yytype_uint16 yycheck[] =
{
      16,   203,   204,   185,   277,   295,    30,    31,    32,    33,
      34,   284,   309,   174,    12,    12,     5,     6,     7,     8,
     222,   343,   124,    17,   226,   227,   368,   369,   370,    15,
     372,   373,   374,   375,    59,    41,    60,    61,    16,    17,
      18,    19,    40,    40,    16,    17,    18,    19,    29,    79,
     252,    49,    49,    16,    18,    13,   275,    10,    11,    39,
      13,    14,    18,     3,    16,    17,    18,    19,    57,     0,
      85,    69,    69,   124,    18,    55,    92,    93,   280,   281,
     282,    70,    35,   285,   286,   287,   288,    62,     4,   387,
      59,   293,   294,   118,    86,   125,   118,    50,    51,   121,
     118,   119,   263,   425,   119,    58,   100,   101,    97,    62,
     116,   453,    75,   102,   100,   131,   132,   133,   134,   118,
      17,    85,    75,   118,   119,   119,   125,   125,   125,    85,
     332,    84,    96,   111,    87,    88,   125,   129,   435,   111,
      96,    85,   158,   362,   125,   120,   436,   125,   172,   118,
      87,    40,    96,   125,   118,   113,   109,   110,   456,   111,
       5,   125,   118,     8,   180,   181,    11,   104,    13,   125,
     119,    62,    63,   125,   118,    75,   378,    38,    11,   521,
     133,   125,    82,   385,   119,    30,    31,    28,    33,    34,
      79,    36,   118,    38,   536,    85,    29,    32,    43,   125,
      41,    62,    63,    44,    45,    46,    47,    48,    41,    42,
     101,    80,    81,   119,    85,    60,    61,   154,   155,   124,
      85,    66,   541,    32,   543,    70,    80,    81,   118,    64,
      75,    76,   434,    78,   125,   125,     9,    10,    11,    12,
     530,   119,    75,   134,    89,    85,    32,   429,   119,    98,
      99,    84,   454,   526,   119,    64,   125,     5,   119,    85,
       8,   118,    10,    11,   125,    13,   130,   112,   113,   124,
      43,   125,   117,   118,   119,   120,   118,   118,    64,   119,
     125,   118,    30,    31,   125,    33,    34,   126,    36,   119,
      38,    28,   118,   122,   496,    43,   118,   499,   130,   125,
     118,   119,    75,    76,    41,    78,   130,    44,    45,    46,
      47,    48,    60,    61,   516,   118,   117,   118,    66,   120,
     117,   118,    70,   120,   125,   118,   119,    75,    76,   531,
      78,    28,   117,   118,   124,   120,    71,    72,    73,    74,
     125,    89,   117,   118,    41,   120,   124,    44,    45,    46,
      47,    48,    15,    16,    17,   117,   118,   124,   120,   117,
     118,   124,   120,   124,   112,   113,    13,    14,   124,   117,
     118,   119,   120,    20,    21,    22,    23,    24,    25,    26,
      27,   118,   114,   117,   118,    35,   120,    32,   125,    52,
     118,   119,   118,   119,   118,   119,   127,   128,    16,    17,
      16,    17,    13,    14,    67,   118,   119,    53,    54,    20,
      21,    22,    23,    24,    25,    26,    27,   433,    53,    54,
      32,   118,    35,   439,   440,   441,    53,    54,   125,   127,
     128,    78,   118,   119,   118,   119,   124,   125,    40,   118,
      87,    13,    14,    90,    91,    92,    93,    94,    20,    21,
      22,    23,    24,    25,    26,    27,   103,   104,   105,   106,
      37,   108,    10,   132,   123,   481,   482,    78,   115,   124,
     124,    75,   488,   489,    15,   124,    87,   119,   125,    90,
      91,    92,    93,    94,   124,   124,   124,   124,   124,   119,
     124,   119,   103,   104,   105,   106,   119,   108,   124,   119,
     124,    15,   124,    15,   115,    10,    78,   107,   107,   107,
     107,    28,    76,   119,   125,    87,   119,    77,    90,    91,
      92,    93,    94,   131,   129,    55,    36,    17,   124,   124,
     124,   103,   104,   105,   106,   124,   108,   118,    65,    15,
      13,    13,   118,   115,    59,   118,    68,   108,   127,   108,
     118,    82,   127,   125,   124,    55,   127,    38,    40,    10,
      55,   118,    56,    52,    68,    52,   124,   118,   124,   118,
     124,   124,   127,   118,    83,    83,   118,    75,   118,   118,
     118,    39,    39,   118,    10,   135,   327,   124,   124,   455,
      67,   125,   182,   186,   475,    98
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,   137,   138,     0,     3,   124,     4,   140,   124,   139,
     141,   192,     5,     6,     7,     8,    57,    70,    97,   102,
     125,   142,    29,   125,   193,   119,   119,   119,     9,    10,
      11,    12,    43,    75,    76,    78,   117,   118,   120,   188,
     191,   221,    71,    72,    73,    74,   224,    98,    99,    17,
     194,   195,   143,   119,   176,   176,   176,   176,   176,   176,
      40,    79,   130,   222,   118,   118,   118,   124,   196,   122,
     145,   146,   147,   148,   150,   149,   176,   176,   118,   219,
     221,   126,   118,   196,     5,     8,    11,    13,    30,    31,
      33,    34,    36,    38,    43,    60,    61,    66,    70,    75,
      76,    78,    89,   112,   113,   119,   191,   197,   208,   209,
     144,   124,   124,   124,   124,   124,   124,   152,   151,   220,
     130,   118,   125,   119,   114,   118,   119,   178,   199,    85,
     209,    32,    32,    35,    35,   191,   191,   118,   119,   180,
     202,   203,   204,   224,   118,   119,   182,   206,   118,   119,
     181,   205,    40,   118,    13,   113,    85,   209,    37,    10,
     132,   123,   153,   156,   158,   210,   165,   162,   124,   124,
     118,   221,    75,   198,   124,   119,   191,   191,   191,   191,
      39,    55,   124,   124,   124,   124,   124,   118,   119,   184,
      85,   209,    85,   209,   119,   191,   118,   119,   177,   201,
     119,    13,    14,    20,    21,    22,    23,    24,    25,    26,
      27,    78,    87,    90,    91,    92,    93,    94,   103,   104,
     105,   106,   108,   115,   125,   154,    16,    17,    18,    19,
     111,   125,   157,    28,    41,    44,    45,    46,    47,    48,
     118,   125,   159,   171,    12,    40,    49,    69,   125,   211,
      18,    85,    96,   118,   125,   166,    85,   118,   125,   163,
     227,   225,   176,   124,   156,   191,   191,   210,   215,   217,
     165,   162,   119,   119,   200,   124,    15,    15,   188,   188,
      17,   100,   101,   119,    15,   107,   107,   107,   107,   188,
      41,   116,   170,   188,   188,    10,   161,    28,   118,   119,
     179,   185,   186,    11,    29,    41,    42,    75,    84,   213,
      10,    11,    13,    14,    35,    50,    51,    58,    62,    75,
      84,    87,    88,   109,   110,   133,   214,    76,   119,   117,
     118,   188,   189,   129,   119,    77,    79,   125,   228,    80,
      81,   125,   226,   131,   207,   156,   125,   125,    62,    63,
     101,   125,   134,   216,    38,    62,    63,   119,   125,   218,
     125,   125,   124,   153,   118,   121,   169,   169,   188,   188,
     188,   169,   188,   188,   188,   188,   127,   128,   155,   188,
     188,   177,   124,   160,   187,    55,   212,   124,    36,    17,
     118,   213,    65,    16,    17,    15,    16,    17,    52,    67,
      15,    13,    13,   118,    59,    16,    17,   118,    15,   100,
      68,   108,   108,   181,   127,   117,   118,   188,   190,   118,
     164,   118,   119,   183,   229,    75,    82,    82,   182,   124,
     125,    59,   118,    55,    38,    40,    10,    59,   118,    55,
      32,    64,   153,   125,   118,    56,   155,   155,   155,   155,
     155,   155,   155,   188,   172,   124,   124,   188,   158,    53,
      54,    68,    53,    54,    52,    52,    16,    75,   118,    53,
      54,   127,    86,   129,   124,   124,   182,    83,    83,   165,
     118,    32,    64,   191,   188,   213,   177,   118,    32,    64,
     191,   191,   191,   125,   118,   118,   155,   125,   188,   172,
     158,   127,   128,   125,    75,   118,   118,   173,   225,   118,
     119,   118,   119,   125,   191,   191,    39,    39,   191,   191,
     118,   188,   125,   125,   168,   167,   124,   125,   125,   188,
      10,   155,   124,   124,   169,   177,   188,   175,   174,   125,
     155,   118,   125,   118,   125,   135,   223,   223,   223
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */





/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

    /* Number of syntax errors so far.  */
    int yynerrs;

    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:

/* Line 1455 of yacc.c  */
#line 2201 "kate_parser.y"
    {nlines=1;}
    break;

  case 3:

/* Line 1455 of yacc.c  */
#line 2201 "kate_parser.y"
    { kd_write_headers(); }
    break;

  case 4:

/* Line 1455 of yacc.c  */
#line 2201 "kate_parser.y"
    { cleanup_memory(); }
    break;

  case 6:

/* Line 1455 of yacc.c  */
#line 2205 "kate_parser.y"
    {}
    break;

  case 8:

/* Line 1455 of yacc.c  */
#line 2209 "kate_parser.y"
    {}
    break;

  case 9:

/* Line 1455 of yacc.c  */
#line 2212 "kate_parser.y"
    { CHECK_KATE_API_ERROR(kate_info_set_language(&ki,(yyvsp[(2) - (2)].string))); }
    break;

  case 10:

/* Line 1455 of yacc.c  */
#line 2213 "kate_parser.y"
    { CHECK_KATE_API_ERROR(kate_info_set_category(&ki,(yyvsp[(2) - (2)].string))); }
    break;

  case 11:

/* Line 1455 of yacc.c  */
#line 2214 "kate_parser.y"
    { CHECK_KATE_API_ERROR(kate_info_set_text_directionality(&ki,(yyvsp[(2) - (2)].number))); }
    break;

  case 12:

/* Line 1455 of yacc.c  */
#line 2215 "kate_parser.y"
    { add_comment(&kc,(yyvsp[(2) - (2)].string)); }
    break;

  case 13:

/* Line 1455 of yacc.c  */
#line 2216 "kate_parser.y"
    {set_macro_mode();}
    break;

  case 14:

/* Line 1455 of yacc.c  */
#line 2216 "kate_parser.y"
    {record_macro_name((yyvsp[(4) - (4)].string));}
    break;

  case 15:

/* Line 1455 of yacc.c  */
#line 2217 "kate_parser.y"
    { add_temp_macro((yyvsp[(6) - (6)].string)); unset_macro_mode(); }
    break;

  case 16:

/* Line 1455 of yacc.c  */
#line 2218 "kate_parser.y"
    {init_style(&kstyle);}
    break;

  case 17:

/* Line 1455 of yacc.c  */
#line 2218 "kate_parser.y"
    { add_style(&ki,(yyvsp[(3) - (7)].string),&kstyle); }
    break;

  case 18:

/* Line 1455 of yacc.c  */
#line 2219 "kate_parser.y"
    {init_region(&kregion);}
    break;

  case 19:

/* Line 1455 of yacc.c  */
#line 2219 "kate_parser.y"
    { add_region(&ki,(yyvsp[(3) - (7)].string),&kregion); }
    break;

  case 20:

/* Line 1455 of yacc.c  */
#line 2220 "kate_parser.y"
    {init_curve();}
    break;

  case 21:

/* Line 1455 of yacc.c  */
#line 2220 "kate_parser.y"
    { add_curve(&ki,(yyvsp[(3) - (7)].string),kcurve.curve); }
    break;

  case 22:

/* Line 1455 of yacc.c  */
#line 2221 "kate_parser.y"
    {init_motion();}
    break;

  case 23:

/* Line 1455 of yacc.c  */
#line 2221 "kate_parser.y"
    { add_motion(&ki,(yyvsp[(3) - (7)].string),kmotion); }
    break;

  case 24:

/* Line 1455 of yacc.c  */
#line 2222 "kate_parser.y"
    {init_palette();}
    break;

  case 25:

/* Line 1455 of yacc.c  */
#line 2222 "kate_parser.y"
    { add_palette(&ki,(yyvsp[(3) - (7)].string),kpalette.palette); }
    break;

  case 26:

/* Line 1455 of yacc.c  */
#line 2223 "kate_parser.y"
    {init_bitmap();}
    break;

  case 27:

/* Line 1455 of yacc.c  */
#line 2223 "kate_parser.y"
    { add_bitmap(&ki,(yyvsp[(3) - (7)].string),kbitmap.bitmap); }
    break;

  case 28:

/* Line 1455 of yacc.c  */
#line 2224 "kate_parser.y"
    {init_font_range();}
    break;

  case 29:

/* Line 1455 of yacc.c  */
#line 2224 "kate_parser.y"
    { add_font_range(&ki,(yyvsp[(4) - (8)].string),krange); }
    break;

  case 30:

/* Line 1455 of yacc.c  */
#line 2225 "kate_parser.y"
    {init_font_mapping();}
    break;

  case 31:

/* Line 1455 of yacc.c  */
#line 2225 "kate_parser.y"
    { add_font_mapping(&ki,(yyvsp[(4) - (8)].string),kmapping); }
    break;

  case 32:

/* Line 1455 of yacc.c  */
#line 2226 "kate_parser.y"
    { timebase=(yyvsp[(2) - (2)].fp); }
    break;

  case 33:

/* Line 1455 of yacc.c  */
#line 2227 "kate_parser.y"
    {set_granule_rate((yyvsp[(3) - (5)].unumber),(yyvsp[(5) - (5)].unumber));}
    break;

  case 34:

/* Line 1455 of yacc.c  */
#line 2228 "kate_parser.y"
    {set_granule_shift((yyvsp[(3) - (3)].unumber));}
    break;

  case 35:

/* Line 1455 of yacc.c  */
#line 2229 "kate_parser.y"
    {set_canvas_size((yyvsp[(3) - (4)].unumber),(yyvsp[(4) - (4)].unumber));}
    break;

  case 37:

/* Line 1455 of yacc.c  */
#line 2233 "kate_parser.y"
    {}
    break;

  case 38:

/* Line 1455 of yacc.c  */
#line 2236 "kate_parser.y"
    { kstyle.halign=(yyvsp[(2) - (2)].fp); }
    break;

  case 39:

/* Line 1455 of yacc.c  */
#line 2237 "kate_parser.y"
    { kstyle.valign=(yyvsp[(2) - (2)].fp); }
    break;

  case 40:

/* Line 1455 of yacc.c  */
#line 2238 "kate_parser.y"
    { kstyle.halign=(kate_float)-1.0; }
    break;

  case 41:

/* Line 1455 of yacc.c  */
#line 2239 "kate_parser.y"
    { kstyle.halign=(kate_float)0.0; }
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 2240 "kate_parser.y"
    { kstyle.halign=(kate_float)1.0; }
    break;

  case 43:

/* Line 1455 of yacc.c  */
#line 2241 "kate_parser.y"
    { kstyle.valign=(kate_float)-1.0; }
    break;

  case 44:

/* Line 1455 of yacc.c  */
#line 2242 "kate_parser.y"
    { kstyle.valign=(kate_float)0.0; }
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 2243 "kate_parser.y"
    { kstyle.valign=(kate_float)1.0; }
    break;

  case 46:

/* Line 1455 of yacc.c  */
#line 2244 "kate_parser.y"
    { set_color(&kstyle.text_color,(yyvsp[(3) - (3)].color)); }
    break;

  case 47:

/* Line 1455 of yacc.c  */
#line 2245 "kate_parser.y"
    { set_color(&kstyle.background_color,(yyvsp[(3) - (3)].color)); }
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 2246 "kate_parser.y"
    { set_color(&kstyle.draw_color,(yyvsp[(3) - (3)].color)); }
    break;

  case 49:

/* Line 1455 of yacc.c  */
#line 2247 "kate_parser.y"
    { kstyle.bold=1; }
    break;

  case 50:

/* Line 1455 of yacc.c  */
#line 2248 "kate_parser.y"
    { kstyle.italics=1; }
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 2249 "kate_parser.y"
    { kstyle.underline=1; }
    break;

  case 52:

/* Line 1455 of yacc.c  */
#line 2250 "kate_parser.y"
    { kstyle.strike=1; }
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 2251 "kate_parser.y"
    { kstyle.justify=1; }
    break;

  case 54:

/* Line 1455 of yacc.c  */
#line 2252 "kate_parser.y"
    { kstyle.wrap_mode=(yyvsp[(2) - (2)].number); }
    break;

  case 55:

/* Line 1455 of yacc.c  */
#line 2253 "kate_parser.y"
    { set_font(&kstyle,(yyvsp[(2) - (2)].string)); }
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 2254 "kate_parser.y"
    { set_font_size(&kstyle,(yyvsp[(3) - (4)].fp),(yyvsp[(4) - (4)].number)); }
    break;

  case 57:

/* Line 1455 of yacc.c  */
#line 2255 "kate_parser.y"
    { set_font_width(&kstyle,(yyvsp[(3) - (4)].fp),(yyvsp[(4) - (4)].number)); }
    break;

  case 58:

/* Line 1455 of yacc.c  */
#line 2256 "kate_parser.y"
    { set_font_height(&kstyle,(yyvsp[(3) - (4)].fp),(yyvsp[(4) - (4)].number)); }
    break;

  case 59:

/* Line 1455 of yacc.c  */
#line 2257 "kate_parser.y"
    { set_margin(&kstyle,&kstyle.left_margin,(yyvsp[(3) - (4)].fp),(yyvsp[(4) - (4)].number)); }
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 2258 "kate_parser.y"
    { set_margin(&kstyle,&kstyle.top_margin,(yyvsp[(3) - (4)].fp),(yyvsp[(4) - (4)].number)); }
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 2259 "kate_parser.y"
    { set_margin(&kstyle,&kstyle.right_margin,(yyvsp[(3) - (4)].fp),(yyvsp[(4) - (4)].number)); }
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 2260 "kate_parser.y"
    { set_margin(&kstyle,&kstyle.bottom_margin,(yyvsp[(3) - (4)].fp),(yyvsp[(4) - (4)].number)); }
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 2262 "kate_parser.y"
    { set_margins(&kstyle,(yyvsp[(2) - (9)].fp),(yyvsp[(3) - (9)].number),(yyvsp[(4) - (9)].fp),(yyvsp[(5) - (9)].number),(yyvsp[(6) - (9)].fp),(yyvsp[(7) - (9)].number),(yyvsp[(8) - (9)].fp),(yyvsp[(9) - (9)].number)); }
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 2265 "kate_parser.y"
    { (yyval.number)=kate_percentage; }
    break;

  case 65:

/* Line 1455 of yacc.c  */
#line 2266 "kate_parser.y"
    { (yyval.number)=kate_millionths; }
    break;

  case 66:

/* Line 1455 of yacc.c  */
#line 2267 "kate_parser.y"
    { (yyval.number)=kate_pixel; }
    break;

  case 68:

/* Line 1455 of yacc.c  */
#line 2271 "kate_parser.y"
    {}
    break;

  case 69:

/* Line 1455 of yacc.c  */
#line 2274 "kate_parser.y"
    {kregion.metric=(yyvsp[(1) - (1)].number); }
    break;

  case 70:

/* Line 1455 of yacc.c  */
#line 2275 "kate_parser.y"
    { kregion.x=(yyvsp[(2) - (3)].fp);kregion.y=(yyvsp[(3) - (3)].fp); }
    break;

  case 71:

/* Line 1455 of yacc.c  */
#line 2276 "kate_parser.y"
    { kregion.w=(yyvsp[(2) - (3)].fp);kregion.h=(yyvsp[(3) - (3)].fp); }
    break;

  case 72:

/* Line 1455 of yacc.c  */
#line 2277 "kate_parser.y"
    { kregion.clip=1; }
    break;

  case 73:

/* Line 1455 of yacc.c  */
#line 2278 "kate_parser.y"
    { kregion.style=(yyvsp[(3) - (3)].number); }
    break;

  case 75:

/* Line 1455 of yacc.c  */
#line 2282 "kate_parser.y"
    {}
    break;

  case 76:

/* Line 1455 of yacc.c  */
#line 2285 "kate_parser.y"
    { kcurve.curve->type=(yyvsp[(1) - (1)].number); n_curve_pts=0; }
    break;

  case 77:

/* Line 1455 of yacc.c  */
#line 2286 "kate_parser.y"
    { init_curve_points((yyvsp[(1) - (2)].unumber)); }
    break;

  case 78:

/* Line 1455 of yacc.c  */
#line 2286 "kate_parser.y"
    {
                if ((size_t)n_curve_pts!=kcurve.curve->npts*2) katedesc_error("Wrong number of points in the curve");
              }
    break;

  case 79:

/* Line 1455 of yacc.c  */
#line 2289 "kate_parser.y"
    { init_open_ended_curve_points(); }
    break;

  case 82:

/* Line 1455 of yacc.c  */
#line 2293 "kate_parser.y"
    {}
    break;

  case 83:

/* Line 1455 of yacc.c  */
#line 2296 "kate_parser.y"
    { init_palette_colors((yyvsp[(1) - (2)].unumber)); }
    break;

  case 84:

/* Line 1455 of yacc.c  */
#line 2296 "kate_parser.y"
    {
                  if ((size_t)n_palette_colors!=kpalette.palette->ncolors) {
                    katedesc_error("Wrong number of colors in the palette");
                  }
                }
    break;

  case 85:

/* Line 1455 of yacc.c  */
#line 2301 "kate_parser.y"
    { load_palette((yyvsp[(2) - (2)].string)); }
    break;

  case 87:

/* Line 1455 of yacc.c  */
#line 2305 "kate_parser.y"
    {}
    break;

  case 88:

/* Line 1455 of yacc.c  */
#line 2308 "kate_parser.y"
    { init_bitmap_pixels((yyvsp[(1) - (5)].unumber),(yyvsp[(3) - (5)].unumber),(yyvsp[(5) - (5)].unumber)); }
    break;

  case 89:

/* Line 1455 of yacc.c  */
#line 2308 "kate_parser.y"
    {
                 if ((size_t)n_bitmap_pixels!=kbitmap.bitmap->width*kbitmap.bitmap->height) {
                   katedesc_error("Wrong number of pixels in the bitmap");
                 }
               }
    break;

  case 90:

/* Line 1455 of yacc.c  */
#line 2313 "kate_parser.y"
    { init_png_bitmap_pixels((yyvsp[(1) - (5)].unumber),(yyvsp[(3) - (5)].unumber),(yyvsp[(5) - (5)].unumber)); }
    break;

  case 91:

/* Line 1455 of yacc.c  */
#line 2313 "kate_parser.y"
    {
                 if ((size_t)n_bitmap_pixels!=kbitmap.bitmap->size) {
                   katedesc_error("Wrong number of bytes in the PNG bitmap");
                 }
               }
    break;

  case 92:

/* Line 1455 of yacc.c  */
#line 2318 "kate_parser.y"
    { load_bitmap((yyvsp[(2) - (2)].string),0); }
    break;

  case 93:

/* Line 1455 of yacc.c  */
#line 2319 "kate_parser.y"
    { kbitmap.bitmap->palette=(yyvsp[(3) - (3)].number); }
    break;

  case 94:

/* Line 1455 of yacc.c  */
#line 2320 "kate_parser.y"
    { kbitmap.bitmap->x_offset=(yyvsp[(2) - (3)].number); kbitmap.bitmap->y_offset=(yyvsp[(3) - (3)].number); }
    break;

  case 95:

/* Line 1455 of yacc.c  */
#line 2323 "kate_parser.y"
    { (yyval.color)=make_color((yyvsp[(1) - (3)].unumber),(yyvsp[(2) - (3)].unumber),(yyvsp[(3) - (3)].unumber),255); }
    break;

  case 96:

/* Line 1455 of yacc.c  */
#line 2324 "kate_parser.y"
    { (yyval.color)=make_color((yyvsp[(1) - (4)].unumber),(yyvsp[(2) - (4)].unumber),(yyvsp[(3) - (4)].unumber),(yyvsp[(4) - (4)].unumber)); }
    break;

  case 97:

/* Line 1455 of yacc.c  */
#line 2325 "kate_parser.y"
    { (yyval.color)=make_color_alpha((yyvsp[(1) - (1)].color),255); }
    break;

  case 98:

/* Line 1455 of yacc.c  */
#line 2326 "kate_parser.y"
    { (yyval.color)=make_color_alpha((yyvsp[(1) - (3)].color),(yyvsp[(3) - (3)].unumber)); }
    break;

  case 99:

/* Line 1455 of yacc.c  */
#line 2329 "kate_parser.y"
    { (yyval.number)=kate_wrap_none; }
    break;

  case 100:

/* Line 1455 of yacc.c  */
#line 2330 "kate_parser.y"
    { (yyval.number)=kate_wrap_word; }
    break;

  case 101:

/* Line 1455 of yacc.c  */
#line 2333 "kate_parser.y"
    { (yyval.number)=kate_curve_none; }
    break;

  case 102:

/* Line 1455 of yacc.c  */
#line 2334 "kate_parser.y"
    { (yyval.number)=kate_curve_static; }
    break;

  case 103:

/* Line 1455 of yacc.c  */
#line 2335 "kate_parser.y"
    { (yyval.number)=kate_curve_linear; }
    break;

  case 104:

/* Line 1455 of yacc.c  */
#line 2336 "kate_parser.y"
    { (yyval.number)=kate_curve_catmull_rom_spline; }
    break;

  case 105:

/* Line 1455 of yacc.c  */
#line 2337 "kate_parser.y"
    { (yyval.number)=kate_curve_bezier_cubic_spline; }
    break;

  case 106:

/* Line 1455 of yacc.c  */
#line 2338 "kate_parser.y"
    { (yyval.number)=kate_curve_bspline; }
    break;

  case 107:

/* Line 1455 of yacc.c  */
#line 2341 "kate_parser.y"
    {
                   if (open_ended_curve) {
                     add_open_ended_curve_point((yyvsp[(2) - (2)].fp));
                   }
                   else {
                     if ((size_t)n_curve_pts>=kcurve.curve->npts*2) katedesc_error("Too many points in curve");
                     else { kcurve.curve->pts[n_curve_pts++]=(yyvsp[(2) - (2)].fp); }
                   }
                 }
    break;

  case 108:

/* Line 1455 of yacc.c  */
#line 2350 "kate_parser.y"
    {}
    break;

  case 109:

/* Line 1455 of yacc.c  */
#line 2353 "kate_parser.y"
    {
                     if ((size_t)n_palette_colors>=kpalette.palette->ncolors) katedesc_error("Too many colors in palette");
                     else { set_color(&kpalette.palette->colors[n_palette_colors++],(yyvsp[(3) - (5)].color)); }
                   }
    break;

  case 110:

/* Line 1455 of yacc.c  */
#line 2357 "kate_parser.y"
    {}
    break;

  case 111:

/* Line 1455 of yacc.c  */
#line 2360 "kate_parser.y"
    {
                    if ((size_t)n_bitmap_pixels>=kbitmap.bitmap->width*kbitmap.bitmap->height) {
                      katedesc_error("Too many pixels in bitmap");
                    }
                    else {
                      if ((yyvsp[(2) - (3)].unumber)>(unsigned int)(1<<kbitmap.bitmap->bpp)-1) {
                        katedesc_error("pixels out of range for given bpp");
                      }
                      else {
                        kbitmap.bitmap->pixels[n_bitmap_pixels++]=(yyvsp[(2) - (3)].unumber);
                      }
                    }
                  }
    break;

  case 112:

/* Line 1455 of yacc.c  */
#line 2373 "kate_parser.y"
    {}
    break;

  case 113:

/* Line 1455 of yacc.c  */
#line 2376 "kate_parser.y"
    {
                        if ((size_t)n_bitmap_pixels>=kbitmap.bitmap->size) {
                          katedesc_error("Too many pixels in bitmap");
                        }
                        else {
                          kbitmap.bitmap->pixels[n_bitmap_pixels++]=(yyvsp[(2) - (3)].unumber);
                        }
                      }
    break;

  case 114:

/* Line 1455 of yacc.c  */
#line 2384 "kate_parser.y"
    {}
    break;

  case 115:

/* Line 1455 of yacc.c  */
#line 2387 "kate_parser.y"
    { (yyval.string)=(yyvsp[(1) - (1)].string); }
    break;

  case 116:

/* Line 1455 of yacc.c  */
#line 2388 "kate_parser.y"
    { (yyval.string)=NULL; }
    break;

  case 117:

/* Line 1455 of yacc.c  */
#line 2391 "kate_parser.y"
    { (yyval.number)=find_style(&ki,(yyvsp[(1) - (1)].string)); }
    break;

  case 118:

/* Line 1455 of yacc.c  */
#line 2392 "kate_parser.y"
    { if ((yyvsp[(1) - (1)].unumber)>=ki.nstyles) yyerrorf("Invalid style index (%u/%d)",(yyvsp[(1) - (1)].unumber),ki.nstyles); (yyval.number)=(yyvsp[(1) - (1)].unumber); }
    break;

  case 119:

/* Line 1455 of yacc.c  */
#line 2395 "kate_parser.y"
    { (yyval.number)=find_region(&ki,(yyvsp[(1) - (1)].string)); }
    break;

  case 120:

/* Line 1455 of yacc.c  */
#line 2396 "kate_parser.y"
    { if ((yyvsp[(1) - (1)].unumber)>=ki.nregions) yyerrorf("Invalid region index (%u/%u)",(yyvsp[(1) - (1)].unumber),ki.nregions); (yyval.number)=(yyvsp[(1) - (1)].unumber); }
    break;

  case 121:

/* Line 1455 of yacc.c  */
#line 2399 "kate_parser.y"
    { (yyval.number)=find_curve(&ki,(yyvsp[(1) - (1)].string)); }
    break;

  case 122:

/* Line 1455 of yacc.c  */
#line 2400 "kate_parser.y"
    { if ((yyvsp[(1) - (1)].unumber)>=ki.ncurves) yyerrorf("Invalid curve index (%u/%u)",(yyvsp[(1) - (1)].unumber),ki.ncurves); (yyval.number)=(yyvsp[(1) - (1)].unumber); }
    break;

  case 123:

/* Line 1455 of yacc.c  */
#line 2403 "kate_parser.y"
    { (yyval.number)=find_motion(&ki,(yyvsp[(1) - (1)].string)); }
    break;

  case 124:

/* Line 1455 of yacc.c  */
#line 2404 "kate_parser.y"
    { if ((yyvsp[(1) - (1)].unumber)>=ki.nmotions) yyerrorf("Invalid motion index (%u/%u)",(yyvsp[(1) - (1)].unumber),ki.nmotions); (yyval.number)=(yyvsp[(1) - (1)].unumber); }
    break;

  case 125:

/* Line 1455 of yacc.c  */
#line 2407 "kate_parser.y"
    { (yyval.number)=find_palette(&ki,(yyvsp[(1) - (1)].string)); }
    break;

  case 126:

/* Line 1455 of yacc.c  */
#line 2408 "kate_parser.y"
    { if ((yyvsp[(1) - (1)].unumber)>=ki.npalettes) yyerrorf("Invalid palette index (%u/%u)",(yyvsp[(1) - (1)].unumber),ki.npalettes); (yyval.number)=(yyvsp[(1) - (1)].unumber); }
    break;

  case 127:

/* Line 1455 of yacc.c  */
#line 2411 "kate_parser.y"
    { (yyval.number)=find_bitmap(&ki,(yyvsp[(1) - (1)].string)); }
    break;

  case 128:

/* Line 1455 of yacc.c  */
#line 2412 "kate_parser.y"
    { if ((yyvsp[(1) - (1)].unumber)>=ki.nbitmaps) yyerrorf("Invalid bitmap index (%u/%u)",(yyvsp[(1) - (1)].unumber),ki.nbitmaps); (yyval.number)=(yyvsp[(1) - (1)].unumber); }
    break;

  case 129:

/* Line 1455 of yacc.c  */
#line 2415 "kate_parser.y"
    { (yyval.number)=find_font_range(&ki,(yyvsp[(1) - (1)].string)); }
    break;

  case 130:

/* Line 1455 of yacc.c  */
#line 2416 "kate_parser.y"
    { if ((yyvsp[(1) - (1)].unumber)>=ki.nfont_ranges) yyerrorf("Invalid font range index (%u/%u)",(yyvsp[(1) - (1)].unumber),ki.nfont_ranges); (yyval.number)=(yyvsp[(1) - (1)].unumber); }
    break;

  case 131:

/* Line 1455 of yacc.c  */
#line 2419 "kate_parser.y"
    { (yyval.number)=find_font_mapping(&ki,(yyvsp[(1) - (1)].string)); }
    break;

  case 132:

/* Line 1455 of yacc.c  */
#line 2420 "kate_parser.y"
    { if ((yyvsp[(1) - (1)].unumber)>=ki.nfont_mappings) yyerrorf("Invalid font mapping index (%u/%u)",(yyvsp[(1) - (1)].unumber),ki.nfont_mappings); (yyval.number)=(yyvsp[(1) - (1)].unumber); }
    break;

  case 133:

/* Line 1455 of yacc.c  */
#line 2423 "kate_parser.y"
    { reference_curve_from((yyvsp[(1) - (1)].number)); }
    break;

  case 134:

/* Line 1455 of yacc.c  */
#line 2424 "kate_parser.y"
    { init_curve(); }
    break;

  case 135:

/* Line 1455 of yacc.c  */
#line 2424 "kate_parser.y"
    {}
    break;

  case 136:

/* Line 1455 of yacc.c  */
#line 2425 "kate_parser.y"
    { init_curve_from((yyvsp[(1) - (1)].number)); }
    break;

  case 137:

/* Line 1455 of yacc.c  */
#line 2425 "kate_parser.y"
    {}
    break;

  case 138:

/* Line 1455 of yacc.c  */
#line 2429 "kate_parser.y"
    { (yyval.fp)=(yyvsp[(1) - (1)].fp); }
    break;

  case 139:

/* Line 1455 of yacc.c  */
#line 2430 "kate_parser.y"
    { (yyval.fp)=(kate_float)(yyvsp[(1) - (1)].unumber); }
    break;

  case 140:

/* Line 1455 of yacc.c  */
#line 2431 "kate_parser.y"
    { (yyval.fp)=(kate_float)(yyvsp[(1) - (1)].number); }
    break;

  case 141:

/* Line 1455 of yacc.c  */
#line 2434 "kate_parser.y"
    { (yyval.number)=(yyvsp[(1) - (1)].unumber); }
    break;

  case 142:

/* Line 1455 of yacc.c  */
#line 2435 "kate_parser.y"
    { (yyval.number)=(yyvsp[(1) - (1)].number); }
    break;

  case 143:

/* Line 1455 of yacc.c  */
#line 2436 "kate_parser.y"
    { (yyval.number)=compute_bitmap_x_offset((yyvsp[(1) - (2)].fp)); }
    break;

  case 144:

/* Line 1455 of yacc.c  */
#line 2439 "kate_parser.y"
    { (yyval.number)=(yyvsp[(1) - (1)].unumber); }
    break;

  case 145:

/* Line 1455 of yacc.c  */
#line 2440 "kate_parser.y"
    { (yyval.number)=(yyvsp[(1) - (1)].number); }
    break;

  case 146:

/* Line 1455 of yacc.c  */
#line 2441 "kate_parser.y"
    { (yyval.number)=compute_bitmap_y_offset((yyvsp[(1) - (2)].fp)); }
    break;

  case 147:

/* Line 1455 of yacc.c  */
#line 2444 "kate_parser.y"
    { (yyval.fp)=(yyvsp[(1) - (5)].unumber)*3600+(yyvsp[(3) - (5)].unumber)*60+(yyvsp[(5) - (5)].fp); }
    break;

  case 148:

/* Line 1455 of yacc.c  */
#line 2445 "kate_parser.y"
    { (yyval.fp)=(yyvsp[(1) - (3)].unumber)*60+(yyvsp[(3) - (3)].fp); }
    break;

  case 149:

/* Line 1455 of yacc.c  */
#line 2446 "kate_parser.y"
    { (yyval.fp)=(yyvsp[(1) - (1)].fp); }
    break;

  case 151:

/* Line 1455 of yacc.c  */
#line 2450 "kate_parser.y"
    {}
    break;

  case 152:

/* Line 1455 of yacc.c  */
#line 2453 "kate_parser.y"
    { init_event(&kevent); }
    break;

  case 153:

/* Line 1455 of yacc.c  */
#line 2453 "kate_parser.y"
    {
            check_event(&kevent); kd_encode_text(&k,&kevent); clear_event(&kevent);
          }
    break;

  case 154:

/* Line 1455 of yacc.c  */
#line 2456 "kate_parser.y"
    { init_event(&kevent); }
    break;

  case 155:

/* Line 1455 of yacc.c  */
#line 2456 "kate_parser.y"
    {
            check_event(&kevent); kd_encode_text(&k,&kevent); clear_event(&kevent);
          }
    break;

  case 157:

/* Line 1455 of yacc.c  */
#line 2462 "kate_parser.y"
    {}
    break;

  case 158:

/* Line 1455 of yacc.c  */
#line 2465 "kate_parser.y"
    { kd_encode_set_id(&k,(yyvsp[(2) - (2)].unumber)); }
    break;

  case 159:

/* Line 1455 of yacc.c  */
#line 2466 "kate_parser.y"
    { kd_encode_set_language(&k,(yyvsp[(2) - (2)].string)); }
    break;

  case 160:

/* Line 1455 of yacc.c  */
#line 2467 "kate_parser.y"
    { CHECK_KATE_API_ERROR(kate_encode_set_text_directionality(&k,(yyvsp[(2) - (2)].number))); }
    break;

  case 161:

/* Line 1455 of yacc.c  */
#line 2468 "kate_parser.y"
    { set_event_t0(&kevent,(yyvsp[(3) - (3)].fp)); }
    break;

  case 162:

/* Line 1455 of yacc.c  */
#line 2469 "kate_parser.y"
    { set_event_t1(&kevent,(yyvsp[(3) - (3)].fp)); }
    break;

  case 163:

/* Line 1455 of yacc.c  */
#line 2470 "kate_parser.y"
    { set_event_t0(&kevent,(yyvsp[(3) - (3)].fp)); }
    break;

  case 164:

/* Line 1455 of yacc.c  */
#line 2471 "kate_parser.y"
    { set_event_t1(&kevent,(yyvsp[(3) - (3)].fp)); }
    break;

  case 165:

/* Line 1455 of yacc.c  */
#line 2472 "kate_parser.y"
    { set_event_t0_t1(&kevent,(yyvsp[(2) - (4)].fp),(yyvsp[(4) - (4)].fp)); }
    break;

  case 166:

/* Line 1455 of yacc.c  */
#line 2473 "kate_parser.y"
    { set_event_duration(&kevent,(yyvsp[(2) - (2)].fp)); }
    break;

  case 167:

/* Line 1455 of yacc.c  */
#line 2474 "kate_parser.y"
    { set_event_t0(&kevent,(yyvsp[(2) - (4)].fp)); set_event_duration(&kevent,(yyvsp[(4) - (4)].fp)); }
    break;

  case 168:

/* Line 1455 of yacc.c  */
#line 2475 "kate_parser.y"
    { set_event_t0_t1(&kevent,(yyvsp[(1) - (3)].fp),(yyvsp[(3) - (3)].fp)); }
    break;

  case 169:

/* Line 1455 of yacc.c  */
#line 2476 "kate_parser.y"
    { set_event_region_index(&kevent,(yyvsp[(2) - (2)].number)); }
    break;

  case 170:

/* Line 1455 of yacc.c  */
#line 2477 "kate_parser.y"
    { init_region_from((yyvsp[(2) - (2)].number)); }
    break;

  case 171:

/* Line 1455 of yacc.c  */
#line 2478 "kate_parser.y"
    { set_event_region(&kevent,&kregion); }
    break;

  case 172:

/* Line 1455 of yacc.c  */
#line 2479 "kate_parser.y"
    { init_region(&kregion); }
    break;

  case 173:

/* Line 1455 of yacc.c  */
#line 2479 "kate_parser.y"
    { set_event_region(&kevent,&kregion); }
    break;

  case 174:

/* Line 1455 of yacc.c  */
#line 2481 "kate_parser.y"
    { if ((yyvsp[(1) - (3)].number)) set_event_secondary_style_index(&kevent,(yyvsp[(3) - (3)].number)); else set_event_style_index(&kevent,(yyvsp[(3) - (3)].number)); }
    break;

  case 175:

/* Line 1455 of yacc.c  */
#line 2482 "kate_parser.y"
    {init_style_from((yyvsp[(3) - (3)].number)); }
    break;

  case 176:

/* Line 1455 of yacc.c  */
#line 2483 "kate_parser.y"
    { if ((yyvsp[(1) - (7)].number)) set_event_secondary_style(&kevent,&kstyle); else set_event_style(&kevent,&kstyle); }
    break;

  case 177:

/* Line 1455 of yacc.c  */
#line 2484 "kate_parser.y"
    { init_style(&kstyle); }
    break;

  case 178:

/* Line 1455 of yacc.c  */
#line 2485 "kate_parser.y"
    { if ((yyvsp[(1) - (6)].number)) set_event_secondary_style(&kevent,&kstyle); else set_event_style(&kevent,&kstyle); }
    break;

  case 179:

/* Line 1455 of yacc.c  */
#line 2486 "kate_parser.y"
    { set_event_text(&kevent,(yyvsp[(2) - (2)].dynstring),0,0); kate_free((yyvsp[(2) - (2)].dynstring)); }
    break;

  case 180:

/* Line 1455 of yacc.c  */
#line 2487 "kate_parser.y"
    { set_event_text(&kevent,(yyvsp[(3) - (3)].dynstring),1,0); kate_free((yyvsp[(3) - (3)].dynstring)); }
    break;

  case 181:

/* Line 1455 of yacc.c  */
#line 2488 "kate_parser.y"
    { set_event_text(&kevent,(yyvsp[(2) - (2)].dynstring),0,1); kate_free((yyvsp[(2) - (2)].dynstring)); }
    break;

  case 182:

/* Line 1455 of yacc.c  */
#line 2489 "kate_parser.y"
    { set_event_text(&kevent,(yyvsp[(3) - (3)].dynstring),1,1); kate_free((yyvsp[(3) - (3)].dynstring)); }
    break;

  case 183:

/* Line 1455 of yacc.c  */
#line 2490 "kate_parser.y"
    { set_event_text_from(&kevent,(yyvsp[(3) - (3)].string),0,0); }
    break;

  case 184:

/* Line 1455 of yacc.c  */
#line 2491 "kate_parser.y"
    { set_event_text_from(&kevent,(yyvsp[(4) - (4)].string),1,0); }
    break;

  case 185:

/* Line 1455 of yacc.c  */
#line 2492 "kate_parser.y"
    { set_event_text_from(&kevent,(yyvsp[(3) - (3)].string),0,1); }
    break;

  case 186:

/* Line 1455 of yacc.c  */
#line 2493 "kate_parser.y"
    { set_event_text_from(&kevent,(yyvsp[(4) - (4)].string),1,1); }
    break;

  case 187:

/* Line 1455 of yacc.c  */
#line 2494 "kate_parser.y"
    { set_event_text(&kevent,(yyvsp[(1) - (1)].dynstring),0,0); kate_free((yyvsp[(1) - (1)].dynstring)); }
    break;

  case 188:

/* Line 1455 of yacc.c  */
#line 2495 "kate_parser.y"
    { init_motion(); }
    break;

  case 189:

/* Line 1455 of yacc.c  */
#line 2495 "kate_parser.y"
    { kd_add_event_motion(kmotion); }
    break;

  case 190:

/* Line 1455 of yacc.c  */
#line 2496 "kate_parser.y"
    { kd_add_event_motion_index((yyvsp[(2) - (2)].number)); }
    break;

  case 191:

/* Line 1455 of yacc.c  */
#line 2497 "kate_parser.y"
    {init_simple_glyph_pointer_motion(); }
    break;

  case 192:

/* Line 1455 of yacc.c  */
#line 2498 "kate_parser.y"
    { kd_finalize_simple_timed_glyph_motion(kmotion); kd_add_event_motion(kmotion); }
    break;

  case 193:

/* Line 1455 of yacc.c  */
#line 2499 "kate_parser.y"
    {init_simple_glyph_pointer_motion(); }
    break;

  case 194:

/* Line 1455 of yacc.c  */
#line 2500 "kate_parser.y"
    { kd_finalize_simple_timed_glyph_motion(kmotion); kd_add_event_motion(kmotion); }
    break;

  case 195:

/* Line 1455 of yacc.c  */
#line 2501 "kate_parser.y"
    { CHECK_KATE_API_ERROR(kate_encode_set_font_mapping_index(&k,(yyvsp[(3) - (3)].number))); }
    break;

  case 196:

/* Line 1455 of yacc.c  */
#line 2502 "kate_parser.y"
    { set_event_palette_index(&kevent,(yyvsp[(2) - (2)].number)); }
    break;

  case 197:

/* Line 1455 of yacc.c  */
#line 2503 "kate_parser.y"
    { init_palette(); }
    break;

  case 198:

/* Line 1455 of yacc.c  */
#line 2503 "kate_parser.y"
    { set_event_palette(&kevent,kpalette.palette); }
    break;

  case 199:

/* Line 1455 of yacc.c  */
#line 2504 "kate_parser.y"
    { set_event_bitmap_index(&kevent,(yyvsp[(2) - (2)].number)); }
    break;

  case 200:

/* Line 1455 of yacc.c  */
#line 2505 "kate_parser.y"
    { init_bitmap(); }
    break;

  case 201:

/* Line 1455 of yacc.c  */
#line 2505 "kate_parser.y"
    { set_event_bitmap(&kevent,kbitmap.bitmap); }
    break;

  case 202:

/* Line 1455 of yacc.c  */
#line 2506 "kate_parser.y"
    {init_bitmap();}
    break;

  case 203:

/* Line 1455 of yacc.c  */
#line 2506 "kate_parser.y"
    { add_local_bitmap(&k,(yyvsp[(4) - (8)].string),kbitmap.bitmap); }
    break;

  case 204:

/* Line 1455 of yacc.c  */
#line 2507 "kate_parser.y"
    { add_local_bitmap_index(&k,(yyvsp[(4) - (6)].string),(yyvsp[(6) - (6)].number)); }
    break;

  case 205:

/* Line 1455 of yacc.c  */
#line 2510 "kate_parser.y"
    { (yyval.number)=1; }
    break;

  case 206:

/* Line 1455 of yacc.c  */
#line 2511 "kate_parser.y"
    { (yyval.number)=0; }
    break;

  case 207:

/* Line 1455 of yacc.c  */
#line 2514 "kate_parser.y"
    { (yyval.dynstring)=catstrings((yyvsp[(1) - (3)].dynstring),(yyvsp[(3) - (3)].string)); }
    break;

  case 208:

/* Line 1455 of yacc.c  */
#line 2515 "kate_parser.y"
    { (yyval.dynstring)=catstrings(NULL,(yyvsp[(1) - (1)].string)); }
    break;

  case 210:

/* Line 1455 of yacc.c  */
#line 2519 "kate_parser.y"
    {}
    break;

  case 211:

/* Line 1455 of yacc.c  */
#line 2522 "kate_parser.y"
    { set_motion_mapping(kmotion,(yyvsp[(2) - (2)].number),(yyvsp[(2) - (2)].number)); }
    break;

  case 212:

/* Line 1455 of yacc.c  */
#line 2523 "kate_parser.y"
    { set_motion_mapping(kmotion,(yyvsp[(2) - (3)].number),(yyvsp[(3) - (3)].number)); }
    break;

  case 213:

/* Line 1455 of yacc.c  */
#line 2524 "kate_parser.y"
    { set_motion_semantics(kmotion,(yyvsp[(2) - (2)].number)); }
    break;

  case 214:

/* Line 1455 of yacc.c  */
#line 2525 "kate_parser.y"
    { add_curve_to_motion(kmotion,(yyvsp[(3) - (3)].fp)); }
    break;

  case 215:

/* Line 1455 of yacc.c  */
#line 2526 "kate_parser.y"
    { kmotion->periodic=1; }
    break;

  case 216:

/* Line 1455 of yacc.c  */
#line 2529 "kate_parser.y"
    { (yyval.fp)=(yyvsp[(2) - (2)].fp); }
    break;

  case 217:

/* Line 1455 of yacc.c  */
#line 2530 "kate_parser.y"
    { (yyval.fp)=-(yyvsp[(2) - (3)].fp)/(kate_float)100.0; }
    break;

  case 218:

/* Line 1455 of yacc.c  */
#line 2531 "kate_parser.y"
    { (yyval.fp)=-(yyvsp[(2) - (3)].fp)/(kate_float)1000000.0; }
    break;

  case 219:

/* Line 1455 of yacc.c  */
#line 2532 "kate_parser.y"
    { (yyval.fp)=(kate_float)-1.0; }
    break;

  case 220:

/* Line 1455 of yacc.c  */
#line 2535 "kate_parser.y"
    { (yyval.number)=kate_motion_mapping_none; }
    break;

  case 221:

/* Line 1455 of yacc.c  */
#line 2536 "kate_parser.y"
    { (yyval.number)=kate_motion_mapping_frame; }
    break;

  case 222:

/* Line 1455 of yacc.c  */
#line 2537 "kate_parser.y"
    { (yyval.number)=kate_motion_mapping_region; }
    break;

  case 223:

/* Line 1455 of yacc.c  */
#line 2538 "kate_parser.y"
    { (yyval.number)=kate_motion_mapping_event_duration; }
    break;

  case 224:

/* Line 1455 of yacc.c  */
#line 2539 "kate_parser.y"
    { (yyval.number)=kate_motion_mapping_bitmap_size; }
    break;

  case 225:

/* Line 1455 of yacc.c  */
#line 2540 "kate_parser.y"
    {
                     if ((yyvsp[(2) - (2)].unumber)<kate_motion_mapping_user) yyerrorf("invalid value for user motion mapping (%u), should be 128 or more",(yyvsp[(2) - (2)].unumber));
                     (yyval.number)=(kate_motion_mapping)(yyvsp[(2) - (2)].unumber);
                   }
    break;

  case 226:

/* Line 1455 of yacc.c  */
#line 2546 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_time; }
    break;

  case 227:

/* Line 1455 of yacc.c  */
#line 2547 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_region_position; }
    break;

  case 228:

/* Line 1455 of yacc.c  */
#line 2548 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_region_size; }
    break;

  case 229:

/* Line 1455 of yacc.c  */
#line 2549 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_text_alignment_int; }
    break;

  case 230:

/* Line 1455 of yacc.c  */
#line 2550 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_text_alignment_int; }
    break;

  case 231:

/* Line 1455 of yacc.c  */
#line 2551 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_text_alignment_ext; }
    break;

  case 232:

/* Line 1455 of yacc.c  */
#line 2552 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_text_position; }
    break;

  case 233:

/* Line 1455 of yacc.c  */
#line 2553 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_text_size; }
    break;

  case 234:

/* Line 1455 of yacc.c  */
#line 2554 "kate_parser.y"
    { (yyval.number)=kd_get_marker_position_semantics((yyvsp[(2) - (3)].unumber)); }
    break;

  case 235:

/* Line 1455 of yacc.c  */
#line 2555 "kate_parser.y"
    { (yyval.number)=kd_get_glyph_pointer_semantics((yyvsp[(3) - (3)].unumber)); }
    break;

  case 236:

/* Line 1455 of yacc.c  */
#line 2556 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_text_color_rg; }
    break;

  case 237:

/* Line 1455 of yacc.c  */
#line 2557 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_text_color_ba; }
    break;

  case 238:

/* Line 1455 of yacc.c  */
#line 2558 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_background_color_rg; }
    break;

  case 239:

/* Line 1455 of yacc.c  */
#line 2559 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_background_color_ba; }
    break;

  case 240:

/* Line 1455 of yacc.c  */
#line 2560 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_draw_color_rg; }
    break;

  case 241:

/* Line 1455 of yacc.c  */
#line 2561 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_draw_color_ba; }
    break;

  case 242:

/* Line 1455 of yacc.c  */
#line 2562 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_style_morph; }
    break;

  case 243:

/* Line 1455 of yacc.c  */
#line 2563 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_text_path; }
    break;

  case 244:

/* Line 1455 of yacc.c  */
#line 2564 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_text_path_section; }
    break;

  case 245:

/* Line 1455 of yacc.c  */
#line 2565 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_draw; }
    break;

  case 246:

/* Line 1455 of yacc.c  */
#line 2566 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_text_visible_section; }
    break;

  case 247:

/* Line 1455 of yacc.c  */
#line 2567 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_z; }
    break;

  case 248:

/* Line 1455 of yacc.c  */
#line 2568 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_horizontal_margins; }
    break;

  case 249:

/* Line 1455 of yacc.c  */
#line 2569 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_vertical_margins; }
    break;

  case 250:

/* Line 1455 of yacc.c  */
#line 2570 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_bitmap_position; }
    break;

  case 251:

/* Line 1455 of yacc.c  */
#line 2571 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_bitmap_size; }
    break;

  case 252:

/* Line 1455 of yacc.c  */
#line 2572 "kate_parser.y"
    { (yyval.number)=kd_get_marker_bitmap_semantics((yyvsp[(2) - (3)].unumber)); }
    break;

  case 253:

/* Line 1455 of yacc.c  */
#line 2573 "kate_parser.y"
    { (yyval.number)=kd_get_glyph_pointer_bitmap_semantics((yyvsp[(3) - (4)].unumber)); }
    break;

  case 254:

/* Line 1455 of yacc.c  */
#line 2574 "kate_parser.y"
    { (yyval.number)=kate_motion_semantics_draw_width; }
    break;

  case 255:

/* Line 1455 of yacc.c  */
#line 2575 "kate_parser.y"
    {
                       if ((yyvsp[(2) - (2)].unumber)<kate_motion_semantics_user) yyerrorf("invalid value for user motion semantics (%u), should be 128 or more",(yyvsp[(2) - (2)].unumber));
                       (yyval.number)=(kate_motion_semantics)(yyvsp[(2) - (2)].unumber);
                     }
    break;

  case 257:

/* Line 1455 of yacc.c  */
#line 2582 "kate_parser.y"
    {}
    break;

  case 258:

/* Line 1455 of yacc.c  */
#line 2585 "kate_parser.y"
    { kmotion->semantics=get_glyph_pointer_offset((yyvsp[(3) - (3)].unumber)); }
    break;

  case 259:

/* Line 1455 of yacc.c  */
#line 2586 "kate_parser.y"
    { kmotion->y_mapping=(yyvsp[(3) - (3)].number); }
    break;

  case 260:

/* Line 1455 of yacc.c  */
#line 2587 "kate_parser.y"
    { karaoke_base_height=(yyvsp[(3) - (5)].fp); karaoke_top_height=(yyvsp[(5) - (5)].fp); }
    break;

  case 261:

/* Line 1455 of yacc.c  */
#line 2588 "kate_parser.y"
    { add_glyph_pause((yyvsp[(3) - (3)].fp),(kate_float)0.0); }
    break;

  case 262:

/* Line 1455 of yacc.c  */
#line 2589 "kate_parser.y"
    { add_glyph_transition((yyvsp[(2) - (4)].unumber),(yyvsp[(4) - (4)].fp),(kate_float)0.0,(kate_float)1.0,0,(kate_float)0.0); }
    break;

  case 263:

/* Line 1455 of yacc.c  */
#line 2590 "kate_parser.y"
    { add_glyph_transition((yyvsp[(2) - (4)].unumber),(yyvsp[(4) - (4)].fp),(kate_float)0.0,(kate_float)1.0,1,(kate_float)0.0); }
    break;

  case 265:

/* Line 1455 of yacc.c  */
#line 2594 "kate_parser.y"
    {}
    break;

  case 266:

/* Line 1455 of yacc.c  */
#line 2597 "kate_parser.y"
    { kmotion->semantics=get_glyph_pointer_offset((yyvsp[(3) - (3)].unumber)); }
    break;

  case 267:

/* Line 1455 of yacc.c  */
#line 2599 "kate_parser.y"
    { set_style_morph(&kevent,(yyvsp[(3) - (6)].number),(yyvsp[(6) - (6)].number)); }
    break;

  case 268:

/* Line 1455 of yacc.c  */
#line 2600 "kate_parser.y"
    { add_glyph_pause((yyvsp[(3) - (3)].fp),(kate_float)0.0); }
    break;

  case 269:

/* Line 1455 of yacc.c  */
#line 2601 "kate_parser.y"
    { add_glyph_transition((yyvsp[(2) - (4)].unumber),(yyvsp[(4) - (4)].fp),(kate_float)0.0,(kate_float)0.0,0,(kate_float)1.0); }
    break;

  case 270:

/* Line 1455 of yacc.c  */
#line 2602 "kate_parser.y"
    { add_glyph_transition((yyvsp[(2) - (4)].unumber),(yyvsp[(4) - (4)].fp),(kate_float)0.0,(kate_float)0.0,1,(kate_float)1.0); }
    break;

  case 271:

/* Line 1455 of yacc.c  */
#line 2603 "kate_parser.y"
    { add_glyph_transition_to_text((yyvsp[(1) - (3)].string),(yyvsp[(3) - (3)].fp),(kate_float)0.0,(kate_float)0.0,0,(kate_float)1.0); }
    break;

  case 272:

/* Line 1455 of yacc.c  */
#line 2604 "kate_parser.y"
    { add_glyph_transition_to_text((yyvsp[(1) - (3)].string),(yyvsp[(3) - (3)].fp),(kate_float)0.0,(kate_float)0.0,1,(kate_float)1.0); }
    break;

  case 273:

/* Line 1455 of yacc.c  */
#line 2607 "kate_parser.y"
    { if ((yyvsp[(1) - (1)].unumber)>59) yyerrorf("Value must be between 0 and 59, but is %u",(yyvsp[(1) - (1)].unumber)); }
    break;

  case 274:

/* Line 1455 of yacc.c  */
#line 2607 "kate_parser.y"
    { (yyval.unumber)=(yyvsp[(1) - (2)].unumber); }
    break;

  case 275:

/* Line 1455 of yacc.c  */
#line 2610 "kate_parser.y"
    { if ((yyvsp[(1) - (1)].fp)<(kate_float)0.0 || (yyvsp[(1) - (1)].fp)>=(kate_float)60.0) yyerrorf("Value must be between 0 (inclusive) and 60 (exclusive), but is %f",(yyvsp[(1) - (1)].fp)); }
    break;

  case 276:

/* Line 1455 of yacc.c  */
#line 2610 "kate_parser.y"
    { (yyval.fp)=(yyvsp[(1) - (2)].fp); }
    break;

  case 277:

/* Line 1455 of yacc.c  */
#line 2613 "kate_parser.y"
    {}
    break;

  case 278:

/* Line 1455 of yacc.c  */
#line 2614 "kate_parser.y"
    {}
    break;

  case 279:

/* Line 1455 of yacc.c  */
#line 2617 "kate_parser.y"
    { (yyval.number)=kate_l2r_t2b; }
    break;

  case 280:

/* Line 1455 of yacc.c  */
#line 2618 "kate_parser.y"
    { (yyval.number)=kate_r2l_t2b; }
    break;

  case 281:

/* Line 1455 of yacc.c  */
#line 2619 "kate_parser.y"
    { (yyval.number)=kate_t2b_r2l; }
    break;

  case 282:

/* Line 1455 of yacc.c  */
#line 2620 "kate_parser.y"
    { (yyval.number)=kate_t2b_l2r; }
    break;

  case 284:

/* Line 1455 of yacc.c  */
#line 2624 "kate_parser.y"
    {}
    break;

  case 285:

/* Line 1455 of yacc.c  */
#line 2627 "kate_parser.y"
    { set_font_range_first_code_point_string((yyvsp[(4) - (4)].string)); }
    break;

  case 286:

/* Line 1455 of yacc.c  */
#line 2628 "kate_parser.y"
    { set_font_range_first_code_point((yyvsp[(4) - (4)].unumber)); }
    break;

  case 287:

/* Line 1455 of yacc.c  */
#line 2629 "kate_parser.y"
    { set_font_range_last_code_point_string((yyvsp[(4) - (4)].string)); }
    break;

  case 288:

/* Line 1455 of yacc.c  */
#line 2630 "kate_parser.y"
    { set_font_range_last_code_point((yyvsp[(4) - (4)].unumber)); }
    break;

  case 289:

/* Line 1455 of yacc.c  */
#line 2631 "kate_parser.y"
    { set_font_range_first_bitmap((yyvsp[(3) - (3)].number)); }
    break;

  case 291:

/* Line 1455 of yacc.c  */
#line 2635 "kate_parser.y"
    {}
    break;

  case 292:

/* Line 1455 of yacc.c  */
#line 2638 "kate_parser.y"
    {init_font_range();}
    break;

  case 293:

/* Line 1455 of yacc.c  */
#line 2638 "kate_parser.y"
    { add_font_range_to_mapping(); }
    break;

  case 294:

/* Line 1455 of yacc.c  */
#line 2639 "kate_parser.y"
    { krange=ki.font_ranges[(yyvsp[(2) - (2)].number)]; add_font_range_to_mapping(); }
    break;



/* Line 1455 of yacc.c  */
#line 6244 "kate_parser.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 1675 of yacc.c  */
#line 2642 "kate_parser.y"



