//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

extern "C" {
#include <libexif/exif-entry.h>
#include <stdlib.h>
}

#include "kexifentry.h"

KExifEntry::KExifEntry()
{
    mExifEntry = 0;
    mName  = "";
    mTitle = "";
    mValue = "";
    mDescription = "";
}

KExifEntry::KExifEntry(ExifEntry* exifEntry)
{
    mExifEntry = 0;
    mName  = "";
    mTitle = "";
    mValue = "";
    mDescription = "";

    if (exifEntry) {
        setEntry(exifEntry);
    }

}

KExifEntry::~KExifEntry()
{
    if (mExifEntry)
        exif_entry_unref(mExifEntry);
}

KExifEntry::KExifEntry(const KExifEntry& entry)
{
    if (this != &entry) {
        setEntry(entry.mExifEntry);
    }
}

KExifEntry& KExifEntry::operator=(const KExifEntry& entry)
{
    if (this != &entry) {
        setEntry(entry.mExifEntry);
    }
    return (*this);
}

void KExifEntry::setEntry(ExifEntry* exifEntry)
{
    if (exifEntry) {

        if (mExifEntry) {
            exif_entry_unref(mExifEntry);
            mExifEntry = 0;
        }

        mExifEntry = exifEntry;
        exif_entry_ref(mExifEntry);

        readEntry();
    }
}

void KExifEntry::readEntry()
{
    mName  = QString(exif_tag_get_name(mExifEntry->tag));
    mTitle = QString::fromUtf8(exif_tag_get_title(mExifEntry->tag));
    mDescription = QString::fromUtf8(exif_tag_get_description(mExifEntry->tag));

#ifdef HAVE_EXIF06
    char val[1024];
    exif_entry_get_value(mExifEntry, val, 1023);
    // just in case we don't get a null-terminated string
    val[1024] = '\0'; 
    mValue = QString::fromUtf8((const char*)&val);
#else
    mValue = QString::fromUtf8(exif_entry_get_value(mExifEntry));
#endif
}

QString KExifEntry::getName() const
{
    return mName;
}

QString KExifEntry::getTitle() const
{
    return mTitle;
}

QString KExifEntry::getValue() const
{
    return mValue;
}

QString KExifEntry::getDescription() const
{
    return mDescription;
}

