/*
 * Copyright (C) 2012  Christian Mollekopf <mollekopf@kolabsys.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "calendaring.h"

#include <kcalcore/event.h>
#include <KDE/KCalCore/Todo>
#include <Qt/qdebug.h>

#include "kolabkcalconversion.h"

namespace Kolab {

    namespace Calendaring {

        bool conflicts(const Kolab::Event &e1, const Kolab::Event &e2)
        {
            KCalCore::Event::Ptr k1 = KCalConversion::toKCalCore(e1);
            KCalCore::Event::Ptr k2 = KCalConversion::toKCalCore(e2);
            if (k2->dtEnd().compare(k1->dtStart()) == KDateTime::Before) {
                return false;
            } else if (k1->dtEnd().compare(k2->dtStart()) == KDateTime::Before) {
                return false;
            }
            return true;
        }

        std::vector<Kolab::cDateTime> timeInInterval(const Kolab::Event &e, const Kolab::cDateTime &start, const Kolab::cDateTime &end)
        {
            KCalCore::Event::Ptr k = KCalConversion::toKCalCore(e);
            KCalCore::DateTimeList list = k->recurrence()->timesInInterval(KCalConversion::toDate(start), KCalConversion::toDate(end));
            std::vector<Kolab::cDateTime> dtList;
            foreach(const KDateTime &dt, list) {
                dtList.push_back(KCalConversion::fromDate(dt));
            }
            return dtList;
        }

    } //Namespace
} //Namespace