/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef LINGDEFS_H
#define LINGDEFS_H 1

#include <libxml/xpath.h>

#ifndef FALSE
#define FALSE (0)
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif

/**
 * \typedef lingbool
 *
 * This is a special defined boolean value - 
 * can return TRUE and FALSE (and should only be used with those both types!)
 */ 
typedef int lingbool;

/**
 * \typedef lingchar
 *
 * This is a unsigned char to hold UTF-8 encoded characters.
 */
typedef unsigned char lingchar;

/**
 * \struct lingConfig
 *
 * A structure for configuration settings 
 */
typedef struct 
{
  lingchar *appname;  /**< The name of the application */
  char     *langfile; /**< The file with the languages */
} lingConfig;

/**
 * \struct lingLesson
 *
 * A public lesson list structure
 */
typedef struct _lingLesson lingLesson;
struct _lingLesson
{
  void       *pdata;    /**< Private data, which should not be modified! */
  lingchar   *type;     /**< The type of the lesson */
  lingLesson *next;     /**< Pointer to the next lesson */
};

/**
 * \struct lingMeaning
 *
 * The structure of a meaning
 */
typedef struct _lingMeaning lingMeaning;
struct _lingMeaning
{
  int  		id;          /**< ID of the Meaning (123) */
  lingchar     *type;        /**< Type of the meaning (object, question, etc.) */
  lingchar     *language;    /**< Translation language (e.g "spanish") */
  lingchar     *translation; /**< The translation text (e.g. "food") */
  lingchar     *description; /**< The description of the meaning */
  lingLesson   *lesson;      /**< The lesson the translation was taken from */
  lingMeaning  *next;        /**< The next meaning in the list */
  lingMeaning  *prev;        /**< The previous meaning in the list */
};

/** 
 * \enum Method
 * 
 * A list of different word choosing methods.
 */
typedef enum
  {
    RANDOM,   /**< Random choosing from 0 to max. possible id */
    SEQUENCE, /**< One after each other */
    REVIEW,   /**< Selects words, which are not well known by the user */
    LEARN     /**< A learn method - for saving statistics */
  } Method;


#endif /* LINGDEFS_H */
