/*  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#ifndef LING_MEANING_H
#define LING_MEANING_H 1

#include "lesson.h"

/*
 * searches the word, which matches int meaning, in the language, which is 
 * given as char* language
 */
lingchar*
meaning_find_word (int id, lingchar *language, lessonData *lesson);

/*
 * searches the sound matching the meaningId id and language
 */
char*
meaning_find_sound (char *soundpath, int id, lingchar *language, 
		    lingLesson *lesson);

/*
 * returns the type of a meaning
 */
lingchar* 
meaning_get_type (int id, lessonData *lesson);

/*
 * returns a possible description of the meaning in the given language
 */
lingchar* 
meaning_get_description (int id, lingchar *language, lessonData *lesson);

/*
 * internal helper for getting the maximum possible id
 */
int 
meaning_get_max_overall (lingLesson *lesson);

/* 
 * creates a new node tree of meanings
 */
xmlNodePtr
meaning_create_node_tree (lingMeaning *meaning, xmlNodePtr parent);

#endif /* LING_MEANING_H */
