/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.  
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details.  
 *
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include "lingoteach.h"

#define OUTPUT "Data after %s Tier %i is %s...\n"

int 
main (int argc, char *argv[])
{
  char *langfile[2] = { "language.xml", "none.xml" };
  char *appname[2]  = { "test", "invalid test" };
  
  lingConfig *test = ling_conf_init_config ();
  lingConfig *tmp;  
  /*
   * ling_conf_set_app_name
   */
  test = ling_conf_set_app_name (test, appname[0]);
  if ((test = ling_conf_set_app_name (test, appname[0])) != NULL)
    printf (OUTPUT, "ling_conf_set_app_name", 0, test->appname);
  
  if ((test = ling_conf_set_app_name (test, appname[1])) != NULL)
    printf (OUTPUT, "ling_conf_set_app_name", 1, test->appname);

  tmp = test;
  if ((test = ling_conf_set_app_name (test, NULL)) == NULL)
    printf (OUTPUT, "ling_conf_set_app_name", 2, "NULL");
  test = tmp;
  
  /*
   * ling_conf_set_lang_file
   */
  
  if ((test = ling_conf_set_lang_file (test, langfile[0])) != NULL)
    printf (OUTPUT, "ling_conf_set_lang_file", 0, test->langfile);
    
  if ((test = ling_conf_set_lang_file (test, langfile[1])) != NULL)
    printf (OUTPUT, "ling_conf_set_lang_file", 1, test->langfile);

  tmp = test;
  if ((test = ling_conf_set_lang_file (test, NULL)) == NULL)
    printf (OUTPUT, "ling_conf_set_lang_file", 2, "NULL");
  test = tmp;
  
  free (test);
  
  return 0;
}
