/**************************************************************************

			Software Library Lip
			   
    begin                : April 30 2004
	version				 : 1.0 
    copyright            : (C) 2004 by Gleb Beliakov
    email                : gleb@deakin.edu.au


    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


 ***************************************************************************/

#include "intwrapper.h"
#include "interpol.h"

// global variables

// an instance of the interpolant class
STCInterpolant gl;

// Lipschitz constant (not yet set)
real	GlobalLip=0;

void	SetLipschitz(real x) {GlobalLip=x;}

int	BuildLipInterpolant(int Dim, int Ndata, real* x, real* y)
{
	gl.SetData(Dim,Ndata,x,y);

	// Lipschitz constants live here
	if(GlobalLip<=0) {
		gl.DetermineLipschitz();
		gl.SetConstants();			// automatic
	} else
		gl.SetConstants(GlobalLip,Dim+1);  // if it was specified

	gl.Construct();

	return gl.LastError();
//	if(gl.LastError()==ERR_LIP_LOW) cout << "Lipschitz const low or data coincide" << endl;
}

int	BuildLipInterpolantExplicit(int Dim, int Ndata,  real* x, real* y)
{
	gl.SetData(Dim,Ndata,x,y);

	// Lipschitz constants live here
	if(GlobalLip<=0) {
		gl.DetermineLipschitz();
		gl.SetConstants();			// automatic, but slow
	} else
		gl.SetConstants(GlobalLip,Dim+1);

	gl.ConstructExplicit();

	return gl.LastError();

//	if(gl.LastError()==ERR_LIP_LOW) cout << "Lipschitz const low or data coincide" << endl;
}

// the methods below are identical to the above, but use columnwise storage of matrices
int	BuildLipInterpolantColumn(int Dim, int Ndata, real* x, real* y)
{
	gl.SetDataColumn(Dim,Ndata,x,y);

	// Lipschitz constants live here
	if(GlobalLip<=0) {
		gl.DetermineLipschitz();
		gl.SetConstants();			// automatic
	} else
		gl.SetConstants(GlobalLip,Dim+1);  // if it was specified

	gl.Construct();

	return gl.LastError();
//	if(gl.LastError()==ERR_LIP_LOW) cout << "Lipschitz const low or data coincide" << endl;
}

int	BuildLipInterpolantExplicitColumn(int Dim, int Ndata,  real* x, real* y)
{
	gl.SetDataColumn(Dim,Ndata,x,y);

	// Lipschitz constants live here
	if(GlobalLip<=0) {
		gl.DetermineLipschitz();
		gl.SetConstants();			// automatic, but slow
	} else
		gl.SetConstants(GlobalLip,Dim+1);

	gl.ConstructExplicit();

	return gl.LastError();

//	if(gl.LastError()==ERR_LIP_LOW) cout << "Lipschitz const low or data coincide" << endl;
}


 real	InterpolantValue( real* x )
{
	return gl.Value(gl.Dim-1,x); // need to compute the slack variable
}

 real	InterpolantValueExplicit( real* x )
{
	return gl.ValueExplicit(gl.Dim-1,x);
}

 /*
	// example of how to interpret error codes
	switch(m_lasterr) {
	case ERR_BOTH_FAIL: *s="Extrapolation"; break;
	case ERR_LO_FAIL: *s="Lower interp failed"; break;
	case ERR_UP_FAIL: *s="Upper interp failed"; break;
	case ERR_LIP_LOW: *s="Lipschitz const low"; break;
	default: *s="";
	}

 */