/**************************************************************************

    begin                : April 30 2004
	version				 : 1.0 
    copyright            : (C) 2004 by Gleb Beliakov
    email                : gleb@deakin.edu.au

     This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  These functions are wrappers for STCInterpolant class
  for those who like using procedural interface, and for calls from
  other languages, like Fortran and Matlab

  These functions simply call the relevant members of the
  STCInterpolant class, whose instance lives in intwrapper.cpp

 ***************************************************************************/

//#include "interpol.h"

#ifdef __cplusplus
extern "C" {
#endif

// supplies the data to STCInterpolant and constructs the interpolant
// assuming a given Lipschitz constant, supplied by SetLipschitz
// if LipConstant was not supplied, tries to find it from the data
// assumes that all data are different. 

 int	BuildLipInterpolant(int Dim, int Ndata, double* x, double* y);

// as above, but for explicit evaluation, needs no preprocessing, but may be slower
  int	BuildLipInterpolantExplicit(int Dim, int Ndata, double* x, double* y);

// in the methods above, the coordinates of the data points in x are stored in rows

// the following methods store data in columns (like in fortran or Matlab)
// they use the transposed of the matrix x 
 int	BuildLipInterpolantColumn(int Dim, int Ndata, double* x, double* y);

// as above, but for explicit evaluation, needs no preprocessing, but may be slower
  int	BuildLipInterpolantExplicitColumn(int Dim, int Ndata, double* x, double* y);



// specify the Lipschitz constant for your function
  void	SetLipschitz(double x);

// computes the value of the interpolant at any given point x
  double	InterpolantValue( double* x );

// same but using explicit evaluation with no preprocessing
  double	InterpolantValueExplicit( double* x );

#ifdef __cplusplus
}
#endif
