package Locales::DB::Language::gsw;

# Auto generated from CLDR

$Locales::DB::Language::gsw::VERSION = '0.06';

$Locales::DB::Language::gsw::cldr_version = '1.7.2';

%Locales::DB::Language::gsw::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => '’',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'language'                => "Schpraach\:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#0 \%",
        'territory'               => "Regioon\:\ \{0\}"
    },
    'fallback'    => [ 'de_CH' ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "näi\:n",
        'yesstr' => "ja\:j"
    },
);

%Locales::DB::Language::gsw::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abchasisch',
    'ace'   => 'Aceh',
    'ach'   => 'Acholi',
    'ada'   => 'Adangme',
    'ady'   => 'Adygai',
    'ae'    => 'Avestisch',
    'af'    => 'Afrikaans',
    'afa'   => "Afro\-Asiatischi\ Schpraach",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadisch',
    'ale'   => 'Aleutisch',
    'alg'   => "Algonkin\-Schpraach",
    'alt'   => "Süüd\-Altaisch",
    'am'    => 'Amharisch',
    'an'    => 'Aragonesisch',
    'ang'   => 'Altänglisch',
    'anp'   => 'Angika',
    'apa'   => "Apache\-Schpraach",
    'ar'    => 'Arabisch',
    'arc'   => 'Aramääisch',
    'arn'   => 'Araukanisch',
    'arp'   => 'Arapaho',
    'art'   => "Künschtlichi\ Schpraach",
    'arw'   => 'Arawak',
    'as'    => 'Assamesisch',
    'ast'   => 'Aschturianisch',
    'ath'   => "Athapaskischi\ Schpraach",
    'aus'   => "Auschtralischi\ Schpraach",
    'av'    => 'Awarisch',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Aserbaidschanisch',
    'ba'    => 'Baschkirisch',
    'bad'   => 'Banda',
    'bai'   => 'Bamileke',
    'bal'   => 'Belutschisch',
    'ban'   => 'Balinesisch',
    'bas'   => 'Basaa',
    'bat'   => "Baltischi\ Schpraach",
    'be'    => 'Wiissrussisch',
    'bej'   => 'Bedauye',
    'bem'   => 'Bemba',
    'ber'   => 'Bärberisch',
    'bg'    => 'Bulgaarisch',
    'bh'    => 'Bihaarisch',
    'bho'   => 'Bhodschpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikolisch',
    'bin'   => 'Bini',
    'bla'   => "Blackfoot\-Schpraach",
    'bm'    => 'Bambara',
    'bn'    => 'Bengalisch',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibeetisch',
    'br'    => 'Brötoonisch',
    'bra'   => "Braj\-Bhakha",
    'bs'    => 'Bosnisch',
    'btk'   => 'Batak',
    'bua'   => 'Burjatisch',
    'bug'   => 'Bugineesisch',
    'byn'   => 'Blin',
    'ca'    => 'Katalaanisch',
    'cad'   => 'Caddo',
    'cai'   => "Zentralamerikanischi\ Indianerschpraach",
    'car'   => 'Kariibisch',
    'cau'   => 'Kaukaasisch',
    'cch'   => 'Atsam',
    'ce'    => 'Tschetscheenisch',
    'ceb'   => 'Cebuano',
    'cel'   => "Keltischi\ Schpraach",
    'ch'    => 'Chamorro',
    'chb'   => 'Tschibtscha',
    'chg'   => 'Tschagataisch',
    'chk'   => 'Trukesisch',
    'chm'   => 'Tscheremissisch',
    'chn'   => 'Chinook',
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamischi\ Schpraach",
    'co'    => 'Korsisch',
    'cop'   => 'Koptisch',
    'cpe'   => "Änglisch\-basierts\ Kreol\ oder\ Pidgin",
    'cpf'   => "Französisch\-basierts\ Kreol\ oder\ Pidgin",
    'cpp'   => "Portugiesisch\-basierts\ Kreol\ oder\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => 'Krimtatarisch',
    'crp'   => "Kreol\ oder\ Pidgin",
    'cs'    => 'Tschechisch',
    'csb'   => 'Kaschubisch',
    'cu'    => 'Chileslawisch',
    'cus'   => "Kuschitischi\ Schpraach",
    'cv'    => 'Tschuwaschisch',
    'cy'    => 'Walisisch',
    'da'    => 'Tänisch',
    'dak'   => 'Takota',
    'dar'   => 'Targiinisch',
    'day'   => 'Tajakisch',
    'de'    => 'Tüütsch',
    'de_at' => "Öschtriichischs\ Tüütsch",
    'de_ch' => "Schwiizer\ Hochtüütsch",
    'del'   => "Delaware\-Schpraach",
    'den'   => 'Slavey',
    'dgr'   => 'Togrib',
    'din'   => 'Tinka',
    'doi'   => 'Togri',
    'dra'   => "Trawidischi\ Schpraach",
    'dsb'   => 'Nidersorbisch',
    'dua'   => 'Tuala',
    'dum'   => 'Mittelniderländisch',
    'dv'    => 'Malediivisch',
    'dyu'   => 'Tiula',
    'dz'    => 'Dschongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efikisch',
    'egy'   => 'Altägyptisch',
    'eka'   => 'Ekajuk',
    'el'    => 'Griechisch',
    'elx'   => 'Elamisch',
    'en'    => 'Änglisch',
    'en_au' => "Auschtralischs\ Änglisch",
    'en_ca' => "Kanadischs\ Änglisch",
    'en_gb' => "Britischs\ Änglisch",
    'en_us' => "Amerikanischs\ Änglisch",
    'enm'   => 'Mittelänglisch',
    'eo'    => 'Eschperanto',
    'es'    => 'Schpanisch',
    'es_es' => "Ibeerischs\ Schpanisch",
    'et'    => 'Eestnisch',
    'eu'    => 'Baskisch',
    'ewo'   => 'Ewondo',
    'fa'    => 'Persisch',
    'fan'   => "Pangwe\-Schpraach",
    'fat'   => "Fanti\-Schpraach",
    'ff'    => 'Ful',
    'fi'    => 'Finnisch',
    'fil'   => 'Filipino',
    'fiu'   => "Finno\-ugrischi\ Schpraach",
    'fj'    => 'Fidschianisch',
    'fo'    => 'Färöisch',
    'fon'   => 'Fon',
    'fr'    => 'Französisch',
    'fr_ca' => "Kanadischs\ Französisch",
    'fr_ch' => "Schwiizer\ Französisch",
    'frm'   => 'Mittelfranzösisch',
    'fro'   => 'Altfranzösisch',
    'frr'   => 'Nordfriesisch',
    'frs'   => 'Oschtfriesisch',
    'fur'   => 'Friulisch',
    'fy'    => 'Friesisch',
    'ga'    => 'Iirisch',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Schottisch\-Gäälisch",
    'gem'   => "Germanischi\ Schpraach",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertesisch',
    'gl'    => 'Galizisch',
    'gmh'   => 'Mittelhochtüütsch',
    'gn'    => 'Guarani',
    'goh'   => 'Althochtüütsch',
    'gon'   => 'Gondi',
    'gor'   => 'Mongondou',
    'got'   => 'Gotisch',
    'grb'   => 'Grebo',
    'grc'   => 'Altgriechisch',
    'gsw'   => 'Schwiizertüütsch',
    'gu'    => 'Gujarati',
    'gv'    => "Manx\-Gäälisch",
    'gwi'   => 'Kutchinisch',
    'ha'    => 'Haussa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiianisch',
    'he'    => 'Hebräisch',
    'hi'    => 'Hindi',
    'hil'   => 'Hiligaynonisch',
    'him'   => 'Himatschalisch',
    'hit'   => 'Hethitisch',
    'hmn'   => 'Miao',
    'ho'    => "Hiri\-Motu",
    'hr'    => 'Kroazisch',
    'hsb'   => 'Obersorbisch',
    'ht'    => 'Haitisch',
    'hu'    => 'Ungarisch',
    'hup'   => 'Hupa',
    'hy'    => 'Armenisch',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Ibanisch',
    'id'    => 'Indonesisch',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sezuanischs\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiak',
    'ilo'   => 'Ilokano',
    'inc'   => "Indoarischi\ Schpraach",
    'ine'   => "Indogermanischi\ Schpraach",
    'inh'   => 'Inguschisch',
    'io'    => 'Ido',
    'ira'   => "Iranischi\ Schpraach",
    'iro'   => "Irokesischi\ Schpraach",
    'is'    => 'Iisländisch',
    'it'    => 'Italiänisch',
    'iu'    => 'Inukitut',
    'ja'    => 'Japanisch',
    'jbo'   => 'Lojbanisch',
    'jpr'   => "Jüüdisch\-Persisch",
    'jrb'   => "Jüüdisch\-Arabisch",
    'jv'    => 'Javanisch',
    'ka'    => 'Georgisch',
    'kaa'   => 'Karakalpakisch',
    'kab'   => 'Kabylisch',
    'kac'   => "Kachin\-Schpraach",
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karenisch',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardinisch',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongolesisch',
    'kha'   => 'Khasisch',
    'khi'   => 'Khoisanisch',
    'kho'   => 'Sakisch',
    'ki'    => "Kikuyu\-Schpraach",
    'kj'    => 'Kwanyama',
    'kk'    => 'Kasachisch',
    'kl'    => 'Gröönländisch',
    'km'    => 'Kambodschanisch',
    'kmb'   => "Kimbundu\-Schpraach",
    'kn'    => 'Kannada',
    'ko'    => 'Koreaanisch',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraeanisch',
    'kpe'   => "Kpelle\-Schpraach",
    'kr'    => "Kanuri\-Schpraach",
    'krc'   => "Karatschaiisch\-Balkarisch",
    'krl'   => 'Karelisch',
    'kro'   => "Kru\-Schpraach",
    'kru'   => "Oraon\-Schpraach",
    'ks'    => 'Kaschmirisch',
    'ku'    => 'Kurdisch',
    'kum'   => 'Kumükisch',
    'kut'   => "Kutenai\-Schpraach",
    'kv'    => "Komi\-Schpraach",
    'kw'    => 'Kornisch',
    'ky'    => 'Kirgiisisch',
    'la'    => 'Latiin',
    'lad'   => 'Ladino',
    'lah'   => 'Lahndanisch',
    'lam'   => 'Lambanisch',
    'lb'    => 'Luxemburgisch',
    'lez'   => 'Lesgisch',
    'lg'    => "Ganda\-Schpraach",
    'li'    => 'Limburgisch',
    'ln'    => 'Lingala',
    'lo'    => 'Laozisch',
    'lol'   => 'Mongo',
    'loz'   => "Rotse\-Schpraach",
    'lt'    => 'Litauisch',
    'lu'    => 'Luba',
    'lua'   => "Luba\-Lulua",
    'lui'   => "Luiseno\-Schpraach",
    'lun'   => "Lunda\-Schpraach",
    'luo'   => "Luo\-Schpraach",
    'lus'   => "Lushai\-Schpraach",
    'lv'    => 'Lettisch',
    'mad'   => 'Maduresisch',
    'mag'   => 'Khotta',
    'mai'   => 'Maithili',
    'mak'   => 'Makassarisch',
    'man'   => "Manding\-Schpraach",
    'map'   => "Auschtroneesischi\ Schpraach",
    'mas'   => "Massai\-Schpraach",
    'mdf'   => 'Mokschamordwinisch',
    'mdr'   => 'Mandaresisch',
    'men'   => "Mende\-Schpraach",
    'mfe'   => 'Morisyen',
    'mg'    => 'Madagassisch',
    'mga'   => 'Mittelirisch',
    'mh'    => 'Marschallesisch',
    'mi'    => 'Maori',
    'mic'   => "Micmac\-Schpraach",
    'min'   => "Minangkabau\-Schpraach",
    'mis'   => "Anderi\ Schpraach",
    'mk'    => 'Mazedonisch',
    'mkh'   => "Mon\-Khmer\-Schpraach",
    'ml'    => 'Malayalam',
    'mn'    => 'Mongolisch',
    'mnc'   => 'Mandschurisch',
    'mni'   => "Meithei\-Schpraach",
    'mno'   => "Manobo\-Schpraach",
    'mo'    => 'Moldawisch',
    'moh'   => "Mohawk\-Schpraach",
    'mos'   => "Mossi\-Schpraach",
    'mr'    => 'Marathi',
    'ms'    => 'Malaiisch',
    'mt'    => 'Maltesisch',
    'mul'   => 'Mehrschpraachig',
    'mun'   => "Munda\-Schpraach",
    'mus'   => "Muskogee\-Schpraach",
    'mwl'   => 'Mirandesisch',
    'mwr'   => 'Marwarisch',
    'my'    => 'Birmanisch',
    'myn'   => "Maya\-Schpraach",
    'myv'   => 'Erzya',
    'na'    => 'Nauruisch',
    'nah'   => 'Nahuatl',
    'nai'   => "Nordamerikanischi\ Indianersprach",
    'nap'   => 'Neapolitanisch',
    'nb'    => "Norwegisch\ Bokmål",
    'nd'    => "Nord\-Ndebele\-Schpraach",
    'nds'   => 'Nidertüütsch',
    'ne'    => 'Nepalesisch',
    'new'   => 'Newarisch',
    'ng'    => 'Ndonga',
    'nia'   => "Nias\-Schpraach",
    'nic'   => "Nigerkordofanischi\ Schpraach",
    'niu'   => "Niue\-Schpraach",
    'nl'    => 'Niderländisch',
    'nl_be' => 'Fläämisch',
    'nn'    => "Norwegisch\ Nynorsk",
    'no'    => 'Norwegisch',
    'nog'   => 'Nogaisch',
    'non'   => 'Altnordisch',
    'nqo'   => 'N’Ko',
    'nr'    => "Süüd\-Ndebele\-Schpraach",
    'nso'   => "Nord\-Sotho\-Schpraach",
    'nub'   => "Nubischi\ Schpraach",
    'nv'    => "Navajo\-Schpraach",
    'nwc'   => "Alt\-Newari",
    'ny'    => "Chewa\-Schpraach",
    'nym'   => "Nyamwezi\-Schpraach",
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Okzitanisch',
    'oj'    => "Ojibwa\-Schpraach",
    'om'    => 'Oromo',
    'or'    => 'Orija',
    'os'    => 'Ossezisch',
    'osa'   => "Osage\-Schpraach",
    'ota'   => 'Osmanisch',
    'oto'   => "Otomangue\-Schpraach",
    'pa'    => 'Pandschabisch',
    'paa'   => "Papua\-Schpraach",
    'pag'   => 'Pangasinanisch',
    'pal'   => 'Mittelpersisch',
    'pam'   => "Pampanggan\-Schpraach",
    'pap'   => 'Papiamento',
    'pau'   => 'Palau',
    'peo'   => 'Altpersisch',
    'phi'   => "Philippine\-Austronesischi\ Schpraach",
    'phn'   => 'Phönikisch',
    'pi'    => 'Pali',
    'pl'    => 'Polnisch',
    'pon'   => 'Ponapeanisch',
    'pra'   => 'Prakrit',
    'pro'   => 'Altprovenzalisch',
    'ps'    => 'Paschtu',
    'pt'    => 'Portugiisisch',
    'pt_br' => "Brasilianischs\ Portugiisisch",
    'pt_pt' => "Iberischs\ Portugiisisch",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => "Oschterinsel\-Schpraach",
    'rar'   => 'Rarotonganisch',
    'rm'    => 'Rätoromanisch',
    'rn'    => "Rundi\-Schpraach",
    'ro'    => 'Rumänisch',
    'roa'   => "Romanischi\ Schpraach",
    'rom'   => 'Zigüünerschpraach',
    'ru'    => 'Russisch',
    'rup'   => 'Aromunisch',
    'rw'    => 'Ruandisch',
    'sa'    => 'Sanschkrit',
    'sad'   => "Sandawe\-Schpraach",
    'sah'   => 'Jakutisch',
    'sai'   => "Süüdamerikanischi\ Indianerschpraach",
    'sal'   => "Salish\-Schpraach",
    'sam'   => 'Samaritanisch',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardisch',
    'scn'   => 'Sizilianisch',
    'sco'   => 'Schottisch',
    'sd'    => 'Sindhi',
    'se'    => "Nord\-Samisch",
    'sel'   => 'Selkupisch',
    'sem'   => "Semitischi\ Schpraach",
    'sg'    => 'Sango',
    'sga'   => 'Altirisch',
    'sgn'   => 'Gebäärdeschpraach',
    'sh'    => "Serbo\-Kroatisch",
    'shn'   => "Schan\-Schpraach",
    'si'    => 'Singhalesisch',
    'sid'   => 'Sidamo',
    'sio'   => "Sioux\-Schpraach",
    'sit'   => "Sinotibetischi\ Schpraach",
    'sk'    => 'Slowakisch',
    'sl'    => 'Slowenisch',
    'sla'   => "Slawischi\ Schpraach",
    'sm'    => 'Samoanisch',
    'sma'   => "Süüd\-Samisch",
    'smi'   => 'Samisch',
    'smj'   => "Lule\-Samisch",
    'smn'   => "Inari\-Samisch",
    'sms'   => "Skolt\-Samisch",
    'sn'    => 'Schhona',
    'snk'   => "Soninke\-Schpraach",
    'so'    => 'Somali',
    'sog'   => 'Sogdisch',
    'son'   => "Songhai\-Schpraach",
    'sq'    => 'Albanisch',
    'sr'    => 'Serbisch',
    'srn'   => 'Srananisch',
    'srr'   => "Serer\-Schpraach",
    'ss'    => 'Swazi',
    'ssa'   => "Nilosaharanischi\ Schpraach",
    'st'    => "Süüd\-Sotho\-Schpraach",
    'su'    => 'Sundanesisch',
    'suk'   => "Sukuma\-Schpraach",
    'sus'   => 'Susu',
    'sux'   => 'Sumerisch',
    'sv'    => 'Schwedisch',
    'sw'    => 'Suaheli',
    'syc'   => 'Altsyrisch',
    'syr'   => 'Syrisch',
    'ta'    => 'Tamilisch',
    'tai'   => 'Thaischpraache',
    'te'    => 'Telugu',
    'tem'   => 'Temne',
    'ter'   => "Tereno\-Schpraach",
    'tet'   => "Tetum\-Schpraach",
    'tg'    => 'Tadschikisch',
    'th'    => 'Thailändisch',
    'ti'    => 'Tigrinja',
    'tig'   => 'Tigre',
    'tiv'   => "Tiv\-Schpraach",
    'tk'    => 'Turkmenisch',
    'tkl'   => 'Tokelauanisch',
    'tl'    => 'Tagalog',
    'tlh'   => 'Klingonisch',
    'tli'   => "Tlingit\-Schpraach",
    'tmh'   => 'Tamaseq',
    'tn'    => "Tswana\-Schpraach",
    'to'    => 'Tongaisch',
    'tog'   => "Tsonga\-Schpraach",
    'tpi'   => 'Neumelanesisch',
    'tr'    => 'Türkisch',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => "Tsimshian\-Schpraach",
    'tt'    => 'Tatarisch',
    'tum'   => "Tumbuka\-Schpraach",
    'tup'   => "Tupi\-Schpraache",
    'tut'   => "Altaischi\ Schpraachä",
    'tvl'   => 'Elliceanisch',
    'tw'    => 'Twi',
    'ty'    => 'Tahitisch',
    'tyv'   => 'Tuwinisch',
    'udm'   => 'Udmurtisch',
    'ug'    => 'Uigurisch',
    'uga'   => 'Ugaritisch',
    'uk'    => 'Ukrainisch',
    'umb'   => "Mbundu\-Schpraach",
    'und'   => "Unbeschtimmti\ Schpraach",
    'ur'    => 'Urdu',
    'uz'    => 'Usbekisch',
    'vai'   => "Vai\-Schpraach",
    've'    => "Venda\-Schpraach",
    'vi'    => 'Vietnamesisch',
    'vo'    => 'Volapük',
    'vot'   => 'Wotisch',
    'wa'    => 'Wallonisch',
    'wak'   => 'Wakashanisch',
    'wal'   => "Walamo\-Schpraach",
    'war'   => 'Waray',
    'was'   => "Washo\-Schpraach",
    'wen'   => 'Sorbisch',
    'wo'    => 'Wolof',
    'xal'   => 'Kalmückisch',
    'xh'    => 'Xhosa',
    'yao'   => "Yao\-Schpraach",
    'yap'   => 'Yapesisch',
    'yi'    => 'Jiddisch',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\-Schpraach",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotekisch',
    'zbl'   => "Bliss\-Symbool",
    'zen'   => 'Zenaga',
    'zh'    => 'Chineesisch',
    'znd'   => "Zande\-Schpraach",
    'zu'    => 'Zulu',
    'zun'   => "Zuni\-Schpraach",
    'zxx'   => "Kän\ schpraachliche\ Inhalt",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::gsw::name_to_code = (
    'abchasisch'                            => 'ab',
    'aceh'                                  => 'ace',
    'acholi'                                => 'ach',
    'adangme'                               => 'ada',
    'adygai'                                => 'ady',
    'afar'                                  => 'aa',
    'afrihili'                              => 'afh',
    'afrikaans'                             => 'af',
    'afroasiatischischpraach'               => 'afa',
    'ainu'                                  => 'ain',
    'akan'                                  => 'ak',
    'akkadisch'                             => 'akk',
    'albanisch'                             => 'sq',
    'aleutisch'                             => 'ale',
    'algonkinschpraach'                     => 'alg',
    'altaischischpraachä'                  => 'tut',
    'altfranzösisch'                       => 'fro',
    'altgriechisch'                         => 'grc',
    'althochtüütsch'                      => 'goh',
    'altirisch'                             => 'sga',
    'altnewari'                             => 'nwc',
    'altnordisch'                           => 'non',
    'altpersisch'                           => 'peo',
    'altprovenzalisch'                      => 'pro',
    'altsyrisch'                            => 'syc',
    'altägyptisch'                         => 'egy',
    'altänglisch'                          => 'ang',
    'amerikanischsÄnglisch'                => 'en_us',
    'amharisch'                             => 'am',
    'anderischpraach'                       => 'mis',
    'angika'                                => 'anp',
    'apacheschpraach'                       => 'apa',
    'arabisch'                              => 'ar',
    'aragonesisch'                          => 'an',
    'aramääisch'                          => 'arc',
    'arapaho'                               => 'arp',
    'araukanisch'                           => 'arn',
    'arawak'                                => 'arw',
    'armenisch'                             => 'hy',
    'aromunisch'                            => 'rup',
    'aschturianisch'                        => 'ast',
    'aserbaidschanisch'                     => 'az',
    'assamesisch'                           => 'as',
    'athapaskischischpraach'                => 'ath',
    'atsam'                                 => 'cch',
    'auschtralischischpraach'               => 'aus',
    'auschtralischsÄnglisch'               => 'en_au',
    'auschtroneesischischpraach'            => 'map',
    'avestisch'                             => 'ae',
    'awadhi'                                => 'awa',
    'awarisch'                              => 'av',
    'aymara'                                => 'ay',
    'balinesisch'                           => 'ban',
    'baltischischpraach'                    => 'bat',
    'bambara'                               => 'bm',
    'bamileke'                              => 'bai',
    'banda'                                 => 'bad',
    'bantu'                                 => 'bnt',
    'basaa'                                 => 'bas',
    'baschkirisch'                          => 'ba',
    'baskisch'                              => 'eu',
    'batak'                                 => 'btk',
    'bedauye'                               => 'bej',
    'belutschisch'                          => 'bal',
    'bemba'                                 => 'bem',
    'bengalisch'                            => 'bn',
    'bhodschpuri'                           => 'bho',
    'bihaarisch'                            => 'bh',
    'bikolisch'                             => 'bik',
    'bini'                                  => 'bin',
    'birmanisch'                            => 'my',
    'bislama'                               => 'bi',
    'blackfootschpraach'                    => 'bla',
    'blin'                                  => 'byn',
    'blisssymbool'                          => 'zbl',
    'bosnisch'                              => 'bs',
    'brajbhakha'                            => 'bra',
    'brasilianischsportugiisisch'           => 'pt_br',
    'britischsÄnglisch'                    => 'en_gb',
    'brötoonisch'                          => 'br',
    'bugineesisch'                          => 'bug',
    'bulgaarisch'                           => 'bg',
    'burjatisch'                            => 'bua',
    'bärberisch'                           => 'ber',
    'caddo'                                 => 'cad',
    'cebuano'                               => 'ceb',
    'chamischischpraach'                    => 'cmc',
    'chamorro'                              => 'ch',
    'cherokee'                              => 'chr',
    'chewaschpraach'                        => 'ny',
    'cheyenne'                              => 'chy',
    'chileslawisch'                         => 'cu',
    'chineesisch'                           => 'zh',
    'chinook'                               => 'chn',
    'chipewyan'                             => 'chp',
    'choctaw'                               => 'cho',
    'cree'                                  => 'cr',
    'delawareschpraach'                     => 'del',
    'dschongkha'                            => 'dz',
    'eestnisch'                             => 'et',
    'efikisch'                              => 'efi',
    'ekajuk'                                => 'eka',
    'elamisch'                              => 'elx',
    'elliceanisch'                          => 'tvl',
    'erzya'                                 => 'myv',
    'eschperanto'                           => 'eo',
    'ewe'                                   => 'ee',
    'ewondo'                                => 'ewo',
    'fantischpraach'                        => 'fat',
    'fidschianisch'                         => 'fj',
    'filipino'                              => 'fil',
    'finnisch'                              => 'fi',
    'finnougrischischpraach'                => 'fiu',
    'fläämisch'                           => 'nl_be',
    'fon'                                   => 'fon',
    'französisch'                          => 'fr',
    'französischbasiertskreoloderpidgin'   => 'cpf',
    'friesisch'                             => 'fy',
    'friulisch'                             => 'fur',
    'ful'                                   => 'ff',
    'färöisch'                            => 'fo',
    'ga'                                    => 'gaa',
    'galizisch'                             => 'gl',
    'gandaschpraach'                        => 'lg',
    'gayo'                                  => 'gay',
    'gbaya'                                 => 'gba',
    'gebäärdeschpraach'                   => 'sgn',
    'geez'                                  => 'gez',
    'georgisch'                             => 'ka',
    'germanischischpraach'                  => 'gem',
    'gilbertesisch'                         => 'gil',
    'gondi'                                 => 'gon',
    'gotisch'                               => 'got',
    'grebo'                                 => 'grb',
    'griechisch'                            => 'el',
    'gröönländisch'                      => 'kl',
    'guarani'                               => 'gn',
    'gujarati'                              => 'gu',
    'haida'                                 => 'hai',
    'haitisch'                              => 'ht',
    'haussa'                                => 'ha',
    'hawaiianisch'                          => 'haw',
    'hebräisch'                            => 'he',
    'herero'                                => 'hz',
    'hethitisch'                            => 'hit',
    'hiligaynonisch'                        => 'hil',
    'himatschalisch'                        => 'him',
    'hindi'                                 => 'hi',
    'hirimotu'                              => 'ho',
    'hupa'                                  => 'hup',
    'ibanisch'                              => 'iba',
    'ibeerischsschpanisch'                  => 'es_es',
    'iberischsportugiisisch'                => 'pt_pt',
    'ido'                                   => 'io',
    'igbo'                                  => 'ig',
    'iirisch'                               => 'ga',
    'iisländisch'                          => 'is',
    'ijo'                                   => 'ijo',
    'ilokano'                               => 'ilo',
    'inarisamisch'                          => 'smn',
    'indoarischischpraach'                  => 'inc',
    'indogermanischischpraach'              => 'ine',
    'indonesisch'                           => 'id',
    'inguschisch'                           => 'inh',
    'interlingua'                           => 'ia',
    'interlingue'                           => 'ie',
    'inukitut'                              => 'iu',
    'inupiak'                               => 'ik',
    'iranischischpraach'                    => 'ira',
    'irokesischischpraach'                  => 'iro',
    'italiänisch'                          => 'it',
    'jakutisch'                             => 'sah',
    'japanisch'                             => 'ja',
    'javanisch'                             => 'jv',
    'jiddisch'                              => 'yi',
    'jju'                                   => 'kaj',
    'jüüdischarabisch'                    => 'jrb',
    'jüüdischpersisch'                    => 'jpr',
    'kabardinisch'                          => 'kbd',
    'kabylisch'                             => 'kab',
    'kachinschpraach'                       => 'kac',
    'kalmückisch'                          => 'xal',
    'kamba'                                 => 'kam',
    'kambodschanisch'                       => 'km',
    'kanadischsfranzösisch'                => 'fr_ca',
    'kanadischsÄnglisch'                   => 'en_ca',
    'kannada'                               => 'kn',
    'kanurischpraach'                       => 'kr',
    'karakalpakisch'                        => 'kaa',
    'karatschaiischbalkarisch'              => 'krc',
    'karelisch'                             => 'krl',
    'karenisch'                             => 'kar',
    'kariibisch'                            => 'car',
    'kasachisch'                            => 'kk',
    'kaschmirisch'                          => 'ks',
    'kaschubisch'                           => 'csb',
    'katalaanisch'                          => 'ca',
    'kaukaasisch'                           => 'cau',
    'kawi'                                  => 'kaw',
    'keltischischpraach'                    => 'cel',
    'khasisch'                              => 'kha',
    'khoisanisch'                           => 'khi',
    'khotta'                                => 'mag',
    'kikuyuschpraach'                       => 'ki',
    'kimbunduschpraach'                     => 'kmb',
    'kirgiisisch'                           => 'ky',
    'klingonisch'                           => 'tlh',
    'komischpraach'                         => 'kv',
    'kongolesisch'                          => 'kg',
    'konkani'                               => 'kok',
    'koptisch'                              => 'cop',
    'koreaanisch'                           => 'ko',
    'kornisch'                              => 'kw',
    'koro'                                  => 'kfo',
    'korsisch'                              => 'co',
    'kosraeanisch'                          => 'kos',
    'kpelleschpraach'                       => 'kpe',
    'kreoloderpidgin'                       => 'crp',
    'krimtatarisch'                         => 'crh',
    'kroazisch'                             => 'hr',
    'kruschpraach'                          => 'kro',
    'kumükisch'                            => 'kum',
    'kurdisch'                              => 'ku',
    'kuschitischischpraach'                 => 'cus',
    'kutchinisch'                           => 'gwi',
    'kutenaischpraach'                      => 'kut',
    'kwanyama'                              => 'kj',
    'känschpraachlicheinhalt'              => 'zxx',
    'künschtlichischpraach'                => 'art',
    'ladino'                                => 'lad',
    'lahndanisch'                           => 'lah',
    'lambanisch'                            => 'lam',
    'laozisch'                              => 'lo',
    'latiin'                                => 'la',
    'lesgisch'                              => 'lez',
    'lettisch'                              => 'lv',
    'limburgisch'                           => 'li',
    'lingala'                               => 'ln',
    'litauisch'                             => 'lt',
    'lojbanisch'                            => 'jbo',
    'luba'                                  => 'lu',
    'lubalulua'                             => 'lua',
    'luisenoschpraach'                      => 'lui',
    'lulesamisch'                           => 'smj',
    'lundaschpraach'                        => 'lun',
    'luoschpraach'                          => 'luo',
    'lushaischpraach'                       => 'lus',
    'luxemburgisch'                         => 'lb',
    'madagassisch'                          => 'mg',
    'maduresisch'                           => 'mad',
    'maithili'                              => 'mai',
    'makassarisch'                          => 'mak',
    'malaiisch'                             => 'ms',
    'malayalam'                             => 'ml',
    'malediivisch'                          => 'dv',
    'maltesisch'                            => 'mt',
    'mandaresisch'                          => 'mdr',
    'mandingschpraach'                      => 'man',
    'mandschurisch'                         => 'mnc',
    'manoboschpraach'                       => 'mno',
    'manxgäälisch'                        => 'gv',
    'maori'                                 => 'mi',
    'marathi'                               => 'mr',
    'marschallesisch'                       => 'mh',
    'marwarisch'                            => 'mwr',
    'massaischpraach'                       => 'mas',
    'mayaschpraach'                         => 'myn',
    'mazedonisch'                           => 'mk',
    'mbunduschpraach'                       => 'umb',
    'mehrschpraachig'                       => 'mul',
    'meitheischpraach'                      => 'mni',
    'mendeschpraach'                        => 'men',
    'miao'                                  => 'hmn',
    'micmacschpraach'                       => 'mic',
    'minangkabauschpraach'                  => 'min',
    'mirandesisch'                          => 'mwl',
    'mittelfranzösisch'                    => 'frm',
    'mittelhochtüütsch'                   => 'gmh',
    'mittelirisch'                          => 'mga',
    'mittelniderländisch'                  => 'dum',
    'mittelpersisch'                        => 'pal',
    'mittelänglisch'                       => 'enm',
    'mohawkschpraach'                       => 'moh',
    'mokschamordwinisch'                    => 'mdf',
    'moldawisch'                            => 'mo',
    'mongo'                                 => 'lol',
    'mongolisch'                            => 'mn',
    'mongondou'                             => 'gor',
    'monkhmerschpraach'                     => 'mkh',
    'morisyen'                              => 'mfe',
    'mossischpraach'                        => 'mos',
    'mundaschpraach'                        => 'mun',
    'muskogeeschpraach'                     => 'mus',
    'nahuatl'                               => 'nah',
    'nauruisch'                             => 'na',
    'navajoschpraach'                       => 'nv',
    'ndonga'                                => 'ng',
    'neapolitanisch'                        => 'nap',
    'nepalesisch'                           => 'ne',
    'neumelanesisch'                        => 'tpi',
    'newarisch'                             => 'new',
    'niasschpraach'                         => 'nia',
    'niderländisch'                        => 'nl',
    'nidersorbisch'                         => 'dsb',
    'nidertüütsch'                        => 'nds',
    'nigerkordofanischischpraach'           => 'nic',
    'nilosaharanischischpraach'             => 'ssa',
    'niueschpraach'                         => 'niu',
    'nogaisch'                              => 'nog',
    'nordamerikanischiindianersprach'       => 'nai',
    'nordfriesisch'                         => 'frr',
    'nordndebeleschpraach'                  => 'nd',
    'nordsamisch'                           => 'se',
    'nordsothoschpraach'                    => 'nso',
    'norwegisch'                            => 'no',
    'norwegischbokmål'                     => 'nb',
    'norwegischnynorsk'                     => 'nn',
    'nubischischpraach'                     => 'nub',
    'nyamwezischpraach'                     => 'nym',
    'nyankole'                              => 'nyn',
    'nyoro'                                 => 'nyo',
    'nzima'                                 => 'nzi',
    'n’ko'                                => 'nqo',
    'obersorbisch'                          => 'hsb',
    'ojibwaschpraach'                       => 'oj',
    'okzitanisch'                           => 'oc',
    'oraonschpraach'                        => 'kru',
    'orija'                                 => 'or',
    'oromo'                                 => 'om',
    'osageschpraach'                        => 'osa',
    'oschterinselschpraach'                 => 'rap',
    'oschtfriesisch'                        => 'frs',
    'osmanisch'                             => 'ota',
    'ossezisch'                             => 'os',
    'otomangueschpraach'                    => 'oto',
    'palau'                                 => 'pau',
    'pali'                                  => 'pi',
    'pampangganschpraach'                   => 'pam',
    'pandschabisch'                         => 'pa',
    'pangasinanisch'                        => 'pag',
    'pangweschpraach'                       => 'fan',
    'papiamento'                            => 'pap',
    'papuaschpraach'                        => 'paa',
    'paschtu'                               => 'ps',
    'persisch'                              => 'fa',
    'philippineaustronesischischpraach'     => 'phi',
    'phönikisch'                           => 'phn',
    'polnisch'                              => 'pl',
    'ponapeanisch'                          => 'pon',
    'portugiesischbasiertskreoloderpidgin'  => 'cpp',
    'portugiisisch'                         => 'pt',
    'prakrit'                               => 'pra',
    'quechua'                               => 'qu',
    'rajasthani'                            => 'raj',
    'rarotonganisch'                        => 'rar',
    'romanischischpraach'                   => 'roa',
    'rotseschpraach'                        => 'loz',
    'ruandisch'                             => 'rw',
    'rumänisch'                            => 'ro',
    'rundischpraach'                        => 'rn',
    'russisch'                              => 'ru',
    'rätoromanisch'                        => 'rm',
    'sakisch'                               => 'kho',
    'salishschpraach'                       => 'sal',
    'samaritanisch'                         => 'sam',
    'samisch'                               => 'smi',
    'samoanisch'                            => 'sm',
    'sandaweschpraach'                      => 'sad',
    'sango'                                 => 'sg',
    'sanschkrit'                            => 'sa',
    'santali'                               => 'sat',
    'sardisch'                              => 'sc',
    'sasak'                                 => 'sas',
    'schanschpraach'                        => 'shn',
    'schhona'                               => 'sn',
    'schottisch'                            => 'sco',
    'schottischgäälisch'                  => 'gd',
    'schpanisch'                            => 'es',
    'schwedisch'                            => 'sv',
    'schwiizerfranzösisch'                 => 'fr_ch',
    'schwiizerhochtüütsch'                => 'de_ch',
    'schwiizertüütsch'                    => 'gsw',
    'selkupisch'                            => 'sel',
    'semitischischpraach'                   => 'sem',
    'serbisch'                              => 'sr',
    'serbokroatisch'                        => 'sh',
    'sererschpraach'                        => 'srr',
    'sezuanischsyi'                         => 'ii',
    'sidamo'                                => 'sid',
    'sindhi'                                => 'sd',
    'singhalesisch'                         => 'si',
    'sinotibetischischpraach'               => 'sit',
    'siouxschpraach'                        => 'sio',
    'sizilianisch'                          => 'scn',
    'skoltsamisch'                          => 'sms',
    'slavey'                                => 'den',
    'slawischischpraach'                    => 'sla',
    'slowakisch'                            => 'sk',
    'slowenisch'                            => 'sl',
    'sogdisch'                              => 'sog',
    'somali'                                => 'so',
    'songhaischpraach'                      => 'son',
    'soninkeschpraach'                      => 'snk',
    'sorbisch'                              => 'wen',
    'srananisch'                            => 'srn',
    'suaheli'                               => 'sw',
    'sukumaschpraach'                       => 'suk',
    'sumerisch'                             => 'sux',
    'sundanesisch'                          => 'su',
    'susu'                                  => 'sus',
    'swazi'                                 => 'ss',
    'syrisch'                               => 'syr',
    'süüdaltaisch'                        => 'alt',
    'süüdamerikanischiindianerschpraach'  => 'sai',
    'süüdndebeleschpraach'                => 'nr',
    'süüdsamisch'                         => 'sma',
    'süüdsothoschpraach'                  => 'st',
    'tadschikisch'                          => 'tg',
    'tagalog'                               => 'tl',
    'tahitisch'                             => 'ty',
    'tajakisch'                             => 'day',
    'takota'                                => 'dak',
    'tamaseq'                               => 'tmh',
    'tamilisch'                             => 'ta',
    'targiinisch'                           => 'dar',
    'taroko'                                => 'trv',
    'tatarisch'                             => 'tt',
    'telugu'                                => 'te',
    'temne'                                 => 'tem',
    'terenoschpraach'                       => 'ter',
    'tetumschpraach'                        => 'tet',
    'thailändisch'                         => 'th',
    'thaischpraache'                        => 'tai',
    'tibeetisch'                            => 'bo',
    'tigre'                                 => 'tig',
    'tigrinja'                              => 'ti',
    'tinka'                                 => 'din',
    'tiula'                                 => 'dyu',
    'tivschpraach'                          => 'tiv',
    'tlingitschpraach'                      => 'tli',
    'togri'                                 => 'doi',
    'togrib'                                => 'dgr',
    'tokelauanisch'                         => 'tkl',
    'tongaisch'                             => 'to',
    'trawidischischpraach'                  => 'dra',
    'trukesisch'                            => 'chk',
    'tschagataisch'                         => 'chg',
    'tschechisch'                           => 'cs',
    'tscheremissisch'                       => 'chm',
    'tschetscheenisch'                      => 'ce',
    'tschibtscha'                           => 'chb',
    'tschuwaschisch'                        => 'cv',
    'tsimshianschpraach'                    => 'tsi',
    'tsonga'                                => 'ts',
    'tsongaschpraach'                       => 'tog',
    'tswanaschpraach'                       => 'tn',
    'tuala'                                 => 'dua',
    'tumbukaschpraach'                      => 'tum',
    'tupischpraache'                        => 'tup',
    'turkmenisch'                           => 'tk',
    'tuwinisch'                             => 'tyv',
    'twi'                                   => 'tw',
    'tyap'                                  => 'kcg',
    'tänisch'                              => 'da',
    'türkisch'                             => 'tr',
    'tüütsch'                             => 'de',
    'udmurtisch'                            => 'udm',
    'ugaritisch'                            => 'uga',
    'uigurisch'                             => 'ug',
    'ukrainisch'                            => 'uk',
    'unbeschtimmtischpraach'                => 'und',
    'ungarisch'                             => 'hu',
    'urdu'                                  => 'ur',
    'usbekisch'                             => 'uz',
    'vaischpraach'                          => 'vai',
    'vendaschpraach'                        => 've',
    'vietnamesisch'                         => 'vi',
    'volapük'                              => 'vo',
    'wakashanisch'                          => 'wak',
    'walamoschpraach'                       => 'wal',
    'walisisch'                             => 'cy',
    'wallonisch'                            => 'wa',
    'waray'                                 => 'war',
    'washoschpraach'                        => 'was',
    'wiissrussisch'                         => 'be',
    'wolof'                                 => 'wo',
    'wotisch'                               => 'vot',
    'xhosa'                                 => 'xh',
    'yaoschpraach'                          => 'yao',
    'yapesisch'                             => 'yap',
    'yoruba'                                => 'yo',
    'yupikschpraach'                        => 'ypk',
    'zandeschpraach'                        => 'znd',
    'zapotekisch'                           => 'zap',
    'zaza'                                  => 'zza',
    'zenaga'                                => 'zen',
    'zentralamerikanischiindianerschpraach' => 'cai',
    'zhuang'                                => 'za',
    'zigüünerschpraach'                   => 'rom',
    'zulu'                                  => 'zu',
    'zunischpraach'                         => 'zun',
    'Änglisch'                             => 'en',
    'Änglischbasiertskreoloderpidgin'      => 'cpe',
    'Öschtriichischstüütsch'             => 'de_at',
);

1;
