package Locales::DB::Language::to;

# Auto generated from CLDR

$Locales::DB::Language::to::VERSION = '0.09';

$Locales::DB::Language::to::cldr_version = '2.0';

%Locales::DB::Language::to::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => "\,",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Lea\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ and\ \{1\}",
            'end'    => "\{0\}\,\ and\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Feituʻu\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '»',
        'alternate_quotation_start' => '«',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => 'ʻikai',
        'yesstr' => 'ʻio'
    },
);

%Locales::DB::Language::to::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => "lea\ fakaʻapakasi",
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => "lea\ fakaʻafilikana",
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'agq'   => 'Aghem',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => "lea\ ʻameliki",
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => "lea\ fakaʻalepea",
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "lea\ faʻu",
    'arw'   => 'Arawak',
    'as'    => "lea\ ʻasamisi",
    'asa'   => 'Asu',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => "lea\ ʻaimala",
    'az'    => "lea\ fakaʻasapaisani",
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basaa',
    'bat'   => "Baltic\ Language",
    'be'    => "lea\ fakapelelusi",
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bez'   => 'Bena',
    'bg'    => "lea\ fakapokalia",
    'bh'    => 'Bihari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => "lea\ fakapengila",
    'bnt'   => 'Bantu',
    'bo'    => "lea\ fakataipeti",
    'br'    => 'Breton',
    'bra'   => 'Braj',
    'brx'   => 'Bodo',
    'bs'    => "lea\ fakaposinia",
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => "lea\ fakaketalani",
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cay'   => 'Cayuga',
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'cgg'   => 'Chiga',
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => "lea\ fakaseki",
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => "lea\ fakauēlesi",
    'da'    => "lea\ fakatenimaʻake",
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'dav'   => 'Taita',
    'day'   => 'Dayak',
    'de'    => "lea\ fakasiamane",
    'de_at' => "lea\ fakasiamani\ ʻaositulia",
    'de_ch' => "lea\ fakasiamani\ suitisālani\ ma\'olunga",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'dje'   => 'Zarma',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => "lea\ tivehi",
    'dyo'   => "Jola\-Fonyi",
    'dyu'   => 'Dyula',
    'dz'    => "lea\ fakaputeni",
    'ebu'   => 'Embu',
    'ee'    => 'Ewe',
    'efi'   => "lea\ ʻefiki",
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => "lea\ fakakalisi",
    'elx'   => 'Elamite',
    'en'    => "lea\ fakapālangi",
    'en_au' => "lea\ fakapālangi\ ʻaositelēlia",
    'en_ca' => "lea\ fakapālangi\ kānata",
    'en_gb' => "lea\ fakapilitānia",
    'en_us' => "lea\ fakapālangi\ ʻamelika",
    'enm'   => "Middle\ English",
    'eo'    => "lea\ fakaʻesipulanito",
    'es'    => "lea\ fakasīpenisi",
    'es_es' => "lea\ fakasipēnisi\ ʻaipilieni",
    'et'    => "lea\ fakaʻesitōnia",
    'eu'    => "lea\ pasiki",
    'ewo'   => 'Ewondo',
    'fa'    => "lea\ fakapēsia",
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => "lea\ fakafinilani",
    'fil'   => "lea\ fakafilipaini",
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => "lea\ fakafisi",
    'fo'    => 'Faroese',
    'fon'   => 'Fon',
    'fr'    => "lea\ fakafalanisē",
    'fr_ca' => "lea\ fakafalanisē\ kānata",
    'fr_ch' => "lea\ fakafalanisē\ suitisālani",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Western\ Frisian",
    'ga'    => "lea\ fakaʻaelani",
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Scottish\ Gaelic",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => "lea\ fakakilipasi",
    'gl'    => "lea\ kalisieni",
    'gmh'   => "Middle\ High\ German",
    'gn'    => "lea\ kualani",
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "lea\ fakakalisimuʻa",
    'gsw'   => "lea\ fakasiamani\ suitisālani",
    'gu'    => "lea\ kutalati",
    'guz'   => 'Gusii',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => "lea\ hausa",
    'hai'   => 'Haida',
    'haw'   => "lea\ fakahauaiʻi",
    'he'    => "lea\ fakahepelū",
    'hi'    => "lea\ fakahinitī",
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => "lea\ fakakuloisia",
    'hsb'   => "Upper\ Sorbian",
    'ht'    => "lea\ fakahaiti",
    'hu'    => "lea\ fakahangakalia",
    'hup'   => 'Hupa',
    'hy'    => "lea\ fakaʻaminiume",
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => "lea\ fakaʻinitōnesia",
    'ie'    => 'Interlingue',
    'ig'    => "lea\ ʻikipō",
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => "lea\ fakaʻaisilani",
    'it'    => "lea\ fakaʻītali",
    'iu'    => 'Inuktitut',
    'ja'    => "lea\ fakasiapani",
    'jbo'   => 'Lojban',
    'jmc'   => 'Machame',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => "lea\ fakasava",
    'ka'    => "lea\ fakasōsia",
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kde'   => 'Makonde',
    'kea'   => 'Kabuverdianu',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'khq'   => "Koyra\ Chiini",
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => "lea\ fakakasakiteni",
    'kl'    => 'Kalaallisut',
    'kln'   => 'Kalenjin',
    'km'    => "lea\ fakakemipōtia",
    'kmb'   => 'Kimbundu',
    'kn'    => "lea\ kanata",
    'ko'    => "lea\ fakakōlea",
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => "lea\ fakakesimia",
    'ksb'   => 'Shambala',
    'ksf'   => 'Bafia',
    'ksh'   => 'Colognian',
    'ku'    => "lea\ kētisi",
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => "lea\ fakakekisiteni",
    'la'    => "lea\ fakalatina",
    'lad'   => 'Ladino',
    'lag'   => 'Langi',
    'lah'   => "lea\ lanita",
    'lam'   => 'Lamba',
    'lb'    => "lea\ fakalakisimipeki",
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => "lea\ lingikala",
    'lo'    => "lea\ fakalau",
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => "lea\ fakalifiuenia",
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'luy'   => 'Luyia',
    'lv'    => "lea\ fakalativia",
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mer'   => 'Meru',
    'mfe'   => 'Morisyen',
    'mg'    => "lea\ fakamatakasika",
    'mga'   => "Middle\ Irish",
    'mgh'   => "Makhuwa\-Meetto",
    'mh'    => "lea\ fakamāsolo",
    'mi'    => "lea\ fakamauli",
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "lea\ kehekehe",
    'mk'    => "lea\ fakamasitōnia",
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => "lea\ fakaʻinitia\ malāialemi",
    'mn'    => "lea\ fakamongokōlia",
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => "lea\ malati",
    'ms'    => "lea\ fakamalei",
    'mt'    => "lea\ fakamolota",
    'mua'   => 'Mundang',
    'mul'   => "lea\ tuifio",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => "lea\ fakapema",
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => "lea\ fakanaulu",
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'naq'   => 'Nama',
    'nb'    => "lea\ fakanouei\ pokimali",
    'nd'    => "lea\ netepele\ fakatokelau",
    'nds'   => "Low\ German",
    'ne'    => "lea\ fakanepali",
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => "lea\ fakaniuē",
    'nl'    => "lea\ fakahōlani",
    'nl_be' => "lea\ fakahōlani\ pelesiume",
    'nmg'   => 'Kwasio',
    'nn'    => "lea\ fakanouei\ nosiki",
    'no'    => "lea\ fakanouē",
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "lea\ sofo\ fakatokelau",
    'nub'   => "Nubian\ Language",
    'nus'   => 'Nuer',
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => "lea\ sua",
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Occitan',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => "lea\ fakaʻinitia\ ʻolāea",
    'os'    => "lea\ ʻosetiki",
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => "lea\ punusapi",
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => "lea\ fakapōlani",
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => "lea\ pasito",
    'pt'    => "lea\ fakapotukali",
    'pt_br' => "lea\ fakapotukali\-palāsili",
    'pt_pt' => "lea\ fakapotukali\ ʻaipilieni",
    'qu'    => "lea\ kuetisa",
    'raj'   => 'Rajasthani',
    'rap'   => "lea\ fakalapanui",
    'rar'   => "lea\ fakalalotonga",
    'rm'    => "lea\ laito\-lomēnia",
    'rn'    => "lea\ luaniti",
    'ro'    => "lea\ fakalōmenia",
    'roa'   => "Romance\ Language",
    'rof'   => 'Rombo',
    'rom'   => 'Romany',
    'ru'    => "lea\ fakalūsia",
    'rup'   => 'Aromanian',
    'rw'    => "lea\ fakaluanita",
    'rwk'   => 'Rwa',
    'sa'    => "lea\ sanisukuliti",
    'sad'   => 'Sandawe',
    'sah'   => "lea\ saka",
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'saq'   => 'Samburu',
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sbp'   => 'Sangu',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => "lea\ fakasikotilani",
    'sd'    => "lea\ siniti",
    'se'    => "lea\ sami\ fakatokelau",
    'see'   => 'Seneca',
    'seh'   => 'Sena',
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'ses'   => "Koyraboro\ Senni",
    'sg'    => "lea\ sango",
    'sga'   => "Old\ Irish",
    'sgn'   => "lea\ fakaʻilonga",
    'sh'    => "lea\ sēpia\-kuloisia",
    'shi'   => 'Tachelhit',
    'shn'   => 'Shan',
    'si'    => "lea\ fakaselengika",
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => "lea\ fakasolāvaki",
    'sl'    => "lea\ fakasolovenia",
    'sla'   => "Slavic\ Language",
    'sm'    => "lea\ fakahaʻamoa",
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => "lea\ sona",
    'snk'   => 'Soninke',
    'so'    => "lea\ fakasomali",
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => "lea\ fakaʻalapēnia",
    'sr'    => "lea\ fakasēpia",
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => "lea\ fakasuasilani",
    'ssa'   => "Nilo\-Saharan\ Language",
    'ssy'   => 'Saho',
    'st'    => "lea\ sofo\ fakatonga",
    'su'    => "lea\ sanita",
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => "lea\ fakasueteni",
    'sw'    => "lea\ suahile",
    'swb'   => "lea\ fakakomolo",
    'swc'   => "Congo\ Swahili",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => "lea\ fakatemole",
    'tai'   => "Tai\ Language",
    'te'    => "lea\ fakaʻinitia\ teluku",
    'tem'   => 'Timne',
    'teo'   => 'Teso',
    'ter'   => 'Tereno',
    'tet'   => "lea\ fakatētamu",
    'tg'    => "lea\ fakatetiki",
    'th'    => "lea\ fakataileni",
    'ti'    => "lea\ fakatikilina",
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => "lea\ tekimeni",
    'tkl'   => "lea\ fakatokelau",
    'tl'    => "lea\ fakatekaloka",
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => "lea\ suana",
    'to'    => "lea\ fakatonga",
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "lea\ toki\ pisini",
    'tr'    => "lea\ fakatoake",
    'trv'   => 'Taroko',
    'ts'    => "lea\ songa",
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => "lea\ fakatūvalu",
    'tw'    => 'Twi',
    'twq'   => 'Tasawaq',
    'ty'    => "lea\ fakatahiti",
    'tyv'   => 'Tuvinian',
    'tzm'   => "Central\ Morocco\ Tamazight",
    'udm'   => 'Udmurt',
    'ug'    => "lea\ fakaʻuika",
    'uga'   => 'Ugaritic',
    'uk'    => "lea\ fakaʻiukālia",
    'umb'   => 'Umbundu',
    'und'   => "lea\ taʻeʻiloa",
    'ur'    => "lea\ fakaʻetiu",
    'uz'    => "lea\ fakaʻusipeki",
    'vai'   => 'Vai',
    've'    => "lea\ fakavenitā",
    'vi'    => "lea\ fakavietinemi",
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'vun'   => 'Vunjo',
    'wa'    => 'Walloon',
    'wae'   => 'Walser',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => "lea\ fakaʻuolofo",
    'xal'   => 'Kalmyk',
    'xh'    => "lea\ fakatōsa",
    'xog'   => 'Soga',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yav'   => 'Yangben',
    'yi'    => 'Yiddish',
    'yo'    => "lea\ fakaʻiōlupa",
    'ypk'   => "Yupik\ Language",
    'yue'   => "lea\ kenitēnisi",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => "lea\ fakasiaina",
    'znd'   => 'Zande',
    'zu'    => "lea\ fakasulu",
    'zun'   => 'Zuni',
    'zxx'   => "ʻikai\ ha\ lea",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::to::name_to_code = (
    'achinese'                           => 'ace',
    'acoli'                              => 'ach',
    'adangme'                            => 'ada',
    'adyghe'                             => 'ady',
    'afar'                               => 'aa',
    'afrihili'                           => 'afh',
    'afroasiaticlanguage'                => 'afa',
    'aghem'                              => 'agq',
    'ainu'                               => 'ain',
    'akan'                               => 'ak',
    'akkadian'                           => 'akk',
    'aleut'                              => 'ale',
    'algonquianlanguage'                 => 'alg',
    'altaiclanguage'                     => 'tut',
    'ancientegyptian'                    => 'egy',
    'angika'                             => 'anp',
    'apachelanguage'                     => 'apa',
    'aragonese'                          => 'an',
    'aramaic'                            => 'arc',
    'arapaho'                            => 'arp',
    'araucanian'                         => 'arn',
    'arawak'                             => 'arw',
    'aromanian'                          => 'rup',
    'asturian'                           => 'ast',
    'asu'                                => 'asa',
    'athapascanlanguage'                 => 'ath',
    'atsam'                              => 'cch',
    'australianlanguage'                 => 'aus',
    'austronesianlanguage'               => 'map',
    'avaric'                             => 'av',
    'avestan'                            => 'ae',
    'awadhi'                             => 'awa',
    'bafia'                              => 'ksf',
    'balinese'                           => 'ban',
    'balticlanguage'                     => 'bat',
    'baluchi'                            => 'bal',
    'bambara'                            => 'bm',
    'bamilekelanguage'                   => 'bai',
    'banda'                              => 'bad',
    'bantu'                              => 'bnt',
    'basaa'                              => 'bas',
    'bashkir'                            => 'ba',
    'batak'                              => 'btk',
    'beja'                               => 'bej',
    'bemba'                              => 'bem',
    'bena'                               => 'bez',
    'berber'                             => 'ber',
    'bhojpuri'                           => 'bho',
    'bihari'                             => 'bh',
    'bikol'                              => 'bik',
    'bini'                               => 'bin',
    'bislama'                            => 'bi',
    'blin'                               => 'byn',
    'blissymbols'                        => 'zbl',
    'bodo'                               => 'brx',
    'braj'                               => 'bra',
    'breton'                             => 'br',
    'buginese'                           => 'bug',
    'buriat'                             => 'bua',
    'caddo'                              => 'cad',
    'carib'                              => 'car',
    'caucasianlanguage'                  => 'cau',
    'cayuga'                             => 'cay',
    'cebuano'                            => 'ceb',
    'celticlanguage'                     => 'cel',
    'centralamericanindianlanguage'      => 'cai',
    'centralmoroccotamazight'            => 'tzm',
    'chagatai'                           => 'chg',
    'chamiclanguage'                     => 'cmc',
    'chamorro'                           => 'ch',
    'chechen'                            => 'ce',
    'cherokee'                           => 'chr',
    'cheyenne'                           => 'chy',
    'chibcha'                            => 'chb',
    'chiga'                              => 'cgg',
    'chinookjargon'                      => 'chn',
    'chipewyan'                          => 'chp',
    'choctaw'                            => 'cho',
    'churchslavic'                       => 'cu',
    'chuukese'                           => 'chk',
    'chuvash'                            => 'cv',
    'classicalnewari'                    => 'nwc',
    'classicalsyriac'                    => 'syc',
    'colognian'                          => 'ksh',
    'congoswahili'                       => 'swc',
    'coptic'                             => 'cop',
    'cornish'                            => 'kw',
    'corsican'                           => 'co',
    'cree'                               => 'cr',
    'creek'                              => 'mus',
    'creoleorpidgin'                     => 'crp',
    'crimeanturkish'                     => 'crh',
    'cushiticlanguage'                   => 'cus',
    'dakota'                             => 'dak',
    'dargwa'                             => 'dar',
    'dayak'                              => 'day',
    'delaware'                           => 'del',
    'dinka'                              => 'din',
    'dogri'                              => 'doi',
    'dogrib'                             => 'dgr',
    'dravidianlanguage'                  => 'dra',
    'duala'                              => 'dua',
    'dyula'                              => 'dyu',
    'easternfrisian'                     => 'frs',
    'ekajuk'                             => 'eka',
    'elamite'                            => 'elx',
    'embu'                               => 'ebu',
    'englishbasedcreoleorpidgin'         => 'cpe',
    'erzya'                              => 'myv',
    'ewe'                                => 'ee',
    'ewondo'                             => 'ewo',
    'fang'                               => 'fan',
    'fanti'                              => 'fat',
    'faroese'                            => 'fo',
    'finnougrianlanguage'                => 'fiu',
    'fon'                                => 'fon',
    'frenchbasedcreoleorpidgin'          => 'cpf',
    'friulian'                           => 'fur',
    'fulah'                              => 'ff',
    'ga'                                 => 'gaa',
    'ganda'                              => 'lg',
    'gayo'                               => 'gay',
    'gbaya'                              => 'gba',
    'geez'                               => 'gez',
    'germaniclanguage'                   => 'gem',
    'gondi'                              => 'gon',
    'gorontalo'                          => 'gor',
    'gothic'                             => 'got',
    'grebo'                              => 'grb',
    'gusii'                              => 'guz',
    "gwich\Ê\¼in"                      => 'gwi',
    'haida'                              => 'hai',
    'herero'                             => 'hz',
    'hiligaynon'                         => 'hil',
    'himachali'                          => 'him',
    'hirimotu'                           => 'ho',
    'hittite'                            => 'hit',
    'hmong'                              => 'hmn',
    'hupa'                               => 'hup',
    'iban'                               => 'iba',
    'ido'                                => 'io',
    'ijo'                                => 'ijo',
    'iloko'                              => 'ilo',
    'inarisami'                          => 'smn',
    'indiclanguage'                      => 'inc',
    'indoeuropeanlanguage'               => 'ine',
    'ingush'                             => 'inh',
    'interlingua'                        => 'ia',
    'interlingue'                        => 'ie',
    'inuktitut'                          => 'iu',
    'inupiaq'                            => 'ik',
    'iranianlanguage'                    => 'ira',
    'iroquoianlanguage'                  => 'iro',
    'jju'                                => 'kaj',
    'jolafonyi'                          => 'dyo',
    'judeoarabic'                        => 'jrb',
    'judeopersian'                       => 'jpr',
    'kabardian'                          => 'kbd',
    'kabuverdianu'                       => 'kea',
    'kabyle'                             => 'kab',
    'kachin'                             => 'kac',
    'kalaallisut'                        => 'kl',
    'kalenjin'                           => 'kln',
    'kalmyk'                             => 'xal',
    'kamba'                              => 'kam',
    'kanuri'                             => 'kr',
    'karachaybalkar'                     => 'krc',
    'karakalpak'                         => 'kaa',
    'karelian'                           => 'krl',
    'karen'                              => 'kar',
    'kashubian'                          => 'csb',
    'kawi'                               => 'kaw',
    'khasi'                              => 'kha',
    'khoisanlanguage'                    => 'khi',
    'khotanese'                          => 'kho',
    'kikuyu'                             => 'ki',
    'kimbundu'                           => 'kmb',
    'klingon'                            => 'tlh',
    'komi'                               => 'kv',
    'kongo'                              => 'kg',
    'konkani'                            => 'kok',
    'koro'                               => 'kfo',
    'kosraean'                           => 'kos',
    'koyraborosenni'                     => 'ses',
    'koyrachiini'                        => 'khq',
    'kpelle'                             => 'kpe',
    'kru'                                => 'kro',
    'kuanyama'                           => 'kj',
    'kumyk'                              => 'kum',
    'kurukh'                             => 'kru',
    'kutenai'                            => 'kut',
    'kwasio'                             => 'nmg',
    'ladino'                             => 'lad',
    'lamba'                              => 'lam',
    'langi'                              => 'lag',
    'leafakafalanisē'                   => 'fr',
    'leafakafalanisēkānata'            => 'fr_ca',
    'leafakafalanisēsuitisālani'       => 'fr_ch',
    'leafakafilipaini'                   => 'fil',
    'leafakafinilani'                    => 'fi',
    'leafakafisi'                        => 'fj',
    'leafakahaiti'                       => 'ht',
    'leafakahangakalia'                  => 'hu',
    'leafakahauaiʻi'                    => 'haw',
    'leafakahaʻamoa'                    => 'sm',
    'leafakahepelū'                     => 'he',
    'leafakahinitī'                     => 'hi',
    'leafakahōlani'                     => 'nl',
    'leafakahōlanipelesiume'            => 'nl_be',
    'leafakakalisi'                      => 'el',
    'leafakakalisimuʻa'                 => 'grc',
    'leafakakasakiteni'                  => 'kk',
    'leafakakekisiteni'                  => 'ky',
    'leafakakemipōtia'                  => 'km',
    'leafakakesimia'                     => 'ks',
    'leafakaketalani'                    => 'ca',
    'leafakakilipasi'                    => 'gil',
    'leafakakomolo'                      => 'swb',
    'leafakakuloisia'                    => 'hr',
    'leafakakōlea'                      => 'ko',
    'leafakalakisimipeki'                => 'lb',
    'leafakalalotonga'                   => 'rar',
    'leafakalapanui'                     => 'rap',
    'leafakalatina'                      => 'la',
    'leafakalativia'                     => 'lv',
    'leafakalau'                         => 'lo',
    'leafakalifiuenia'                   => 'lt',
    'leafakaluanita'                     => 'rw',
    'leafakalōmenia'                    => 'ro',
    'leafakalūsia'                      => 'ru',
    'leafakamalei'                       => 'ms',
    'leafakamasitōnia'                  => 'mk',
    'leafakamatakasika'                  => 'mg',
    'leafakamauli'                       => 'mi',
    'leafakamolota'                      => 'mt',
    'leafakamongokōlia'                 => 'mn',
    'leafakamāsolo'                     => 'mh',
    'leafakanaulu'                       => 'na',
    'leafakanepali'                      => 'ne',
    'leafakaniuē'                       => 'niu',
    'leafakanoueinosiki'                 => 'nn',
    'leafakanoueipokimali'               => 'nb',
    'leafakanouē'                       => 'no',
    'leafakapelelusi'                    => 'be',
    'leafakapema'                        => 'my',
    'leafakapengila'                     => 'bn',
    'leafakapilitānia'                  => 'en_gb',
    'leafakapokalia'                     => 'bg',
    'leafakaposinia'                     => 'bs',
    'leafakapotukali'                    => 'pt',
    'leafakapotukalipalāsili'           => 'pt_br',
    'leafakapotukaliʻaipilieni'         => 'pt_pt',
    'leafakaputeni'                      => 'dz',
    'leafakapālangi'                    => 'en',
    'leafakapālangikānata'             => 'en_ca',
    'leafakapālangiʻamelika'           => 'en_us',
    'leafakapālangiʻaositelēlia'      => 'en_au',
    'leafakapēsia'                      => 'fa',
    'leafakapōlani'                     => 'pl',
    'leafakasava'                        => 'jv',
    'leafakaseki'                        => 'cs',
    'leafakaselengika'                   => 'si',
    'leafakasiaina'                      => 'zh',
    'leafakasiamane'                     => 'de',
    'leafakasiamanisuitisālani'         => 'gsw',
    'leafakasiamanisuitisālanimaolunga' => 'de_ch',
    'leafakasiamaniʻaositulia'          => 'de_at',
    'leafakasiapani'                     => 'ja',
    'leafakasikotilani'                  => 'sco',
    'leafakasipēnisiʻaipilieni'        => 'es_es',
    'leafakasolovenia'                   => 'sl',
    'leafakasolāvaki'                   => 'sk',
    'leafakasomali'                      => 'so',
    'leafakasuasilani'                   => 'ss',
    'leafakasueteni'                     => 'sv',
    'leafakasulu'                        => 'zu',
    'leafakasēpia'                      => 'sr',
    'leafakasīpenisi'                   => 'es',
    'leafakasōsia'                      => 'ka',
    'leafakatahiti'                      => 'ty',
    'leafakataileni'                     => 'th',
    'leafakataipeti'                     => 'bo',
    'leafakatekaloka'                    => 'tl',
    'leafakatemole'                      => 'ta',
    'leafakatenimaʻake'                 => 'da',
    'leafakatetiki'                      => 'tg',
    'leafakatikilina'                    => 'ti',
    'leafakatoake'                       => 'tr',
    'leafakatokelau'                     => 'tkl',
    'leafakatonga'                       => 'to',
    'leafakatētamu'                     => 'tet',
    'leafakatōsa'                       => 'xh',
    'leafakatūvalu'                     => 'tvl',
    'leafakauēlesi'                     => 'cy',
    'leafakavenitā'                     => 've',
    'leafakavietinemi'                   => 'vi',
    'leafakaʻaelani'                    => 'ga',
    'leafakaʻafilikana'                 => 'af',
    'leafakaʻaisilani'                  => 'is',
    'leafakaʻalapēnia'                 => 'sq',
    'leafakaʻalepea'                    => 'ar',
    'leafakaʻaminiume'                  => 'hy',
    'leafakaʻapakasi'                   => 'ab',
    'leafakaʻasapaisani'                => 'az',
    'leafakaʻesipulanito'               => 'eo',
    'leafakaʻesitōnia'                 => 'et',
    'leafakaʻetiu'                      => 'ur',
    'leafakaʻilonga'                    => 'sgn',
    'leafakaʻinitiamalāialemi'         => 'ml',
    'leafakaʻinitiateluku'              => 'te',
    'leafakaʻinitiaʻolāea'            => 'or',
    'leafakaʻinitōnesia'               => 'id',
    'leafakaʻiukālia'                  => 'uk',
    'leafakaʻiōlupa'                   => 'yo',
    'leafakaʻuika'                      => 'ug',
    'leafakaʻuolofo'                    => 'wo',
    'leafakaʻusipeki'                   => 'uz',
    'leafakaʻītali'                    => 'it',
    'leafaʻu'                           => 'art',
    'leahausa'                           => 'ha',
    'leakalisieni'                       => 'gl',
    'leakanata'                          => 'kn',
    'leakehekehe'                        => 'mis',
    'leakenitēnisi'                     => 'yue',
    'leakualani'                         => 'gn',
    'leakuetisa'                         => 'qu',
    'leakutalati'                        => 'gu',
    'leakētisi'                         => 'ku',
    'lealaitolomēnia'                   => 'rm',
    'lealanita'                          => 'lah',
    'lealingikala'                       => 'ln',
    'lealuaniti'                         => 'rn',
    'leamalati'                          => 'mr',
    'leanetepelefakatokelau'             => 'nd',
    'leapasiki'                          => 'eu',
    'leapasito'                          => 'ps',
    'leapunusapi'                        => 'pa',
    'leasaka'                            => 'sah',
    'leasamifakatokelau'                 => 'se',
    'leasango'                           => 'sg',
    'leasanisukuliti'                    => 'sa',
    'leasanita'                          => 'su',
    'leasiniti'                          => 'sd',
    'leasofofakatokelau'                 => 'nso',
    'leasofofakatonga'                   => 'st',
    'leasona'                            => 'sn',
    'leasonga'                           => 'ts',
    'leasua'                             => 'ny',
    'leasuahile'                         => 'sw',
    'leasuana'                           => 'tn',
    'leasēpiakuloisia'                  => 'sh',
    'leataʻeʻiloa'                     => 'und',
    'leatekimeni'                        => 'tk',
    'leativehi'                          => 'dv',
    'leatokipisini'                      => 'tpi',
    'leatuifio'                          => 'mul',
    'leaʻaimala'                        => 'ay',
    'leaʻameliki'                       => 'am',
    'leaʻasamisi'                       => 'as',
    'leaʻefiki'                         => 'efi',
    'leaʻikipō'                        => 'ig',
    'leaʻosetiki'                       => 'os',
    'lezghian'                           => 'lez',
    'limburgish'                         => 'li',
    'lojban'                             => 'jbo',
    'lowersorbian'                       => 'dsb',
    'lowgerman'                          => 'nds',
    'lozi'                               => 'loz',
    'lubakatanga'                        => 'lu',
    'lubalulua'                          => 'lua',
    'luiseno'                            => 'lui',
    'lulesami'                           => 'smj',
    'lunda'                              => 'lun',
    'luo'                                => 'luo',
    'lushai'                             => 'lus',
    'luyia'                              => 'luy',
    'machame'                            => 'jmc',
    'madurese'                           => 'mad',
    'magahi'                             => 'mag',
    'maithili'                           => 'mai',
    'makasar'                            => 'mak',
    'makhuwameetto'                      => 'mgh',
    'makonde'                            => 'kde',
    'manchu'                             => 'mnc',
    'mandar'                             => 'mdr',
    'mandingo'                           => 'man',
    'manipuri'                           => 'mni',
    'manobolanguage'                     => 'mno',
    'manx'                               => 'gv',
    'mari'                               => 'chm',
    'marwari'                            => 'mwr',
    'masai'                              => 'mas',
    'mayanlanguage'                      => 'myn',
    'mende'                              => 'men',
    'meru'                               => 'mer',
    'micmac'                             => 'mic',
    'middledutch'                        => 'dum',
    'middleenglish'                      => 'enm',
    'middlefrench'                       => 'frm',
    'middlehighgerman'                   => 'gmh',
    'middleirish'                        => 'mga',
    'minangkabau'                        => 'min',
    'mirandese'                          => 'mwl',
    'mohawk'                             => 'moh',
    'moksha'                             => 'mdf',
    'moldavian'                          => 'mo',
    'mongo'                              => 'lol',
    'monkhmerlanguage'                   => 'mkh',
    'morisyen'                           => 'mfe',
    'mossi'                              => 'mos',
    'mundalanguage'                      => 'mun',
    'mundang'                            => 'mua',
    'nahuatl'                            => 'nah',
    'nama'                               => 'naq',
    'navajo'                             => 'nv',
    'ndonga'                             => 'ng',
    'neapolitan'                         => 'nap',
    'newari'                             => 'new',
    'nias'                               => 'nia',
    'nigerkordofanianlanguage'           => 'nic',
    'nilosaharanlanguage'                => 'ssa',
    'nogai'                              => 'nog',
    'northamericanindianlanguage'        => 'nai',
    'northernfrisian'                    => 'frr',
    'nubianlanguage'                     => 'nub',
    'nuer'                               => 'nus',
    'nyamwezi'                           => 'nym',
    'nyankole'                           => 'nyn',
    'nyasatonga'                         => 'tog',
    'nyoro'                              => 'nyo',
    'nzima'                              => 'nzi',
    "n\â\\ko"                       => 'nqo',
    'occitan'                            => 'oc',
    'ojibwa'                             => 'oj',
    'oldenglish'                         => 'ang',
    'oldfrench'                          => 'fro',
    'oldhighgerman'                      => 'goh',
    'oldirish'                           => 'sga',
    'oldnorse'                           => 'non',
    'oldpersian'                         => 'peo',
    "oldproven\Ã\§al"                  => 'pro',
    'oromo'                              => 'om',
    'osage'                              => 'osa',
    'otomianlanguage'                    => 'oto',
    'ottomanturkish'                     => 'ota',
    'pahlavi'                            => 'pal',
    'palauan'                            => 'pau',
    'pali'                               => 'pi',
    'pampanga'                           => 'pam',
    'pangasinan'                         => 'pag',
    'papiamento'                         => 'pap',
    'papuanlanguage'                     => 'paa',
    'philippinelanguage'                 => 'phi',
    'phoenician'                         => 'phn',
    'pohnpeian'                          => 'pon',
    'portuguesebasedcreoleorpidgin'      => 'cpp',
    'prakritlanguage'                    => 'pra',
    'rajasthani'                         => 'raj',
    'romancelanguage'                    => 'roa',
    'romany'                             => 'rom',
    'rombo'                              => 'rof',
    'rwa'                                => 'rwk',
    'saho'                               => 'ssy',
    'salishanlanguage'                   => 'sal',
    'samaritanaramaic'                   => 'sam',
    'samburu'                            => 'saq',
    'samilanguage'                       => 'smi',
    'sandawe'                            => 'sad',
    'sangu'                              => 'sbp',
    'santali'                            => 'sat',
    'sardinian'                          => 'sc',
    'sasak'                              => 'sas',
    'scottishgaelic'                     => 'gd',
    'selkup'                             => 'sel',
    'semiticlanguage'                    => 'sem',
    'sena'                               => 'seh',
    'seneca'                             => 'see',
    'serer'                              => 'srr',
    'shambala'                           => 'ksb',
    'shan'                               => 'shn',
    'sichuanyi'                          => 'ii',
    'sicilian'                           => 'scn',
    'sidamo'                             => 'sid',
    'siksika'                            => 'bla',
    'sinotibetanlanguage'                => 'sit',
    'siouanlanguage'                     => 'sio',
    'skoltsami'                          => 'sms',
    'slave'                              => 'den',
    'slaviclanguage'                     => 'sla',
    'soga'                               => 'xog',
    'sogdien'                            => 'sog',
    'songhai'                            => 'son',
    'soninke'                            => 'snk',
    'sorbianlanguage'                    => 'wen',
    'southamericanindianlanguage'        => 'sai',
    'southernaltai'                      => 'alt',
    'southernsami'                       => 'sma',
    'southndebele'                       => 'nr',
    'sranantongo'                        => 'srn',
    'sukuma'                             => 'suk',
    'sumerian'                           => 'sux',
    'susu'                               => 'sus',
    'syriac'                             => 'syr',
    'tachelhit'                          => 'shi',
    'tailanguage'                        => 'tai',
    'taita'                              => 'dav',
    'tamashek'                           => 'tmh',
    'taroko'                             => 'trv',
    'tasawaq'                            => 'twq',
    'tatar'                              => 'tt',
    'tereno'                             => 'ter',
    'teso'                               => 'teo',
    'tigre'                              => 'tig',
    'timne'                              => 'tem',
    'tiv'                                => 'tiv',
    'tlingit'                            => 'tli',
    'tsimshian'                          => 'tsi',
    'tumbuka'                            => 'tum',
    'tupilanguage'                       => 'tup',
    'tuvinian'                           => 'tyv',
    'twi'                                => 'tw',
    'tyap'                               => 'kcg',
    'udmurt'                             => 'udm',
    'ugaritic'                           => 'uga',
    'umbundu'                            => 'umb',
    'uppersorbian'                       => 'hsb',
    'vai'                                => 'vai',
    "volap\Ã\¼k"                       => 'vo',
    'votic'                              => 'vot',
    'vunjo'                              => 'vun',
    'wakashanlanguage'                   => 'wak',
    'walamo'                             => 'wal',
    'walloon'                            => 'wa',
    'walser'                             => 'wae',
    'waray'                              => 'war',
    'washo'                              => 'was',
    'westernfrisian'                     => 'fy',
    'yangben'                            => 'yav',
    'yao'                                => 'yao',
    'yapese'                             => 'yap',
    'yiddish'                            => 'yi',
    'yupiklanguage'                      => 'ypk',
    'zande'                              => 'znd',
    'zapotec'                            => 'zap',
    'zarma'                              => 'dje',
    'zaza'                               => 'zza',
    'zenaga'                             => 'zen',
    'zhuang'                             => 'za',
    'zuni'                               => 'zun',
    'ʻikaihalea'                        => 'zxx',
);

1;
