/*
    libmaus2
    Copyright (C) 2019 German Tischler-Höhle

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#if ! defined(LIBMAUS2_PROTEIN_CODONMAPPER_HPP)
#define LIBMAUS2_PROTEIN_CODONMAPPER_HPP

#include <libmaus2/fastx/acgtnMap.hpp>
#include <cassert>
#include <sstream>

namespace libmaus2
{
	namespace protein
	{
		struct CodonMapper
		{
			static char const codonArray[64];
			static char const stopArray[64];

			static std::string mapString(std::string const & s)
			{
				uint64_t const full = s.size() / 3;
				uint64_t const frac = s.size() % 3;

				std::ostringstream ostr;

				for ( uint64_t i = 0; i < full; ++i )
					ostr.put(
						map(s[3*i+0],s[3*i+1],s[3*i+2])
					);

				if ( frac )
					ostr.put('X');

				return ostr.str();
			}

			// map codon triple to amino acid
			static char map(char const a, char const b, char const c)
			{
				char const ma = libmaus2::fastx::mapChar(a);
				char const mb = libmaus2::fastx::mapChar(b);
				char const mc = libmaus2::fastx::mapChar(c);

				char const cd = ma | mb | mc;
				assert ( !(cd & (~3)) );

				int const index = (ma<<4) | (mb<<2) | mc;

				assert ( static_cast<unsigned int>(index) < sizeof(codonArray)/sizeof(codonArray[0]) );

				return codonArray[index];
			}

			// is the given triple a stop codon?
			static bool isStop(char const a, char const b, char const c)
			{
				char const ma = libmaus2::fastx::mapChar(a);
				char const mb = libmaus2::fastx::mapChar(b);
				char const mc = libmaus2::fastx::mapChar(c);

				char const cd = ma | mb | mc;
				assert ( !(cd & (~3)) );

				int const index = (ma<<4) | (mb<<2) | mc;

				assert ( static_cast<unsigned int>(index) < sizeof(codonArray)/sizeof(codonArray[0]) );

				return stopArray[index];
			}
		};
	}
}
#endif
